/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.assistant.service;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bd.assistant.api.CostCenterService;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.cache.AppCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import org.apache.commons.lang3.tuple.Pair;

public class CostCenterServiceImpl
implements CostCenterService {
    protected static final Log logger = LogFactory.getLog(CostCenterServiceImpl.class);
    private static final String COST_CENTER = "costcenter";
    private static final String NAME = "name";
    private static final String EFFECT_DATE = "effectdate";
    private static final String EXP_DATE = "expdate:";

    public Map<String, List<Pair<String, String>>> getMappingFieldByEntity(String entityNumber, Long billTypeId) {
        logger.info("\u6210\u672c\u4e2d\u5fc3\u53d6\u503c\u914d\u7f6e\u63a5\u53e3\u5165\u53c2:entityNumber{}\uff0cbillTypeId:{}", (Object)entityNumber, (Object)billTypeId);
        if (StringUtils.isEmpty((CharSequence)entityNumber)) {
            logger.info("\u5355\u636e\u7f16\u7801\u4e3a\u7a7a");
            return null;
        }
        QFilter qFilter = new QFilter("businessbill", "=", (Object)entityNumber);
        qFilter.and("enable", "=", (Object)Boolean.TRUE);
        if (billTypeId != null && billTypeId != 0L) {
            qFilter.and("billtype", "=", (Object)billTypeId);
        }
        HashMap<String, List<Pair<String, String>>> mappingField = new HashMap<String, List<Pair<String, String>>>(2);
        Map costCenterFiledEntityMap = BusinessDataServiceHelper.loadFromCache((String)"bos_costcenterfieldmap", (QFilter[])qFilter.toArray());
        if (CollectionUtils.isEmpty((Map)costCenterFiledEntityMap)) {
            return mappingField;
        }
        for (Map.Entry costCenterFiledEntity : costCenterFiledEntityMap.entrySet()) {
            DynamicObject costCenterFiled = (DynamicObject)costCenterFiledEntity.getValue();
            DynamicObjectCollection entryEntity = costCenterFiled.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : entryEntity) {
                String costCenterField = entry.getString("costcenterfield");
                String sourceField = entry.getString("sourcefield");
                String sourceFieldType = entry.getString("sourcefieldtype");
                mappingField.computeIfAbsent(costCenterField, s -> new ArrayList()).add(Pair.of((Object)sourceField, (Object)sourceFieldType));
            }
        }
        logger.info("\u6210\u672c\u4e2d\u5fc3\u53d6\u503c\u914d\u7f6e\u63a5\u53e3\u8fd4\u56de\u503c:{}", (Object)SerializationUtils.toJsonString(mappingField));
        return mappingField;
    }

    public Map<String, Object> getCostCenterByMappingParam(List<Pair<List<List<Pair<Long, String>>>, Date>> data) {
        logger.info("\u6210\u672c\u4e2d\u5fc3\u6620\u5c04\u914d\u7f6e\u63a5\u53e3\u5165\u53c2:{}", (Object)SerializationUtils.toJsonString(data));
        HashMap<String, List<Map<String, Object>>> localCache = new HashMap<String, List<Map<String, Object>>>(16);
        if (CollectionUtils.isEmpty(data)) {
            logger.info("\u6620\u5c04\u53c2\u6570\u4e3a\u7a7a");
            return this.buildResultMap(Boolean.FALSE, "mappingParam is empty", null);
        }
        ArrayList idCostCenterIdNameList = new ArrayList();
        try {
            HashSet<Object> sourceDataIds = new HashSet<Object>(16);
            HashSet<Object> sourceTypes = new HashSet<Object>(16);
            for (Pair<List<List<Pair<Long, String>>>, Date> dataEntry : data) {
                for (Object mappingList : (List)dataEntry.getKey()) {
                    Iterator iterator = mappingList.iterator();
                    while (iterator.hasNext()) {
                        Pair pair = (Pair)iterator.next();
                        Long sourceDataId = (Long)pair.getKey();
                        String sourceType = (String)pair.getValue();
                        String dimensionKey = sourceDataId + "@" + sourceType;
                        List<Map<String, Object>> cacheData = this.getCacheData(dimensionKey, localCache);
                        if (!CollectionUtils.isEmpty(cacheData)) continue;
                        sourceDataIds.add(pair.getKey());
                        sourceTypes.add(pair.getValue());
                    }
                }
            }
            if (!CollectionUtils.isEmpty(sourceDataIds) && !CollectionUtils.isEmpty(sourceTypes)) {
                QFilter qFilter = new QFilter("entryentity.sourcetype", "in", sourceTypes);
                qFilter.and("entryentity.sourcedata", "in", sourceDataIds);
                HashMap costCenterSourceMap = new HashMap(16);
                DynamicObjectCollection costCenterSourceDc = QueryServiceHelper.query((String)"bos_costcentersourcemap", (String)"id,costcenter.name,costcenter,effectdate,expdate,entryentity.sourcedata,entryentity.sourcetype", (QFilter[])new QFilter[]{qFilter});
                costCenterSourceDc.forEach(s -> {
                    Long sourceDataId = s.getLong("entryentity.sourcedata");
                    String sourceType = s.getString("entryentity.sourcetype");
                    String dimensionKey = sourceDataId + "@" + sourceType;
                    HashMap<String, Object> sourceParam = new HashMap<String, Object>(3);
                    sourceParam.put(COST_CENTER, s.getString(COST_CENTER));
                    sourceParam.put(NAME, s.getString("costcenter.name"));
                    sourceParam.put(EFFECT_DATE, s.getDate(EFFECT_DATE));
                    sourceParam.put(EXP_DATE, s.getDate("expdate"));
                    costCenterSourceMap.computeIfAbsent(dimensionKey, c -> new ArrayList()).add(sourceParam);
                });
                if (!CollectionUtils.isEmpty(costCenterSourceMap)) {
                    for (Map.Entry entry : costCenterSourceMap.entrySet()) {
                        this.setCacheData((String)entry.getKey(), (List)entry.getValue(), localCache);
                    }
                }
            }
            for (Pair<List<List<Pair<Long, String>>>, Date> value : data) {
                ArrayList<Pair> costCenterIdNames = new ArrayList<Pair>(8);
                Date bizDate = (Date)value.getValue();
                if (bizDate == null) {
                    bizDate = new Date();
                }
                for (List mappingList : (List)value.getKey()) {
                    Long costCenterId = 0L;
                    String name = "";
                    boolean isBreak = false;
                    block8: for (Pair pair : mappingList) {
                        if (isBreak) break;
                        Long sourceDataId = (Long)pair.getKey();
                        String sourceType = (String)pair.getValue();
                        String dimensionKey = sourceDataId + "@" + sourceType;
                        List<Map<String, Object>> costCenterSourceCacheList = this.getCacheData(dimensionKey, localCache);
                        if (costCenterSourceCacheList == null || costCenterSourceCacheList.isEmpty()) continue;
                        for (Map<String, Object> costCenterSourceCache : costCenterSourceCacheList) {
                            Date effectDate = CostCenterServiceImpl.parseDate(String.valueOf(costCenterSourceCache.get(EFFECT_DATE)));
                            Date expDate = CostCenterServiceImpl.parseDate(String.valueOf(costCenterSourceCache.get(EXP_DATE)));
                            if (effectDate == null || expDate == null || bizDate.getTime() < effectDate.getTime() || bizDate.getTime() >= expDate.getTime()) continue;
                            costCenterId = Long.parseLong((String)costCenterSourceCache.get(COST_CENTER));
                            name = String.valueOf(costCenterSourceCache.get(NAME));
                            isBreak = true;
                            continue block8;
                        }
                    }
                    costCenterIdNames.add(Pair.of((Object)costCenterId, (Object)name));
                }
                idCostCenterIdNameList.add(costCenterIdNames);
            }
        }
        catch (Exception e) {
            return this.buildResultMap(Boolean.FALSE, e.getMessage(), idCostCenterIdNameList);
        }
        logger.info("\u6210\u672c\u4e2d\u5fc3\u6620\u5c04\u914d\u7f6e\u63a5\u53e3\u8fd4\u56de\u503c:{}", (Object)SerializationUtils.toJsonString(idCostCenterIdNameList));
        return this.buildResultMap(Boolean.TRUE, "", idCostCenterIdNameList);
    }

    private static Date parseDate(String dateStr) {
        Date date = null;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            date = sdf.parse(dateStr);
        }
        catch (ParseException e) {
            logger.error(e.getMessage());
        }
        return date;
    }

    private Map<String, Object> buildResultMap(Boolean success, String message, Object data) {
        HashMap<String, Object> resultCostCenterMap = new HashMap<String, Object>(3);
        resultCostCenterMap.put("success", success);
        resultCostCenterMap.put("message", message);
        resultCostCenterMap.put("data", data);
        return resultCostCenterMap;
    }

    private List<Map<String, Object>> getCacheData(String cacheKey, Map<String, List<Map<String, Object>>> localCache) {
        try {
            if (StringUtils.isEmpty((CharSequence)cacheKey)) {
                return null;
            }
            if (localCache.containsKey(cacheKey)) {
                return localCache.get(cacheKey);
            }
            List cacheData = (List)AppCache.get((String)"macc").get("costcenter:" + cacheKey, List.class);
            if (cacheData != null) {
                localCache.put(cacheKey, cacheData);
            }
            return cacheData;
        }
        catch (Exception ex) {
            logger.error("cacheKey\uff1a{} \u83b7\u53d6\u7f13\u5b58\u5931\u8d25\uff1a{}\uff0c", (Object)cacheKey, (Object)ex.getMessage());
            return null;
        }
    }

    private void setCacheData(String cacheKey, List<Map<String, Object>> cacheData, Map<String, List<Map<String, Object>>> localCache) {
        try {
            localCache.put(cacheKey, cacheData);
            AppCache.get((String)"macc").put("costcenter:" + cacheKey, cacheData);
        }
        catch (Exception ex) {
            logger.error("cacheKey\uff1a{} \u8bbe\u7f6e\u7f13\u5b58\u5931\u8d25\uff1a{}\uff0c", (Object)cacheKey, (Object)ex.getMessage());
        }
    }

    private Map<String, List<Pair<String, String>>> getCostCenterConfigCache(String entityName) {
        HashMap<String, List<Pair<String, String>>> data = new HashMap<String, List<Pair<String, String>>>(8);
        if (StringUtils.isEmpty((CharSequence)entityName)) {
            return data;
        }
        String cacheKey = entityName.concat("costcenterconfig");
        Map cacheData = (Map)AppCache.get((String)"macc").get("costcenter:" + cacheKey, Map.class);
        if (cacheData != null && !cacheData.isEmpty()) {
            for (Map.Entry configEntry : cacheData.entrySet()) {
                String fillKey = (String)configEntry.getKey();
                List fillConfig = (List)configEntry.getValue();
                ArrayList<Pair> transfer = new ArrayList<Pair>(fillConfig.size());
                for (Map configMap : fillConfig) {
                    String key = (String)configMap.get("key");
                    String value = (String)configMap.get("value");
                    transfer.add(Pair.of((Object)key, (Object)value));
                }
                data.put(fillKey, transfer);
            }
        }
        return data;
    }
}

