/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.sbd.formplugin;

import java.math.BigDecimal;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bd.sbd.enums.ConfirmTypeEnum;
import kd.bd.sbd.utils.StringUtils;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.property.ComboProp;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;

public class BaseConditionEditPlugin
extends AbstractBasePlugIn {
    private static final String BASIS_TATE = "A";
    private static final String BASIS_AMOUNT = "B";
    private static final String CB_CONFIRMTYPE = "CONFIRMTYPEDETAIL";
    private static final String CUST_CONFIRMTYPEDETAIL = "CONFIRMTYPEDETAIL";
    private static final String KEY_CONFIRMTYPE = "CONFIRMTYPE";
    private static final String KEY_DETAIL = "DETAIL";
    private static final String KEY_DESC = "DESC";
    private static final String KEY_DATA = "DATA";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"confirmtypename"});
    }

    public void beforeBindData(EventObject e) {
        IFormView view = this.getView();
        String basis = (String)this.getModel().getValue("basis");
        if (BASIS_TATE.equals(basis)) {
            view.setVisible(Boolean.valueOf(true), new String[]{"rate"});
            view.setVisible(Boolean.valueOf(false), new String[]{"amount"});
        } else if (BASIS_AMOUNT.equals(basis)) {
            view.setVisible(Boolean.valueOf(true), new String[]{"amount"});
            view.setVisible(Boolean.valueOf(false), new String[]{"rate"});
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        AbstractOperate op = (AbstractOperate)e.getSource();
        String key = op.getOperateKey();
        if ("save".equals(key) && BASIS_TATE.equals(this.getModel().getValue("basis"))) {
            int entryRowCount = this.getModel().getEntryRowCount("entry");
            for (int i = entryRowCount - 1; i > -1; --i) {
                BigDecimal rate = (BigDecimal)this.getModel().getValue("rate", i);
                if (rate.compareTo(BigDecimal.ZERO) != 0) continue;
                this.getModel().deleteEntryRow("entry", i);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propName = e.getProperty().getName();
        ChangeData[] valueSet = e.getChangeSet();
        block10: for (int i = 0; i < valueSet.length; ++i) {
            Object newValue = valueSet[i].getNewValue();
            Object oldValue = valueSet[i].getOldValue();
            if (newValue != null && newValue.equals(oldValue)) {
                return;
            }
            if (oldValue != null && newValue != null && oldValue instanceof DynamicObject && newValue instanceof DynamicObject && ((DynamicObject)oldValue).getPkValue().equals(((DynamicObject)newValue).getPkValue())) {
                return;
            }
            if (oldValue != null && newValue != null && oldValue instanceof BigDecimal && newValue instanceof BigDecimal && ((BigDecimal)oldValue).doubleValue() == ((BigDecimal)newValue).doubleValue()) {
                return;
            }
            switch (propName) {
                case "basis": {
                    this.changeBasis(newValue);
                    continue block10;
                }
                case "confirmtype": {
                    this.changeConfirmType(newValue);
                }
                case "confirmtypename": {
                    if (newValue != null && !"".equals(newValue)) continue block10;
                    this.getModel().beginInit();
                    this.getModel().setValue("confirmtype", null, valueSet[i].getRowIndex());
                    this.getModel().setValue("confirmtypedesc", null, valueSet[i].getRowIndex());
                    this.getModel().setValue("confirmtypedata", null, valueSet[i].getRowIndex());
                    this.getView().updateView("confirmtype", valueSet[i].getRowIndex());
                    this.getView().updateView("confirmtypedesc", valueSet[i].getRowIndex());
                    this.getView().updateView("confirmtypedata", valueSet[i].getRowIndex());
                    this.getModel().endInit();
                }
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control ctlSource = (Control)evt.getSource();
        switch (ctlSource.getKey()) {
            case "confirmtypename": {
                this.showDueDateDetailForm();
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String key;
        super.closedCallBack(e);
        Object returnData = e.getReturnData();
        if (ObjectUtils.isEmpty((Object)returnData)) {
            return;
        }
        switch (key = e.getActionId()) {
            case "CONFIRMTYPEDETAIL": {
                HashMap data = (HashMap)returnData;
                Object confirmtype = data.get(KEY_CONFIRMTYPE);
                int rowIndex = this.getModel().getEntryCurrentRowIndex("entry");
                String dataStr = (String)this.getModel().getValue("confirmtypedata", rowIndex);
                if (StringUtils.isEmpty((String)dataStr) && this.getModel().getValue("confirmtype", rowIndex) != null) {
                    this.getModel().beginInit();
                    this.getModel().setValue("confirmtype", null, rowIndex);
                    this.getModel().endInit();
                }
                this.getModel().setValue("confirmtype", confirmtype, rowIndex);
                Map detail = (Map)data.get(KEY_DETAIL);
                String desc = (String)detail.get(KEY_DESC);
                String dataJson = SerializationUtils.toJsonString((Object)data);
                this.getModel().setValue("confirmtypedata", (Object)dataJson, rowIndex);
                this.getModel().setValue("confirmtypedesc", (Object)desc, rowIndex);
            }
        }
    }

    private void initEntryRowData() {
        int rowCount = this.getModel().getEntryRowCount("entry");
        for (int i = 0; i < rowCount; ++i) {
            this.setConfirmTypeData(i);
        }
    }

    private void setConfirmTypeData(int i) {
        final String confirmtype = (String)this.getModel().getValue("confirmtype", i);
        HashMap<String, String> map = new HashMap<String, String>(){
            {
                this.put("confirmtype", confirmtype);
            }
        };
        this.getModel().setValue("confirmtypedata", (Object)SerializationUtils.toJsonString((Object)map), i);
        this.getModel().setValue("confirmtypename", (Object)ConfirmTypeEnum.getConfirmTypeEnumByValue((String)confirmtype).getName(), i);
    }

    private void showDueDateDetailForm() {
        IDataModel model = this.getModel();
        int rowIndex = model.getEntryCurrentRowIndex("entry");
        String confirmTypeData = (String)model.getValue("confirmtypedata", rowIndex);
        CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, "CONFIRMTYPEDETAIL");
        this.showForm("bd_conditionduedatedetail", "CONFIRMTYPEDETAIL", confirmTypeData, closeCallBack, ShowType.Modal);
    }

    private void changeConfirmType(Object newValue) {
        MainEntityType dataEntityType = this.getModel().getDataEntityType();
        int rowIndex = this.getModel().getEntryCurrentRowIndex("entry");
        ComboProp property = (ComboProp)dataEntityType.findProperty("confirmtype");
        List comboItems = property.getComboItems();
        for (ValueMapItem item : comboItems) {
            String value = item.getValue();
            if (value == null || newValue == null || !value.equals(newValue)) continue;
            this.getModel().setValue("confirmtypename", (Object)item.getName().getLocaleValue(), rowIndex);
        }
    }

    private void changeBasis(Object newValue) {
        if (newValue instanceof String) {
            String basis = (String)newValue;
            IFormView view = this.getView();
            IDataModel model = this.getModel();
            model.deleteEntryData("entry");
            model.createNewEntryRow("entry");
            if (BASIS_TATE.equals(basis)) {
                view.setVisible(Boolean.valueOf(true), new String[]{"rate"});
                view.setVisible(Boolean.valueOf(false), new String[]{"amount"});
            } else if (BASIS_AMOUNT.equals(basis)) {
                view.setVisible(Boolean.valueOf(true), new String[]{"amount"});
                view.setVisible(Boolean.valueOf(false), new String[]{"rate"});
            }
        }
    }

    private void showForm(String formId, String paramName, Object params, CloseCallBack closeCallBack, ShowType showType) {
        FormShowParameter param = new FormShowParameter();
        param.getOpenStyle().setShowType(showType);
        param.setFormId(formId);
        if (params != null) {
            param.setCustomParam(paramName, params);
        }
        if (closeCallBack != null) {
            param.setCloseCallBack(closeCallBack);
        }
        this.getView().showForm(param);
    }

    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        this.getModel().setDataChanged(false);
    }
}

