/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.sbd.formplugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bd.sbd.business.helper.BizTypeHelper;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.lang.Lang;

public class LineTypeFormPlugin
extends AbstractBasePlugIn {
    private static final String SQL_1 = "SELECT T2.FNUMBER,T3.FNAME FROM T_BD_LINETYPEENTRY T1  INNER JOIN T_BD_BIZTYPE T2 ON T1.FID=T2.FID INNER JOIN T_BD_BIZTYPE_L T3 ON T2.FID=T3.FID  WHERE t1.FLINETYPEID = ";
    private static final String SQL_2 = " AND T3.FLOCALEID= '";
    private static final String SQL_3 = " ORDER BY T2.FNUMBER";
    private static final String[] FIELDS = new String[]{"biztypenumber", "biztypename"};

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        List<Map<String, String>> datas = this.queryBizType(this.getModel().getDataEntity().getPkValue());
        if (datas == null || datas.size() == 0) {
            return;
        }
        this.fillEntry(datas);
        this.getModel().setDataChanged(false);
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        FormOperate formOperate = (FormOperate)afterDoOperationEventArgs.getSource();
        String operate = formOperate.getOperateKey();
        if ("save".equals(operate)) {
            List<Map<String, String>> datas = this.queryBizType(this.getModel().getDataEntity().getPkValue());
            if (datas == null || datas.size() == 0) {
                return;
            }
            this.fillEntry(datas);
        }
    }

    private List<Map<String, String>> queryBizType(Object pk) {
        StringBuilder sql = new StringBuilder(SQL_1);
        sql.append(pk);
        sql.append(SQL_2);
        String lang = (Lang.get() == null ? "zh_CN" : String.valueOf(Lang.get())).concat("' ");
        sql.append(lang);
        sql.append(SQL_3);
        ArrayList<Map<String, String>> datas = new ArrayList<Map<String, String>>();
        HashMap<String, String> map = null;
        try (DataSet ds = DB.queryDataSet((String)BizTypeHelper.class.getName(), (DBRoute)DBRoute.basedata, (String)sql.toString());){
            for (Row row : ds) {
                map = new HashMap<String, String>(2);
                map.put("biztypenumber", row.getString("FNUMBER"));
                map.put("biztypename", row.getString("FNAME"));
                datas.add(map);
            }
        }
        return datas;
    }

    private void fillEntry(List<Map<String, String>> datas) {
        if (datas != null && datas.size() > 0) {
            this.getModel().deleteEntryData("entryentity");
            IDataModel model = this.getModel();
            this.getModel().beginInit();
            TableValueSetter vs = new TableValueSetter(FIELDS);
            for (Map<String, String> map : datas) {
                Object[] value = new Object[FIELDS.length];
                value[0] = map.get("biztypenumber");
                value[1] = map.get("biztypename");
                vs.addRow(value);
            }
            AbstractFormDataModel dataModel = (AbstractFormDataModel)model;
            dataModel.batchCreateNewEntryRow("entryentity", vs);
            this.getModel().endInit();
            this.getView().updateView("entryentity");
            this.getModel().setDataChanged(false);
        }
    }
}

