/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.sbd.formplugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;

public class WarehouseLocationRefFromPlugin
extends AbstractBasePlugIn
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit warehouseEdit = (BasedataEdit)this.getView().getControl("warehouse");
        warehouseEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit locationEdit = (BasedataEdit)this.getView().getControl("location");
        locationEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String fieldKey = e.getProperty().getName();
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        if ("warehouse".equals(fieldKey)) {
            this.beforeWarehouseSelect(showParameter);
        } else if ("location".equals(fieldKey)) {
            this.beforeLocationSelect(e, showParameter);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        OperationStatus status = this.getView().getFormShowParameter().getStatus();
        if (!OperationStatus.ADDNEW.equals((Object)status)) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"location"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"btnsave"});
        }
    }

    private void beforeLocationSelect(BeforeF7SelectEvent e, ListShowParameter showParameter) {
        DynamicObject warehouse = (DynamicObject)this.getModel().getValue("warehouse");
        if (warehouse == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u4ed3\u5e93\u3002", (String)"WarehouseLocationRefFromPlugin_1", (String)"bd-sbd-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        QFilter qFilter = new QFilter("warehouse.id", "=", warehouse.getPkValue());
        DataSet rows = QueryServiceHelper.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (String)"bd_warelocareference", (String)"location.id", (QFilter[])qFilter.toArray(), null);
        ArrayList<Long> refLocationIds = new ArrayList<Long>(128);
        while (rows.hasNext()) {
            Row row = rows.next();
            Long locationId = row.getLong("location.id");
            refLocationIds.add(locationId);
        }
        if (!refLocationIds.isEmpty()) {
            showParameter.getListFilterParameter().setFilter(new QFilter("id", "not in", refLocationIds));
        }
    }

    private void beforeWarehouseSelect(ListShowParameter showParameter) {
        Long userId = UserServiceHelper.getCurrentUserId();
        HasPermOrgResult hasPermOrgResult = PermissionServiceHelper.getAllPermOrgs((long)userId, (String)"05", (String)"=9Q86DR2P+Q", (String)"bd_warelocareference", (String)"47156aff000000ac", (boolean)true);
        List hasPermOrgIds = hasPermOrgResult.getHasPermOrgs();
        QFilter qFilter = new QFilter("createorg.id", "in", (Object)hasPermOrgIds);
        qFilter.and(new QFilter("isopenlocation", "=", (Object)"1"));
        showParameter.getListFilterParameter().setFilter(qFilter);
    }
}

