/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.sbd.formplugin.lot;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import kd.bd.sbd.business.helper.LotCodeRuleHelper;
import kd.bd.sbd.enums.LotCodeFormatEnum;
import kd.bd.sbd.enums.LotCodeItemTypeEnum;
import kd.bd.sbd.enums.UseModeEnum;
import kd.bd.sbd.utils.StringUtils;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;

public class LotCodeRulePlugin
extends AbstractBasePlugIn
implements CellClickListener,
RowClickEventListener {
    private static final String CACHEKEY_FOCUSROW = "focusrow";
    private static final String PROP_TYPE = "type";
    private static final String KEY_DATE = "dateFormat";
    private static final String KEY_LOTDATE = "lotDateFormat";
    private static final String KEY_CURRENTROW = "currentRow";
    private static final String[] COL_Arrays = new String[]{"attusingmode", "format", "settingvalue", "length", "step", "addchar", "addstyle", "cutstyle"};

    public void initialize() {
        super.initialize();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"format"});
        EntryGrid eg = (EntryGrid)this.getControl("entryentity");
        eg.addCellClickListener((CellClickListener)this);
        eg.addRowClickListener((RowClickEventListener)this);
    }

    public void cellClick(CellClickEvent evt) {
        String key;
        if (evt.getRow() < 0) {
            return;
        }
        switch (key = evt.getFieldKey()) {
            case "lotprop": {
                break;
            }
            default: {
                this.checkLotPropIsNull(evt.getRow(), evt);
            }
        }
    }

    public void cellDoubleClick(CellClickEvent paramCellClickEvent) {
    }

    public void entryRowClick(RowClickEvent evt) {
        super.entryRowClick(evt);
        if (evt.getRow() < 0) {
            return;
        }
        this.getPageCache().put(CACHEKEY_FOCUSROW, evt.getRow() + "");
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control c = (Control)evt.getSource();
        switch (c.getKey()) {
            case "format": {
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put(KEY_CURRENTROW, this.getFocusRow());
                String type = this.getLotProp().getString(PROP_TYPE);
                if (LotCodeItemTypeEnum.DATE == LotCodeItemTypeEnum.getLotCodeItemTypeEnumByValue((String)type)) {
                    CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, KEY_DATE);
                    this.showForm("bos_coderule_dateformat", params, closeCallBack, ShowType.Modal);
                    break;
                }
                CloseCallBack closeCallBack = new CloseCallBack((IFormPlugin)this, KEY_LOTDATE);
                this.showForm("bd_lotcoderule_format", params, closeCallBack, ShowType.Modal);
                break;
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        String key;
        super.closedCallBack(evt);
        Object returnData = evt.getReturnData();
        if (ObjectUtils.isEmpty((Object)returnData)) {
            return;
        }
        switch (key = evt.getActionId()) {
            case "dateFormat": {
                HashMap map1 = (HashMap)returnData;
                int currentRow1 = (Integer)map1.get(KEY_CURRENTROW);
                this.getModel().beginInit();
                this.getModel().setValue("format", (Object)map1.get("format").toString(), currentRow1);
                this.getModel().setValue("formatvalue", (Object)map1.get("format").toString(), currentRow1);
                this.getModel().setValue("length", (Object)map1.get("format").toString().length(), currentRow1);
                this.getModel().endInit();
                this.getView().updateView("format", currentRow1);
                this.getView().updateView("length", currentRow1);
                this.buildExampleDataForGL();
                break;
            }
            case "lotDateFormat": {
                HashMap map2 = (HashMap)returnData;
                int currentRow2 = (Integer)map2.get(KEY_CURRENTROW);
                this.getModel().beginInit();
                this.getModel().setValue("formatvalue", (Object)map2.get("value").toString(), currentRow2);
                this.getModel().setValue("format", (Object)map2.get("format").toString(), currentRow2);
                this.getModel().endInit();
                this.getView().updateView("format", currentRow2);
                this.buildExampleDataForGL();
                break;
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Object modifier = this.getModel().getValue("modifier");
        if (modifier == null) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"pagepanel"});
        }
        DynamicObjectCollection entry = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        for (DynamicObject row : entry) {
            int index = row.getInt("seq") - 1;
            this.setEnableProp(index, row.getDynamicObject("lotprop"));
        }
        ILocaleString exmaple = (ILocaleString)this.getView().getModel().getValue("example");
        Map exampleMap = LotCodeRuleHelper.buildExampleDataForGL((DynamicObjectCollection)entry);
        exmaple.setLocaleValue_en((String)exampleMap.get("en"));
        exmaple.setLocaleValue_zh_CN((String)exampleMap.get("zh_CN"));
        exmaple.setLocaleValue_zh_TW((String)exampleMap.get("zh_TW"));
        if (exampleMap.get("en") == null) {
            exmaple.setLocaleValue((String)exampleMap.get("zh_CN"));
        }
        if (null == exampleMap.get("zh_CN")) {
            exmaple.setLocaleValue((String)exampleMap.get("en"));
        }
        this.getModel().setValue("example", (Object)exmaple);
        this.getModel().setDataChanged(false);
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        super.afterAddRow(e);
        int index = e.getRowDataEntities()[0].getRowIndex();
        this.lotPropChange(false, index);
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        super.afterDeleteRow(e);
        DynamicObjectCollection entry = this.getModel().getEntryEntity("entryentity");
        if (entry == null || entry.size() == 0) {
            this.getModel().createNewEntryRow("entryentity");
            EntryGrid eg = (EntryGrid)this.getControl("entryentity");
            eg.selectRows(0);
        }
        this.buildExampleDataForGL();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        super.propertyChanged(e);
        Object newValue = e.getChangeSet()[0].getNewValue();
        int index = e.getChangeSet()[0].getRowIndex();
        if (index < 0) {
            return;
        }
        switch (key = e.getProperty().getName()) {
            case "attusingmode": {
                if (ObjectUtils.isEmpty((Object)newValue)) break;
                String useMode = (String)newValue;
                UseModeEnum en = UseModeEnum.getUseModeEnumEnumByValue((String)useMode);
                this.setEnableProp4UseMode(en, index);
                if (UseModeEnum.CUT == en) {
                    this.setDefaultValue(index);
                    break;
                }
                if (UseModeEnum.TOTAL != en) break;
                this.setDefaultValueComplete(index);
                break;
            }
            case "settingvalue": {
                if (LotCodeItemTypeEnum.CONST.getValue().equals(this.getLotProp(index).getString(PROP_TYPE))) {
                    int length = 0;
                    if (!ObjectUtils.isEmpty((Object)newValue)) {
                        length = newValue.toString().length();
                    }
                    this.getModel().setValue("length", (Object)length, index);
                }
                this.buildExampleDataForGL();
                break;
            }
            case "lotprop": {
                this.lotPropChange(newValue != null, index);
                if (!ObjectUtils.isEmpty((Object)newValue)) {
                    DynamicObject lotProp = (DynamicObject)newValue;
                    this.getView().setEnable(Boolean.TRUE, index, new String[]{"isnumaccord"});
                    this.setEnableProp(index, lotProp);
                }
            }
            case "splitsign": 
            case "entrysplitsign": 
            case "format": 
            case "length": {
                this.buildExampleDataForGL();
            }
        }
    }

    private void setDefaultEnable(int index) {
        this.getView().setEnable(Boolean.FALSE, index, COL_Arrays);
    }

    private void setEnableProp4UseMode(UseModeEnum en, int index) {
        if (UseModeEnum.CUT == en) {
            this.getView().setEnable(Boolean.FALSE, index, new String[]{"settingvalue", "step"});
            this.getView().setEnable(Boolean.TRUE, index, new String[]{"attusingmode", "length", "addchar", "addstyle", "cutstyle"});
            if (LotCodeItemTypeEnum.SEQ.getValue().equals(this.getLotProp(index).getString(PROP_TYPE))) {
                this.getView().setEnable(Boolean.FALSE, index, new String[]{"format", "cutstyle"});
            }
        } else if (UseModeEnum.TOTAL == en) {
            this.getView().setEnable(Boolean.FALSE, index, new String[]{"length", "step", "addchar", "addstyle", "cutstyle"});
            if (!LotCodeItemTypeEnum.CONST.getValue().equals(this.getLotProp(index).getString(PROP_TYPE))) {
                this.getView().setEnable(Boolean.FALSE, index, new String[]{"settingvalue"});
            }
        }
    }

    private void setEnableProp(int index, DynamicObject lotProp) {
        this.lotPropChange(lotProp != null, index);
        if (lotProp == null) {
            return;
        }
        switch (LotCodeItemTypeEnum.getLotCodeItemTypeEnumByValue((String)lotProp.getString(PROP_TYPE))) {
            case CONST: {
                this.getView().setEnable(Boolean.FALSE, index, new String[]{"attusingmode", "length", "step", "addchar", "addstyle", "cutstyle"});
                this.getView().setEnable(Boolean.TRUE, index, new String[]{"format", "settingvalue"});
                break;
            }
            case DATE: {
                this.getView().setEnable(Boolean.FALSE, index, new String[]{"attusingmode", "settingvalue", "length", "step", "addchar", "addstyle", "cutstyle"});
                this.getView().setEnable(Boolean.TRUE, index, new String[]{"format"});
                break;
            }
            case SERIALNUM: {
                this.getView().setEnable(Boolean.FALSE, index, new String[]{"attusingmode", "format", "addchar", "addstyle", "cutstyle", "isnumaccord"});
                this.getView().setEnable(Boolean.TRUE, index, new String[]{"settingvalue", "length", "step"});
                break;
            }
            case SEQ: {
                this.getView().setEnable(Boolean.TRUE, index, new String[]{"attusingmode"});
                break;
            }
            case TXT: {
                this.getView().setEnable(Boolean.FALSE, index, new String[]{"settingvalue"});
                this.getView().setEnable(Boolean.TRUE, index, new String[]{"attusingmode", "format"});
            }
        }
        String useMode = (String)this.getModel().getValue("attusingmode", index);
        if (StringUtils.isNotEmpty((String)useMode)) {
            UseModeEnum en = UseModeEnum.getUseModeEnumEnumByValue((String)useMode);
            this.setEnableProp4UseMode(en, index);
        }
    }

    private void setDefaultValueComplete(int index) {
        this.getModel().beginInit();
        this.getModel().setValue("format", (Object)LotCodeFormatEnum.NORMAL.getName(), index);
        this.getModel().setValue("formatvalue", (Object)LotCodeFormatEnum.NORMAL.getValue(), index);
        this.getModel().endInit();
        for (String key : COL_Arrays) {
            this.getView().updateView(key, index);
        }
    }

    private void setDefaultValue(int index) {
        this.getModel().beginInit();
        this.getModel().setValue("settingvalue", null, index);
        this.getModel().setValue("step", null, index);
        this.getModel().setValue("format", (Object)LotCodeFormatEnum.NORMAL.getName(), index);
        this.getModel().setValue("formatvalue", (Object)LotCodeFormatEnum.NORMAL.getValue(), index);
        this.getModel().setValue("addstyle", (Object)"1", index);
        this.getModel().setValue("cutstyle", (Object)"1", index);
        LotCodeItemTypeEnum ienum = LotCodeItemTypeEnum.getLotCodeItemTypeEnumByValue((String)this.getLotProp(index).getString(PROP_TYPE));
        switch (ienum) {
            case TXT: {
                this.getModel().setValue("length", (Object)10, index);
                break;
            }
            case SEQ: {
                this.getModel().setValue("length", (Object)3, index);
                this.getModel().setValue("addchar", (Object)"0", index);
                this.getModel().setValue("addstyle", (Object)"0", index);
                this.getModel().setValue("cutstyle", null, index);
                break;
            }
        }
        this.getModel().endInit();
        for (String key : COL_Arrays) {
            this.getView().updateView(key, index);
        }
    }

    private Integer getFocusRow() {
        String rowIndex = this.getPageCache().get(CACHEKEY_FOCUSROW);
        if (rowIndex == null) {
            return -1;
        }
        return Integer.valueOf(rowIndex);
    }

    private DynamicObject getLotProp() {
        return this.getLotProp(this.getFocusRow());
    }

    private DynamicObject getLotProp(int row) {
        return (DynamicObject)this.getModel().getValue("lotprop", row);
    }

    private void showForm(String formId, Map<String, Object> params, CloseCallBack closeCallBack, ShowType showType) {
        FormShowParameter param = new FormShowParameter();
        param.getOpenStyle().setShowType(showType);
        param.setFormId(formId);
        if (params != null) {
            param.setCustomParams(params);
        }
        if (closeCallBack != null) {
            param.setCloseCallBack(closeCallBack);
        }
        this.getView().showForm(param);
    }

    private boolean checkLotPropIsNull(int row, CellClickEvent evt) {
        Object ob = ((DynamicObject)this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity").get(row)).get("lotprop");
        if (ObjectUtils.isEmpty((Object)ob)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6279\u53f7\u5c5e\u6027\u3002", (String)"LotCodeRulePlugin_0", (String)"bd-sbd-formplugin", (Object[])new Object[0]));
            return true;
        }
        return false;
    }

    private void buildExampleDataForGL() {
        DynamicObjectCollection entry = this.getModel().getDataEntity(true).getDynamicObjectCollection("entryentity");
        ILocaleString exmaple = (ILocaleString)this.getView().getModel().getValue("example");
        Map exampleMap = LotCodeRuleHelper.buildExampleDataForGL((DynamicObjectCollection)entry);
        exmaple.setLocaleValue_en((String)exampleMap.get("en"));
        exmaple.setLocaleValue_zh_CN((String)exampleMap.get("zh_CN"));
        exmaple.setLocaleValue_zh_TW((String)exampleMap.get("zh_TW"));
        if (exampleMap.get("en") == null) {
            exmaple.setLocaleValue((String)exampleMap.get("zh_CN"));
        }
        if (null == exampleMap.get("zh_CN")) {
            exmaple.setLocaleValue((String)exampleMap.get("en"));
        }
        this.getModel().setValue("example", (Object)exmaple);
    }

    private void lotPropChange(boolean enable, int row) {
        this.getView().setEnable(Boolean.valueOf(enable), row, new String[]{"format", "cutstyle", "settingvalue", "attusingmode", "length", "step", "addchar", "addstyle", "isnumaccord"});
        this.getView().setEnable(Boolean.valueOf(row != 0 && enable), row, new String[]{"entrysplitsign"});
        if (enable && LotCodeItemTypeEnum.SEQ.getValue().equals(this.getLotProp(row).getString(PROP_TYPE))) {
            this.getView().setEnable(Boolean.FALSE, row, new String[]{"format", "cutstyle"});
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        Object modifier = this.getModel().getValue("modifier");
        if (modifier != null) {
            this.getView().setVisible(Boolean.TRUE, new String[]{"pagepanel"});
        }
    }
}

