/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.sbd.formplugin.manustrassign;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bd.sbd.utils.SbdEntityTypeUtils;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.operate.Audit;
import kd.bos.entity.operate.Save;
import kd.bos.entity.operate.Submit;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;

public class ManuStrAssignEditPlugin
extends AbstractBasePlugIn {
    public static final String CLOSECALLBACK_SELECTMATEIRALPLAN = "selectMateiralPlan";
    public static final String NEWASSIGNENTRY = "newassignentry";
    public static final String MPDM_MATERIALPLAN = "mpdm_materialplan";
    protected static final String FILTERGRIDAP = "filtergridap";
    private static final Log log = LogFactory.getLog(ManuStrAssignEditPlugin.class);
    protected static final String FILTER = "filter_tag";

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        if (NEWASSIGNENTRY.equals(e.getOperateKey())) {
            this.showMaterialPlans();
        }
    }

    public void afterLoadData(EventObject e) {
        super.afterLoadData(e);
        String billfilterstr = (String)this.getModel().getDataEntity().get(FILTER);
        DynamicObject demandsoure = (DynamicObject)this.getModel().getValue("demandsoure");
        if (demandsoure != null) {
            this.getView().setEnable(Boolean.TRUE, new String[]{FILTERGRIDAP});
            String number = demandsoure.getString("number");
            this.setFilterByDestBillType(number);
        } else {
            this.getView().setEnable(Boolean.FALSE, new String[]{FILTERGRIDAP});
        }
        if (StringUtils.isNotBlank((CharSequence)billfilterstr)) {
            FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)billfilterstr, FilterCondition.class);
            FilterGrid filterGrid = (FilterGrid)this.getView().getControl(FILTERGRIDAP);
            filterGrid.SetValue(filterCondition);
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        String actionId = e.getActionId();
        if (CLOSECALLBACK_SELECTMATEIRALPLAN.equals(actionId)) {
            try (TraceSpan span = Tracer.create((String)"ManuStrAssignEditPlugin", (String)"showMaterialPlanInfos");){
                this.showMaterialPlanInfos(e);
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        super.beforeDoOperation(e);
        if (e.getSource() instanceof Audit || e.getSource() instanceof Submit || e.getSource() instanceof Save) {
            this.beforeSave(e);
        }
    }

    protected void beforeSave(BeforeDoOperationEventArgs e) {
        String number = "";
        if (this.getModel().getValue("number") != null) {
            number = (String)this.getModel().getValue("number");
        }
        log.info("\u6570\u636e\u6e90\u914d\u7f6e" + number + "\u5f00\u59cb\u8fdb\u884c\u8fc7\u6ee4\u6761\u4ef6\u7684\u503c\u4fdd\u5b58");
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl(FILTERGRIDAP);
        FilterGrid.FilterGridState filterGridState = filterGrid.getFilterGridState();
        String filterString = SerializationUtils.toJsonString((Object)filterGridState.getFilterCondition());
        log.info("\u6570\u636e\u6e90\u914d\u7f6e" + number + "\u9700\u8981\u4fdd\u5b58\u7684\u8fc7\u6ee4\u6761\u4ef6\u7684JSON\u5b57\u7b26\u4e32\u7684\u503c\u4e3a:" + filterString);
        this.getModel().setValue(FILTER, (Object)filterString);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        if ("demandsoure".equals(key)) {
            FilterGrid filterGrid = (FilterGrid)this.getView().getControl(FILTERGRIDAP);
            filterGrid.SetValue(new FilterCondition());
            DynamicObject demandsoure = (DynamicObject)this.getModel().getValue("demandsoure");
            if (demandsoure != null) {
                this.getView().setEnable(Boolean.TRUE, new String[]{FILTERGRIDAP});
                String number = demandsoure.getString("number");
                this.setFilterByDestBillType(number);
            } else {
                this.getView().setEnable(Boolean.FALSE, new String[]{FILTERGRIDAP});
            }
            this.getView().updateView(FILTERGRIDAP);
        }
    }

    protected void setFilterByDestBillType(String number) {
        if (number != null) {
            SbdEntityTypeUtils helper = new SbdEntityTypeUtils();
            MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)number);
            List cols = helper.getFilterColumns((IDataEntityType)mainEntityType);
            FilterGrid filterGrid = (FilterGrid)this.getView().getControl(FILTERGRIDAP);
            filterGrid.setEntityNumber(mainEntityType.getName());
            filterGrid.setFilterColumns(cols);
            this.getView().updateView(FILTERGRIDAP);
        }
    }

    private void showMaterialPlanInfos(ClosedCallBackEvent e) {
        ListSelectedRowCollection col = (ListSelectedRowCollection)e.getReturnData();
        if (col == null || col.size() == 0) {
            return;
        }
        int rowCount = this.getModel().getEntryRowCount("assignentry");
        HashSet<Object> materialPlanIds = new HashSet<Object>(rowCount);
        for (int i = 0; i < rowCount; ++i) {
            Long materialPlanId = (Long)this.getModel().getValue("mateiralplanid", i);
            materialPlanIds.add(materialPlanId);
        }
        ArrayList<Long> materialPlanIdsToAdd = new ArrayList<Long>();
        for (ListSelectedRow row : col) {
            Long newMaterialPlanId = (Long)row.getPrimaryKeyValue();
            if (materialPlanIds.contains(newMaterialPlanId)) continue;
            materialPlanIdsToAdd.add(newMaterialPlanId);
        }
        if (materialPlanIdsToAdd.size() > 0) {
            this.getModel().batchCreateNewEntryRow("assignentry", materialPlanIdsToAdd.size());
            Map materialPlans = BusinessDataServiceHelper.loadFromCache((String)MPDM_MATERIALPLAN, (String)"id,masterid.id,masterid.number,masterid.name", (QFilter[])new QFilter[]{new QFilter("id", "in", materialPlanIdsToAdd)});
            this.getModel().beginInit();
            for (int i = 0; i < materialPlanIdsToAdd.size(); ++i) {
                Long materialPlanId = (Long)materialPlanIdsToAdd.get(i);
                DynamicObject materialPlan = (DynamicObject)materialPlans.get(materialPlanId);
                String number = materialPlan.getString("masterid.number");
                String name = materialPlan.getString("masterid.name");
                this.getModel().setValue("mateiralplanid", (Object)materialPlanId, i + rowCount);
                this.getModel().setValue("materialplannumber", (Object)number, i + rowCount);
                this.getModel().setValue("mateiralplanname", (Object)name, i + rowCount);
                this.getModel().setValue("material", (Object)materialPlan.getLong("masterid.id"), i + rowCount);
            }
            this.getModel().endInit();
            this.getView().updateView("assignentry");
        }
    }

    private void showMaterialPlans() {
        ListShowParameter lsp = ShowFormHelper.createShowListForm((String)MPDM_MATERIALPLAN, (boolean)true, (int)2);
        int rowCount = this.getModel().getEntryRowCount("assignentry");
        Object[] muids = new Long[rowCount];
        for (int i = 0; i < rowCount; ++i) {
            muids[i] = this.getModel().getValue("mateiralplanid", i);
        }
        lsp.setSelectedRows(muids);
        lsp.setFormId("mpdm_materialtreelistf7");
        lsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CLOSECALLBACK_SELECTMATEIRALPLAN));
        this.getView().showForm((FormShowParameter)lsp);
    }
}

