/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.pbd.mservice;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bd.pbd.PbdGroupStandardUtils;
import kd.bd.pbd.mservice.CategoryParam;
import kd.bd.pbd.mservice.CategoryParamWrapper;
import kd.bd.pbd.mservice.IStrategyResultService;
import kd.bd.pbd.mservice.PurchaseOrgResultService;
import kd.bd.pbd.mservice.PurchaseStrategyResultService;
import kd.bd.pbd.mservice.api.ICategoryService;
import kd.bos.algo.DataSet;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.bd.engine.BaseDataUseRelQueryEngine;
import kd.bos.bd.pojo.BaseDataUseRelBit;
import kd.bos.bd.service.BaseDataCommonService;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import org.roaringbitmap.RoaringBitmap;

public class CategoryServiceImp
implements ICategoryService {
    private static Log log = LogFactory.getLog(CategoryServiceImp.class);
    private static final String SUCCESS = "success";
    private static final String ERROR_INFO = "error";
    private static final String DATA = "data";
    private static final String CLASS_TYPE = "classtype";
    private static final Map<String, Set<String>> DATA_TYPE = new HashMap<String, Set<String>>(2);
    private static final Map<String, Integer> CTL_STRATEGY_PRIORITY = new HashMap<String, Integer>(5);

    public Map<String, Object> batchGetPurChaseOrg(List<Map<String, Object>> paramMap, List<String> uniqueKeys, Map<String, String> extPropertyMap, Map<String, String> resultProperty, String entityKey) {
        Map<String, Object> resultMap = this.buildDefaultResult();
        Long standardId = PbdGroupStandardUtils.getMaterialGroupType((String)entityKey);
        HashMap<String, List<CategoryParam>> categoryToParam = new HashMap<String, List<CategoryParam>>(16);
        HashMap<String, List<CategoryParam>> materialToParam = new HashMap<String, List<CategoryParam>>(16);
        Map dataMap = (Map)resultMap.get(DATA);
        try {
            Object[] result = this.dealParam(categoryToParam, materialToParam, paramMap, "batchGetPurChaseOrg");
            if (result != null && result.length == 3 && extPropertyMap != null) {
                extPropertyMap.put("ctrlstrategy", "ctrlstrategy");
                extPropertyMap.put("auditdate", "auditdate");
                extPropertyMap.put("type", "type");
                extPropertyMap.put(CLASS_TYPE, CLASS_TYPE);
                if (result[0] instanceof HashSet && result[1] instanceof HashSet && result[2] instanceof HashSet) {
                    HashSet regOrgIds = (HashSet)result[0];
                    HashSet categoryIds = (HashSet)result[1];
                    HashSet materialIds = (HashSet)result[2];
                    extPropertyMap.put("baseDataId", "material.id");
                    CategoryParamWrapper wrapper = new CategoryParamWrapper(uniqueKeys, extPropertyMap, resultProperty);
                    wrapper.setTargetEntity("bd_centralpurchaselist");
                    wrapper.setResultService(new PurchaseOrgResultService());
                    wrapper.setBaseDataIds(materialIds);
                    Map<Long, List<Long>> supCtrlUnitIfIsUnCtrlUint = this.getSupCtrlUnitIfIsUnCtrlUint(regOrgIds, wrapper.getTargetEntity());
                    wrapper.setSupCtrlUnitIfIsUnCtrlUint(supCtrlUnitIfIsUnCtrlUint);
                    wrapper.setMaterialToParam(materialToParam);
                    wrapper.setProperty("baseDataId");
                    wrapper.setUniqueKeys(uniqueKeys);
                    wrapper.setSelectExpress(wrapper.wrapSelectExpress());
                    this.dealBaseDataInfo(wrapper);
                    categoryIds.addAll(this.bindMaterialAndCategory(categoryToParam, materialToParam, standardId));
                    Map<Long, LinkedList<Long>> groupLongNumMaps = this.getLongNumMapByCategory(categoryIds, standardId);
                    extPropertyMap.put("baseDataId", "category.id");
                    wrapper.setBaseDataIds(categoryIds);
                    wrapper.setProperty("baseDataId");
                    wrapper.setMaterialToParam(categoryToParam);
                    wrapper.setGroupLongNumMaps(groupLongNumMaps);
                    wrapper.setSelectExpress(wrapper.wrapSelectExpress());
                    this.dealBaseDataInfo(wrapper);
                    dataMap.putAll(wrapper.getResultMap());
                }
            }
        }
        catch (KDBizException e) {
            this.buildFailResult(e.getMessage(), resultMap);
            log.error(e.getMessage());
        }
        return resultMap;
    }

    public Map<String, Object> batchGetPurChaseOrg(List<Map<String, Object>> paramMap, String entityKey) {
        ArrayList<String> keys = new ArrayList<String>(4);
        keys.add("orgId");
        keys.add("baseDataId");
        keys.add("bizType");
        keys.add("baseDataType");
        HashMap<String, String> propertyMap = new HashMap<String, String>(5);
        propertyMap.put("orgId", "entryentity.orgsch.entryentity.entryreqorg");
        propertyMap.put("bizType", "entryentity.biztype");
        propertyMap.put("baseDataType", "type");
        propertyMap.put("purchaseOrgId", "entryentity.orgsch.entryentity.entryorg");
        propertyMap.put("entryentity.orgsch", "entryentity.orgsch");
        propertyMap.put(CLASS_TYPE, CLASS_TYPE);
        HashMap<String, String> resultProMap = new HashMap<String, String>(2);
        resultProMap.put("orgId", "purchaseOrgId");
        resultProMap.put(CLASS_TYPE, CLASS_TYPE);
        resultProMap.put("ctrlstrategy", "ctrlstrategy");
        return this.batchGetPurChaseOrg(paramMap, keys, propertyMap, resultProMap, entityKey);
    }

    private void buildFailResult(String message, Map<String, Object> resultMap) {
        resultMap.put(SUCCESS, Boolean.FALSE);
        resultMap.put(ERROR_INFO, message);
    }

    private Map<String, Object> buildDefaultResult() {
        HashMap<String, Object> resultMap = new HashMap<String, Object>(3);
        HashMap dataMap = new HashMap(1);
        resultMap.put(SUCCESS, Boolean.TRUE);
        resultMap.put(ERROR_INFO, "");
        resultMap.put(DATA, dataMap);
        return resultMap;
    }

    private Object[] dealParam(Map<String, List<CategoryParam>> categoryToParam, Map<String, List<CategoryParam>> materialToParam, List<Map<String, Object>> paramMap, String type) throws KDBizException {
        Object[] result = new Object[]{new HashSet(), new HashSet(), new HashSet()};
        if (paramMap.size() > 10000) {
            throw new KDBizException(ResManager.loadKDString((String)"\u63a5\u53e3\u8bf7\u6c42\u6279\u91cf\u6700\u5927\u4e0d\u8d85\u8fc71\u4e07\u3002", (String)"CategoryServiceImp_0", (String)"bd-pbd-mservice", (Object[])new Object[0]));
        }
        for (Map<String, Object> param : paramMap) {
            String baseDataType = this.getStringValue(param, "baseDataType", true);
            Long orgId = this.getLongValue(param, "orgId", true);
            Long baseDataId = this.getLongValue(param, "baseDataId", true);
            StringBuilder keySb = new StringBuilder();
            keySb.append(orgId).append("-").append(baseDataId);
            String paramKey = keySb.toString();
            this.getStringValue(param, "bizType", StringUtils.equals((CharSequence)type, (CharSequence)"batchGetPurChaseOrg"));
            List<CategoryParam> params = null;
            CategoryParam info = new CategoryParam(param);
            ((HashSet)result[0]).add(orgId);
            if ("1".equals(baseDataType)) {
                ((HashSet)result[1]).add(baseDataId);
                params = categoryToParam.get(paramKey);
                if (params == null) {
                    params = new ArrayList<CategoryParam>();
                    categoryToParam.put(paramKey, params);
                }
                params.add(info);
                continue;
            }
            ((HashSet)result[2]).add(baseDataId);
            params = materialToParam.get(paramKey);
            if (params == null) {
                params = new ArrayList<CategoryParam>();
                materialToParam.put(paramKey, params);
            }
            params.add(info);
        }
        return result;
    }

    private String getStringValue(Map<String, Object> param, String property, boolean mustInput) throws KDBizException {
        Set<String> enumValues = DATA_TYPE.get(property);
        Object value = param.get(property);
        if (mustInput) {
            if (enumValues != null && !enumValues.contains(value)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8f93\u5165\u53c2\u6570\u5c5e\u6027\u201c%1$s\u201d\u503c\u4e0d\u7b26\u5408\u6761\u4ef6\u3002", (String)"CategoryServiceImp_1", (String)"bd-pbd-mservice", (Object[])new Object[0]), property));
            }
            if (value == null) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8f93\u5165\u53c2\u6570\u5c5e\u6027\u201c%1$s\u201d\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"CategoryServiceImp_2", (String)"bd-pbd-mservice", (Object[])new Object[0]), property));
            }
            if (!(value instanceof String)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8f93\u5165\u53c2\u6570\u5c5e\u6027\u201c%1$s\u201d\u6570\u636e\u503c\u7c7b\u578b\u4e0d\u5408\u6cd5\u3002", (String)"CategoryServiceImp_3", (String)"bd-pbd-mservice", (Object[])new Object[0]), property));
            }
        }
        return (String)value;
    }

    private Long getLongValue(Map<String, Object> param, String property, boolean mustInput) throws KDBizException {
        Object value = param.get(property);
        if (mustInput && value == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8f93\u5165\u53c2\u6570\u5c5e\u6027\u201c%1$s\u201d\u4e0d\u5141\u8bb8\u4e3a\u7a7a\u3002", (String)"CategoryServiceImp_2", (String)"bd-pbd-mservice", (Object[])new Object[0]), property));
        }
        if (!(value instanceof Long)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8f93\u5165\u53c2\u6570\u5c5e\u6027\u201c%1$s\u201d\u6570\u636e\u503c\u7c7b\u578b\u4e0d\u5408\u6cd5\u3002", (String)"CategoryServiceImp_3", (String)"bd-pbd-mservice", (Object[])new Object[0]), property));
        }
        return (Long)value;
    }

    private void matchStrategyInfo(CategoryParamWrapper wrapper, QFilter qFilter, Map<Long, BaseDataUseRelBit> relBitMap) {
        String baseProperty = wrapper.getProperty();
        String selectProperty = wrapper.getSelectExpress();
        Map<Long, List<Long>> supCtrlUnitIfIsUnCtrlUint = wrapper.getSupCtrlUnitIfIsUnCtrlUint();
        if (supCtrlUnitIfIsUnCtrlUint != null && !supCtrlUnitIfIsUnCtrlUint.isEmpty()) {
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)wrapper.getTargetEntity(), (String)("id,bitindex,createorg," + selectProperty), (QFilter[])new QFilter[]{qFilter}, (String)"auditdate desc,ctrlstrategy desc");){
                for (Row row : dataSet) {
                    String uniqueKey2;
                    String ctrlstrategy = row.getString("ctrlstrategy");
                    List<String> uniqueKeys = wrapper.getUniqueKeys();
                    RowMeta rowMeta = dataSet.getRowMeta();
                    HashMap<String, Object> resultValues = new HashMap<String, Object>();
                    for (String uniqueKey2 : uniqueKeys) {
                        Field field = rowMeta.getField(uniqueKey2, false);
                        if (field == null) continue;
                        resultValues.put(uniqueKey2, row.getString(uniqueKey2));
                    }
                    CategoryParam param = new CategoryParam();
                    param.setParam(resultValues);
                    uniqueKey2 = wrapper.buildUniqueKey(param);
                    Map<String, Object> mapResult = wrapper.dealResult(row, dataSet);
                    HashMap<String, Map<String, Object>> centoMap = new HashMap<String, Map<String, Object>>();
                    centoMap.put(uniqueKey2, mapResult);
                    String key = null;
                    mapResult.put("bitindex", row.getInteger("bitindex"));
                    List<Map<String, Map<String, Object>>> values = null;
                    if ("7".equals(ctrlstrategy)) {
                        key = row.getString("createorg") + "-" + row.getString(baseProperty);
                        values = this.getOrCreateValue(key, wrapper.getPrivacyMap());
                    } else if ("5".equals(ctrlstrategy)) {
                        key = row.getString(baseProperty);
                        values = this.getOrCreateValue(key, wrapper.getPublicMap());
                    } else if ("6".equals(ctrlstrategy)) {
                        key = row.getString("createorg") + "-" + row.getString(baseProperty);
                        values = this.getOrCreateValue(key, wrapper.getShareInScopeMap());
                    } else {
                        key = row.getString(baseProperty);
                        values = this.getOrCreateValue(key, wrapper.getResultIndexMap());
                    }
                    values.add(centoMap);
                }
            }
            Map<String, List<CategoryParam>> materialToParam = wrapper.getMaterialToParam();
            for (Map.Entry<String, List<CategoryParam>> next : materialToParam.entrySet()) {
                LinkedList<Long> categoryIds;
                String key = next.getKey();
                List<CategoryParam> values = next.getValue();
                String[] split = key.split("-");
                String orgId = split[0];
                String baseDateId = split[1];
                this.matchStrategyPriority(wrapper, orgId, baseDateId, values, relBitMap, supCtrlUnitIfIsUnCtrlUint);
                if (wrapper.getGroupLongNumMaps() == null || (categoryIds = wrapper.getGroupLongNumMaps().get(Long.valueOf(baseDateId))) == null) continue;
                for (Long categoryId : categoryIds) {
                    this.matchStrategyPriority(wrapper, orgId, String.valueOf(categoryId), values, relBitMap, supCtrlUnitIfIsUnCtrlUint);
                }
            }
        }
    }

    private Map<Long, List<Long>> getSupCtrlUnitIfIsUnCtrlUint(Set<Long> orgIds, String entity) {
        DynamicObject ctrlView = BaseDataServiceHelper.getCtrlview((String)entity);
        HashMap<Long, List<Long>> unCuToAllParentCuMap = new HashMap<Long, List<Long>>();
        String treeType = ctrlView.getString("treetype");
        if (!"16".equals(treeType)) {
            for (Long tempOrgId : orgIds) {
                this.putParentCu(unCuToAllParentCuMap, tempOrgId, tempOrgId);
            }
            return unCuToAllParentCuMap;
        }
        HashMap<Long, String> unCuOrgLongNumberMap = new HashMap<Long, String>(orgIds.size());
        QFilter viewFilter = new QFilter("view.id", "=", (Object)ctrlView.getLong("id"));
        QFilter orgFilter = new QFilter("org.id", "in", orgIds);
        QFilter[] filters = new QFilter[]{viewFilter, orgFilter};
        String selectFields = "org.id, isctrlunit, level, longnumber";
        Map viewOrgArr = BusinessDataServiceHelper.loadFromCache((String)"bos_org_structure", (String)selectFields, (QFilter[])filters);
        for (DynamicObject viewOrg : viewOrgArr.values()) {
            Long tempOrgId = (Long)viewOrg.get("org.id");
            if (viewOrg.getBoolean("isctrlunit") || viewOrg.getInt("level") == 1) {
                this.putParentCu(unCuToAllParentCuMap, tempOrgId, tempOrgId);
            }
            unCuOrgLongNumberMap.put(viewOrg.getLong("org.id"), viewOrg.getString("longnumber"));
        }
        if (CollectionUtils.isEmpty(unCuOrgLongNumberMap.values())) {
            return unCuToAllParentCuMap;
        }
        String sep = OrgUnitServiceHelper.getOrgSeparation().getLongNumberSep();
        HashSet<String> allLongNumberSet = new HashSet<String>(orgIds.size());
        for (String longNumber : unCuOrgLongNumberMap.values()) {
            while (longNumber.contains(sep)) {
                longNumber = longNumber.substring(0, longNumber.lastIndexOf(sep));
                allLongNumberSet.add(longNumber);
            }
        }
        QFilter longNumberFilter = new QFilter("longnumber", "in", allLongNumberSet);
        filters = new QFilter[]{viewFilter, longNumberFilter};
        Map allParentOrgArr = BusinessDataServiceHelper.loadFromCache((String)"bos_org_structure", (String)selectFields, (QFilter[])filters);
        HashMap<String, DynamicObject> parentOrgMap = new HashMap<String, DynamicObject>(allParentOrgArr.size());
        for (DynamicObject parentOrg : allParentOrgArr.values()) {
            parentOrgMap.put(parentOrg.getString("longnumber"), parentOrg);
        }
        for (Map.Entry next : unCuOrgLongNumberMap.entrySet()) {
            DynamicObject parentOrg;
            String longNumber = (String)next.getValue();
            while (longNumber.contains(sep) && null != (parentOrg = (DynamicObject)parentOrgMap.get(longNumber = longNumber.substring(0, longNumber.lastIndexOf(sep)))) && parentOrg.getBoolean("isctrlunit")) {
                Long tempOrgId = (Long)parentOrg.get("org.id");
                this.putParentCu(unCuToAllParentCuMap, (Long)next.getKey(), tempOrgId);
            }
        }
        return unCuToAllParentCuMap;
    }

    private void putParentCu(Map<Long, List<Long>> unCuToAllParentCuMap, Long tempOrgId, Long parentCu) {
        List<Long> parentCus = unCuToAllParentCuMap.get(tempOrgId);
        if (parentCus == null) {
            parentCus = new LinkedList<Long>();
            unCuToAllParentCuMap.put(tempOrgId, parentCus);
        }
        parentCus.add(parentCu);
    }

    private void matchStrategyPriority(CategoryParamWrapper wrapper, String orgId, String baseDateId, List<CategoryParam> values, Map<Long, BaseDataUseRelBit> relBitMap, Map<Long, List<Long>> supCtrlUnitIfIsUnCtrlUint) {
        String rowKey = orgId + "-" + baseDateId;
        List<Long> parentCus = supCtrlUnitIfIsUnCtrlUint.get(Long.valueOf(orgId));
        IStrategyResultService resultService = wrapper.getResultService();
        if (resultService == null || wrapper.getPrivacyMap().isEmpty() && wrapper.getResultIndexMap().isEmpty() && wrapper.getPublicMap().isEmpty() && wrapper.getShareInScopeMap().isEmpty()) {
            return;
        }
        if (parentCus != null && parentCus.size() > 0) {
            BaseDataUseRelBit baseDataUseRelBit;
            List<Map<String, Map<String, Object>>> maps = wrapper.getPrivacyMap().get(parentCus.get(0) + "-" + baseDateId);
            if (maps != null) {
                for (Map<String, Map<String, Object>> centralPurchaseMap : maps) {
                    resultService.dealMatchResult(rowKey, values, wrapper, centralPurchaseMap, false);
                }
            }
            if ((baseDataUseRelBit = relBitMap.get(parentCus.get(0))) != null) {
                RoaringBitmap bit = baseDataUseRelBit.getBit();
                maps = wrapper.getResultIndexMap().get(baseDateId);
                if (maps != null) {
                    for (Map<String, Map<String, Object>> map : maps) {
                        for (Map.Entry<String, Map<String, Object>> next1 : map.entrySet()) {
                            Map<String, Object> value = next1.getValue();
                            Integer bitindex = (Integer)value.get("bitindex");
                            if (!bit.contains(bitindex.intValue())) continue;
                            resultService.dealMatchResult(rowKey, values, wrapper, map, false);
                        }
                    }
                }
            }
            if (wrapper.getShareInScopeMap().size() > 0) {
                for (Long l : parentCus) {
                    maps = wrapper.getShareInScopeMap().get(l + "-" + baseDateId);
                    if (maps == null) continue;
                    for (Map<String, Map<String, Object>> centralPurchaseMap : maps) {
                        resultService.dealMatchResult(rowKey, values, wrapper, centralPurchaseMap, false);
                    }
                }
            }
            if ((maps = wrapper.getPublicMap().get(baseDateId)) != null && values.size() > 0) {
                for (Map map : maps) {
                    resultService.dealMatchResult(rowKey, values, wrapper, map, true);
                }
            }
        }
    }

    private List<Map<String, Map<String, Object>>> getOrCreateValue(String key, Map<String, List<Map<String, Map<String, Object>>>> resultMap) {
        List<Map<String, Map<String, Object>>> values = resultMap.get(key);
        if (values == null) {
            values = new ArrayList<Map<String, Map<String, Object>>>();
            resultMap.put(key, values);
        }
        return values;
    }

    private void matchNormalType(CategoryParamWrapper wrapper, String property) {
        Map<String, List<CategoryParam>> materialToParams = wrapper.getMaterialToParam();
        Iterator<Map.Entry<String, List<CategoryParam>>> iters = materialToParams.entrySet().iterator();
        IStrategyResultService resultService = wrapper.getResultService();
        if (resultService == null) {
            return;
        }
        while (iters.hasNext()) {
            Long baseDataId;
            Long orgId;
            QFilter baseDataCentralFilter;
            CategoryParam categoryParam;
            String[] split;
            Map.Entry<String, List<CategoryParam>> next = iters.next();
            String key = next.getKey();
            List<CategoryParam> values = next.getValue();
            if (StringUtils.isBlank((CharSequence)key) || (split = key.split("-")).length != 2 || values == null || values.size() <= 0 || (categoryParam = values.get(0)) == null || (baseDataCentralFilter = this.getBaseDataCentralFilter(property, orgId = Long.valueOf(String.valueOf(split[0])), baseDataId = Long.valueOf(String.valueOf(split[1])), wrapper)) == null) continue;
            HashMap<String, Map<String, Object>> centralPurchaseMap = new HashMap<String, Map<String, Object>>(1024);
            String selectProperty = wrapper.getSelectExpress();
            DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)wrapper.getTargetEntity(), (String)selectProperty, (QFilter[])new QFilter[]{baseDataCentralFilter}, null);
            Throwable throwable = null;
            try {
                boolean isPublic = this.dealDataSetWithStrategy(centralPurchaseMap, dataSet, wrapper);
                resultService.dealMatchResult(key, values, wrapper, centralPurchaseMap, isPublic);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (dataSet == null) continue;
                if (throwable != null) {
                    try {
                        dataSet.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                dataSet.close();
            }
        }
    }

    private boolean dealDataSetWithStrategy(Map<String, Map<String, Object>> centralPurchaseMap, DataSet dataSet, CategoryParamWrapper wrapper) {
        Integer ctrStrategy = null;
        String defaultStrategy = null;
        Date lastTime = null;
        for (Row row : dataSet) {
            CategoryParam param = new CategoryParam();
            List<String> uniqueKeys = wrapper.getUniqueKeys();
            RowMeta rowMeta = dataSet.getRowMeta();
            HashMap<String, Object> resultValues = new HashMap<String, Object>();
            for (String uniqueKey : uniqueKeys) {
                Field field = rowMeta.getField(uniqueKey, false);
                if (field == null) continue;
                resultValues.put(uniqueKey, row.getString(uniqueKey));
            }
            param.setParam(resultValues);
            String uniqueKey = wrapper.buildUniqueKey(param);
            String ctrlstrategy = row.getString("ctrlstrategy");
            Date auditdate = row.getDate("auditdate");
            Integer index = CTL_STRATEGY_PRIORITY.get(ctrlstrategy);
            if (index == null || auditdate == null) continue;
            if (centralPurchaseMap.containsKey(uniqueKey) && ctrStrategy != null) {
                int i = ctrStrategy.compareTo(index);
                if (i < 0 || i == 0 && lastTime != null && lastTime.after(auditdate)) {
                    continue;
                }
            } else {
                ctrStrategy = index;
                defaultStrategy = ctrlstrategy;
                lastTime = auditdate;
            }
            centralPurchaseMap.put(uniqueKey, wrapper.dealResult(row, dataSet));
        }
        return StringUtils.equals(defaultStrategy, (CharSequence)"5");
    }

    private QFilter getBaseDataCentralFilter(String property, Object orgId, Long baseDataId, CategoryParamWrapper wrapper) {
        QFilter qFilter = null;
        if (wrapper != null) {
            LinkedList<Long> categoryIds;
            qFilter = new QFilter(property, "=", (Object)baseDataId);
            QFilter qFilter1 = BaseDataServiceHelper.getBaseDataFilter((String)wrapper.getTargetEntity(), (Long)Long.valueOf(String.valueOf(orgId)));
            HashSet<Long> queryDataIds = new HashSet<Long>(1);
            queryDataIds.add(baseDataId);
            if (wrapper.getGroupLongNumMaps() != null && (categoryIds = wrapper.getGroupLongNumMaps().get(baseDataId)) != null) {
                queryDataIds.addAll(categoryIds);
            }
            qFilter1.and(property, "=", (Object)baseDataId);
            if (qFilter1 != null) {
                qFilter.and(qFilter1);
            }
            qFilter.and("status", "=", (Object)"C");
            qFilter.and("enable", "=", (Object)"1");
        }
        return qFilter;
    }

    private Collection<?> bindMaterialAndCategory(Map<String, List<CategoryParam>> categoryToParam, Map<String, List<CategoryParam>> materialToParam, long standardId) {
        HashMap<Long, Set<Long>> materialToOrgMap = new HashMap<Long, Set<Long>>();
        Set<Object> categoryIds = this.getBaseDataIds(categoryToParam, null);
        Set<Object> materialIds = this.getBaseDataIds(materialToParam, materialToOrgMap);
        if (materialIds.size() > 0) {
            QFilter qFilter = new QFilter("material", "in", materialIds);
            qFilter.and("standard.id", "=", (Object)standardId);
            DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"bd_materialgroupdetail", (String)"group,group.number,material", (QFilter[])new QFilter[]{qFilter}, null);
            for (Row row : dataSet) {
                categoryIds.add(row.getLong("group"));
                Set orgIds = (Set)materialToOrgMap.get(row.getLong("material"));
                if (orgIds == null) continue;
                for (Long orgId : orgIds) {
                    List<CategoryParam> material1 = materialToParam.get(orgId + "-" + row.getString("material"));
                    if (material1 == null) continue;
                    List<CategoryParam> params = categoryToParam.get(orgId + "-" + row.getString("group"));
                    if (params == null) {
                        params = new ArrayList<CategoryParam>();
                        categoryToParam.put(orgId + "-" + row.getString("group"), params);
                    }
                    params.addAll(material1);
                }
            }
        }
        return categoryIds;
    }

    private Set<Object> getBaseDataIds(Map<String, List<CategoryParam>> materialToParam, Map<Long, Set<Long>> materialToOrgMap) {
        HashSet<Object> baseDataIds = new HashSet<Object>(1024);
        for (Map.Entry<String, List<CategoryParam>> next : materialToParam.entrySet()) {
            String[] param;
            String paramKey = next.getKey();
            if (!StringUtils.isNotBlank((CharSequence)paramKey) || (param = paramKey.split("-")).length != 2) continue;
            String org = param[0];
            String baseDataId = param[1];
            Long dataId = Long.valueOf(baseDataId);
            Long orgId = Long.valueOf(org);
            baseDataIds.add(dataId);
            if (materialToOrgMap == null) continue;
            Set<Long> orgIds = materialToOrgMap.get(dataId);
            if (orgIds == null) {
                orgIds = new HashSet<Long>(next.getValue().size());
                materialToOrgMap.put(dataId, orgIds);
            }
            orgIds.add(orgId);
        }
        return baseDataIds;
    }

    private Set<Object> mergeAllCategory(Set<Object> baseDataIds, Map<Long, LinkedList<Long>> groupLongNumMaps) {
        HashSet<Object> resultMap = new HashSet<Object>();
        if (baseDataIds == null || baseDataIds.size() < 1) {
            return resultMap;
        }
        resultMap.addAll(baseDataIds);
        if (groupLongNumMaps != null) {
            for (Object baseDataId : baseDataIds) {
                LinkedList<Long> longs = groupLongNumMaps.get(baseDataId);
                if (longs == null) continue;
                resultMap.addAll(longs);
            }
        }
        return resultMap;
    }

    private Map<Long, LinkedList<Long>> getLongNumMapByCategory(Set<Object> categoryIds, Long standardId) {
        HashMap<Long, LinkedList<Long>> resultList = new HashMap<Long, LinkedList<Long>>();
        HashMap longNumbers = new HashMap();
        HashSet<String> numbers = new HashSet<String>();
        QFilter qFilter = new QFilter("id", "in", categoryIds);
        qFilter.and("standard", "=", (Object)standardId);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"bd_materialgroup", (String)"id,number,longnumber", (QFilter[])new QFilter[]{qFilter}, null);){
            for (Object row : dataSet) {
                LinkedList<String> number = (LinkedList<String>)longNumbers.get(row.getLong("id"));
                if (number == null) {
                    number = new LinkedList<String>();
                    longNumbers.put(row.getLong("id"), number);
                }
                if (!StringUtils.isNotBlank((CharSequence)row.getString("longnumber"))) continue;
                String[] longnumbers = row.getString("longnumber").split("!");
                for (int i = longnumbers.length - 1; i >= 0; --i) {
                    if (i == longnumbers.length - 1) continue;
                    number.add(longnumbers[i]);
                    numbers.add(longnumbers[i]);
                }
            }
        }
        if (numbers.size() > 0) {
            HashMap<String, Long> categoryNumber = new HashMap<String, Long>();
            qFilter = new QFilter("number", "in", numbers);
            qFilter.and("standard", "=", (Object)standardId);
            DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"bd_materialgroup", (String)"id,number", (QFilter[])new QFilter[]{qFilter}, null);
            Object object = null;
            try {
                for (Row row : dataSet) {
                    categoryNumber.put(row.getString("number"), row.getLong("id"));
                }
            }
            catch (Throwable row) {
                object = row;
                throw row;
            }
            finally {
                if (dataSet != null) {
                    if (object != null) {
                        try {
                            dataSet.close();
                        }
                        catch (Throwable row) {
                            ((Throwable)object).addSuppressed(row);
                        }
                    } else {
                        dataSet.close();
                    }
                }
            }
            for (Map.Entry next : longNumbers.entrySet()) {
                Long key = (Long)next.getKey();
                LinkedList<Long> longs = (LinkedList<Long>)resultList.get(key);
                if (longs == null) {
                    longs = new LinkedList<Long>();
                    resultList.put(key, longs);
                }
                LinkedList value = (LinkedList)next.getValue();
                for (String s : value) {
                    Long aLong = (Long)categoryNumber.get(s);
                    longs.add(aLong);
                }
            }
        }
        return resultList;
    }

    public Map<String, Object> matchPurChaseStrategy(List<Map<String, Object>> paramMap, String entityKey) {
        Map<String, Object> resultMap = this.buildDefaultResult();
        Map dataMap = (Map)resultMap.get(DATA);
        HashMap<String, List<CategoryParam>> categoryToParam = new HashMap<String, List<CategoryParam>>();
        HashMap<String, List<CategoryParam>> materialToParam = new HashMap<String, List<CategoryParam>>();
        try {
            Object[] result = this.dealParam(categoryToParam, materialToParam, paramMap, "matchPurChaseStrategy");
            Long standardId = PbdGroupStandardUtils.getMaterialGroupType((String)entityKey);
            if (result != null && result.length == 3) {
                ArrayList<String> uniqueKeys = new ArrayList<String>(1);
                uniqueKeys.add("orgId");
                uniqueKeys.add("baseDataId");
                uniqueKeys.add("baseDataType");
                HashMap<String, String> extPropertyMap = new HashMap<String, String>();
                HashMap<String, String> resultProperty = new HashMap<String, String>();
                extPropertyMap.put("orgId", "createorg");
                extPropertyMap.put("isMal", "schema.ismalpurchase");
                extPropertyMap.put("coptype", "schema.coptype");
                extPropertyMap.put("paycond", "schema.paycond");
                extPropertyMap.put("baseDataType", "type");
                resultProperty.put("isMal", "isMal");
                extPropertyMap.put("ctrlstrategy", "ctrlstrategy");
                extPropertyMap.put("auditdate", "auditdate");
                if (result[0] instanceof HashSet && result[1] instanceof HashSet && result[2] instanceof HashSet) {
                    HashSet regOrgIds = (HashSet)result[0];
                    HashSet categoryIds = (HashSet)result[1];
                    HashSet materialIds = (HashSet)result[2];
                    CategoryParamWrapper wrapper = new CategoryParamWrapper(uniqueKeys, extPropertyMap, resultProperty);
                    wrapper.setTargetEntity("bd_purstrategy");
                    wrapper.setResultService(new PurchaseStrategyResultService());
                    Map<Long, List<Long>> supCtrlUnitIfIsUnCtrlUint = this.getSupCtrlUnitIfIsUnCtrlUint(regOrgIds, wrapper.getTargetEntity());
                    wrapper.setSupCtrlUnitIfIsUnCtrlUint(supCtrlUnitIfIsUnCtrlUint);
                    wrapper.setTargetEntity("bd_purstrategy");
                    wrapper.setBaseDataIds(materialIds);
                    wrapper.setMaterialToParam(materialToParam);
                    extPropertyMap.put("baseDataId", "material.id");
                    wrapper.setProperty("baseDataId");
                    wrapper.setSelectExpress(wrapper.wrapSelectExpress());
                    this.dealBaseDataInfo(wrapper);
                    categoryIds.addAll(this.bindMaterialAndCategory(categoryToParam, materialToParam, standardId));
                    Map<Long, LinkedList<Long>> groupLongNumMaps = this.getLongNumMapByCategory(categoryIds, standardId);
                    wrapper.setBaseDataIds(categoryIds);
                    extPropertyMap.put("baseDataId", "category.id");
                    wrapper.setProperty("baseDataId");
                    wrapper.setSelectExpress(wrapper.wrapSelectExpress());
                    wrapper.setMaterialToParam(categoryToParam);
                    wrapper.setGroupLongNumMaps(groupLongNumMaps);
                    wrapper.setSupCtrlUnitIfIsUnCtrlUint(supCtrlUnitIfIsUnCtrlUint);
                    this.dealBaseDataInfo(wrapper);
                    dataMap.putAll(wrapper.getResultMap());
                }
            }
        }
        catch (KDBizException e) {
            this.buildFailResult(e.getMessage(), resultMap);
            log.error(e.getMessage());
        }
        return resultMap;
    }

    private void dealBaseDataInfo(CategoryParamWrapper wrapper) {
        QFilter qFilter = new QFilter("status", "=", (Object)"C");
        qFilter.and("enable", "=", (Object)"1");
        Set<Object> queryDataIds = this.mergeAllCategory(wrapper.getBaseDataIds(), wrapper.getGroupLongNumMaps());
        if (queryDataIds == null || queryDataIds.size() == 0) {
            return;
        }
        qFilter.and(wrapper.getExtPropertyMap().get(wrapper.getProperty()), "in", queryDataIds);
        HashMap<Long, BaseDataUseRelBit> relBitMap = new HashMap(1);
        Map<Long, List<Long>> supCtrlUnitIfIsUnCtrlUint = wrapper.getSupCtrlUnitIfIsUnCtrlUint();
        ArrayList<Long> cuOrgs = new ArrayList<Long>();
        for (List<Long> value : supCtrlUnitIfIsUnCtrlUint.values()) {
            cuOrgs.addAll(value);
        }
        if (this.isNewModel(wrapper.getTargetEntity())) {
            try {
                relBitMap = BaseDataUseRelQueryEngine.getRelBitMapByOrgIds(cuOrgs, (String)wrapper.getTargetEntity());
            }
            catch (Exception e) {
                throw new KDBizException(e.getMessage());
            }
        }
        IStrategyResultService resultService = wrapper.getResultService();
        ArrayList<Long> orgIds = new ArrayList<Long>(supCtrlUnitIfIsUnCtrlUint.size());
        orgIds.addAll(supCtrlUnitIfIsUnCtrlUint.keySet());
        orgIds.add(0L);
        if (resultService instanceof PurchaseOrgResultService) {
            QFilter orQfilter = new QFilter("entryentity.orgsch.entryentity.entryreqorg", "in", orgIds).or("entryentity.orgsch", "is null", null);
            qFilter.and(orQfilter);
        }
        Set allUseBitByOrgIds = BaseDataUseRelQueryEngine.getAllUseBitByOrgIds(orgIds, (String)wrapper.getTargetEntity());
        qFilter.and(new QFilter("createorg", "in", cuOrgs).or("bitindex", "in", (Object)allUseBitByOrgIds).or("ctrlstrategy", "=", (Object)"5"));
        this.matchStrategyInfo(wrapper, qFilter, relBitMap);
    }

    private boolean isNewModel(String targetEntity) {
        return BaseDataCommonService.isNewModel((String)targetEntity);
    }

    static {
        CTL_STRATEGY_PRIORITY.put("1", 1);
        CTL_STRATEGY_PRIORITY.put("2", 1);
        CTL_STRATEGY_PRIORITY.put("5", 3);
        CTL_STRATEGY_PRIORITY.put("6", 2);
        CTL_STRATEGY_PRIORITY.put("7", 0);
        HashSet<String> baseDataType = new HashSet<String>();
        HashSet<String> bizType = new HashSet<String>();
        baseDataType.add("1");
        baseDataType.add("2");
        bizType.add("1");
        bizType.add("2");
        bizType.add("3");
        DATA_TYPE.put("baseDataType", baseDataType);
        DATA_TYPE.put("bizType", bizType);
    }
}

