/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.master;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.UUID;
import kd.bd.master.helper.BizpartnerHelper;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;

public class BizPartnerFormPlugin
extends AbstractFormPlugin
implements HyperLinkClickListener,
TabSelectListener {
    public static final String TOOLBAR_NAME = "tbmain";
    private static final String TABAP = "tabap";

    public void registerListener(EventObject e) {
        EntryGrid customerEntryGrid = (EntryGrid)this.getView().getControl("entryentity_customer");
        customerEntryGrid.addHyperClickListener((HyperLinkClickListener)this);
        EntryGrid supplierEntryGrid = (EntryGrid)this.getView().getControl("entryentity_supplier");
        supplierEntryGrid.addHyperClickListener((HyperLinkClickListener)this);
        this.addTabSelectListener(this, new String[]{TABAP});
    }

    private void addTabSelectListener(TabSelectListener form, String[] tabName) {
        Tab tab = null;
        int len = tabName.length;
        for (int i = 0; i < len; ++i) {
            tab = (Tab)this.getControl(tabName[i]);
            if (tab == null) continue;
            tab.addTabSelectListener(form);
        }
    }

    public void initialize() {
        this.addItemClickListeners(new String[]{TOOLBAR_NAME});
    }

    public void afterBindData(EventObject e) {
        this.queryEntityData();
    }

    public void afterCreateNewData(EventObject e) {
        this.queryParam();
    }

    private void queryParam() {
        if (BizpartnerHelper.isEnablepartner()) {
            return;
        }
        this.getModel().setValue("status", (Object)"A");
        if (StringUtils.isEmpty((String)((String)this.getModel().getValue("partnerrole")))) {
            this.getModel().setValue("partnerrole", (Object)",1,2,3,");
        }
    }

    private void queryEntityData() {
        DynamicObject[] customers;
        String sql = "id,number,name,bizfunction,type,createorg,internal_company";
        Object pk = this.getModel().getDataEntity().getPkValue();
        DynamicObject[] suppliers = BusinessDataServiceHelper.load((String)"bd_supplier", (String)sql, (QFilter[])new QFilter[]{new QFilter("bizpartner", "=", pk), new QFilter("supplier_status", "in", this.getSupplierStatusPk())});
        if (suppliers != null && suppliers.length > 0) {
            ((DynamicObjectCollection)this.getModel().getValue("entryentity_supplier")).clear();
            this.getModel().batchCreateNewEntryRow("entryentity_supplier", suppliers.length);
            for (int i = 0; i < suppliers.length; ++i) {
                this.getModel().setValue("supnumber", suppliers[i].get("number"), i);
                this.getModel().setValue("supid", suppliers[i].get("id"), i);
                this.getModel().setValue("supname", suppliers[i].get("name"), i);
                this.getModel().setValue("supbizfunction", suppliers[i].get("bizfunction"), i);
                this.getModel().setValue("suptype", suppliers[i].get("type"), i);
                DynamicObject createorg = suppliers[i].getDynamicObject("createorg");
                this.getModel().setValue("supcreateorg", (Object)(createorg != null ? createorg.getString("name") : createorg), i);
                DynamicObject internalCompany = suppliers[i].getDynamicObject("internal_company");
                this.getModel().setValue("supinternal_company", (Object)(internalCompany != null ? internalCompany.getString("name") : internalCompany), i);
            }
        }
        if ((customers = BusinessDataServiceHelper.load((String)"bd_customer", (String)sql, (QFilter[])new QFilter[]{new QFilter("bizpartner", "=", pk), new QFilter("customerstatus", "in", this.getCustomerStatusPk())})) != null && customers.length > 0) {
            ((DynamicObjectCollection)this.getModel().getValue("entryentity_customer")).clear();
            this.getModel().batchCreateNewEntryRow("entryentity_customer", customers.length);
            for (int i = 0; i < customers.length; ++i) {
                this.getModel().setValue("cusnumber", customers[i].get("number"), i);
                this.getModel().setValue("cusid", customers[i].get("id"), i);
                this.getModel().setValue("cusname", customers[i].get("name"), i);
                this.getModel().setValue("cusbizfunction", customers[i].get("bizfunction"), i);
                this.getModel().setValue("custype", customers[i].get("type"), i);
                DynamicObject createorg = customers[i].getDynamicObject("createorg");
                this.getModel().setValue("cuscreateorg", (Object)(createorg != null ? createorg.getString("name") : createorg), i);
                DynamicObject internalCompany = customers[i].getDynamicObject("internal_company");
                this.getModel().setValue("cusinternal_company", (Object)(internalCompany != null ? internalCompany.getString("name") : internalCompany), i);
            }
        }
        this.getModel().setDataChanged(false);
    }

    private List<Long> getSupplierStatusPk() {
        ArrayList<Long> ids = null;
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT FID FROM T_BD_SUPPLIERSTATUS A WHERE(SELECT COUNT(1) FROM T_BD_SUPPLIERSTATUSEXCLUD B WHERE A.FID=B.FSUPPLIERSTATUS)=0 ");
        DataSet ds = DB.queryDataSet((String)(((Object)((Object)this)).getClass().getName() + UUID.randomUUID()), (DBRoute)DBRoute.basedata, (String)sql.toString(), null);
        if (ds != null) {
            ids = new ArrayList<Long>();
            for (Row row : ds) {
                ids.add(row.getLong("FID"));
            }
        }
        return ids;
    }

    private List<Long> getCustomerStatusPk() {
        ArrayList<Long> ids = null;
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT FID FROM T_BD_CUSTOMERSTATUS A WHERE(SELECT COUNT(1) FROM T_BD_CUSTOMERSTATUSEXCLUD B WHERE A.FID=B.FCUSTOMERSTATUS)=0  ");
        DataSet ds = DB.queryDataSet((String)(((Object)((Object)this)).getClass().getName() + UUID.randomUUID()), (DBRoute)DBRoute.basedata, (String)sql.toString(), null);
        if (ds != null) {
            ids = new ArrayList<Long>();
            for (Row row : ds) {
                ids.add(row.getLong("FID"));
            }
        }
        return ids;
    }

    public void hyperLinkClick(HyperLinkClickEvent e) {
        String fieldName = e.getFieldName();
        int rowIndex = e.getRowIndex();
        BaseShowParameter formShowParameter = null;
        if ("supnumber".equals(fieldName)) {
            Object pk = this.getModel().getValue("supid", rowIndex);
            formShowParameter = this.createFormShowParameter("bd_supplier", pk, ResManager.loadKDString((String)"\u4f9b\u5e94\u5546", (String)"BizPartnerFormPlugin_0", (String)"bd-master-formplugin", (Object[])new Object[0]));
        } else if ("cusnumber".equals(fieldName)) {
            Object pk = this.getModel().getValue("cusid", rowIndex);
            formShowParameter = this.createFormShowParameter("bd_customer", pk, ResManager.loadKDString((String)"\u5ba2\u6237", (String)"BizPartnerFormPlugin_1", (String)"bd-master-formplugin", (Object[])new Object[0]));
        }
        this.getView().showForm(formShowParameter);
    }

    private BaseShowParameter createFormShowParameter(String formId, Object pk, String caption) {
        BaseShowParameter formShowParameter = new BaseShowParameter();
        formShowParameter.setFormId(formId);
        formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        formShowParameter.setCaption(caption);
        formShowParameter.setPkId(pk);
        formShowParameter.setStatus(OperationStatus.VIEW);
        formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        return formShowParameter;
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propName = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        Object oldValue = e.getChangeSet()[0].getOldValue();
        if ("type".equals(propName)) {
            if (!"1".equals(newValue) && !"3".equals(newValue)) {
                this.getModel().setValue("internal_company", null);
                this.getModel().setValue("corporation", (Object)false);
            } else if ("4".equals(oldValue)) {
                this.getModel().setValue("idno", (Object)"");
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        FormOperate formOperate = (FormOperate)afterDoOperationEventArgs.getSource();
        String operate = formOperate.getOperateKey();
        if ("save".equals(operate) || "submit".equals(operate)) {
            boolean corporation = this.getModel().getDataEntity().getBoolean("corporation");
            long id = this.getModel().getDataEntity().getLong("id");
            if (corporation) {
                this.getModel().setValue("affiliatedgroup", (Object)id);
            }
        }
    }

    public void tabSelected(TabSelectEvent arg0) {
        String tabKey = arg0.getTabKey();
        if ("tabpageap1".equals(tabKey)) {
            this.getModel().deleteEntryData("entryentity_supplier");
            this.getModel().deleteEntryData("entryentity_customer");
            this.queryEntityData();
        } else if ("tabpageap2".equals(tabKey)) {
            this.getModel().deleteEntryData("entryentity_supplier");
            this.getModel().deleteEntryData("entryentity_customer");
            this.queryEntityData();
        }
    }
}

