/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.master;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bd.master.MasterDataFormPlugin;
import kd.bd.master.enums.MaterialInfoEntityTypeEnum;
import kd.bd.master.enums.MaterialInfoEnum;
import kd.bd.master.helper.GroupStandardHelper;
import kd.bd.master.helper.MasterDataHelper;
import kd.bd.master.helper.MaterialServiceHelper;
import kd.bd.master.util.ErrorInfoConverUtil;
import kd.bd.master.util.GroupStandardUtils;
import kd.bd.master.util.OperteUtils;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.container.Tab;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.notification.IconType;
import kd.bos.notification.NotificationBody;
import kd.bos.notification.NotificationFormInfo;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.notification.NotificationServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;

public class MaterialDataFormPlugin
extends MasterDataFormPlugin
implements TabSelectListener,
BeforeF7SelectListener {
    private static Log logger = LogFactory.getLog(MaterialDataFormPlugin.class);
    public static final String TABPAGE_UNITINFO = "tabpage_unitinfo";
    public static final String TABPAGEAP = "tabpageap";
    public static final String BTN_ADDROW = "btn_addrow";
    public static final String NEW_NULL_FID = "0";
    public static final String BTN_SAVESTANDARD = "btn_savestandard";
    public static final String BAR_DELETE = "bar_delete";
    public static final String CLOSECALLBACK_SELECTMUS = "selectMUs";
    public static final String PGCACHE_CURSELTABKEY = "CurSelTabKey";
    public static final String ISMATERIALPRECISIONENABLE = "ismaterialprecisionenable";
    public static final String TABPAGEAP_INVENTORY = "inventoryinfo";
    public static final String TABPAGEAP_PURCHASE = "purchaseinfo";
    public static final String TABPAGEAP_SAL = "salinfo";
    public static final String TABPAGEAP_MFT = "mftinfo";
    public static final String TABPAGEAP_INS = "inspectinfo";
    public static final String TABPAGEAP_CAL = "calinfo";
    public static final String TABPAGEAP_PLAN = "planinfo";
    public static final String TABPAGEAP_BASEINFO = "tabpage_baseinfo";
    public static final String OPENFROMMATERIAL = "openFromMaterial";
    public static final String PROP_SHOWCREATEORG = "showcreateorg";
    public static final String CURSELTABKEY = "curseltabkey";
    public static final String ISALLENABLE = "isAllEnable";
    public static final String STATUS_A = "A";
    public static final String STATUS_B = "B";
    public static final String STATUS_C = "C";
    public static List<String> TAB_LIST = Arrays.asList("purchaseinfo", "inventoryinfo", "salinfo", "mftinfo", "inspectinfo", "calinfo", "planinfo");
    private GroupStandardHelper groupStandardHelper = new GroupStandardHelper();

    @Override
    public String getType() {
        return "bd_material";
    }

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        Tab tab = (Tab)this.getView().getControl("tabap");
        tab.addTabSelectListener((TabSelectListener)this);
        BasedataEdit datas = (BasedataEdit)this.getControl("standardid");
        datas.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit groupid = (BasedataEdit)this.getControl("groupid");
        groupid.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit auxptyunit = (BasedataEdit)this.getControl("auxptyunit");
        auxptyunit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit auxpty = (BasedataEdit)this.getControl("auxpty");
        auxpty.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit productfamily = (BasedataEdit)this.getControl("productfamily");
        productfamily.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit productseries = (BasedataEdit)this.getControl("productseries");
        productseries.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit productmodel = (BasedataEdit)this.getControl("productmodel");
        productmodel.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    @Override
    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String curSelTabKey;
        FormOperate operate = (FormOperate)args.getSource();
        String operateKey = operate.getOperateKey();
        if ("change".equals(operateKey) && (TABPAGEAP_INVENTORY.equals(curSelTabKey = this.getPageCache().get(PGCACHE_CURSELTABKEY)) || TABPAGEAP_PURCHASE.equals(curSelTabKey) || TABPAGEAP_SAL.equals(curSelTabKey) || TABPAGEAP_MFT.equals(curSelTabKey) || TABPAGEAP_INS.equals(curSelTabKey) || TABPAGEAP_CAL.equals(curSelTabKey))) {
            Tab tab = (Tab)this.getView().getControl("tabap");
            tab.activeTab(TABPAGEAP_BASEINFO);
        }
        if ("save".equals(operateKey) || "submit".equals(operateKey)) {
            operate.getOption().setVariableValue("fromFormView", "true");
            if ("submit".equals(operateKey) && MaterialServiceHelper.getBillParameter() != null && MaterialServiceHelper.getBillParameter().isResultr() && this.getModel().getDataEntity().getPkValue().equals(0L)) {
                args.setCancel(true);
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u7269\u6599\u4e0e\u4e1a\u52a1\u4fe1\u606f\u64cd\u4f5c\u534f\u540c\u53c2\u6570\u5f00\u542f\u65f6\uff0c\u7269\u6599\u672a\u4fdd\u5b58\u65f6\uff0c\u7269\u6599\u4e1a\u52a1\u4fe1\u606f\u65e0\u6cd5\u8fdb\u884c\u540c\u6b65\u64cd\u4f5c\uff0c\u8bf7\u5148\u4fdd\u5b58\u7269\u6599\u3002", (String)"MaterialDataFormPlugin_14", (String)"bd-master-formplugin", (Object[])new Object[0]));
                return;
            }
        }
        if ("save".equals(operateKey) || "submit".equals(operateKey) || "audit".equals(operateKey) || "unsubmit".equals(operateKey) || "unaudit".equals(operateKey)) {
            this.syncOperateBizInfoTabpageData(operateKey, args, this.getModel().getDataEntity().getPkValue());
        }
        super.beforeDoOperation(args);
    }

    @Override
    public void afterDoOperation(AfterDoOperationEventArgs adoe) {
        String curSelTabKey;
        String operateKey = adoe.getOperateKey();
        if ("submit".equals(operateKey) || "save".equals(operateKey)) {
            if (adoe.getOperationResult() == null || adoe.getOperationResult().getSuccessPkIds() == null || adoe.getOperationResult().getSuccessPkIds().size() <= 0) {
                return;
            }
            try (TraceSpan span = Tracer.create((String)"MaterialDataFormPlugin", (String)"setUnitConvert");){
                this.setUnitConvert(this.getModel().getDataEntity().getPkValue().toString());
            }
        } else if ("unaudit".equals(operateKey)) {
            String curSelTabKey2 = this.getPageCache().get(PGCACHE_CURSELTABKEY);
            if (TABPAGEAP_INVENTORY.equals(curSelTabKey2) || TABPAGEAP_PURCHASE.equals(curSelTabKey2) || TABPAGEAP_SAL.equals(curSelTabKey2) || TABPAGEAP_MFT.equals(curSelTabKey2) || TABPAGEAP_INS.equals(curSelTabKey2) || TABPAGEAP_CAL.equals(curSelTabKey2) || TABPAGEAP_PLAN.equals(curSelTabKey2)) {
                Tab tab = (Tab)this.getView().getControl("tabap");
                tab.activeTab(TABPAGEAP_BASEINFO);
            }
        } else if ("disable".equals(operateKey) && (TABPAGEAP_INVENTORY.equals(curSelTabKey = this.getPageCache().get(PGCACHE_CURSELTABKEY)) || TABPAGEAP_PURCHASE.equals(curSelTabKey) || TABPAGEAP_SAL.equals(curSelTabKey) || TABPAGEAP_MFT.equals(curSelTabKey) || TABPAGEAP_INS.equals(curSelTabKey) || TABPAGEAP_CAL.equals(curSelTabKey) || TABPAGEAP_PLAN.equals(curSelTabKey))) {
            Tab tab = (Tab)this.getView().getControl("tabap");
            tab.activeTab(TABPAGEAP_BASEINFO);
        }
        if (adoe.getOperationResult() != null && adoe.getOperationResult().isSuccess() && ("submit".equals(operateKey) || "save".equals(operateKey) || "unsubmit".equals(operateKey) || "audit".equals(operateKey) || "unaudit".equals(operateKey))) {
            this.setMaterialBizInfoVisibility();
        }
        super.afterDoOperation(adoe);
    }

    private void syncOperateBizInfoTabpageData(String operateKey, BeforeDoOperationEventArgs args, Object pk) {
        if (MaterialServiceHelper.getBillParameter() == null) {
            return;
        }
        if (MaterialServiceHelper.getBillParameter() != null && !MaterialServiceHelper.getBillParameter().isResultr()) {
            this.getView().showErrorNotification(MaterialServiceHelper.getBillParameter().getError());
            args.setCancel(true);
            return;
        }
        HashMap<String, Object> materialInfoData = new HashMap<String, Object>(7);
        for (String tabName : TAB_LIST) {
            String pageId = this.getPageCache().get(tabName);
            IFormView childView = this.getView().getView(pageId);
            if (!StringUtils.isNotBlank((CharSequence)pageId) || childView == null) continue;
            logger.info("syncOperateBizInfoTabpageData: " + pageId + " and " + tabName);
            OperationResult invokeOperation = null;
            try {
                OperateOption op = OperateOption.create();
                op.setVariableValue("isStrict", String.valueOf(true));
                op.setVariableValue("ignoreValidation", String.valueOf(true));
                invokeOperation = childView.invokeOperation(operateKey, op);
            }
            catch (Exception e) {
                logger.error("materialinfo error:" + e.getMessage());
                this.getView().showErrorNotification(e.getLocalizedMessage());
                args.setCancel(true);
                return;
            }
            if (invokeOperation != null && !invokeOperation.isSuccess()) {
                int billCount = invokeOperation.getBillCount();
                if (billCount == 0) {
                    StringBuilder errorInfos = new StringBuilder();
                    errorInfos.append(MaterialInfoEnum.getDescByCode((String)tabName));
                    errorInfos.append(ResManager.loadKDString((String)"\u7269\u6599\u4fe1\u606f\u6570\u636e\u4e0d\u5b58\u5728\u3002", (String)"MaterialDataFormPlugin_15", (String)"bd-master-formplugin", (Object[])new Object[0]));
                    this.getView().showErrorNotification(errorInfos.toString());
                    this.rollBackData(operateKey, args, materialInfoData);
                    return;
                }
                List operateInfos = invokeOperation.getAllErrorOrValidateInfo();
                String error = ErrorInfoConverUtil.getErrorInfo((String)tabName, (List)operateInfos);
                if (StringUtils.isEmpty((CharSequence)error)) {
                    error = invokeOperation.getMessage();
                }
                if (StringUtils.isEmpty((CharSequence)error)) {
                    return;
                }
                this.getView().showErrorNotification(error);
                if ("save".equals(operateKey)) {
                    args.setCancel(true);
                    if (materialInfoData == null || materialInfoData.size() <= 0) break;
                    this.rollBackData("delete", materialInfoData, operateInfos);
                    break;
                }
                this.rollBackData(operateKey, args, materialInfoData);
                break;
            }
            if (invokeOperation == null || !invokeOperation.isSuccess() || invokeOperation.getSuccessPkIds() == null || invokeOperation.getSuccessPkIds().size() <= 0) continue;
            materialInfoData.put(tabName, invokeOperation.getSuccessPkIds().get(0));
            this.reinitMaterialInfo(tabName);
        }
    }

    private void rollBackData(String operateKey, BeforeDoOperationEventArgs args, Map<String, Object> materialInfoData) {
        switch (operateKey) {
            case "submit": {
                this.rollBackDataStatus(STATUS_A, materialInfoData);
                args.setCancel(true);
                break;
            }
            case "audit": {
                this.rollBackDataStatus(STATUS_B, materialInfoData);
                args.setCancel(true);
                break;
            }
            case "unaudit": {
                this.rollBackDataStatus(STATUS_C, materialInfoData);
                args.setCancel(true);
                break;
            }
            case "unsubmit": {
                this.rollBackDataStatus(STATUS_B, materialInfoData);
                args.setCancel(true);
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rollBackDataStatus(String status, Map<String, Object> materialInfoData) {
        if (materialInfoData != null && materialInfoData.size() > 0) {
            StringBuilder updateSql = null;
            for (Map.Entry<String, Object> info : materialInfoData.entrySet()) {
                logger.info("\u9700\u8981\u66f4\u65b0\u7684\u7269\u6599\u4fe1\u606fid:" + info.getValue());
                updateSql = new StringBuilder("update ");
                updateSql.append(MaterialInfoEntityTypeEnum.getTableByCode((String)info.getKey()));
                updateSql.append(" set fstatus=? where fid=?");
                TXHandle h = TX.required((String)((Object)((Object)this)).getClass().getName());
                Throwable throwable = null;
                try {
                    try {
                        this.dataExecute(status, updateSql, info);
                    }
                    catch (Throwable e) {
                        h.markRollback();
                        logger.error(e.getMessage());
                    }
                    finally {
                        this.reinitMaterialInfo(info.getKey());
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (h == null) continue;
                    if (throwable != null) {
                        try {
                            h.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    h.close();
                }
            }
        }
    }

    private void dataExecute(String status, StringBuilder updateSql, Map.Entry<String, Object> info) {
        Object[] params = new Object[]{status, info.getValue()};
        DB.execute((DBRoute)DBRoute.basedata, (String)updateSql.toString(), (Object[])params);
    }

    private void rollBackData(String operateKey, Map<String, Object> materialInfoData, List<IOperateInfo> operateInfos) {
        if (materialInfoData != null && materialInfoData.size() > 0) {
            OperateOption op = OperateOption.create();
            op.setVariableValue("ignoreValidation", String.valueOf(true));
            for (Map.Entry<String, Object> info : materialInfoData.entrySet()) {
                OperationResult ors = OperationServiceHelper.executeOperate((String)operateKey, (String)MaterialInfoEntityTypeEnum.getEntityTypeByCode((String)info.getKey()), (Object[])new Object[]{info.getValue()}, (OperateOption)op);
                if (ors.isSuccess()) continue;
                logger.error(ErrorInfoConverUtil.getErrorInfo((String)info.getKey(), operateInfos));
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void itemClick(ItemClickEvent evt) {
        block45: {
            block47: {
                block46: {
                    super.itemClick(evt);
                    itemKey = evt.getItemKey();
                    operationKey = evt.getOperationKey();
                    if (!"tabpage_unitinfo".equals(itemKey)) break block46;
                    var4_4 = operationKey;
                    var5_7 = -1;
                    switch (var4_4.hashCode()) {
                        case 1177017175: {
                            if (!var4_4.equals("bar_delete")) break;
                            var5_7 = 0;
                            break;
                        }
                        case -1568190244: {
                            if (!var4_4.equals("btn_addrow")) break;
                            var5_7 = 1;
                        }
                    }
                    switch (var5_7) {
                        case 0: {
                            break;
                        }
                        case 1: {
                            this.showUnitList();
                            break;
                        }
                    }
                    break block45;
                }
                if (!"tabpageap".equals(itemKey)) break block47;
                var4_5 = operationKey;
                var5_8 = -1;
                switch (var4_5.hashCode()) {
                    case -407161795: {
                        if (!var4_5.equals("btn_savestandard")) break;
                        var5_8 = 0;
                    }
                }
                switch (var5_8) {
                    case 0: {
                        span = Tracer.create((String)"MaterialDataFormPlugin", (String)"setSupGroupStandard");
                        var7_13 = null;
                        if (MasterDataHelper.checkMasterDataExit((IDataModel)this.getModel(), (String)this.getType())) ** GOTO lbl48
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u4fdd\u5b58\u7269\u6599\u3002", (String)"MaterialDataFormPlugin_3", (String)"bd-master-formplugin", (Object[])new Object[0]));
                        if (span == null) ** GOTO lbl46
                        if (var7_13 == null) ** GOTO lbl45
                        try {
                            span.close();
                        }
                        catch (Throwable var8_14) {
                            var7_13.addSuppressed(var8_14);
                        }
                        ** GOTO lbl46
lbl45:
                        // 1 sources

                        span.close();
lbl46:
                        // 4 sources

                        return;
lbl48:
                        // 2 sources

                        result = MasterDataHelper.checkGroupEnable((IDataModel)this.getModel(), (IFormView)this.getView(), (String)this.getType());
                        if (result == null) ** GOTO lbl62
                        this.getView().showTipNotification(result);
                        if (span == null) ** GOTO lbl60
                        if (var7_13 == null) ** GOTO lbl59
                        try {
                            span.close();
                        }
                        catch (Throwable var9_18) {
                            var7_13.addSuppressed(var9_18);
                        }
                        ** GOTO lbl60
lbl59:
                        // 1 sources

                        span.close();
lbl60:
                        // 4 sources

                        return;
lbl62:
                        // 2 sources

                        isGroupNew = new MasterDataHelper().checkGroupNew(this.getModel().getDataEntity(), this.getType(), this.getView());
                        if (isGroupNew) {
                            this.setMtGroupStandard(this.getModel(), this.getView());
                        }
                        if (span == null) break block45;
                        if (var7_13 == null) ** GOTO lbl73
                        try {
                            span.close();
                        }
                        catch (Throwable var8_16) {
                            var7_13.addSuppressed(var8_16);
                        }
                        break;
lbl73:
                        // 1 sources

                        span.close();
                        break;
                        catch (Throwable var8_17) {
                            try {
                                var7_13 = var8_17;
                                throw var8_17;
                            }
                            catch (Throwable var10_20) {
                                if (span != null) {
                                    if (var7_13 != null) {
                                        try {
                                            span.close();
                                        }
                                        catch (Throwable var11_21) {
                                            var7_13.addSuppressed(var11_21);
                                        }
                                    } else {
                                        span.close();
                                    }
                                }
                                throw var10_20;
                            }
                        }
                    }
                }
                break block45;
            }
            if ("inventoryinfo".equals(itemKey) || "purchaseinfo".equals(itemKey) || "salinfo".equals(itemKey) || "mftinfo".equals(itemKey) || "inspectinfo".equals(itemKey) || "calinfo".equals(itemKey) || "planinfo".equals(itemKey)) {
                span = Tracer.create((String)"MaterialDataFormPlugin", (String)"handleTabInfo");
                var5_9 = null;
                try {
                    this.handleTabInfo(itemKey, operationKey);
                }
                catch (Throwable var6_12) {
                    var5_9 = var6_12;
                    throw var6_12;
                }
                finally {
                    if (span != null) {
                        if (var5_9 != null) {
                            try {
                                span.close();
                            }
                            catch (Throwable var6_11) {
                                var5_9.addSuppressed(var6_11);
                            }
                        } else {
                            span.close();
                        }
                    }
                }
            }
        }
    }

    private void handleTabInfo(String itemKey, String operationKey) {
        String pageId = this.getPageCache().get(itemKey);
        String entityNumber = this.getEntityNumber(itemKey);
        if ("mpdm_materialplan".equals(entityNumber)) {
            entityNumber = "bd_materialplan";
        }
        if (StringUtils.isBlank((CharSequence)entityNumber)) {
            this.setVisible(itemKey, STATUS_A, null);
            return;
        }
        switch (operationKey) {
            case "new_inventoryinfo": 
            case "new_purchaseinfo": 
            case "new_salinfo": 
            case "new_mftinfo": 
            case "new_inspectinfo": 
            case "new_calinfo": 
            case "new_planinfo": {
                try {
                    boolean checkPermResult = this.checkPerm("new", "47156aff000000ac", pageId, entityNumber);
                    if (!checkPermResult) break;
                    this.setVisible(itemKey, STATUS_A, null);
                    if (pageId != null && this.getView().getView(pageId) != null) {
                        this.getView().getView(pageId).getModel().setDataChanged(false);
                        this.getView().getView(pageId).invokeOperation("close");
                        this.getView().sendFormAction(this.getView().getView(pageId));
                        pageId = null;
                    }
                    if ("mpdm_materialplan".equals(entityNumber)) {
                        entityNumber = "bd_materialplan";
                        this.openPlanInfoPage(entityNumber, itemKey, pageId, null, OperationStatus.ADDNEW, false, null);
                        break;
                    }
                    this.openInfoPage(entityNumber, itemKey, pageId, null, OperationStatus.ADDNEW, false, null);
                }
                catch (Exception ex) {
                    logger.error((Throwable)ex);
                }
                break;
            }
            case "save_inventoryinfo": 
            case "save_purchaseinfo": 
            case "save_salinfo": 
            case "save_mftinfo": 
            case "save_inspectinfo": 
            case "save_calinfo": 
            case "save_planinfo": {
                this.handleOperate("save", "47156aff000000ac", pageId, entityNumber, itemKey, null);
                break;
            }
            case "submit_inventoryinfo": 
            case "submit_purchaseinfo": 
            case "submit_salinfo": 
            case "submit_mftinfo": 
            case "submit_inspectinfo": 
            case "submit_calinfo": 
            case "submit_planinfo": {
                this.handleOperate("submit", "804f6478000000ac", pageId, entityNumber, itemKey, STATUS_B);
                break;
            }
            case "audit_inventoryinfo": 
            case "audit_purchaseinfo": 
            case "audit_salinfo": 
            case "audit_mftinfo": 
            case "audit_inspectinfo": 
            case "audit_calinfo": 
            case "audit_planinfo": {
                this.handleOperate("audit", "47162f66000000ac", pageId, entityNumber, itemKey, STATUS_C);
                break;
            }
            case "unsubmit_inventoryinfo": 
            case "unsubmit_purchaseinfo": 
            case "unsubmit_salinfo": 
            case "unsubmit_mftinfo": 
            case "unsubmit_inspectinfo": 
            case "unsubmit_calinfo": 
            case "unsubmit_planinfo": {
                this.handleOperate("unsubmit", "80513207000000ac", pageId, entityNumber, itemKey, STATUS_A);
                break;
            }
            case "unaudit_inventoryinfo": 
            case "unaudit_purchaseinfo": 
            case "unaudit_salinfo": 
            case "unaudit_mftinfo": 
            case "unaudit_inspectinfo": 
            case "unaudit_calinfo": 
            case "unaudit_planinfo": {
                this.handleOperate("unaudit", "47165e8e000000ac", pageId, entityNumber, itemKey, STATUS_A);
                break;
            }
        }
    }

    private void handleOperate(String operate, String permItem, String pageId, String entityNumber, String itemKey, String status) {
        DynamicObject showcreateorg;
        boolean checkPermResult;
        IFormView materialBizView = this.getView().getView(pageId);
        if (pageId != null && materialBizView != null) {
            DynamicObject data = this.getView().getView(pageId).getModel().getDataEntity();
            Object pkValue = data.getPkValue();
            if ("save".equals(operate) && pkValue != null && Long.parseLong(pkValue.toString()) != 0L) {
                permItem = "4715a0df000000ac";
            }
        }
        if (!(checkPermResult = this.checkPerm(operate, permItem, pageId, entityNumber))) {
            return;
        }
        if (pageId != null && materialBizView != null && !"bd_materialplan".equals(entityNumber) && (showcreateorg = materialBizView.getModel().getDataEntity().getDynamicObject(PROP_SHOWCREATEORG)) == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u521b\u5efa\u7ec4\u7ec7\u3002", (String)"MaterialDataFormPlugin_7", (String)"bd-master-formplugin", (Object[])new Object[0]));
            return;
        }
        if (pageId != null && materialBizView != null) {
            OperationResult invokeOperation = this.getView().getView(pageId).invokeOperation(operate);
            this.getView().sendFormAction(this.getView().getView(pageId));
            if (invokeOperation.isSuccess() && StringUtils.isNotBlank((CharSequence)status)) {
                this.setVisible(itemKey, status, null);
            }
        }
    }

    private boolean checkPerm(String operate, String permItem, String pageId, String entityNumber) {
        boolean result = true;
        IFormView materialBizInfoView = this.getView().getView(pageId);
        long dimObjId = 0L;
        if (materialBizInfoView == null || "new".equals(operate)) {
            dimObjId = RequestContext.get().getOrgId();
        } else {
            DynamicObject createOrg = materialBizInfoView.getModel().getDataEntity().getDynamicObject("createorg");
            if (createOrg == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u521b\u5efa\u7ec4\u7ec7\u3002", (String)"MaterialDataFormPlugin_7", (String)"bd-master-formplugin", (Object[])new Object[0]));
                result = false;
                return result;
            }
            dimObjId = createOrg.getLong("id");
        }
        String appNumber = this.getView().getFormShowParameter().getAppId();
        int checkPermissionResult = PermissionServiceHelper.checkPermission((long)Long.parseLong(RequestContext.get().getUserId()), (String)"DIM_ORG", (long)dimObjId, (String)appNumber, (String)entityNumber, (String)permItem);
        if (checkPermissionResult == 0) {
            String operateName = OperteUtils.getOperteName((String)permItem);
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8be5\u7528\u6237\u5728\u5f53\u524d\u4e1a\u52a1\u7ec4\u7ec7\u4e0b\u6ca1\u6709%s\u6743\u9650\u3002", (String)"MaterialDataFormPlugin_5", (String)"bd-master-formplugin", (Object[])new Object[0]), operateName));
            result = false;
        }
        return result;
    }

    public void tabSelected(TabSelectEvent evt) {
        String curSelTabKey = evt.getTabKey();
        this.getPageCache().put(PGCACHE_CURSELTABKEY, curSelTabKey);
        this.initMaterialInfo(curSelTabKey, true);
    }

    private void initMaterialInfo(String curSelTabKey, boolean flag) {
        if (!flag) {
            return;
        }
        if (TABPAGEAP_INVENTORY.equals(curSelTabKey) || TABPAGEAP_PURCHASE.equals(curSelTabKey) || TABPAGEAP_SAL.equals(curSelTabKey) || TABPAGEAP_MFT.equals(curSelTabKey) || TABPAGEAP_INS.equals(curSelTabKey) || TABPAGEAP_CAL.equals(curSelTabKey) || TABPAGEAP_PLAN.equals(curSelTabKey)) {
            Object materialId = this.getModel().getDataEntity().getPkValue();
            DynamicObject useOrg = this.getModel().getDataEntity().getDynamicObject("useorg");
            Long useOrgId = useOrg == null ? 0L : useOrg.getLong("id");
            String entityNumber = this.getEntityNumber(curSelTabKey);
            String pageId = this.getPageCache().get(curSelTabKey);
            if (pageId != null && this.getView().getView(pageId) != null) {
                return;
            }
            ArrayList<QFilter> filters = new ArrayList<QFilter>(2);
            filters.add(new QFilter("createorg", "=", (Object)useOrgId));
            filters.add(new QFilter("masterid", "=", materialId));
            DynamicObject bizInfo = BusinessDataServiceHelper.loadSingle((String)entityNumber, (String)"id,status,createorg", (QFilter[])filters.toArray(new QFilter[0]));
            String appNumber = this.getView().getFormShowParameter().getAppId();
            if (bizInfo != null) {
                Object bizInfoId = bizInfo.getPkValue();
                Boolean hasEditOperPermission = MasterDataHelper.hasOperPermission((Long)useOrgId, (String)appNumber, (String)entityNumber, (String)"4715a0df000000ac");
                OperationStatus operStatus = hasEditOperPermission != false ? OperationStatus.EDIT : OperationStatus.VIEW;
                this.setVisible(curSelTabKey, bizInfo.getString("status"), operStatus);
                if ("mpdm_materialplan".equals(entityNumber)) {
                    entityNumber = "bd_materialplan";
                    this.openPlanInfoPage(entityNumber, curSelTabKey, pageId, bizInfoId, operStatus, false, bizInfo.getDynamicObject("createorg").getPkValue());
                } else {
                    this.openInfoPage(entityNumber, curSelTabKey, pageId, bizInfoId, operStatus, false, bizInfo.getDynamicObject("createorg").getPkValue());
                }
            } else {
                Boolean hasNewOperPermission = MasterDataHelper.hasOperPermission((Long)useOrgId, (String)appNumber, (String)entityNumber, (String)"47156aff000000ac");
                boolean hasOrgPermission = MasterDataHelper.hasOrgPermission((Long)useOrgId, (String)entityNumber);
                OperationStatus operStatus = hasNewOperPermission != false && hasOrgPermission ? OperationStatus.EDIT : OperationStatus.VIEW;
                this.setVisible(curSelTabKey, STATUS_A, operStatus);
                if (!hasOrgPermission) {
                    LocaleString entityName = EntityMetadataCache.getDataEntityType((String)entityNumber).getDisplayName();
                    this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u65e0%1$s\u521b\u5efa\u6743\u9650\uff0c\u8bf7\u68c0\u67e5\u57fa\u7840\u6570\u636e\u7ba1\u63a7\u7b56\u7565\u7684\u63a7\u5236\u89c4\u5219\u662f\u5426\u914d\u7f6e\u6b63\u786e\u3002", (String)"MaterialDataFormPlugin_9", (String)"bd-master-formplugin", (Object[])new Object[0]), entityName.getLocaleValue()));
                    return;
                }
                if ("mpdm_materialplan".equals(entityNumber)) {
                    entityNumber = "bd_materialplan";
                    this.openPlanInfoPage(entityNumber, curSelTabKey, pageId, null, OperationStatus.ADDNEW, false, null);
                } else {
                    this.openInfoPage(entityNumber, curSelTabKey, pageId, null, OperationStatus.ADDNEW, false, null);
                }
            }
        }
    }

    private void reinitMaterialInfo(String curSelTabKey) {
        if (TABPAGEAP_INVENTORY.equals(curSelTabKey) || TABPAGEAP_PURCHASE.equals(curSelTabKey) || TABPAGEAP_SAL.equals(curSelTabKey) || TABPAGEAP_MFT.equals(curSelTabKey) || TABPAGEAP_INS.equals(curSelTabKey) || TABPAGEAP_CAL.equals(curSelTabKey) || TABPAGEAP_PLAN.equals(curSelTabKey)) {
            Object materialId = this.getModel().getDataEntity().getPkValue();
            DynamicObject useOrg = this.getModel().getDataEntity().getDynamicObject("useorg");
            Long useOrgId = useOrg == null ? 0L : useOrg.getLong("id");
            String entityNumber = this.getEntityNumber(curSelTabKey);
            String pageId = this.getPageCache().get(curSelTabKey);
            ArrayList<QFilter> filters = new ArrayList<QFilter>(2);
            filters.add(new QFilter("createorg", "=", (Object)useOrgId));
            filters.add(new QFilter("masterid", "=", materialId));
            DynamicObject bizInfo = BusinessDataServiceHelper.loadSingle((String)entityNumber, (String)"id,status", (QFilter[])filters.toArray(new QFilter[0]));
            String appNumber = this.getView().getFormShowParameter().getAppId();
            if (bizInfo != null) {
                Object bizInfoId = bizInfo.getPkValue();
                Boolean hasEditOperPermission = MasterDataHelper.hasOperPermission((Long)useOrgId, (String)appNumber, (String)entityNumber, (String)"4715a0df000000ac");
                OperationStatus operStatus = hasEditOperPermission != false ? OperationStatus.EDIT : OperationStatus.VIEW;
                this.setVisible(curSelTabKey, bizInfo.getString("status"), operStatus);
                if ("mpdm_materialplan".equals(entityNumber)) {
                    entityNumber = "bd_materialplan";
                    this.openPlanInfoPage(entityNumber, curSelTabKey, pageId, bizInfoId, operStatus, false, bizInfo.getDynamicObject("createorg").getPkValue());
                } else {
                    this.openInfoPage(entityNumber, curSelTabKey, pageId, bizInfoId, operStatus, false, bizInfo.getDynamicObject("createorg").getPkValue());
                }
            } else {
                Boolean hasNewOperPermission = MasterDataHelper.hasOperPermission((Long)useOrgId, (String)appNumber, (String)entityNumber, (String)"47156aff000000ac");
                boolean hasOrgPermission = MasterDataHelper.hasOrgPermission((Long)useOrgId, (String)entityNumber);
                OperationStatus operStatus = hasNewOperPermission != false && hasOrgPermission ? OperationStatus.EDIT : OperationStatus.VIEW;
                this.setVisible(curSelTabKey, STATUS_A, operStatus);
                if (!hasOrgPermission) {
                    LocaleString entityName = EntityMetadataCache.getDataEntityType((String)entityNumber).getDisplayName();
                    this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u65e0%1$s\u521b\u5efa\u6743\u9650\uff0c\u8bf7\u68c0\u67e5\u57fa\u7840\u6570\u636e\u7ba1\u63a7\u7b56\u7565\u7684\u63a7\u5236\u89c4\u5219\u662f\u5426\u914d\u7f6e\u6b63\u786e\u3002", (String)"MaterialDataFormPlugin_9", (String)"bd-master-formplugin", (Object[])new Object[0]), entityName.getLocaleValue()));
                    return;
                }
                if ("mpdm_materialplan".equals(entityNumber)) {
                    entityNumber = "bd_materialplan";
                    this.openPlanInfoPage(entityNumber, curSelTabKey, pageId, null, OperationStatus.ADDNEW, false, null);
                } else {
                    this.openInfoPage(entityNumber, curSelTabKey, pageId, null, OperationStatus.ADDNEW, false, null);
                }
            }
        }
    }

    private void openInfoPage(String entityNumber, String curSelTabKey, String pageId, Object dataId, OperationStatus operationStatus, boolean isAllEnable, Object createorg) {
        BaseShowParameter lsp = new BaseShowParameter();
        pageId = lsp.getPageId();
        if (StringUtils.isNotBlank((Object)dataId)) {
            lsp.setPkId(dataId);
        }
        BaseShowParameter baseShowParameter = (BaseShowParameter)this.getView().getFormShowParameter();
        lsp.setAppId(baseShowParameter.getAppId());
        lsp.setFormId(entityNumber);
        lsp.getOpenStyle().setTargetKey(curSelTabKey);
        lsp.getOpenStyle().setShowType(ShowType.InContainer);
        HashMap<String, Object> params = new HashMap<String, Object>(6);
        params.put(OPENFROMMATERIAL, Boolean.TRUE);
        params.put("materialid", this.getModel().getDataEntity().getPkValue());
        if (createorg != null) {
            params.put("createorg", createorg);
        } else {
            params.put("createorg", this.getModel().getDataEntity().getDynamicObject("useorg").getPkValue());
        }
        params.put("useorg", this.getModel().getDataEntity().getDynamicObject("useorg").getPkValue());
        params.put("baseunit", this.getModel().getDataEntity().getDynamicObject("baseunit").getPkValue());
        params.put("minbatchunit", this.getModel().getDataEntity().getDynamicObject("baseunit").getPkValue());
        params.put(CURSELTABKEY, curSelTabKey);
        params.put(ISALLENABLE, isAllEnable);
        lsp.setCustomParams(params);
        lsp.setParentFormId(this.getView().getFormShowParameter().getFormId());
        lsp.setStatus(operationStatus);
        this.getPageCache().put(curSelTabKey, pageId);
        this.getView().showForm((FormShowParameter)lsp);
    }

    private void openPlanInfoPage(String entityNumber, String curSelTabKey, String pageId, Object dataId, OperationStatus operationStatus, boolean isAllEnable, Object createorg) {
        FormShowParameter lsp = new FormShowParameter();
        pageId = lsp.getPageId();
        FormShowParameter baseShowParameter = this.getView().getFormShowParameter();
        lsp.setAppId(baseShowParameter.getAppId());
        lsp.setFormId(entityNumber);
        lsp.getOpenStyle().setTargetKey(curSelTabKey);
        lsp.getOpenStyle().setShowType(ShowType.InContainer);
        HashMap<String, Object> params = new HashMap<String, Object>(6);
        params.put(OPENFROMMATERIAL, Boolean.TRUE);
        params.put("materialid", this.getModel().getDataEntity().getPkValue());
        if (createorg != null) {
            params.put("createorg", createorg);
        } else {
            params.put("createorg", this.getModel().getDataEntity().getDynamicObject("useorg").getPkValue());
        }
        params.put("useorg", this.getModel().getDataEntity().getDynamicObject("useorg").getPkValue());
        params.put("baseunit", this.getModel().getDataEntity().getDynamicObject("baseunit").getPkValue());
        if (StringUtils.isNotBlank((Object)dataId)) {
            params.put("id", dataId);
        }
        params.put(CURSELTABKEY, curSelTabKey);
        params.put(ISALLENABLE, isAllEnable);
        lsp.setCustomParams(params);
        lsp.setParentFormId(this.getView().getFormShowParameter().getFormId());
        lsp.setStatus(operationStatus);
        this.getPageCache().put(curSelTabKey, pageId);
        this.getView().showForm(lsp);
    }

    private void setMtGroupStandard(IDataModel model, IFormView view) {
        boolean result = GroupStandardHelper.saveGroupStandard((DynamicObject)model.getDataEntity(), (DynamicObjectCollection)model.getEntryEntity("entry_groupstandard"), (String)this.getType(), (IFormView)view);
        if (result) {
            GroupStandardHelper.setGroupStandard((Object)model.getDataEntity().getPkValue(), (String)MasterDataHelper.getUseOrg((IFormView)view).toString(), null, (IDataModel)model, (IFormView)view, (String)this.getType());
            GroupStandardHelper.setGrouptandard((IDataModel)model, (IFormView)view, (IPageCache)this.getPageCache(), (String)this.getType());
            view.showSuccessNotification(ResManager.loadKDString((String)"\u5206\u7c7b\u6807\u51c6\u4fdd\u5b58\u6210\u529f\u3002", (String)"MaterialDataFormPlugin_4", (String)"bd-master-formplugin", (Object[])new Object[0]));
            model.setDataChanged(false);
        }
    }

    private void showUnitList() {
        Object baseunit = this.getModel().getValue("baseunit");
        if (baseunit == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u8bbe\u7f6e\u57fa\u672c\u5355\u4f4d\u3002", (String)"MaterialDataFormPlugin_0", (String)"bd-master-formplugin", (Object[])new Object[0]));
            return;
        }
        ListShowParameter lsp = ShowFormHelper.createShowListForm((String)"bd_measureunits", (boolean)true, (int)2);
        int rowCount = this.getModel().getEntryRowCount("entryentity");
        Object[] muids = new Long[rowCount];
        for (int i = 0; i < rowCount; ++i) {
            DynamicObject mu = (DynamicObject)this.getModel().getValue("measureunitid", i);
            muids[i] = mu.getLong("id");
        }
        lsp.setSelectedRows(muids);
        lsp.setFormId("bos_treelistf7");
        lsp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CLOSECALLBACK_SELECTMUS));
        lsp.getListFilterParameter().getQFilters().add(new QFilter("enable", "=", (Object)"1"));
        lsp.getListFilterParameter().getQFilters().add(new QFilter("id", "!=", ((DynamicObject)baseunit).getPkValue()));
        this.getView().showForm((FormShowParameter)lsp);
    }

    @Override
    public void afterBindData(EventObject e) {
        String materialid = this.getModel().getDataEntity().getPkValue().toString();
        this.setUnitConvert(materialid);
        try (TraceSpan span = Tracer.create((String)"MaterialDataFormPlugin", (String)"getPrecisionProperty");){
            boolean isOpenPrecision = MaterialServiceHelper.getPrecisionProperty();
            this.getView().setVisible(Boolean.valueOf(isOpenPrecision), new String[]{"precision"});
        }
        if (StringUtils.isEmpty((CharSequence)materialid) || NEW_NULL_FID.equals(materialid)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"new_purchaseinfo", "save_purchaseinfo", "submit_purchaseinfo", "audit_purchaseinfo", "new_inventoryinfo", "save_inventoryinfo", "submit_inventoryinfo", "audit_inventoryinfo", "new_salinfo", "save_salinfo", "submit_salinfo", "audit_salinfo", "new_mftinfo", "save_mftinfo", "submit_mftinfo", "audit_mftinfo", "new_inspectinfo", "save_inspectinfo", "submit_inspectinfo", "audit_inspectinfo", "new_calinfo", "save_calinfo", "submit_calinfo", "audit_calinfo", "new_planinfo", "save_planinfo", "submit_planinfo", "unsubmit_planinfo", "audit_planinfo", "unaudit_planinfo"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{TABPAGEAP_PURCHASE, TABPAGEAP_INVENTORY, TABPAGEAP_SAL, TABPAGEAP_MFT, TABPAGEAP_INS, TABPAGEAP_CAL, TABPAGEAP_PLAN});
        } else {
            this.setMaterialBizInfoVisibility();
        }
        if (((Boolean)this.getModel().getValue("farmproducts")).booleanValue()) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"deductiblerate"});
        } else {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"deductiblerate"});
        }
        String materialType = this.getModel().getDataEntity().getString("materialtype");
        boolean suite = this.getModel().getDataEntity().getBoolean("suite");
        if (("1".equals(materialType) || "9".equals(materialType)) && suite) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"enableproduct", "enableinspect", "enableoutsource", "enabletrustee", "enableconsign"});
        }
        super.afterBindData(e);
    }

    private void setMaterialBizInfoVisibility() {
        DynamicObject material = this.getModel().getDataEntity();
        OperationStatus operationStatus = this.getView().getFormShowParameter().getStatus();
        boolean enableinv = MaterialServiceHelper.isMaterialBizVisible((DynamicObject)material, (String)"bd_materialinventoryinfo", (String)"enableinv");
        this.getView().setVisible(Boolean.valueOf(enableinv), new String[]{TABPAGEAP_INVENTORY});
        if (enableinv && !OperationStatus.VIEW.equals((Object)operationStatus)) {
            this.initMaterialInfo(TABPAGEAP_INVENTORY, MaterialServiceHelper.getBillParameter() != null && MaterialServiceHelper.getBillParameter().isResultr());
            this.getView().updateView(TABPAGEAP_INVENTORY);
        }
        boolean enablepur = MaterialServiceHelper.isMaterialBizVisible((DynamicObject)material, (String)"bd_materialpurchaseinfo", (String)"enablepur");
        this.getView().setVisible(Boolean.valueOf(enablepur), new String[]{TABPAGEAP_PURCHASE});
        if (enablepur && !OperationStatus.VIEW.equals((Object)operationStatus)) {
            this.initMaterialInfo(TABPAGEAP_PURCHASE, MaterialServiceHelper.getBillParameter() != null && MaterialServiceHelper.getBillParameter().isResultr());
            this.getView().updateView(TABPAGEAP_PURCHASE);
        }
        boolean enablesale = MaterialServiceHelper.isMaterialBizVisible((DynamicObject)material, (String)"bd_materialsalinfo", (String)"enablesale");
        this.getView().setVisible(Boolean.valueOf(enablesale), new String[]{TABPAGEAP_SAL});
        if (enablesale && !OperationStatus.VIEW.equals((Object)operationStatus)) {
            this.initMaterialInfo(TABPAGEAP_SAL, MaterialServiceHelper.getBillParameter() != null && MaterialServiceHelper.getBillParameter().isResultr());
            this.getView().updateView(TABPAGEAP_SAL);
        }
        boolean enableeproduct = MaterialServiceHelper.isMaterialBizVisible((DynamicObject)material, (String)"bd_materialmftinfo", (String)"enableproduct");
        this.getView().setVisible(Boolean.valueOf(enableeproduct), new String[]{TABPAGEAP_MFT});
        if (enableeproduct && !OperationStatus.VIEW.equals((Object)operationStatus)) {
            this.initMaterialInfo(TABPAGEAP_MFT, MaterialServiceHelper.getBillParameter() != null && MaterialServiceHelper.getBillParameter().isResultr());
            this.getView().updateView(TABPAGEAP_MFT);
        }
        boolean enableinspect = MaterialServiceHelper.isMaterialBizVisible((DynamicObject)material, (String)"bd_inspect_cfg", (String)"enableinspect");
        this.getView().setVisible(Boolean.valueOf(enableinspect), new String[]{TABPAGEAP_INS});
        if (enableinspect && !OperationStatus.VIEW.equals((Object)operationStatus)) {
            this.initMaterialInfo(TABPAGEAP_INS, MaterialServiceHelper.getBillParameter() != null && MaterialServiceHelper.getBillParameter().isResultr());
            this.getView().updateView(TABPAGEAP_INS);
        }
        this.getView().setVisible(MaterialServiceHelper.isMaterialBizVisible((DynamicObject)material, (String)"bd_materialcalinfo", (String)""), new String[]{TABPAGEAP_CAL});
        if (!OperationStatus.VIEW.equals((Object)operationStatus)) {
            this.initMaterialInfo(TABPAGEAP_CAL, MaterialServiceHelper.getBillParameter() != null && MaterialServiceHelper.getBillParameter().isResultr());
            this.getView().updateView(TABPAGEAP_CAL);
        }
        this.getView().setVisible(MaterialServiceHelper.isMaterialBizVisible((DynamicObject)material, (String)"bd_materialplan", (String)""), new String[]{TABPAGEAP_PLAN});
        if (!OperationStatus.VIEW.equals((Object)operationStatus)) {
            this.initMaterialInfo(TABPAGEAP_PLAN, MaterialServiceHelper.getBillParameter() != null && MaterialServiceHelper.getBillParameter().isResultr());
            this.getView().updateView(TABPAGEAP_PLAN);
        }
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        DynamicObjectCollection doc = null;
        Object newValue = e.getChangeSet()[0].getNewValue();
        Object oldValue = e.getChangeSet()[0].getOldValue();
        Long pkValue = (Long)this.getModel().getDataEntity().getPkValue();
        if (newValue instanceof DynamicObjectCollection && ((doc = (DynamicObjectCollection)newValue) == null || doc.size() == 0)) {
            return;
        }
        String name = e.getProperty().getName();
        if ("baseunit".equals(name)) {
            this.getModel().setValue("auxptyunit", null);
            Object baseunit = this.getModel().getValue("baseunit");
            if (baseunit instanceof DynamicObject) {
                if (!(oldValue instanceof DynamicObject)) {
                    return;
                }
            } else {
                return;
            }
            this.getView().showConfirm(ResManager.loadKDString((String)"\u4fee\u6539\u57fa\u672c\u5355\u4f4d\u53ef\u80fd\u5f71\u54cd\u5355\u4f4d\u4fe1\u606f\u7684\u6362\u7b97\u5173\u7cfb\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"MaterialDataFormPlugin_1", (String)"bd-master-formplugin", (Object[])new Object[0]), MessageBoxOptions.OK);
            DynamicObjectCollection unitdoc = this.getModel().getEntryEntity("entryentity");
            if (unitdoc == null || unitdoc.isEmpty()) {
                return;
            }
            for (int index = 0; index < unitdoc.size(); ++index) {
                this.getModel().setValue("desmuid", this.getModel().getValue("baseunit"), index);
            }
        } else if ("enableinv".equals(name) || "enablepur".equals(name) || "enablesale".equals(name) || "enableproduct".equals(name) || "enableinspect".equals(name)) {
            this.closeSwitchCheckBizInfo(name);
        } else if ("isuseauxpty".equals(name) && Boolean.FALSE.equals(newValue)) {
            this.removeUnSaveAuxPtyEntryRows();
        } else if ("materialtype".equals(name) && "9".equals(newValue)) {
            this.getModel().setValue("enableinv", (Object)NEW_NULL_FID);
            boolean suite = this.getModel().getDataEntity().getBoolean("suite");
            if (suite) {
                this.getModel().setValue("enableproduct", (Object)false);
                this.getModel().setValue("enableinspect", (Object)false);
                this.getModel().setValue("enableoutsource", (Object)false);
                this.getModel().setValue("enabletrustee", (Object)false);
                this.getModel().setValue("enableconsign", (Object)false);
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"enableproduct", "enableinspect", "enableoutsource", "enabletrustee", "enableconsign"});
            }
        } else if ("materialtype".equals(name) && !"1".equals(newValue)) {
            this.getModel().setValue("farmproducts", (Object)false);
            this.getModel().setValue("deductiblerate", (Object)0);
            if ("7".equals(newValue)) {
                this.getModel().setValue("enableinv", (Object)false);
                this.getModel().setValue("enableproduct", (Object)false);
                this.getModel().setValue("enableasset", (Object)false);
                this.getModel().setValue("enableoutsource", (Object)false);
                this.getModel().setValue("enabletrustee", (Object)false);
                this.getModel().setValue("enableconsign", (Object)false);
                this.getModel().setValue("enablevmi", (Object)false);
                this.getModel().setValue("suite", (Object)false);
            }
            if ("8".equals(newValue)) {
                this.getModel().setValue("enableoutsource", (Object)false);
                this.getModel().setValue("enabletrustee", (Object)false);
                this.getModel().setValue("enableconsign", (Object)false);
                this.getModel().setValue("enablevmi", (Object)false);
                this.getModel().setValue("suite", (Object)false);
            }
        } else if ("farmproducts".equals(name) && ((Boolean)newValue).booleanValue()) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"deductiblerate"});
        } else if ("farmproducts".equals(name) && !((Boolean)newValue).booleanValue()) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"deductiblerate"});
            this.getModel().setValue("deductiblerate", (Object)0);
        } else if ("productline".equals(name) && (oldValue != null && !oldValue.equals(newValue) || oldValue == null && newValue != null)) {
            this.getModel().setValue("productfamily", null);
            this.getModel().setValue("productseries", null);
            this.getModel().setValue("productmodel", null);
        } else if ("productfamily".equals(name) && (oldValue != null && !oldValue.equals(newValue) || oldValue == null && newValue != null)) {
            this.getModel().setValue("productseries", null);
            this.getModel().setValue("productmodel", null);
        } else if ("productseries".equals(name) && (oldValue != null && !oldValue.equals(newValue) || oldValue == null && newValue != null)) {
            this.getModel().setValue("productmodel", null);
        } else if ("denominator".equals(name) && oldValue != null) {
            this.sendNotification(ResManager.loadKDString((String)"\u4fee\u6539\u6e90\u5355\u4f4d\u6362\u7b97\u7cfb\u6570\u53ef\u5bfc\u81f4\u5df2\u5f15\u7528\u7684\u4e1a\u52a1\u5355\u636e\u6570\u91cf\u6362\u7b97\u51fa\u73b0\u5f02\u5e38\uff0c\u8bf7\u5bf9\u5f15\u7528\u4e1a\u52a1\u6570\u636e\u505a\u53d8\u66f4\u5904\u7406\u6216\u4f5c\u5e9f\u3001\u5220\u9664\u540e\u91cd\u65b0\u5f55\u5355\u7b49\u3002", (String)"MaterialDataFormPlugin_10", (String)"bd-master-formplugin", (Object[])new Object[0]));
        } else if ("numerator".equals(name) && oldValue != null) {
            this.sendNotification(ResManager.loadKDString((String)"\u4fee\u6539\u57fa\u672c\u5355\u4f4d\u6362\u7b97\u7cfb\u6570\u53ef\u5bfc\u81f4\u5df2\u5f15\u7528\u7684\u4e1a\u52a1\u5355\u636e\u6570\u91cf\u6362\u7b97\u51fa\u73b0\u5f02\u5e38\uff0c\u8bf7\u5bf9\u5f15\u7528\u6570\u636e\u505a\u53d8\u66f4\u5904\u7406\u6216\u4f5c\u5e9f\u3001\u5220\u9664\u540e\u91cd\u65b0\u5f55\u5355\u7b49\u3002", (String)"MaterialDataFormPlugin_11", (String)"bd-master-formplugin", (Object[])new Object[0]));
        } else if ("materialtype".equals(name) && "1".equals(newValue)) {
            boolean suite = this.getModel().getDataEntity().getBoolean("suite");
            if (suite) {
                this.getModel().setValue("enableproduct", (Object)false);
                this.getModel().setValue("enableinspect", (Object)false);
                this.getModel().setValue("enableoutsource", (Object)false);
                this.getModel().setValue("enabletrustee", (Object)false);
                this.getModel().setValue("enableconsign", (Object)false);
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"enableproduct", "enableinspect", "enableoutsource", "enabletrustee", "enableconsign"});
            }
        } else if ("suite".equals(name)) {
            String materialType = this.getModel().getDataEntity().getString("materialtype");
            if (("1".equals(materialType) || "9".equals(materialType)) && ((Boolean)newValue).booleanValue()) {
                this.getModel().setValue("enableproduct", (Object)false);
                this.getModel().setValue("enableinspect", (Object)false);
                this.getModel().setValue("enableoutsource", (Object)false);
                this.getModel().setValue("enabletrustee", (Object)false);
                this.getModel().setValue("enableconsign", (Object)false);
                this.getView().setEnable(Boolean.valueOf(false), new String[]{"enableproduct", "enableinspect", "enableoutsource", "enabletrustee", "enableconsign"});
            } else if (!((Boolean)newValue).booleanValue()) {
                this.getView().setEnable(Boolean.valueOf(true), new String[]{"enableproduct", "enableinspect", "enableoutsource", "enabletrustee", "enableconsign"});
            }
        } else if (pkValue != 0L && "configproperties".equals(name) && "2".equals(newValue)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5982\u7269\u6599\u88ab\u5f15\u7528\uff0c\u4fee\u6539\u914d\u7f6e\u5c5e\u6027\u4f1a\u5bfc\u81f4\u5386\u53f2\u5355\u636e\u65e0\u6cd5\u51fa\u5165\u5e93\u3002", (String)"BASEDATA-E-272285", (String)"bd-master-formplugin", (Object[])new Object[0]));
        }
    }

    private void inspectMatCloseCheck() {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        String isOpenInspect = "1";
        QFilter invMasterQ = new QFilter("masterid", "=", dataEntity.getPkValue());
        QFilter invInspectQ = new QFilter("isinvinspect", "=", (Object)isOpenInspect);
        QFilter purInspectQ = new QFilter("ispurchaseinspect", "=", (Object)isOpenInspect);
        boolean existsInv = QueryServiceHelper.exists((String)"bd_materialinventoryinfo", (QFilter[])new QFilter[]{invMasterQ.and(invInspectQ.or(purInspectQ))});
        String msg = ResManager.loadKDString((String)"\u7269\u6599\u5e93\u5b58\u4fe1\u606f\u5f00\u542f\u3010\u6765\u6599\u68c0\u9a8c\u3011\u6216\u3010\u5e93\u5b58\u68c0\u9a8c\u3011\uff0c\u6216\u7269\u6599\u9500\u552e\u4fe1\u606f\u5f00\u542f\u3010\u53d1\u8d27\u68c0\u9a8c\u3011\u6216\u3010\u9000\u8d27\u68c0\u9a8c\u3011\uff0c\u4e0d\u5141\u8bb8\u5173\u95ed\u3002", (String)"MaterialDataFormPlugin_13", (String)"bd-master-formplugin", (Object[])new Object[0]);
        if (existsInv) {
            this.getModel().beginInit();
            this.getModel().setValue("enableinspect", (Object)Boolean.TRUE);
            this.getModel().endInit();
            this.getView().showTipNotification(msg);
            return;
        }
        QFilter salMasterQ = new QFilter("masterid", "=", dataEntity.getPkValue());
        QFilter deliverInspectQ = new QFilter("isdeliverinspect", "=", (Object)isOpenInspect);
        QFilter returnInspectQ = new QFilter("isreturninspect", "=", (Object)isOpenInspect);
        boolean existsSal = QueryServiceHelper.exists((String)"bd_materialsalinfo", (QFilter[])new QFilter[]{salMasterQ.and(deliverInspectQ.or(returnInspectQ))});
        if (existsSal) {
            this.getModel().beginInit();
            this.getModel().setValue("enableinspect", (Object)Boolean.TRUE);
            this.getModel().endInit();
            this.getView().showTipNotification(msg);
        }
    }

    private void sendNotification(String content) {
        NotificationBody notificationBody = new NotificationBody();
        notificationBody.setAppId("bos");
        notificationBody.setTitle(ResManager.loadKDString((String)"\u4fee\u6539\u63d0\u793a", (String)"MaterialDataFormPlugin_12", (String)"bd-master-formplugin", (Object[])new Object[0]));
        notificationBody.setContent(content);
        notificationBody.setIconType(IconType.Warning.toString());
        notificationBody.setLevel(2);
        notificationBody.setDuration(3000);
        notificationBody.setClickClassName("kd.bos.portal.plugin.LoginIpMessagePlugin");
        NotificationFormInfo notificationFormInfo = new NotificationFormInfo();
        notificationFormInfo.setNotification(notificationBody);
        ArrayList<String> userids = new ArrayList<String>();
        userids.add(String.valueOf(RequestContext.get().getCurrUserId()));
        NotificationServiceHelper.sendNotification(userids, (NotificationFormInfo)notificationFormInfo);
    }

    private void removeUnSaveAuxPtyEntryRows() {
        DynamicObjectCollection auxPtyEntry = this.getModel().getEntryEntity("auxptyentry");
        int auxPtyEntrySize = auxPtyEntry.size();
        ArrayList<Integer> removeRowIdxList = new ArrayList<Integer>(auxPtyEntrySize);
        for (int i = 0; i < auxPtyEntrySize; ++i) {
            DynamicObject auxPtyRow = (DynamicObject)auxPtyEntry.get(i);
            Object auxPtyId = auxPtyRow.getPkValue();
            if (auxPtyId != null && !NEW_NULL_FID.equals(String.valueOf(auxPtyId))) continue;
            removeRowIdxList.add(i);
        }
        if (!removeRowIdxList.isEmpty()) {
            int[] removeRowIdxArr = removeRowIdxList.stream().mapToInt(Integer::intValue).toArray();
            this.getModel().deleteEntryRows("auxptyentry", removeRowIdxArr);
        }
    }

    private void closeSwitchCheckBizInfo(String name) {
        String entityNumber = this.getEntityNumber(name);
        Object pkValue = this.getModel().getDataEntity().getPkValue();
        boolean isEnableInspect = this.getModel().getDataEntity().getBoolean(name);
        if (StringUtils.isNotBlank((Object)pkValue) && !NEW_NULL_FID.equals(pkValue.toString()) && !isEnableInspect) {
            boolean exists = QueryServiceHelper.exists((String)entityNumber, (QFilter[])new QFilter[]{new QFilter("masterid", "=", pkValue)});
            if (exists) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7269\u6599\u5b58\u5728\u5bf9\u5e94\u4e1a\u52a1\u4fe1\u606f\uff0c\u4e0d\u5141\u8bb8\u5173\u95ed\u3002", (String)"MaterialDataFormPlugin_8", (String)"bd-master-formplugin", (Object[])new Object[0]));
                this.getModel().beginInit();
                this.getModel().setValue(name, (Object)Boolean.TRUE);
                this.getModel().endInit();
            } else {
                if (MaterialServiceHelper.getBillParameter() != null && MaterialServiceHelper.getBillParameter().isResultr()) {
                    switch (name) {
                        case "enableinv": {
                            this.getPageCache().remove(TABPAGEAP_INVENTORY);
                            break;
                        }
                        case "enablepur": {
                            this.getPageCache().remove(TABPAGEAP_PURCHASE);
                            break;
                        }
                        case "enablesale": {
                            this.getPageCache().remove(TABPAGEAP_SAL);
                            break;
                        }
                        case "enableproduct": {
                            this.getPageCache().remove(TABPAGEAP_MFT);
                            break;
                        }
                        case "enableinspect": {
                            this.getPageCache().remove(TABPAGEAP_INS);
                            break;
                        }
                    }
                }
                if ("enableinspect".equals(name)) {
                    this.inspectMatCloseCheck();
                }
            }
        }
    }

    private void setVisible(String tabpageap, String status, OperationStatus operationStatus) {
        String newOp = "new_" + tabpageap;
        String saveOp = "save_" + tabpageap;
        String submitOp = "submit_" + tabpageap;
        String unsubmitOp = "unsubmit_" + tabpageap;
        String auditOp = "audit_" + tabpageap;
        String unauditOp = "unaudit_" + tabpageap;
        if (OperationStatus.VIEW.equals((Object)operationStatus)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{newOp, saveOp, submitOp, unsubmitOp, auditOp, unauditOp});
        } else if (STATUS_A.equals(status)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{saveOp, submitOp});
            this.getView().setVisible(Boolean.FALSE, new String[]{newOp, unsubmitOp, auditOp, unauditOp});
        } else if (STATUS_B.equals(status)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{auditOp, unsubmitOp});
            this.getView().setVisible(Boolean.FALSE, new String[]{newOp, saveOp, submitOp, unauditOp});
        } else if (STATUS_C.equals(status)) {
            this.getView().setVisible(Boolean.TRUE, new String[]{unauditOp});
            this.getView().setVisible(Boolean.FALSE, new String[]{newOp, submitOp, saveOp, auditOp, auditOp, unsubmitOp});
        }
        this.getView().updateView(tabpageap);
    }

    private String getEntityNumber(String context) {
        if (TABPAGEAP_INVENTORY.equals(context) || "enableinv".equals(context)) {
            return "bd_materialinventoryinfo";
        }
        if (TABPAGEAP_PURCHASE.equals(context) || "enablepur".equals(context)) {
            return "bd_materialpurchaseinfo";
        }
        if (TABPAGEAP_SAL.equals(context) || "enablesale".equals(context)) {
            return "bd_materialsalinfo";
        }
        if (TABPAGEAP_MFT.equals(context) || "enableproduct".equals(context)) {
            return "bd_materialmftinfo";
        }
        if (TABPAGEAP_INS.equals(context) || "enableinspect".equals(context)) {
            return "bd_inspect_cfg";
        }
        if (TABPAGEAP_CAL.equals(context)) {
            return "bd_materialcalinfo";
        }
        if (TABPAGEAP_PLAN.equals(context)) {
            return "mpdm_materialplan";
        }
        return null;
    }

    public void confirmCallBack(MessageBoxClosedEvent mbce) {
        super.confirmCallBack(mbce);
        String callBackId = mbce.getCallBackId();
        if ("baseunit".equals(callBackId)) {
            ListShowParameter createShowListForm = ShowFormHelper.createShowListForm((String)"bd_measureunits", (boolean)false);
            createShowListForm.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "baseunit"));
            this.getView().showForm((FormShowParameter)createShowListForm);
        }
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        String actionId = e.getActionId();
        if (CLOSECALLBACK_SELECTMUS.equals(actionId)) {
            try (TraceSpan span = Tracer.create((String)"MaterialDataFormPlugin", (String)"showUintInfo");){
                this.showUintInfo(e);
            }
        }
    }

    private void showUintInfo(ClosedCallBackEvent e) {
        ListSelectedRowCollection col = (ListSelectedRowCollection)e.getReturnData();
        if (col == null || col.size() == 0) {
            return;
        }
        int rowCount = this.getModel().getEntryRowCount("entryentity");
        HashSet<Long> muids = new HashSet<Long>(rowCount);
        for (int i = 0; i < rowCount; ++i) {
            DynamicObject mu = (DynamicObject)this.getModel().getValue("measureunitid", i);
            muids.add(mu.getLong("id"));
        }
        ArrayList<Long> muidsToAdd = new ArrayList<Long>();
        for (ListSelectedRow row : col) {
            Long muid = (Long)row.getPrimaryKeyValue();
            if (muids.contains(muid)) continue;
            muidsToAdd.add(muid);
        }
        if (muidsToAdd.size() > 0) {
            this.getModel().batchCreateNewEntryRow("entryentity", muidsToAdd.size());
            DynamicObject baseUnit = (DynamicObject)this.getModel().getValue("baseunit");
            this.getModel().beginInit();
            for (int i = 0; i < muidsToAdd.size(); ++i) {
                DynamicObject unitConvert;
                long srcmuid = (Long)muidsToAdd.get(i);
                long desmuid = baseUnit.getLong("id");
                this.getModel().setValue("measureunitid", (Object)srcmuid, i + rowCount);
                this.getModel().setValue("desmuid", (Object)desmuid, i + rowCount);
                DynamicObject queryOne = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_measureunits", (String)"precision", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)srcmuid)});
                if (queryOne != null) {
                    this.getModel().setValue("precision", queryOne.get("precision"), i + rowCount);
                }
                if ((unitConvert = this.getUnitConvert(srcmuid, desmuid)) == null) continue;
                this.getModel().setValue("numerator", unitConvert.get("numerator"), i + rowCount);
                this.getModel().setValue("denominator", unitConvert.get("denominator"), i + rowCount);
            }
            this.getModel().endInit();
            this.getView().updateView("entryentity");
        }
    }

    private DynamicObject getUnitConvert(long srcmuid, long desmuid) {
        DynamicObject result = null;
        QFilter[] filters = new QFilter[]{new QFilter("srcmuid", "=", (Object)srcmuid), new QFilter("desmuid", "=", (Object)desmuid)};
        result = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_measureunitconv", (String)"numerator, denominator, converttype", (QFilter[])filters);
        return result;
    }

    private void setUnitConvert(String materialid) {
        if (null == materialid || NEW_NULL_FID.equals(materialid)) {
            return;
        }
        this.getModel().deleteEntryData("entryentity");
        QFilter[] filters = new QFilter[]{new QFilter("materialid", "=", (Object)Long.valueOf(materialid))};
        String selectFields = "id,measureunitid.id,denominator,numerator,converttype,appscen,precision";
        Map multimeasureunits = BusinessDataServiceHelper.loadFromCache((String)"bd_multimeasureunit", (String)"id,measureunitid.id,denominator,numerator,converttype,appscen,precision", (QFilter[])filters);
        if (multimeasureunits != null && multimeasureunits.size() > 0) {
            this.getModel().beginInit();
            this.getModel().batchCreateNewEntryRow("entryentity", multimeasureunits.size());
            int index = 0;
            for (DynamicObject object : multimeasureunits.values()) {
                this.getModel().setValue("measureunitid", object.get("measureunitid.id"), index);
                this.getModel().setValue("denominator", object.get("denominator"), index);
                this.getModel().setValue("numerator", object.get("numerator"), index);
                this.getModel().setValue("converttype", object.get("converttype"), index);
                this.getModel().setValue("appscen", object.get("appscen"), index);
                this.getModel().setValue("desmuid", this.getModel().getValue("baseunit"), index);
                this.getModel().setValue("precision", object.get("precision"), index);
                this.getModel().setValue("unitconvertid", object.get("id"), index);
                ++index;
            }
            this.getModel().endInit();
            this.getView().updateView("entryentity");
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent e) {
        String fieldKey = e.getProperty().getName();
        Object materialId = this.getModel().getDataEntity().getPkValue();
        if (materialId == null) {
            return;
        }
        if ("auxptyunit".equals(fieldKey)) {
            DynamicObject baseUnit = (DynamicObject)this.getModel().getValue("baseunit");
            if (baseUnit == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u8bbe\u7f6e\u57fa\u672c\u5355\u4f4d\u3002", (String)"MaterialDataFormPlugin_0", (String)"bd-master-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                return;
            }
            Long baseUnitId = GroupStandardUtils.getDataByType((Object)baseUnit);
            MaterialServiceHelper.addAuxptyUnitbeforeF7Select((IDataModel)this.getModel(), (BeforeF7SelectEvent)e, (Long)baseUnitId);
        } else if ("auxpty".equals(fieldKey)) {
            MaterialServiceHelper.addAuxptyInfobeforeF7Select((IDataModel)this.getModel(), (BeforeF7SelectEvent)e);
        } else if ("standardid".equals(fieldKey)) {
            GroupStandardHelper.addGroupStandardbeforeF7Select((IDataModel)this.getModel(), (String)"bd_customer", (BeforeF7SelectEvent)e);
        } else if ("groupid".equals(fieldKey)) {
            this.groupStandardHelper.addGroupbeforeF7Select(this.getModel(), e, this.getType());
        } else if ("productfamily".equals(fieldKey) && this.getModel().getDataEntity().getDynamicObject("productline") != null && this.getModel().getDataEntity().getDynamicObject("productline").containsProperty("producthierarchy") && this.getModel().getDataEntity().getDynamicObject("productline").getDynamicObject("producthierarchy") != null) {
            QFilter qfilter = new QFilter("producthierarchy.parent", "in", this.getModel().getDataEntity().getDynamicObject("productline").getDynamicObject("producthierarchy").getPkValue());
            ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().getQFilters().add(qfilter);
        } else if ("productseries".equals(fieldKey) && this.getModel().getDataEntity().getDynamicObject("productfamily") != null && this.getModel().getDataEntity().getDynamicObject("productfamily").containsProperty("producthierarchy") && this.getModel().getDataEntity().getDynamicObject("productfamily").getDynamicObject("producthierarchy") != null) {
            QFilter qfilter = new QFilter("producthierarchy.parent", "in", this.getModel().getDataEntity().getDynamicObject("productfamily").getDynamicObject("producthierarchy").getPkValue());
            ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().getQFilters().add(qfilter);
        } else if ("productmodel".equals(fieldKey) && this.getModel().getDataEntity().getDynamicObject("productseries") != null && this.getModel().getDataEntity().getDynamicObject("productseries").containsProperty("producthierarchy") && this.getModel().getDataEntity().getDynamicObject("productseries").getDynamicObject("producthierarchy") != null) {
            QFilter qfilter = new QFilter("producthierarchy.parent", "in", this.getModel().getDataEntity().getDynamicObject("productseries").getDynamicObject("producthierarchy").getPkValue());
            ((ListShowParameter)e.getFormShowParameter()).getListFilterParameter().getQFilters().add(qfilter);
        }
    }

    @Override
    public void afterCopyData(EventObject e) {
        super.afterCopyData(e);
        IFormView parentView = this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId());
        if (parentView != null) {
            IPageCache pageCache = (IPageCache)parentView.getService(IPageCache.class);
            String copyMatId = pageCache.get("copyMatId");
            if (copyMatId == null) {
                copyMatId = this.getPageCache().get("copyMatId");
            }
            String selectFields = "id,measureunitid.id,denominator,numerator,converttype,appscen,precision";
            Map datas = BusinessDataServiceHelper.loadFromCache((String)"bd_multimeasureunit", (String)"id,measureunitid.id,denominator,numerator,converttype,appscen,precision", (QFilter[])new QFilter[]{new QFilter("materialid", "=", (Object)Long.valueOf(copyMatId))});
            if (datas == null || datas.size() == 0) {
                return;
            }
            this.getModel().deleteEntryData("entryentity");
            this.getModel().batchCreateNewEntryRow("entryentity", datas.size());
            int i = 0;
            DynamicObject baseUnit = (DynamicObject)this.getModel().getValue("baseunit");
            for (Map.Entry map : datas.entrySet()) {
                this.getModel().setValue("denominator", ((DynamicObject)map.getValue()).get("denominator"), i);
                this.getModel().setValue("measureunitid", ((DynamicObject)map.getValue()).get("measureunitid.id"), i);
                this.getModel().setValue("numerator", ((DynamicObject)map.getValue()).get("numerator"), i);
                this.getModel().setValue("desmuid", (Object)baseUnit.getLong("id"), i);
                this.getModel().setValue("converttype", ((DynamicObject)map.getValue()).get("converttype"), i);
                this.getModel().setValue("appscen", ((DynamicObject)map.getValue()).get("appscen"), i);
                this.getModel().setValue("precision", ((DynamicObject)map.getValue()).get("precision"), i);
                this.getModel().setValue("unitconvertid", ((DynamicObject)map.getValue()).get("id"), i);
                ++i;
            }
        }
    }
}

