/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.master.list;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bd.master.util.GroupStandardUtils;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.list.plugin.AbstractTreeListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;

public class GroupStandardTempListPlugin
extends AbstractTreeListPlugin
implements BeforeFilterF7SelectListener {
    private Map<String, List<Map<String, List<Object>>>> filterValues = null;
    private List<Map<String, List<Object>>> customfilter = null;
    private static final String USEORG_FILEDNAME = "useorg.id";
    public static final String PROP_SUPPLIER = "supplier";
    public static final String PROP_CUSTOMER = "customer";
    public static final String PROP_MATERIAL = "material";
    public static final String PGCACHE_CREATEORG = "createOrg";

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        if (listShowParameter.isLookUp()) {
            return;
        }
        List filterColumnList = args.getFilterContainerInitEvent().getCommonFilterColumns();
        LocaleString orgPropertyName = new LocaleString(ResManager.loadKDString((String)"\u4e1a\u52a1\u7ec4\u7ec7", (String)"GroupStandardTempListPlugin_0", (String)"bd-master-formplugin", (Object[])new Object[0]));
        String entity = this.getMasterEntityNumber();
        CommonFilterColumn orgColumn = new CommonFilterColumn();
        orgColumn.setCaption(orgPropertyName);
        orgColumn.setFieldName(USEORG_FILEDNAME);
        orgColumn.setMustInput(true);
        orgColumn.setEntityField(false);
        if (filterColumnList.contains(orgColumn)) {
            return;
        }
        ArrayList<ComboItem> combos = new ArrayList<ComboItem>();
        String appNumber = this.getView().getFormShowParameter().getAppId();
        DynamicObjectCollection col = GroupStandardUtils.getOrgSet((String)entity, (String)appNumber);
        String defaultOrg = this.getDefaultUseOrg(col);
        for (Object org : col) {
            if (org == null) continue;
            ComboItem item = new ComboItem();
            item.setCaption(new LocaleString(org.getString("name")));
            item.setValue(String.valueOf(org.get("id")));
            combos.add(item);
        }
        orgColumn.setComboItems(combos);
        orgColumn.setType("enum");
        String createOrg = this.getPageCache().get(PGCACHE_CREATEORG);
        if (StringUtils.isBlank((CharSequence)createOrg)) {
            orgColumn.setDefaultValue(defaultOrg);
        } else {
            orgColumn.setDefaultValue(createOrg);
        }
        filterColumnList.add(0, orgColumn);
        if (this.filterValues == null) {
            this.filterValues = new HashMap<String, List<Map<String, List<Object>>>>();
            this.filterValues.put("fastfilter", new ArrayList());
            this.filterValues.put("customfilter", new ArrayList());
            for (FilterColumn filterColumn : filterColumnList) {
                HashMap<String, List> customFiter = new HashMap<String, List>();
                ArrayList<String> fieldName = new ArrayList<String>();
                fieldName.add(filterColumn.getFieldName());
                customFiter.put("FieldName", fieldName);
                if (USEORG_FILEDNAME.equals(filterColumn.getFieldName())) {
                    ArrayList<String> value = new ArrayList<String>();
                    if (StringUtils.isBlank((CharSequence)createOrg)) {
                        value.add(defaultOrg);
                        this.getPageCache().put(PGCACHE_CREATEORG, defaultOrg);
                        this.getPageCache().put("verifyOrg", defaultOrg);
                    } else {
                        value.add(createOrg);
                        this.getPageCache().put(PGCACHE_CREATEORG, createOrg);
                        this.getPageCache().put("verifyOrg", createOrg);
                    }
                    customFiter.put("Value", value);
                } else if (filterColumn.getDefaultValues() != null && filterColumn.getDefaultValues().size() > 0) {
                    customFiter.put("Value", filterColumn.getDefaultValues());
                }
                if (customFiter.get("Value") == null) continue;
                this.filterValues.get("customfilter").add(customFiter);
            }
            this.customfilter = this.filterValues.get("customfilter");
            String customfilterSer = SerializationUtils.toJsonString(this.customfilter);
            this.getPageCache().put("customfilter", customfilterSer);
        }
    }

    private String getDefaultUseOrg(DynamicObjectCollection col) {
        String defaultUseOrg = null;
        if (!col.isEmpty()) {
            defaultUseOrg = String.valueOf(((DynamicObject)col.get(0)).get("id"));
        }
        long longinOrg = RequestContext.get().getOrgId();
        for (DynamicObject obj : col) {
            if (longinOrg != obj.getLong("id")) continue;
            defaultUseOrg = String.valueOf(longinOrg);
        }
        return defaultUseOrg;
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        List filters = e.getQFilters();
        Iterator it = filters.iterator();
        QFilter standardFilter = null;
        while (it.hasNext()) {
            QFilter filter = (QFilter)it.next();
            String property = filter.getProperty();
            if (StringUtils.isBlank((CharSequence)property) || !filter.toString().contains(USEORG_FILEDNAME)) continue;
            it.remove();
        }
        e.setMainOrgQFilter(null);
        String useOrg = this.getPageCache().get(PGCACHE_CREATEORG);
        if (!StringUtils.isBlank((CharSequence)useOrg)) {
            String entity = this.getMasterEntityNumber();
            standardFilter = GroupStandardUtils.getGroupStandardFilter((String)entity, (Long)Long.valueOf(useOrg), (boolean)false, null);
        }
        if (standardFilter != null) {
            filters.add(standardFilter);
        }
    }

    protected String getMasterEntityNumber() {
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        String entityType = listShowParameter.getBillFormId();
        String entity = "";
        if (entityType.contains(PROP_SUPPLIER)) {
            entity = "bd_supplier";
        } else if (entityType.contains(PROP_CUSTOMER)) {
            entity = "bd_customer";
        } else if (entityType.contains(PROP_MATERIAL)) {
            entity = "bd_material";
        }
        return entity;
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        this.filterValues = args.getSearchClickEvent().getFilterValues();
        List<Map<String, List<Object>>> customFiterList = this.filterValues.get("customfilter");
        if (customFiterList == null) {
            return;
        }
        String customfilterSer = SerializationUtils.toJsonString(customFiterList);
        this.getPageCache().remove("customfilter");
        this.getPageCache().put("customfilter", customfilterSer);
        String orgId = null;
        for (Map<String, List<Object>> customFiter : customFiterList) {
            String createOrg;
            List<Object> orgIds;
            List<Object> fieldNames = customFiter.get("FieldName");
            if (fieldNames == null || fieldNames.size() == 0 || !USEORG_FILEDNAME.equals(fieldNames.get(0)) || (orgIds = customFiter.get("Value")) == null || orgIds.size() == 0) continue;
            orgId = String.valueOf(orgIds.get(0));
            if (orgId.equals(createOrg = this.getPageCache().get(PGCACHE_CREATEORG))) {
                return;
            }
            this.getPageCache().put(PGCACHE_CREATEORG, orgId);
        }
    }

    public void beforeF7Select(BeforeFilterF7SelectEvent event) {
        if (!"bos_org".equals(event.getRefEntityId())) {
            return;
        }
        String appNumber = this.getView().getFormShowParameter().getAppId();
        DynamicObjectCollection orgCols = GroupStandardUtils.getOrgSet((String)"bd_material", (String)appNumber);
        ArrayList<Long> orgIds = new ArrayList<Long>();
        for (DynamicObject viewOrg : orgCols) {
            if (viewOrg.get("id") == null) continue;
            orgIds.add(Long.valueOf(viewOrg.get("id").toString()));
        }
        ArrayList<QFilter> filterList = new ArrayList<QFilter>();
        QFilter idsFilter = new QFilter("id", "in", orgIds);
        filterList.add(idsFilter);
        DynamicObject ctrlview = BaseDataServiceHelper.getCtrlview((String)this.getMasterEntityNumber());
        if (ctrlview != null) {
            event.addCustomParam("orgFuncId", (Object)ctrlview.getString("treetype"));
            event.addCustomParam("orgViewSchemeNumber", (Object)ctrlview.getString("number"));
        }
        event.getQfilters().addAll(filterList);
    }
}

