/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.gmc.formplugin.itemclass;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import kd.bd.gmc.common.f7.F7Utils;
import kd.bd.gmc.common.pagemodel.ClassTreeSearchParam;
import kd.bd.gmc.common.util.ClassTreeUtils;
import kd.bd.gmc.common.util.CommonUtils;
import kd.bd.master.util.GroupStandardUtils;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Button;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.BeforeClickEvent;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeCheckEvent;
import kd.bos.form.control.events.TreeNodeCheckListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.control.events.TreeNodeQueryListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;

public class ItemClassViewFormPlugin
extends AbstractFormPlugin
implements TreeNodeQueryListener,
TreeNodeClickListener,
TreeNodeCheckListener,
SearchEnterListener {
    private static final Log log = LogFactory.getLog(ItemClassViewFormPlugin.class);
    private static ThreadPool threadPool = ThreadPools.newFixedThreadPool((String)"ItemClassViewFormPlugin.ThreadPools", (int)2);
    public static final String CACHE_MATERIALCLASS_TREE_ROOTNODE = "CACHE_MATERIALCLASS_TREE_ROOTNODE";
    public static final String CACHE_MATERIALCLASS_TREE_ROOTNODE_CHECKED = "CACHE_MATERIALCLASS_TREE_ROOTNODE_CHECKED";
    public static final String CACHE_ITEMCLASSVIEW_TREE_ROOTNODE = "CACHE_ITEMCLASSVIEW_TREE_ROOTNODE";

    public void registerListener(EventObject e) {
        Search viewsearchap;
        super.registerListener(e);
        TreeView materialClassTreeView = (TreeView)this.getControl("materialclasstree");
        materialClassTreeView.addTreeNodeQueryListener((TreeNodeQueryListener)this);
        materialClassTreeView.addTreeNodeCheckListener((TreeNodeCheckListener)this);
        TreeView itemClassTreeView = (TreeView)this.getControl("itemclassviewtree");
        itemClassTreeView.addTreeNodeQueryListener((TreeNodeQueryListener)this);
        itemClassTreeView.addTreeNodeCheckListener((TreeNodeCheckListener)this);
        this.addClickListeners(new String[]{"btn_leveladd", "btn_orderadd", "btn_deletenode", "btn_uncheckmaterialclass", "btn_uncheckitemclass"});
        this.addItemClickListeners(new String[]{"tbmain"});
        Search orgsearchap = (Search)this.getView().getControl("materialclasssearchap");
        if (orgsearchap != null) {
            orgsearchap.addEnterListener((SearchEnterListener)this);
        }
        if ((viewsearchap = (Search)this.getView().getControl("itemclasssearchap")) != null) {
            viewsearchap.addEnterListener((SearchEnterListener)this);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.setClassStandardComboEdit("materialclassstandard", "bd_materialgroupstandard");
        this.setClassStandardComboEdit("itemclassstandard", "bd_goodsclassstandard");
        this.getModel().setValue("ismaterialclasschild", (Object)Boolean.TRUE);
        this.loadClassViewTree();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propertyName;
        super.propertyChanged(e);
        switch (propertyName = e.getProperty().getName()) {
            case "materialclassstandard": {
                this.initMaterialClassStandardViewTree();
                this.getPageCache().remove(CACHE_MATERIALCLASS_TREE_ROOTNODE_CHECKED);
                break;
            }
            case "itemclassstandard": {
                this.initItemClassStandardViewTree();
                break;
            }
        }
    }

    public void search(SearchEnterEvent evt) {
        String searchText = evt.getText();
        Search search = (Search)evt.getSource();
        TreeView treeView = null;
        String rootNodeView = "";
        long standardId = 0L;
        if ("materialclasssearchap".equals(search.getKey())) {
            treeView = (TreeView)this.getControl("materialclasstree");
            rootNodeView = CACHE_MATERIALCLASS_TREE_ROOTNODE;
            standardId = CommonUtils.stringToLong((Object)this.getModel().getValue("materialclassstandard"));
        } else {
            treeView = (TreeView)this.getControl("itemclassviewtree");
            rootNodeView = CACHE_ITEMCLASSVIEW_TREE_ROOTNODE;
            standardId = CommonUtils.stringToLong((Object)this.getModel().getValue("itemclassstandard"));
        }
        ClassTreeSearchParam searchParam = new ClassTreeSearchParam(searchText, this.getView(), treeView, rootNodeView, standardId);
        ClassTreeUtils.searchFromLazyOrgTree((ClassTreeSearchParam)searchParam);
    }

    public void treeNodeCheck(TreeNodeCheckEvent evt) {
        TreeView treeView = (TreeView)evt.getSource();
        String treeKey = treeView.getKey();
        String nodeId = evt.getNodeId().toString();
        boolean isChecked = evt.getChecked();
        if ("materialclasstree".equals(treeKey)) {
            this.materialClassTreeNodeCheck(treeView, nodeId, (Boolean)this.getModel().getValue("ismaterialclasschild"), isChecked);
        }
    }

    public void queryTreeNodeChildren(TreeNodeEvent evt) {
        TreeView treeView = (TreeView)evt.getSource();
        String treeKey = treeView.getKey();
        String nodeId = evt.getNodeId().toString();
        switch (treeKey) {
            case "materialclasstree": {
                Object defaultStandardId = this.getModel().getValue("materialclassstandard");
                treeView.addNodes(this.queryMateriallassByStandardId(CommonUtils.stringToLong((Object)defaultStandardId), nodeId, false));
                break;
            }
            case "itemclassviewtree": {
                Object defaultStandardId = this.getModel().getValue("itemclassstandard");
                treeView.addNodes(this.queryItemClassByStandardId(CommonUtils.stringToLong((Object)defaultStandardId), CommonUtils.stringToLong((Object)nodeId)));
                break;
            }
        }
    }

    public void click(EventObject evt) {
        Object src = evt.getSource();
        if (!(src instanceof Button)) {
            return;
        }
        String itemKey = ((Button)src).getKey();
        if ("btn_uncheckmaterialclass".equals(itemKey)) {
            TreeView bizUnitTree = (TreeView)this.getControl("materialclasstree");
            List selectedUnitList = bizUnitTree.getTreeState().getSelectedNodeId();
            bizUnitTree.uncheckNodes(selectedUnitList);
        } else if ("btn_uncheckitemclass".equals(itemKey)) {
            TreeView bizViewTree = (TreeView)this.getControl("itemclassviewtree");
            List bizViewParentIds = bizViewTree.getTreeState().getSelectedNodeId();
            bizViewTree.uncheckNodes(bizViewParentIds);
        }
    }

    public void beforeClick(BeforeClickEvent evt) {
        String itemKey;
        Object src = evt.getSource();
        if (!(src instanceof Button)) {
            return;
        }
        switch (itemKey = ((Button)src).getKey()) {
            case "btn_leveladd": {
                if (this.isAddAble(false)) break;
                evt.setCancel(true);
                break;
            }
            case "btn_orderadd": {
                if (this.isAddAble(true)) break;
                evt.setCancel(true);
                break;
            }
            case "btn_deletenode": {
                if (this.isDeleteAble()) break;
                evt.setCancel(true);
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs e) {
        String operateKey;
        super.beforeDoOperation(e);
        AbstractOperate operate = (AbstractOperate)e.getSource();
        switch (operateKey = operate.getOperateKey()) {
            case "save": {
                IPageCache pageCache = this.getPageCache();
                String deleteCache = pageCache.get("_deleteNode_");
                String updateCache = this.getPageCache().get("_updateNode_");
                String addCache = this.getPageCache().get("_addNode_");
                HashMap<String, String> cacheMap = new HashMap<String, String>(3);
                cacheMap.put("_deleteNode_", deleteCache);
                cacheMap.put("_updateNode_", this.sortItemClassByTreeNodeLevel(updateCache));
                cacheMap.put("_addNode_", this.sortItemClassByTreeNodeLevel(addCache));
                OperateOption op = operate.getOption();
                op.setVariableValue("_itemclass_option_params_", SerializationUtils.toJsonString(cacheMap));
                this.getModel().setValue("isdatachangedflag", (Object)Boolean.FALSE);
                break;
            }
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        String updateCache = this.getPageCache().get("_updateNode_");
        String addCache = this.getPageCache().get("_addNode_");
        Map<String, Map<String, Object>> updateNodeMap = this.convertNodeCacheMap(updateCache);
        Map<String, Map<String, Object>> addNodeMap = this.convertNodeCacheMap(addCache);
        boolean isChange = (Boolean)this.getModel().getValue("isdatachangedflag");
        if (isChange && (updateNodeMap != null || addNodeMap != null)) {
            e.setCancel(true);
            String msg = ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u60a8\u6709\u66f4\u6539\u5185\u5bb9\uff0c\u662f\u5426\u4e0d\u4fdd\u5b58\u76f4\u63a5\u9000\u51fa\uff1f\r\n\u82e5\u4e0d\u4fdd\u5b58\uff0c\u5c06\u4e22\u5931\u8fd9\u4e9b\u66f4\u6539\u3002", (String)"ItemClassViewFormPlugin_0", (String)"bd-gmc-formplugin", (Object[])new Object[0]);
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("continue_close", (IFormPlugin)this);
            HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>(2);
            btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u8fd4\u56de\u7f16\u8f91", (String)"ItemClassViewFormPlugin_1", (String)"bd-gmc-formplugin", (Object[])new Object[0]));
            btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u76f4\u63a5\u9000\u51fa", (String)"ItemClassViewFormPlugin_2", (String)"bd-gmc-formplugin", (Object[])new Object[0]));
            MessageBoxOptions options = MessageBoxOptions.OKCancel;
            this.getView().showConfirm(msg, "", options, ConfirmTypes.Save, confirmCallBacks, btnNameMaps);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        String key;
        super.afterDoOperation(e);
        switch (key = e.getOperateKey()) {
            case "save": {
                this.getPageCache().remove("_addNode_");
                this.getPageCache().remove("_updateNode_");
                this.getPageCache().remove("_deleteNode_");
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        if (evt.getResult() == MessageBoxResult.Yes) {
            this.getModel().setValue("isdatachangedflag", (Object)Boolean.FALSE);
            this.getView().invokeOperation("close");
        }
    }

    private void loadClassViewTree() {
        Future leftTree = threadPool.submit(() -> {
            this.initMaterialClassStandardViewTree();
            return Boolean.TRUE;
        });
        Future rightTree = threadPool.submit(() -> {
            this.initItemClassStandardViewTree();
            return Boolean.TRUE;
        });
        try {
            if (((Boolean)leftTree.get()).booleanValue()) {
                rightTree.get();
            }
        }
        catch (InterruptedException e) {
            log.error("loadClassViewTree is error", (Throwable)e);
        }
        catch (ExecutionException e) {
            log.error("loadClassViewTree is error", (Throwable)e);
        }
    }

    private void initMaterialClassStandardViewTree() {
        TreeView treeView = (TreeView)this.getControl("materialclasstree");
        TreeNode rootNode = this.getTreeRootNode(treeView);
        Object defaultStandardId = this.getModel().getValue("materialclassstandard");
        List<TreeNode> nodeList = this.queryMateriallassByStandardId(CommonUtils.stringToLong((Object)defaultStandardId), "0", false);
        for (TreeNode treeNode : nodeList) {
            rootNode.addChild(treeNode);
        }
        this.updateRootNodeCache(CACHE_MATERIALCLASS_TREE_ROOTNODE, rootNode);
        treeView.addNode(rootNode);
        treeView.focusNode(rootNode);
        treeView.uncheckNodes(treeView.getTreeState().getSelectedNodeId());
    }

    private void initItemClassStandardViewTree() {
        TreeView treeView = (TreeView)this.getControl("itemclassviewtree");
        TreeNode rootNode = this.getTreeRootNode(treeView);
        Object defaultStandardId = this.getModel().getValue("itemclassstandard");
        List<TreeNode> nodeList = this.queryItemClassByStandardId(CommonUtils.stringToLong((Object)defaultStandardId), 0L);
        for (TreeNode treeNode : nodeList) {
            rootNode.addChild(treeNode);
        }
        this.updateRootNodeCache(CACHE_ITEMCLASSVIEW_TREE_ROOTNODE, rootNode);
        treeView.addNode(rootNode);
        treeView.focusNode(rootNode);
        treeView.uncheckNodes(treeView.getTreeState().getSelectedNodeId());
    }

    private TreeNode getTreeRootNode(TreeView treeView) {
        treeView.deleteAllNodes();
        String name = ResManager.loadKDString((String)"\u5168\u90e8", (String)"ItemClassViewFormPlugin_3", (String)"bd-gmc-formplugin", (Object[])new Object[0]);
        TreeNode rootNode = new TreeNode("", "0", name);
        rootNode.setIsOpened(true);
        return rootNode;
    }

    private void updateRootNodeCache(String rootNodeCache, TreeNode rootNode) {
        String rootNodeView = "";
        rootNodeView = CACHE_ITEMCLASSVIEW_TREE_ROOTNODE.equals(rootNodeCache) ? CACHE_ITEMCLASSVIEW_TREE_ROOTNODE : CACHE_MATERIALCLASS_TREE_ROOTNODE;
        if (rootNode == null) {
            this.getPageCache().remove(rootNodeView);
        } else {
            this.getPageCache().put(rootNodeView, SerializationUtils.toJsonString((Object)rootNode));
        }
    }

    private void setClassStandardComboEdit(String comboControlKey, String formId) {
        long orgId = RequestContext.get().getOrgId();
        QFilter enableFilter = F7Utils.getEnableFilter();
        if (orgId > 0L) {
            QFilter[] qFilterArray;
            QFilter authorizedFilter = BaseDataServiceHelper.getBaseDataFilter((String)formId, (Long)orgId);
            if ("bd_goodsclassstandard".equals(formId)) {
                enableFilter = enableFilter.and(new QFilter("scope", "like", (Object)"%0%"));
            }
            if (authorizedFilter == null) {
                QFilter[] qFilterArray2 = new QFilter[1];
                qFilterArray = qFilterArray2;
                qFilterArray2[0] = enableFilter;
            } else {
                QFilter[] qFilterArray3 = new QFilter[2];
                qFilterArray3[0] = enableFilter;
                qFilterArray = qFilterArray3;
                qFilterArray3[1] = authorizedFilter;
            }
            QFilter[] qfilers = qFilterArray;
            DynamicObject[] dynObjs = BusinessDataServiceHelper.load((String)formId, (String)String.join((CharSequence)",", "id", "number", "name", "ispreset"), (QFilter[])qfilers);
            if (CommonUtils.isNull((Object)dynObjs)) {
                return;
            }
            String defaultStandardId = this.getDefaultStandardId(dynObjs, formId);
            ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(dynObjs.length);
            for (DynamicObject dynObj : dynObjs) {
                ComboItem item = new ComboItem();
                item.setValue(dynObj.getString("id"));
                item.setCaption(new LocaleString(dynObj.getString("name")));
                comboItems.add(item);
            }
            ComboEdit comboEdit = (ComboEdit)this.getView().getControl(comboControlKey);
            comboEdit.setComboItems(comboItems);
            if (CommonUtils.isNull((Object)defaultStandardId)) {
                defaultStandardId = ((ComboItem)comboItems.get(0)).getValue();
            }
            this.getModel().setValue(comboControlKey, (Object)defaultStandardId);
        }
    }

    private String getDefaultStandardId(DynamicObject[] dynObjs, String formId) {
        IPageCache pageCache;
        String standard;
        IFormView parentView;
        String defaultStandardId = "";
        for (DynamicObject dynObj : dynObjs) {
            if (!dynObj.getBoolean("ispreset")) continue;
            defaultStandardId = dynObj.getString("id");
            break;
        }
        if ("bd_goodsclassstandard".equals(formId) && (parentView = this.getView().getViewNoPlugin(this.getView().getFormShowParameter().getParentPageId())) != null && StringUtils.isNotBlank((CharSequence)(standard = (pageCache = (IPageCache)parentView.getService(IPageCache.class)).get("standard")))) {
            defaultStandardId = standard;
        }
        return defaultStandardId;
    }

    private List<TreeNode> queryMateriallassByStandardId(long standardId, String parentId, boolean isCheckChildren) {
        ArrayList<TreeNode> nodeList = new ArrayList<TreeNode>(30);
        long orgId = RequestContext.get().getOrgId();
        if (orgId == 0L) {
            return nodeList;
        }
        String selectFields = String.join((CharSequence)",", "id", "longnumber", "parent", "name", "isleaf");
        QFilter filter = new QFilter("enable", "=", (Object)Boolean.TRUE);
        filter = filter.and(new QFilter("standard", "=", (Object)standardId));
        HashSet<Long> creatOrgIdSet = new HashSet<Long>(1);
        creatOrgIdSet.add(orgId);
        Set groupOrgIdSet = GroupStandardUtils.getGroupOrgId((String)"bd_material", creatOrgIdSet);
        filter = filter.and(new QFilter("createorg", "in", (Object)groupOrgIdSet));
        TreeNode rootNode = this.getRootNodeFromCache(CACHE_MATERIALCLASS_TREE_ROOTNODE);
        QFilter parentFilter = this.getMaterialClassParentFilter(rootNode, parentId, isCheckChildren);
        if (parentFilter != null) {
            filter = filter.and(parentFilter);
        }
        String sortFields = String.join((CharSequence)",", "level", "number", "longnumber");
        DynamicObjectCollection materialClassDynObjColl = QueryServiceHelper.query((String)"bd_materialgroup", (String)selectFields, (QFilter[])filter.toArray(), (String)sortFields);
        QFilter itemClassFilter = QFilter.join((String)"id", (String)String.join((CharSequence)".", "mdr_item_class", "materialclassid"));
        List materialClassIdList = QueryServiceHelper.queryPrimaryKeys((String)"bd_materialgroup", (QFilter[])itemClassFilter.toArray(), null, (int)-1);
        for (DynamicObject materialClassDynObj : materialClassDynObjColl) {
            String nodeId = materialClassDynObj.getString("id");
            String longNumber = materialClassDynObj.getString("longnumber");
            String curParentId = materialClassDynObj.getString("parent");
            String name = materialClassDynObj.getString("name");
            if (materialClassIdList.contains(materialClassDynObj.get("id"))) {
                name = String.format(ResManager.loadKDString((String)"%s(\u5df2\u6dfb\u52a0)", (String)"ItemClassViewFormPlugin_11", (String)"bd-gmc-formplugin", (Object[])new Object[0]), name);
                nodeId = nodeId + "_1";
            }
            if (materialClassIdList.contains(Long.parseLong(curParentId))) {
                curParentId = curParentId + "_1";
            }
            TreeNode node = new TreeNode(curParentId, nodeId, name);
            node.setLongNumber(longNumber);
            if (!materialClassDynObj.getBoolean("isleaf")) {
                node.setChildren(new ArrayList());
            }
            nodeList.add(node);
            if (rootNode == null || ClassTreeUtils.getNode((TreeNode)rootNode, (Object)nodeId) != null) continue;
            TreeNode parentNode = ClassTreeUtils.getNode((TreeNode)rootNode, (Object)curParentId);
            if (parentNode == null) {
                rootNode.addChild(node);
                continue;
            }
            parentNode.addChild(node);
        }
        if (rootNode != null) {
            this.updateRootNodeCache(CACHE_MATERIALCLASS_TREE_ROOTNODE, rootNode);
        }
        return nodeList;
    }

    private QFilter getMaterialClassParentFilter(TreeNode rootNode, String parentId, boolean isCheckChildren) {
        TreeNode curNode;
        String longnumber = "";
        if (isCheckChildren && rootNode != null && (curNode = ClassTreeUtils.getNode((TreeNode)rootNode, (Object)parentId)) != null) {
            longnumber = curNode.getLongNumber();
        }
        QFilter parentFilter = null;
        if (StringUtils.isBlank((CharSequence)longnumber)) {
            if (!isCheckChildren) {
                parentFilter = new QFilter("parent", "=", (Object)Long.parseLong(parentId.split("_")[0]));
            } else {
                this.getPageCache().put(CACHE_MATERIALCLASS_TREE_ROOTNODE_CHECKED, "");
            }
        } else {
            parentFilter = new QFilter("longnumber", "like", (Object)(longnumber + "!" + "%"));
        }
        return parentFilter;
    }

    private List<TreeNode> queryItemClassByStandardId(long standardId, long parentId) {
        QFilter filter = new QFilter("enable", "=", (Object)Boolean.TRUE);
        filter = filter.and(new QFilter("standard", "=", (Object)standardId));
        filter = filter.and(new QFilter("parent", "=", (Object)parentId));
        String selectFields = String.join((CharSequence)",", "id", "longnumber", "parent", "name", "isleaf");
        String sortFields = String.join((CharSequence)",", "level", "number", "longnumber");
        DynamicObjectCollection itemClassDynObjColl = QueryServiceHelper.query((String)"mdr_item_class", (String)selectFields, (QFilter[])filter.toArray(), (String)sortFields);
        int count = itemClassDynObjColl.size();
        TreeNode rootNode = this.getRootNodeFromCache(CACHE_ITEMCLASSVIEW_TREE_ROOTNODE);
        ArrayList<TreeNode> nodeList = new ArrayList<TreeNode>(count);
        for (DynamicObject itemClassDynObj : itemClassDynObjColl) {
            String nodeId = itemClassDynObj.getString("id");
            String curParentId = itemClassDynObj.getString("parent");
            String longNumber = itemClassDynObj.getString("longnumber");
            TreeNode node = new TreeNode(curParentId, nodeId, itemClassDynObj.getString("name"));
            node.setLongNumber(longNumber);
            if (!itemClassDynObj.getBoolean("isleaf")) {
                node.setChildren(new ArrayList());
            }
            nodeList.add(node);
            if (rootNode == null || ClassTreeUtils.getNode((TreeNode)rootNode, (Object)nodeId) != null) continue;
            TreeNode parentNode = ClassTreeUtils.getNode((TreeNode)rootNode, (Object)curParentId);
            if (parentNode == null) {
                rootNode.addChild(node);
                continue;
            }
            parentNode.addChild(node);
        }
        if (rootNode != null) {
            this.updateRootNodeCache(CACHE_ITEMCLASSVIEW_TREE_ROOTNODE, rootNode);
        }
        return nodeList;
    }

    private void materialClassTreeNodeCheck(TreeView treeView, String nodeId, boolean isCheckChildren, boolean isChecked) {
        if (!isCheckChildren) {
            return;
        }
        TreeNode rootNode = this.getRootNodeFromCache(CACHE_MATERIALCLASS_TREE_ROOTNODE);
        if (isChecked) {
            List<TreeNode> allChildren = this.getMaterialClassAllCheckNode(treeView, rootNode, nodeId);
            treeView.checkNodes(allChildren);
        } else {
            TreeNode nodeCache = ClassTreeUtils.getNode((TreeNode)rootNode, (Object)nodeId);
            if (nodeCache != null) {
                ArrayList<TreeNode> allChildren = new ArrayList<TreeNode>();
                this.findAllChildren(nodeCache, allChildren, null);
                ArrayList<String> nodes = new ArrayList<String>(allChildren.size() + 1);
                nodes.add(nodeId);
                for (TreeNode node : allChildren) {
                    nodes.add(node.getId());
                }
                treeView.uncheckNodes(nodes);
            }
        }
    }

    private List<TreeNode> getMaterialClassAllCheckNode(TreeView treeView, TreeNode rootNode, String nodeId) {
        boolean isOpened = false;
        TreeNode nodeCache = ClassTreeUtils.getNode((TreeNode)rootNode, (Object)nodeId);
        ArrayList<TreeNode> allChildren = new ArrayList<TreeNode>(30);
        if (nodeCache != null) {
            this.findAllChildren(nodeCache, allChildren, null);
            if (nodeCache.getIsOpened()) {
                if (StringUtils.isBlank((CharSequence)nodeCache.getParentid())) {
                    if (this.getPageCache().get(CACHE_MATERIALCLASS_TREE_ROOTNODE_CHECKED) != null) {
                        isOpened = true;
                    }
                } else {
                    isOpened = true;
                }
            } else {
                nodeCache.setIsOpened(true);
                this.updateRootNodeCache(CACHE_MATERIALCLASS_TREE_ROOTNODE, rootNode);
            }
        }
        if (!isOpened) {
            Object materialStandardId = this.getModel().getValue("materialclassstandard");
            boolean isCheckChildren = (Boolean)this.getModel().getValue("ismaterialclasschild");
            List<TreeNode> nodeList = this.queryMateriallassByStandardId(CommonUtils.stringToLong((Object)materialStandardId), nodeId, isCheckChildren);
            treeView.addNodes(nodeList);
            allChildren.addAll(nodeList);
        }
        return allChildren;
    }

    private void findAllChildren(TreeNode treeNode, List<TreeNode> allChildren, List<String> allDeleteNodeIds) {
        List children = treeNode.getChildren();
        if (CommonUtils.isNull((Object)children)) {
            return;
        }
        for (TreeNode node : children) {
            allChildren.add(node);
            if (allDeleteNodeIds != null) {
                allDeleteNodeIds.add(node.getId());
            }
            this.findAllChildren(node, allChildren, allDeleteNodeIds);
        }
    }

    private TreeNode getRootNodeFromCache(String rootNodeCacheKey) {
        String rootNodeCache = this.getPageCache().get(rootNodeCacheKey);
        TreeNode rootNode = null;
        if (StringUtils.isNotBlank((CharSequence)rootNodeCache)) {
            rootNode = (TreeNode)SerializationUtils.fromJsonString((String)rootNodeCache, TreeNode.class);
        }
        return rootNode;
    }

    private boolean isAddAble(boolean isAddByOrder) {
        TreeView materialClassTree = (TreeView)this.getControl("materialclasstree");
        Map focusMaterialClassNodeMap = materialClassTree.getTreeState().getFocusNode();
        ArrayList<String> materialClassNodeIdList = materialClassTree.getTreeState().getSelectedNodeId();
        ArrayList<Map<String, Object>> materialClassNodeMapList = new ArrayList<Map<String, Object>>();
        if (CommonUtils.isNull((Object)materialClassNodeIdList)) {
            if (focusMaterialClassNodeMap == null) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u4ece\u5de6\u6811\u9009\u62e9\u8981\u6dfb\u52a0\u7684\u7269\u6599\u5206\u7c7b\u3002", (String)"ItemClassViewFormPlugin_5", (String)"bd-gmc-formplugin", (Object[])new Object[0]));
                return false;
            }
            String nodeId = focusMaterialClassNodeMap.get("id").toString();
            materialClassNodeIdList = new ArrayList<String>(1);
            materialClassNodeIdList.add(nodeId);
            materialClassNodeMapList.add(focusMaterialClassNodeMap);
        } else {
            materialClassNodeMapList.addAll(materialClassTree.getTreeState().getSelectedNodes());
        }
        String itemClassRootNodeCache = this.getPageCache().get(CACHE_ITEMCLASSVIEW_TREE_ROOTNODE);
        boolean isHasRootNode = false;
        TreeNode itemClassRootNode = null;
        if (StringUtils.isNotEmpty((CharSequence)itemClassRootNodeCache)) {
            isHasRootNode = true;
            itemClassRootNode = (TreeNode)SerializationUtils.fromJsonString((String)itemClassRootNodeCache, TreeNode.class);
        }
        TreeView itemClassTree = (TreeView)this.getControl("itemclassviewtree");
        String itemClassNodeParentId = "";
        List itemClassNodeIdList = itemClassTree.getTreeState().getSelectedNodeId();
        if (CommonUtils.isNull((Object)itemClassNodeIdList)) {
            if (isHasRootNode) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u4ece\u53f3\u6811\u9009\u62e9\u4e00\u4e2a\u5546\u54c1\u5206\u7c7b\u4f5c\u4e3a\u4e0a\u7ea7\u3002", (String)"ItemClassViewFormPlugin_6", (String)"bd-gmc-formplugin", (Object[])new Object[0]));
                return false;
            }
        } else {
            int selectedCount = itemClassNodeIdList.size();
            if (selectedCount > 1) {
                this.getView().showTipNotification(MessageFormat.format(ResManager.loadKDString((String)"\u8bf7\u4ece\u53f3\u6811\u9009\u62e9\u4e00\u4e2a\u5546\u54c1\u5206\u7c7b\u4f5c\u4e3a\u4e0a\u7ea7\uff0c\u5f53\u524d\u5df2\u9009\u6570\u91cf\uff1a{0}", (String)"ItemClassViewFormPlugin_7", (String)"bd-gmc-formplugin", (Object[])new Object[0]), selectedCount));
                return false;
            }
            itemClassNodeParentId = (String)itemClassNodeIdList.get(0);
        }
        boolean isCanDelete = true;
        for (String nodeId : materialClassNodeIdList) {
            if (nodeId.split("_").length <= 1) continue;
            isCanDelete = false;
            break;
        }
        if (!isCanDelete) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u4ece\u5de6\u6811\u91cd\u65b0\u9009\u62e9\u8981\u6dfb\u52a0\u7684\u7269\u6599\u5206\u7c7b\uff0c\u5df2\u6dfb\u52a0\u8fc7\u7684\u7269\u6599\u5206\u7c7b\u4e0d\u80fd\u518d\u6dfb\u52a0\u3002", (String)"ItemClassViewFormPlugin_8", (String)"bd-gmc-formplugin", (Object[])new Object[0]));
            return false;
        }
        HashMap<String, String> leftTreeNodeParentMap = new HashMap<String, String>();
        this.replaceFirstNodeParent(itemClassRootNode, materialClassNodeMapList, leftTreeNodeParentMap, itemClassNodeParentId, isAddByOrder);
        this.updateAddNodeCache(materialClassNodeIdList, leftTreeNodeParentMap, itemClassNodeParentId);
        return true;
    }

    private void updateAddNodeCache(List<String> selectedList, Map<String, String> leftTreeNodeParentMap, String itemClassNodeParentId) {
        ArrayList<String> addNodeList = new ArrayList<String>(selectedList.size());
        for (String nodeId : selectedList) {
            String newParentId = leftTreeNodeParentMap.get(nodeId);
            if (newParentId.equals(nodeId)) {
                leftTreeNodeParentMap.remove(nodeId);
                continue;
            }
            addNodeList.add(nodeId);
        }
        ArrayList<String> addToViewNodeList = new ArrayList<String>();
        this.removeDeletedNodeFromCache(addNodeList, addToViewNodeList, leftTreeNodeParentMap);
        this.removeAddedNodeFromCache(addNodeList, leftTreeNodeParentMap);
        TreeView bizUnitTree = (TreeView)this.getControl("materialclasstree");
        if (!addNodeList.isEmpty()) {
            List selectedNodes = bizUnitTree.getTreeState().getSelectedNodes();
            HashMap curAddCacheMap = new HashMap(addNodeList.size());
            Object standardId = this.getModel().getValue("itemclassstandard");
            TreeNode rootNode = this.getRootNodeFromCache(CACHE_MATERIALCLASS_TREE_ROOTNODE);
            for (Map nodeMap : selectedNodes) {
                String nodeId = String.valueOf(nodeMap.get("id"));
                if (!addNodeList.contains(nodeId)) continue;
                String newParentId = leftTreeNodeParentMap.get(nodeId);
                HashMap<String, Object> dataMap = new HashMap<String, Object>();
                dataMap.put("parentid", newParentId);
                dataMap.put("text", String.valueOf(nodeMap.get("text")));
                dataMap.put("standard", standardId);
                TreeNode treeNode = ClassTreeUtils.getNode((TreeNode)rootNode, (Object)nodeId);
                if (treeNode != null) {
                    String[] longNumerStrs = treeNode.getLongNumber().split("!");
                    dataMap.put("number", longNumerStrs[longNumerStrs.length - 1]);
                }
                curAddCacheMap.put(nodeId, dataMap);
            }
            String addCache = this.getPageCache().get("_addNode_");
            Map addCacheMap = null;
            if (StringUtils.isNotBlank((CharSequence)addCache)) {
                addCacheMap = (Map)SerializationUtils.fromJsonString((String)addCache, Map.class);
            }
            if (addCacheMap == null) {
                addCacheMap = curAddCacheMap;
            } else {
                addCacheMap.putAll(curAddCacheMap);
            }
            this.getPageCache().put("_addNode_", SerializationUtils.toJsonString(addCacheMap));
        }
        addToViewNodeList.addAll(addNodeList);
        this.addNodeToViewTree(bizUnitTree, selectedList, leftTreeNodeParentMap, itemClassNodeParentId, addToViewNodeList);
    }

    private void addNodeToViewTree(TreeView bizUnitTree, List<String> selectedList, Map<String, String> leftTreeNodeParentMap, String bizViewParentId, List<String> addToViewNodeList) {
        TreeView bizViewTree = (TreeView)this.getControl("itemclassviewtree");
        String bizViewRootNodeCache = this.getPageCache().get(CACHE_ITEMCLASSVIEW_TREE_ROOTNODE);
        TreeNode bizViewRootNode = null;
        if (StringUtils.isNotBlank((CharSequence)bizViewRootNodeCache)) {
            bizViewRootNode = (TreeNode)SerializationUtils.fromJsonString((String)bizViewRootNodeCache, TreeNode.class);
        }
        if (!CommonUtils.isNull(addToViewNodeList)) {
            List selectedUnitNodes = bizUnitTree.getTreeState().getSelectedNodes();
            int count = selectedUnitNodes.size();
            HashMap<String, TreeNode> addedNodeMap = new HashMap<String, TreeNode>(count);
            ArrayList<String> deletedNodeIds = new ArrayList<String>(count);
            this.deleteOldTreeNode(bizViewTree, bizViewRootNode, leftTreeNodeParentMap, bizViewParentId, addedNodeMap, deletedNodeIds);
            this.addNodeToViewTree(bizViewTree, bizViewRootNode, leftTreeNodeParentMap, selectedUnitNodes, addedNodeMap, deletedNodeIds);
        }
        bizViewTree.expand(bizViewParentId);
        bizViewTree.focusNode(new TreeNode("", bizViewParentId, ""));
        bizUnitTree.uncheckNodes(selectedList);
        bizUnitTree.setMulti(true);
    }

    private void deleteOldTreeNode(TreeView bizViewTree, TreeNode bizViewRootNode, Map<String, String> leftTreeNodeParentMap, String bizViewParentId, Map<String, TreeNode> addedNodeMap, List<String> deletedNodeIds) {
        for (Map.Entry<String, String> entry : leftTreeNodeParentMap.entrySet()) {
            String oldParentId;
            String newParentId;
            String nodeId = entry.getKey();
            if (bizViewParentId.equals(nodeId)) continue;
            TreeNode node = ClassTreeUtils.getNode((TreeNode)bizViewRootNode, (Object)nodeId);
            addedNodeMap.put(nodeId, node);
            if (node != null && (newParentId = entry.getValue()).equals(oldParentId = node.getParentid())) continue;
            deletedNodeIds.add(nodeId);
        }
        bizViewTree.deleteNodes(deletedNodeIds);
    }

    private void addNodeToViewTree(TreeView bizViewTree, TreeNode bizViewRootNode, Map<String, String> leftTreeNodeParentMap, List<Map<String, Object>> selectedUnitNodes, Map<String, TreeNode> addedNodeMap, List<String> deletedNodeIds) {
        boolean isDataChanged = false;
        int addCount = selectedUnitNodes.size();
        HashMap<String, TreeNode> newNodeMap = new HashMap<String, TreeNode>(addCount);
        for (Map<String, Object> nodeMap : selectedUnitNodes) {
            String nodeId = String.valueOf(nodeMap.get("id"));
            if (!deletedNodeIds.contains(nodeId)) continue;
            String name = String.valueOf(nodeMap.get("text"));
            TreeNode node = addedNodeMap.get(nodeId);
            String newParentId = leftTreeNodeParentMap.get(nodeId);
            if (node == null) {
                node = new TreeNode(newParentId, nodeId, name);
            } else {
                TreeNode oldParentNode;
                String oldParentId = node.getParentid();
                if (bizViewRootNode != null) {
                    bizViewRootNode.deleteChildNode(node.getId());
                }
                if ((oldParentNode = ClassTreeUtils.getNode((TreeNode)bizViewRootNode, (Object)oldParentId)) != null && CommonUtils.isNull((Object)oldParentNode.getChildren())) {
                    oldParentNode.setChildren(null);
                    bizViewTree.updateNode(oldParentNode);
                }
                node.setParentid(newParentId);
            }
            node.setIsOpened(false);
            newNodeMap.put(nodeId, node);
            TreeNode bizViewParentNode = (TreeNode)newNodeMap.get(newParentId);
            if (bizViewParentNode == null) {
                bizViewParentNode = ClassTreeUtils.getNode((TreeNode)bizViewRootNode, (Object)newParentId);
            }
            if (bizViewRootNode == null) {
                bizViewRootNode = node;
            } else if (bizViewParentNode == null) {
                bizViewRootNode.addChild(node);
            } else {
                bizViewParentNode.addChild(node);
            }
            bizViewTree.addNode(node);
            isDataChanged = true;
        }
        if (isDataChanged) {
            this.updateRootNodeCache(CACHE_ITEMCLASSVIEW_TREE_ROOTNODE, bizViewRootNode);
            this.getModel().setValue("isdatachangedflag", (Object)Boolean.TRUE);
        }
    }

    private void removeDeletedNodeFromCache(List<String> addNodeList, List<String> addToViewNodeList, Map<String, String> leftTreeNodeParentMap) {
        if (addNodeList.isEmpty()) {
            return;
        }
        String deleteCache = this.getPageCache().get("_deleteNode_");
        if (StringUtils.isBlank((CharSequence)deleteCache)) {
            return;
        }
        Map nodeMap = (Map)SerializationUtils.fromJsonString((String)deleteCache, Map.class);
        if (nodeMap == null || nodeMap.isEmpty()) {
            return;
        }
        HashMap<String, Map<String, Object>> curUpdateCacheMap = new HashMap<String, Map<String, Object>>(addNodeList.size());
        Iterator it = nodeMap.entrySet().iterator();
        while (!addNodeList.isEmpty() && it.hasNext()) {
            Map.Entry entry = it.next();
            String orgId = (String)entry.getKey();
            if (!addNodeList.contains(orgId)) continue;
            it.remove();
            addToViewNodeList.add(orgId);
            Map deletedNodeMap = (Map)entry.getValue();
            Object parentId = deletedNodeMap.get("parentid");
            String newParentId = leftTreeNodeParentMap.get(orgId);
            if (newParentId.equals(parentId)) {
                addNodeList.remove(orgId);
                continue;
            }
            HashMap<String, String> dataMap = new HashMap<String, String>();
            dataMap.put("parentid", newParentId);
            dataMap.put("text", (String)deletedNodeMap.get("text"));
            curUpdateCacheMap.put(orgId, dataMap);
        }
        this.getPageCache().put("_deleteNode_", SerializationUtils.toJsonString((Object)nodeMap));
        this.addNodeToUpdateCache(curUpdateCacheMap);
    }

    private void addNodeToUpdateCache(Map<String, Map<String, Object>> curUpdateCacheMap) {
        if (curUpdateCacheMap.isEmpty()) {
            return;
        }
        String updateCache = this.getPageCache().get("_updateNode_");
        HashMap<String, Map<String, Object>> updateCacheMap = null;
        if (StringUtils.isNotBlank((CharSequence)updateCache)) {
            updateCacheMap = (HashMap<String, Map<String, Object>>)SerializationUtils.fromJsonString((String)updateCache, Map.class);
        }
        if (updateCacheMap == null) {
            updateCacheMap = new HashMap<String, Map<String, Object>>();
        }
        updateCacheMap.putAll(curUpdateCacheMap);
        this.getPageCache().put("_updateNode_", SerializationUtils.toJsonString(updateCacheMap));
    }

    private void replaceFirstNodeParent(TreeNode rootNode, List<Map<String, Object>> selectedMapList, Map<String, String> leftTreeNodeParentMap, String bizViewParentId, boolean isAddByOrder) {
        HashSet<String> firstLevelNodeIds = new HashSet<String>(20);
        HashSet<String> firstLevelParentIds = new HashSet<String>(20);
        String parentId = bizViewParentId;
        String nodeId = null;
        for (Map<String, Object> map : selectedMapList) {
            nodeId = map.get("id").toString();
            if (isAddByOrder) {
                parentId = map.get("parentid").toString();
                firstLevelNodeIds.add(nodeId);
                firstLevelParentIds.add(parentId);
            }
            leftTreeNodeParentMap.put(nodeId, parentId);
        }
        firstLevelParentIds.removeAll(firstLevelNodeIds);
        if (firstLevelParentIds.isEmpty()) {
            return;
        }
        for (Map.Entry entry : leftTreeNodeParentMap.entrySet()) {
            if (!firstLevelParentIds.contains(entry.getValue())) continue;
            entry.setValue(bizViewParentId);
        }
    }

    private void removeAddedNodeFromCache(List<String> addNodeList, Map<String, String> leftTreeNodeParentMap) {
        if (addNodeList.isEmpty()) {
            return;
        }
        String addCache = this.getPageCache().get("_addNode_");
        if (StringUtils.isBlank((CharSequence)addCache)) {
            return;
        }
        Map addCacheMap = (Map)SerializationUtils.fromJsonString((String)addCache, Map.class);
        if (addCacheMap == null || addCacheMap.isEmpty()) {
            return;
        }
        for (Map.Entry entry : addCacheMap.entrySet()) {
            String orgId = (String)entry.getKey();
            String newParentId = leftTreeNodeParentMap.get(orgId);
            if (!addNodeList.contains(orgId) || !newParentId.equals(((Map)entry.getValue()).get("parentid"))) continue;
            addNodeList.remove(orgId);
        }
    }

    private boolean isDeleteAble() {
        TreeView bizViewTree = (TreeView)this.getControl("itemclassviewtree");
        List selectedNodes = bizViewTree.getTreeState().getSelectedNodes();
        if (CommonUtils.isNull((Object)selectedNodes)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u4ece\u53f3\u6811\u9009\u62e9\u9700\u8981\u79fb\u9664\u7684\u5546\u54c1\u5206\u7c7b\u3002", (String)"ItemClassViewFormPlugin_9", (String)"bd-gmc-formplugin", (Object[])new Object[0]));
            return false;
        }
        TreeNode rootNode = this.getRootNodeFromCache(CACHE_ITEMCLASSVIEW_TREE_ROOTNODE);
        if (rootNode == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u4ece\u53f3\u6811\u9009\u62e9\u9700\u8981\u79fb\u9664\u7684\u5546\u54c1\u5206\u7c7b\u3002", (String)"ItemClassViewFormPlugin_9", (String)"bd-gmc-formplugin", (Object[])new Object[0]));
            return false;
        }
        List<TreeNode> allChildren = this.getMaterialClassAllCheckNode((TreeView)this.getControl("materialclasstree"), this.getRootNodeFromCache(CACHE_MATERIALCLASS_TREE_ROOTNODE), "0");
        List materialClassIdList = allChildren.stream().map(TreeNode::getId).collect(Collectors.toList());
        int count = selectedNodes.size();
        ArrayList<TreeNode> allDeleteNodeList = new ArrayList<TreeNode>(count);
        String rootId = rootNode.getId();
        boolean isDeleteRootNode = false;
        ArrayList<String> allDeleteNodeIds = new ArrayList<String>(count);
        boolean isCanDelete = true;
        for (Map nodeMap : selectedNodes) {
            String nodeId = String.valueOf(nodeMap.get("id"));
            if (!materialClassIdList.contains(nodeId)) {
                isCanDelete = false;
                break;
            }
            if (rootId.equals(nodeId)) {
                isDeleteRootNode = true;
            }
            TreeNode treeNode = ClassTreeUtils.getNode((TreeNode)rootNode, (Object)nodeId);
            allDeleteNodeIds.add(nodeId);
            if (treeNode == null) continue;
            allDeleteNodeList.add(treeNode);
            this.findAllChildren(treeNode, allDeleteNodeList, allDeleteNodeIds);
        }
        if (!isCanDelete) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u4ece\u53f3\u6811\u9009\u62e9\u65b0\u6dfb\u52a0\u7684\u5546\u54c1\u5206\u7c7b\uff0c\u5df2\u7ecf\u5b58\u5728\u7684\u5546\u54c1\u5206\u7c7b\u4e0d\u80fd\u79fb\u9664\u3002", (String)"ItemClassViewFormPlugin_10", (String)"bd-gmc-formplugin", (Object[])new Object[0]));
            return false;
        }
        this.updateCacheWhenDeleteNode(selectedNodes, rootNode, allDeleteNodeList, isDeleteRootNode);
        return true;
    }

    private void updateCacheWhenDeleteNode(List<Map<String, Object>> selectedNodes, TreeNode itemClassRootNode, List<TreeNode> allDeleteNodeList, boolean isDeleteRootNode) {
        this.deleteNodeFromAddCache(itemClassRootNode, allDeleteNodeList);
        this.deleteNodeFromUpdateCache(itemClassRootNode, allDeleteNodeList);
        if (!allDeleteNodeList.isEmpty()) {
            int delCount = allDeleteNodeList.size();
            HashMap curDeleteCacheMap = new HashMap(delCount);
            ArrayList<TreeNode> updateParentNodes = new ArrayList<TreeNode>(delCount);
            for (TreeNode node : allDeleteNodeList) {
                String parentId = node.getParentid();
                String nodeId = node.getId();
                HashMap<String, String> nodeMap = new HashMap<String, String>();
                nodeMap.put("id", nodeId);
                nodeMap.put("parentid", parentId);
                nodeMap.put("text", node.getText());
                nodeMap.put("longnumber", node.getLongNumber());
                curDeleteCacheMap.put(nodeId, nodeMap);
                itemClassRootNode.deleteChildNode(nodeId);
                TreeNode parentNode = ClassTreeUtils.getNode((TreeNode)itemClassRootNode, (Object)node.getParentid());
                if (parentNode == null || !CommonUtils.isNull((Object)parentNode.getChildren())) continue;
                parentNode.setChildren(null);
                updateParentNodes.add(parentNode);
            }
            String deleteCache = this.getPageCache().get("_deleteNode_");
            Map deleteCacheMap = null;
            if (StringUtils.isNotBlank((CharSequence)deleteCache)) {
                deleteCacheMap = (Map)SerializationUtils.fromJsonString((String)deleteCache, Map.class);
            }
            if (deleteCacheMap == null) {
                deleteCacheMap = curDeleteCacheMap;
            } else {
                deleteCacheMap.putAll(curDeleteCacheMap);
            }
            this.getPageCache().put("_deleteNode_", SerializationUtils.toJsonString(deleteCacheMap));
            if (!updateParentNodes.isEmpty()) {
                TreeView bizViewTree = (TreeView)this.getControl("itemclassviewtree");
                bizViewTree.updateNodes(updateParentNodes);
            }
        }
        this.deleteNodeFromViewTree(itemClassRootNode, isDeleteRootNode);
    }

    private void deleteNodeFromViewTree(TreeNode itemClassRootNode, boolean isDeleteRootNode) {
        TreeView bizViewTree = (TreeView)this.getControl("itemclassviewtree");
        if (isDeleteRootNode) {
            bizViewTree.deleteAllNodes();
            itemClassRootNode = null;
        } else {
            List bizViewParentIds = bizViewTree.getTreeState().getSelectedNodeId();
            for (String nodeId : bizViewParentIds) {
                if (itemClassRootNode != null) {
                    itemClassRootNode.deleteChildNode(nodeId);
                }
                bizViewTree.deleteNode(nodeId);
            }
        }
        this.updateRootNodeCache(CACHE_ITEMCLASSVIEW_TREE_ROOTNODE, itemClassRootNode);
        this.getModel().setValue("isdatachangedflag", (Object)Boolean.TRUE);
        this.changeBizUnitTreeMulti(this.getRootNodeFromCache(CACHE_ITEMCLASSVIEW_TREE_ROOTNODE) != null);
    }

    private void deleteNodeFromAddCache(TreeNode rootNode, List<TreeNode> allDeleteNodeList) {
        String addCache = this.getPageCache().get("_addNode_");
        if (StringUtils.isBlank((CharSequence)addCache)) {
            return;
        }
        Map addCacheMap = (Map)SerializationUtils.fromJsonString((String)addCache, Map.class);
        if (addCacheMap == null || addCacheMap.isEmpty()) {
            return;
        }
        int count = allDeleteNodeList.size();
        ArrayList<TreeNode> cacheNodeList = new ArrayList<TreeNode>(count);
        ArrayList<TreeNode> updateParentNodes = new ArrayList<TreeNode>(count);
        this.getDeleteNodeFromCache(rootNode, allDeleteNodeList, addCacheMap, cacheNodeList, updateParentNodes);
        if (!updateParentNodes.isEmpty()) {
            TreeView bizViewTree = (TreeView)this.getControl("itemclassviewtree");
            bizViewTree.updateNodes(updateParentNodes);
        }
        if (cacheNodeList.isEmpty()) {
            return;
        }
        allDeleteNodeList.removeAll(cacheNodeList);
        if (addCacheMap == null || addCacheMap.isEmpty()) {
            this.getPageCache().remove("_addNode_");
        } else {
            this.getPageCache().put("_addNode_", SerializationUtils.toJsonString((Object)addCacheMap));
        }
    }

    private void changeBizUnitTreeMulti(boolean isMulti) {
        TreeView bizUnitTree = (TreeView)this.getControl("materialclasstree");
        bizUnitTree.setMulti(isMulti);
        if (isMulti) {
            bizUnitTree.uncheckNodes(bizUnitTree.getTreeState().getSelectedNodeId());
        } else {
            TreeNode rootNode = this.getRootNodeFromCache(CACHE_MATERIALCLASS_TREE_ROOTNODE);
            if (rootNode != null) {
                bizUnitTree.focusNode(new TreeNode(rootNode.getParentid(), rootNode.getId(), rootNode.getText()));
            }
        }
    }

    private void deleteNodeFromUpdateCache(TreeNode rootNode, List<TreeNode> allDeleteNodeList) {
        if (allDeleteNodeList.isEmpty()) {
            return;
        }
        String updateCache = this.getPageCache().get("_updateNode_");
        if (StringUtils.isBlank((CharSequence)updateCache)) {
            return;
        }
        Map updateCacheMap = (Map)SerializationUtils.fromJsonString((String)updateCache, Map.class);
        if (updateCacheMap == null || updateCacheMap.isEmpty()) {
            return;
        }
        int count = allDeleteNodeList.size();
        ArrayList<TreeNode> cacheNodeList = new ArrayList<TreeNode>(count);
        ArrayList<TreeNode> updateParentNodes = new ArrayList<TreeNode>(count);
        this.getDeleteNodeFromCache(rootNode, allDeleteNodeList, updateCacheMap, cacheNodeList, updateParentNodes);
        if (!updateParentNodes.isEmpty()) {
            TreeView bizViewTree = (TreeView)this.getControl("itemclassviewtree");
            bizViewTree.updateNodes(updateParentNodes);
        }
        if (cacheNodeList.isEmpty()) {
            return;
        }
        allDeleteNodeList.removeAll(cacheNodeList);
        if (updateCacheMap == null || updateCacheMap.isEmpty()) {
            this.getPageCache().remove("_updateNode_");
        } else {
            this.getPageCache().put("_updateNode_", SerializationUtils.toJsonString((Object)updateCacheMap));
        }
    }

    private void getDeleteNodeFromCache(TreeNode rootNode, List<TreeNode> allDeleteNodeList, Map<String, Map<String, Object>> cacheMap, List<TreeNode> cacheNodeList, List<TreeNode> updateParentNodes) {
        for (TreeNode node : allDeleteNodeList) {
            String nodeId = node.getId();
            if (!cacheMap.containsKey(nodeId)) continue;
            cacheMap.remove(nodeId);
            cacheNodeList.add(node);
            rootNode.deleteChildNode(nodeId);
            TreeNode parentNode = ClassTreeUtils.getNode((TreeNode)rootNode, (Object)node.getParentid());
            if (parentNode == null || !CommonUtils.isNull((Object)parentNode.getChildren())) continue;
            parentNode.setChildren(null);
            updateParentNodes.add(parentNode);
        }
    }

    private String sortItemClassByTreeNodeLevel(String nodeCache) {
        List orgIds;
        int level;
        Map<String, Map<String, Object>> nodeMap = this.convertNodeCacheMap(nodeCache);
        if (nodeMap == null) {
            return "";
        }
        TreeNode rootNode = this.getRootNodeFromCache(CACHE_ITEMCLASSVIEW_TREE_ROOTNODE);
        if (rootNode == null) {
            return "";
        }
        TreeMap levelMap = new TreeMap();
        for (Map.Entry<String, Map<String, Object>> nodeEntry : nodeMap.entrySet()) {
            String orgId = nodeEntry.getKey();
            level = rootNode.getNodeLevel(orgId, 1);
            orgIds = (ArrayList<String>)levelMap.get(level);
            if (orgIds == null) {
                orgIds = new ArrayList<String>();
                levelMap.put(level, orgIds);
            }
            orgIds.add(orgId);
        }
        ArrayList<Map<String, Object>> sortedNodeList = new ArrayList<Map<String, Object>>(nodeMap.size());
        for (Map.Entry levelEntry : levelMap.entrySet()) {
            level = (Integer)levelEntry.getKey();
            orgIds = (List)levelEntry.getValue();
            for (String orgId : orgIds) {
                Map<String, Object> orgMap = nodeMap.get(orgId);
                orgMap.put("id", orgId);
                orgMap.put("level", level);
                sortedNodeList.add(orgMap);
            }
        }
        return SerializationUtils.toJsonString(sortedNodeList);
    }

    private Map<String, Map<String, Object>> convertNodeCacheMap(String nodeCache) {
        if (StringUtils.isBlank((CharSequence)nodeCache)) {
            return null;
        }
        Map nodeMap = (Map)SerializationUtils.fromJsonString((String)nodeCache, Map.class);
        if (CollectionUtils.isEmpty((Map)nodeMap)) {
            return null;
        }
        return nodeMap;
    }
}

