/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.sbd.utils;

import java.util.ArrayList;
import java.util.Arrays;
import kd.bd.sbd.utils.StringUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class GroupSynPurStateUtil {
    private static Log log = LogFactory.getLog(GroupSynPurStateUtil.class);
    private static final String PUR_BIZPERSONGROUP = "pur_bizperson";

    public static void synPurGroupStateFilter(DynamicObject[] grpList, String operNumber, String enable) {
        if (null == grpList || grpList.length < 1 || StringUtils.isBlank(enable)) {
            return;
        }
        ArrayList<Long> groups = new ArrayList<Long>(grpList.length);
        ArrayList<String> operS = new ArrayList<String>(1024);
        for (DynamicObject grp : grpList) {
            DynamicObjectCollection operLists;
            Object operList = grp.get("entryentity");
            if (null == operList || null == (operLists = grp.getDynamicObjectCollection("entryentity")) || operLists.size() <= 0) continue;
            groups.add(Long.parseLong(grp.getPkValue().toString()));
            operLists.forEach(o -> {
                if (!o.getBoolean("invalid")) {
                    operS.add(o.getDynamicObject("operator").getString("number"));
                }
            });
        }
        GroupSynPurStateUtil.synPurGroupStateBatch(groups, operS, enable);
    }

    public static void synPurGroupState(ArrayList<Long> groups, String operNumber, String enable) {
        ArrayList<String> operList = new ArrayList<String>();
        if (!StringUtils.isEmpty(operNumber)) {
            operList.add(operNumber);
        }
        GroupSynPurStateUtil.synPurGroupStateBatch(groups, operList, enable);
    }

    public static void synPurGroupStateBatch(ArrayList<Long> groups, ArrayList<String> operList, String enable) {
        DynamicObject[] entityObjects;
        if (null == groups || groups.size() < 1 || StringUtils.isBlank(enable)) {
            return;
        }
        QFilter groupFilter = new QFilter("group", "in", groups);
        groupFilter.and(new QFilter("enable", "!=", (Object)enable));
        if (null != operList && operList.size() > 0) {
            groupFilter.and(new QFilter("number", "in", operList));
        }
        if (null == (entityObjects = BusinessDataServiceHelper.load((String)PUR_BIZPERSONGROUP, (String)"id,enable", (QFilter[])new QFilter[]{groupFilter}))) {
            return;
        }
        for (int i = 0; i < entityObjects.length; ++i) {
            DynamicObject object = entityObjects[i];
            object.set("enable", (Object)enable);
        }
        Object[] operatorObjs = SaveServiceHelper.save((DynamicObject[])entityObjects);
        log.info("syn opertor success:" + Arrays.toString(operatorObjs));
    }
}

