/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.sbd.opplugin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.bec.api.IEventServicePlugin;
import kd.bos.bec.model.EntityEvent;
import kd.bos.bec.model.KDBizEvent;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class TrackNumberAutoGenOp
implements IEventServicePlugin {
    private static final String BILLS = "bills";
    private static final String BILL_NUMBER = "billNumber";
    private static final String BILL_TYPE = "billType";
    private static final String ENTITYNAME = "entityName";
    private static final String ENTRYNAME = "entryName";
    private static final String RULE = "rule";
    private static final String COL_MATERIAL = "materialColName";
    private static final String COL_SEQ = "seqColName";
    private static final String COL_ORG = "storageorg";
    private static final String COL_TRACKNUMBER = "tracknumberColName";
    private Map<String, Object> params;
    private DynamicObject rule;
    private DynamicObject manuStrConfig;

    public Object handleEvent(KDBizEvent evt) {
        Map sns;
        EntityEvent e = (EntityEvent)evt;
        Set delTrackNumbers = new HashSet(16);
        if (this.params == null) {
            this.rule = this.getRule();
            this.manuStrConfig = this.getManuStrConfig(e.getEntityNumber());
        }
        if (this.rule == null || this.manuStrConfig == null) {
            return null;
        }
        this.params = this.getBillParams(this.manuStrConfig, this.rule, e.getEntityNumber());
        if (this.params == null) {
            return null;
        }
        if (e.getBusinesskeys() == null || e.getBusinesskeys().isEmpty()) {
            return null;
        }
        HashSet<Long> bks = new HashSet<Long>(16);
        for (int i = 0; i < e.getBusinesskeys().size(); ++i) {
            bks.add(Long.parseLong((String)e.getBusinesskeys().get(i)));
        }
        DynamicObject[] bills = BusinessDataServiceHelper.load((Object[])bks.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)e.getEntityNumber()));
        if (bills == null || bills.length < 1) {
            return null;
        }
        if (this.params.get(BILL_TYPE) == null) {
            this.params.put(BILL_TYPE, this.getBillType(bills[0], e.getEntityNumber()));
        }
        if (this.params != null) {
            this.params.put(BILLS, bills);
        }
        if ((sns = (Map)DispatchServiceHelper.invokeBizService((String)"bd", (String)"sbd", (String)"TrackNumberService", (String)"autoGenerateTrackNumber", (Object[])new Object[]{this.params})) == null || sns.size() == 0) {
            return null;
        }
        if (sns.get("ERROR") != null) {
            throw new KDBizException(sns.get("ERROR") == null ? "" : sns.get("ERROR").toString());
        }
        delTrackNumbers.clear();
        delTrackNumbers = (Set)sns.get("DELTRACKNUMBER");
        ArrayList<DynamicObject> updateTrackNumbers = new ArrayList<DynamicObject>(16);
        String[] trackCols = this.params.get(COL_TRACKNUMBER).toString().split("\\.");
        for (int i = 0; i < bills.length; ++i) {
            DynamicObject dataEntity = bills[i];
            if (dataEntity == null) continue;
            if (trackCols.length == 1) {
                if (sns.get(dataEntity.getPkValue().toString()) == null) continue;
                dataEntity.set(trackCols[0], sns.get(dataEntity.getPkValue().toString()));
                updateTrackNumbers.add(dataEntity);
                continue;
            }
            DynamicObjectCollection billEntry = dataEntity.getDynamicObjectCollection(this.params.get(ENTRYNAME).toString());
            if (billEntry == null) continue;
            for (DynamicObject dynamicObject : billEntry) {
                if (sns.get(dynamicObject.getPkValue().toString()) == null) continue;
                dynamicObject.set(trackCols[1], sns.get(dynamicObject.getPkValue().toString()));
                updateTrackNumbers.add(dynamicObject);
            }
        }
        DynamicObject[] objs = new DynamicObject[updateTrackNumbers.size()];
        SaveServiceHelper.update((DynamicObject[])updateTrackNumbers.toArray(objs));
        if (delTrackNumbers != null && delTrackNumbers.size() > 0) {
            ArrayList billEntrys = new ArrayList(delTrackNumbers);
            DispatchServiceHelper.invokeBizService((String)"bd", (String)"sbd", (String)"TrackNumberService", (String)"deleteTrackNumber", (Object[])new Object[]{billEntrys});
        }
        return "OK";
    }

    private Map<String, Object> getBillParams(DynamicObject manuStrConfig, DynamicObject rule, String entityName) {
        String entryName = "";
        String materialColName = "";
        String tracknumberColName = "";
        String billNumber = "billno";
        String seqColName = "seq";
        String storageOrgColName = "";
        MainEntityType billEntityType = MetadataServiceHelper.getDataEntityType((String)entityName);
        Map propertyMap = billEntityType.getAllEntities();
        HashMap<String, Object> returnParams = new HashMap<String, Object>(16);
        if (manuStrConfig == null || rule == null) {
            return null;
        }
        DynamicObjectCollection entryEntitys = manuStrConfig.getDynamicObjectCollection("entryentity");
        if (entryEntitys == null) {
            return null;
        }
        DynamicObject subEntryForMine = null;
        for (DynamicObject subEntry : entryEntitys) {
            if (subEntry.get("billentity") == null || !((DynamicObject)subEntry.get("billentity")).get("number").equals(entityName)) continue;
            subEntryForMine = subEntry;
        }
        if (subEntryForMine == null) {
            return null;
        }
        DynamicObjectCollection subentryEntitys = subEntryForMine.getDynamicObjectCollection("subentryentity");
        if (subentryEntitys == null) {
            return null;
        }
        for (DynamicObject subEntry : subentryEntitys) {
            if ((DynamicObject)subEntry.get("dimension") == null) continue;
            String dimension = ((DynamicObject)subEntry.get("dimension")).get("number").toString();
            String[] fields = null;
            if (subEntry.get("field") == null) continue;
            fields = subEntry.get("field").toString().split("\\.");
            boolean isEntryField = this.isEntryField(propertyMap, fields);
            if (dimension.equals("GZ001")) {
                if (isEntryField) {
                    tracknumberColName = fields[0] + '.' + fields[1];
                    entryName = fields[0];
                    continue;
                }
                tracknumberColName = fields[0];
                continue;
            }
            if (dimension.equals("GZ002") || dimension.equals("GZ003")) continue;
            if (dimension.equals("GZ004")) {
                if (isEntryField) {
                    storageOrgColName = fields[0] + '.' + fields[1];
                    continue;
                }
                storageOrgColName = fields[0];
                continue;
            }
            if (!dimension.equals("GZ005")) continue;
            if (isEntryField) {
                materialColName = fields[0] + '.' + fields[1];
                continue;
            }
            materialColName = fields[0];
        }
        if (StringUtils.isBlank((CharSequence)materialColName) || StringUtils.isBlank((CharSequence)tracknumberColName) || StringUtils.isBlank((CharSequence)storageOrgColName)) {
            return null;
        }
        returnParams.put(ENTITYNAME, entityName);
        returnParams.put(ENTRYNAME, entryName);
        returnParams.put(COL_SEQ, seqColName);
        returnParams.put(COL_MATERIAL, materialColName);
        returnParams.put(COL_TRACKNUMBER, tracknumberColName);
        returnParams.put(BILL_NUMBER, billNumber);
        returnParams.put(COL_ORG, storageOrgColName);
        returnParams.put(RULE, rule);
        return returnParams;
    }

    private boolean isEntryField(Map<String, EntityType> propertyMap, String[] fields) {
        if (fields.length > 1) {
            EntityType property = propertyMap.get(fields[0]);
            return property instanceof EntryType;
        }
        return false;
    }

    private DynamicObject getManuStrConfig(String entityName) {
        QFilter qFilter2 = new QFilter("entryentity.billentity", "=", (Object)entityName);
        QFilter qFilter3 = new QFilter("enable", "=", (Object)"1");
        QFilter qFilter4 = new QFilter("status", "=", (Object)"C");
        Map manustrconfig = BusinessDataServiceHelper.loadFromCache((String)"bd_manustrconfig", (QFilter[])new QFilter[]{qFilter2, qFilter3, qFilter4});
        DynamicObject mscEntry = null;
        if (manustrconfig == null || manustrconfig.size() < 1) {
            return null;
        }
        for (Object value : manustrconfig.values()) {
            mscEntry = (DynamicObject)value;
        }
        return mscEntry;
    }

    private DynamicObject getRule() {
        QFilter qFilter3;
        DynamicObject rule = null;
        QFilter qFilter2 = new QFilter("useintracknumber", "=", (Object)Character.valueOf('1'));
        Map mapRule = BusinessDataServiceHelper.loadFromCache((String)"bd_lotcoderule", (QFilter[])new QFilter[]{qFilter2, qFilter3 = new QFilter("enable", "=", (Object)Character.valueOf('1'))});
        if (mapRule == null || mapRule.size() < 1) {
            return null;
        }
        for (Object value : mapRule.values()) {
            rule = (DynamicObject)value;
        }
        return rule;
    }

    private DynamicObject getBillType(DynamicObject bill, String entityName) {
        DynamicObject billType = null;
        if (bill != null) {
            MainEntityType appBillMainType = MetadataServiceHelper.getDataEntityType((String)entityName);
            DataEntityPropertyCollection entityPro = appBillMainType.getProperties();
            for (IDataEntityProperty en : entityPro) {
                if (!(en instanceof BasedataProp) || !"bos_billtype".equals(((BasedataProp)en).getBaseEntityId())) continue;
                billType = bill.get(en.getName()) == null ? null : (DynamicObject)bill.get(en.getName());
                break;
            }
        }
        if (billType == null) {
            QFilter qFilter = new QFilter("billformid.id", "=", (Object)entityName);
            billType = BusinessDataServiceHelper.loadSingle((String)"bos_billtype", (String)"id,number", (QFilter[])new QFilter[]{qFilter});
        }
        return billType;
    }
}

