/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.sbd.opplugin.pdm.mftbom;

import java.util.HashSet;
import java.util.Set;
import kd.bd.sbd.utils.BOMVersionUtil;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class BOMSetVersionValueValidator
extends AbstractValidator {
    private static final Log log = LogFactory.getLog(BOMSetVersionValueValidator.class);

    public void validate() {
        String operate = this.getOperateKey();
        ExtendedDataEntity[] objs = this.getDataEntities();
        if (objs == null || objs.length <= 0) {
            return;
        }
        if ("submit".equalsIgnoreCase(operate)) {
            HashSet<Long> unVersionIdSet = new HashSet<Long>(16);
            for (ExtendedDataEntity obj : objs) {
                try {
                    this.createBomVersion(obj.getDataEntity(), unVersionIdSet);
                }
                catch (Exception e) {
                    log.error((Throwable)e);
                    this.addErrorMessage(obj, e.getMessage());
                }
            }
        }
    }

    public boolean isEcoBom(DynamicObject bom) {
        return "pdm_ecobom".equals(bom.getDataEntityType().getName());
    }

    private boolean isVersionType(DynamicObject type) {
        String isVersionField = "isversion";
        if (!type.containsProperty(isVersionField)) {
            type = BusinessDataServiceHelper.loadSingleFromCache((Object)type.getPkValue(), (String)type.getDataEntityType().getName(), (String)isVersionField);
        }
        return type.getBoolean(isVersionField);
    }

    private DynamicObject getMateria(DynamicObject bom) {
        Object masterId;
        DynamicObject material = bom.getDynamicObject("material");
        if (material != null && (masterId = material.get("masterid")) instanceof DynamicObject) {
            return (DynamicObject)masterId;
        }
        return material;
    }

    public void createBomVersion(DynamicObject dataEntity, Set<Long> unVersionIdSet) {
        if (this.isEcoBom(dataEntity)) {
            return;
        }
        DynamicObject material = this.getMateria(dataEntity);
        if (material == null) {
            return;
        }
        DynamicObject type = dataEntity.getDynamicObject("type");
        DynamicObject version = dataEntity.getDynamicObject("version");
        if (version == null && material != null && (material.getBoolean("isenablematerialversion") || this.isVersionType(type))) {
            DynamicObject newVersion = BOMVersionUtil.createAndGetBomVersion((DynamicObject)dataEntity, (boolean)true, unVersionIdSet);
            dataEntity.set("version", (Object)newVersion);
            if (newVersion != null) {
                unVersionIdSet.add((Long)newVersion.getPkValue());
            }
        }
    }
}

