/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.sbd.validator;

import java.util.HashSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;

public class WarehouseSaveValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] dataEntities2;
        for (ExtendedDataEntity dataEntity : dataEntities2 = this.dataEntities) {
            this.checkLocation(dataEntity);
        }
    }

    private void checkLocation(ExtendedDataEntity wh) {
        DynamicObject dataEntity = wh.getDataEntity();
        boolean isOpenLocation = dataEntity.getBoolean("isopenlocation");
        DynamicObjectCollection rowInfos = dataEntity.getDynamicObjectCollection("entryentity");
        if (!isOpenLocation) {
            if (rowInfos != null && rowInfos.size() != 0) {
                this.addMessage(wh, ResManager.loadKDString((String)"\u672a\u542f\u7528\u4ed3\u4f4d, \u4ed3\u4f4d\u5206\u5f55\u4fe1\u606f\u5fc5\u987b\u4e3a\u7a7a\u3002", (String)"WarehouseSaveValidator_0", (String)"bd-sbd-opplugin", (Object[])new Object[0]));
            }
            return;
        }
        HashSet<String> pkSet = new HashSet<String>();
        if (rowInfos != null && rowInfos.size() != 0) {
            for (int i = 0; i < rowInfos.size(); ++i) {
                int seq = i + 1;
                DynamicObject rowInfo = (DynamicObject)rowInfos.get(i);
                DynamicObject location = (DynamicObject)rowInfo.get("location");
                if (location == null) continue;
                if (pkSet.contains(location.getPkValue().toString())) {
                    this.addMessage(wh, String.format(ResManager.loadKDString((String)"\u7b2c%1$s\u884c\u5206\u5f55\uff0c\u4ed3\u4f4d  %2$s \u91cd\u590d \u3002", (String)"WarehouseSaveValidator_1", (String)"bd-sbd-opplugin", (Object[])new Object[0]), seq, location.getString("name")));
                    continue;
                }
                pkSet.add(location.getPkValue().toString());
            }
        } else {
            this.addMessage(wh, ResManager.loadKDString((String)"\u542f\u7528\u4ed3\u4f4d, \u4ed3\u4f4d\u5206\u5f55\u4fe1\u606f\u5fc5\u5f55\u3002", (String)"WarehouseSaveValidator_4", (String)"bd-sbd-opplugin", (Object[])new Object[0]));
        }
    }
}

