/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.gmc.common.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kd.bd.gmc.common.pagemodel.ClassTreeSearchParam;
import kd.bd.gmc.common.util.CommonUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ITreeModel;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.TreeView;
import kd.bos.list.ITreeListView;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;

public class ClassTreeUtils {
    public static TreeNode getNode(Object nodeId, ITreeModel treeModel) {
        if (treeModel == null) {
            return null;
        }
        return ClassTreeUtils.getNode(treeModel.getRoot(), nodeId);
    }

    public static TreeNode getNode(TreeNode rootNode, Object nodeId) {
        if (rootNode == null || StringUtils.isBlank((Object)nodeId)) {
            return null;
        }
        return rootNode.getTreeNode(nodeId.toString(), 20);
    }

    public static void searchFromLazyOrgTree(ClassTreeSearchParam searchParam) {
        if (searchParam == null) {
            return;
        }
        String searchText = searchParam.getSearchText();
        if (StringUtils.isBlank((CharSequence)searchText)) {
            return;
        }
        IFormView formView = searchParam.getFormView();
        long standardId = searchParam.getStandardId();
        if (standardId == 0L) {
            formView.showTipNotification(ResManager.loadKDString((String)"\u5206\u7c7b\u6807\u51c6\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u4fee\u6539\u3002", (String)"ClassTreeUtils_0", (String)"bd-gmc-common", (Object[])new Object[0]));
            return;
        }
        ArrayList<TreeNode> treeNodes = new ArrayList(16);
        IPageCache pageCache = searchParam.getPageCache();
        String standardIdStr = pageCache.get("_oldSearchViewSchema");
        if (StringUtils.isNotEmpty((CharSequence)standardIdStr) && standardId != Long.parseLong(standardIdStr)) {
            ClassTreeUtils.removeAllSearchTreeNodeCache(pageCache);
        }
        pageCache.put("_oldSearchViewSchema", String.valueOf(standardId));
        String oldSearchTextCacheKey = "_oldSearchText";
        String oldSearchText = pageCache.get("_oldSearchText");
        pageCache.put("_oldSearchText", searchText);
        if (searchText.equals(oldSearchText)) {
            String searchNodesCache = pageCache.get("_searchNodes");
            if (StringUtils.isNotBlank((CharSequence)searchNodesCache)) {
                treeNodes = SerializationUtils.fromJsonStringToList((String)searchNodesCache, TreeNode.class);
            }
        } else {
            ClassTreeUtils.removeLoopSearchTreeNodeCache(pageCache);
            treeNodes = ClassTreeUtils.searchTreeNode(searchParam);
            if (ClassTreeUtils.finishSearch(searchParam, treeNodes, true)) {
                return;
            }
            pageCache.put("_resultTotalCacheKey", Integer.toString(treeNodes.size()));
        }
        if (CollectionUtils.isEmpty(treeNodes)) {
            ClassTreeUtils.finishSearch(searchParam, treeNodes, false);
        } else {
            ClassTreeUtils.searchFromLazyOrgTree(searchParam, treeNodes);
        }
    }

    private static void expandParentNode(ClassTreeSearchParam searchParam, String nodeId, List<String> loopController) {
        if (searchParam == null || StringUtils.isBlank((CharSequence)nodeId)) {
            return;
        }
        if (loopController == null || loopController.contains(nodeId)) {
            return;
        }
        TreeNode rootNode = searchParam.getRootNode();
        if (rootNode == null) {
            return;
        }
        loopController.add(nodeId);
        TreeNode treeNode = ClassTreeUtils.getNode(rootNode, nodeId);
        if (treeNode != null && !treeNode.isExpend()) {
            searchParam.getTreeView().expand(nodeId);
            treeNode.setExpend(true);
            ClassTreeUtils.expandParentNode(searchParam, treeNode.getParentid(), loopController);
        }
    }

    private static void searchFromLazyOrgTree(ClassTreeSearchParam searchParam, List<TreeNode> treeNodes) {
        IPageCache pageCache = searchParam.getPageCache();
        String resultTotal = pageCache.get("_resultTotalCacheKey");
        boolean firstTimeCheck = StringUtils.isNotBlank((CharSequence)resultTotal) && Integer.parseInt(resultTotal) == treeNodes.size();
        TreeView treeView = searchParam.getTreeView();
        treeView.uncheckNodes(treeView.getTreeState().getSelectedNodeId());
        TreeNode node = ClassTreeUtils.searchExistsNodeFromLazyOrgTree(searchParam, treeNodes);
        if (node == null) {
            ClassTreeUtils.finishSearch(searchParam, treeNodes, firstTimeCheck);
        } else {
            treeView.expand(searchParam.getRootNode().getId());
            if (searchParam.isClickNode()) {
                treeView.treeNodeClick(node.getParentid(), node.getId());
            }
            treeView.checkNode(node);
            ClassTreeUtils.focusNodeAfterSearch(searchParam, node);
            if (treeNodes != null && !treeNodes.isEmpty()) {
                treeNodes.remove(0);
            }
        }
        pageCache.put("_searchNodes", SerializationUtils.toJsonString(treeNodes));
    }

    private static void focusNodeAfterSearch(ClassTreeSearchParam searchParam, TreeNode node) {
        searchParam.getTreeView().focusNode(node);
        IFormView formView = searchParam.getFormView();
        if (formView instanceof ListView) {
            ITreeListView treeListView = ((ListView)formView).getTreeListView();
            treeListView.getTreeModel().setCurrentNodeId((Object)node.getId());
        }
    }

    private static boolean finishSearch(ClassTreeSearchParam searchParam, List<TreeNode> treeNodes, boolean noResult) {
        if (!CollectionUtils.isEmpty(treeNodes)) {
            return false;
        }
        searchParam.getPageCache().put("_searchNodes", "");
        searchParam.getPageCache().remove("_oldSearchText");
        TreeView treeView = searchParam.getTreeView();
        TreeNode rootNode = searchParam.getRootNode();
        if (!rootNode.getId().equals(treeView.getTreeState().getFocusNodeId())) {
            treeView.uncheckNodes(treeView.getTreeState().getSelectedNodeId());
            treeView.treeNodeClick(rootNode.getParentid(), rootNode.getId());
            ClassTreeUtils.focusNodeAfterSearch(searchParam, rootNode);
        }
        return true;
    }

    private static TreeNode searchExistsNodeFromLazyOrgTree(ClassTreeSearchParam searchParam, List<TreeNode> treeNodes) {
        if (CollectionUtils.isEmpty(treeNodes)) {
            return null;
        }
        TreeNode node = treeNodes.get(0);
        String parentId = node.getParentid();
        TreeNode parentNode = ClassTreeUtils.getNode(searchParam.getRootNode(), parentId);
        if (ClassTreeUtils.isChildNode(parentNode, node)) {
            ArrayList<String> loopController = new ArrayList<String>();
            ClassTreeUtils.expandParentNode(searchParam, parentId, loopController);
        } else {
            String treeKey = searchParam.getTreeView().getKey();
            if ("materialclasstree".equals(treeKey)) {
                ClassTreeUtils.queryMaterialClassTreeNodeWithParent(searchParam, node);
            } else {
                ClassTreeUtils.queryItemClassTreeNodeWithParent(searchParam, node);
            }
        }
        node = ClassTreeUtils.getNode(searchParam.getRootNode(), node.getId());
        if (node == null) {
            TreeNode removeNode = treeNodes.remove(0);
            String subNodeLongNumber = removeNode.getLongNumber() + "!";
            ArrayList<TreeNode> removeSubNodes = new ArrayList<TreeNode>(treeNodes.size());
            for (TreeNode subNode : treeNodes) {
                if (subNode.getLongNumber() == null || !subNode.getLongNumber().startsWith(subNodeLongNumber)) continue;
                removeSubNodes.add(subNode);
            }
            treeNodes.removeAll(removeSubNodes);
            return ClassTreeUtils.searchExistsNodeFromLazyOrgTree(searchParam, treeNodes);
        }
        return node;
    }

    private static boolean isChildNode(TreeNode parentNode, TreeNode node) {
        if (parentNode == null || CollectionUtils.isEmpty((Collection)parentNode.getChildren())) {
            return false;
        }
        for (TreeNode child : parentNode.getChildren()) {
            if (!node.getId().equals(child.getId())) continue;
            return true;
        }
        return false;
    }

    private static List<TreeNode> searchTreeNode(ClassTreeSearchParam searchParam) {
        DynamicObjectCollection classDynObjColl;
        QFilter numberFilter;
        QFilter nameFilter;
        ArrayList<TreeNode> treeNodes = new ArrayList<TreeNode>();
        String searchText = searchParam.getSearchText();
        String treeKey = searchParam.getTreeView().getKey();
        if ("materialclasstree".equals(treeKey)) {
            nameFilter = new QFilter("name", "like", (Object)("%" + searchText + "%"));
            numberFilter = new QFilter("number", "like", (Object)("%" + searchText + "%"));
            nameFilter = nameFilter.or(numberFilter);
            classDynObjColl = ClassTreeUtils.queryMaterialClassDynColl(searchParam, nameFilter);
        } else {
            nameFilter = new QFilter("name", "like", (Object)("%" + searchText + "%"));
            numberFilter = new QFilter("number", "like", (Object)("%" + searchText + "%"));
            nameFilter = nameFilter.or(numberFilter);
            classDynObjColl = ClassTreeUtils.queryItemClassDynColl(searchParam, nameFilter);
        }
        if (!CommonUtils.isNull(classDynObjColl)) {
            for (DynamicObject classDynObj : classDynObjColl) {
                String orgId = classDynObj.getString("id");
                TreeNode treeNode = new TreeNode(classDynObj.getString("parent"), orgId, classDynObj.getString("name"));
                treeNode.setExpend(true);
                treeNode.setLongNumber(classDynObj.getString("longnumber"));
                treeNodes.add(treeNode);
            }
        }
        return treeNodes;
    }

    private static void queryMaterialClassTreeNodeWithParent(ClassTreeSearchParam searchParam, TreeNode node) {
        TreeView treeView = searchParam.getTreeView();
        List<String> longNumList = ClassTreeUtils.getParentNumbers(searchParam, node);
        if (longNumList.isEmpty()) {
            return;
        }
        QFilter filter = new QFilter("number", "in", longNumList);
        DynamicObjectCollection materialClassDynObjColl = ClassTreeUtils.queryMaterialClassDynColl(searchParam, filter);
        TreeNode parentNode = searchParam.getRootNode();
        for (DynamicObject materialClassDynObj : materialClassDynObjColl) {
            String materialClassId = materialClassDynObj.getString("id");
            if ((parentNode = ClassTreeUtils.getNode(parentNode, materialClassId)) == null || parentNode.getChildren() == null || parentNode.getChildren().isEmpty() || node.getParentid().equals(materialClassId)) {
                String parentId = materialClassDynObj.getString("parent");
                treeView.queryTreeNodeChildren(parentId, materialClassId);
            }
            treeView.expand(materialClassId);
        }
    }

    private static DynamicObjectCollection queryMaterialClassDynColl(ClassTreeSearchParam searchParam, QFilter filter) {
        String selectFields = String.join((CharSequence)",", "id", "longnumber", "parent", "name", "isleaf");
        filter = filter.and(new QFilter("standard", "=", (Object)searchParam.getStandardId()));
        String sortFields = String.join((CharSequence)",", "level", "number", "longnumber");
        DynamicObjectCollection materialClassDynObjColl = QueryServiceHelper.query((String)"bd_materialgroup", (String)selectFields, (QFilter[])filter.toArray(), (String)sortFields);
        return materialClassDynObjColl;
    }

    private static void queryItemClassTreeNodeWithParent(ClassTreeSearchParam searchParam, TreeNode node) {
        TreeView treeView = searchParam.getTreeView();
        List<String> longNumList = ClassTreeUtils.getParentNumbers(searchParam, node);
        if (longNumList.isEmpty()) {
            return;
        }
        QFilter filter = new QFilter("number", "in", longNumList);
        DynamicObjectCollection itemClassDynObjColl = ClassTreeUtils.queryItemClassDynColl(searchParam, filter);
        TreeNode parentNode = searchParam.getRootNode();
        for (DynamicObject materialClassDynObj : itemClassDynObjColl) {
            String materialClassId = materialClassDynObj.getString("id");
            if ((parentNode = ClassTreeUtils.getNode(parentNode, materialClassId)) == null || parentNode.getChildren() == null || parentNode.getChildren().isEmpty() || node.getParentid().equals(materialClassId)) {
                String parentId = materialClassDynObj.getString("parent");
                treeView.queryTreeNodeChildren(parentId, materialClassId);
            }
            treeView.expand(materialClassId);
        }
    }

    private static DynamicObjectCollection queryItemClassDynColl(ClassTreeSearchParam searchParam, QFilter filter) {
        String selectFields = String.join((CharSequence)",", "id", "longnumber", "parent", "name", "isleaf");
        filter = filter.and(new QFilter("standard", "=", (Object)searchParam.getStandardId()));
        String sortFields = String.join((CharSequence)",", "level", "number", "longnumber");
        DynamicObjectCollection itemClassDynObjColl = QueryServiceHelper.query((String)"mdr_item_class", (String)selectFields, (QFilter[])filter.toArray(), (String)sortFields);
        return itemClassDynObjColl;
    }

    private static List<String> getParentNumbers(ClassTreeSearchParam searchParam, TreeNode node) {
        ArrayList<String> longNumList = new ArrayList<String>();
        String longNumber = node.getLongNumber();
        if (StringUtils.isNotBlank((CharSequence)longNumber)) {
            int i;
            String[] numbers = longNumber.split("!");
            int n = i = searchParam.getRootNode().getId().equals(node.getParentid()) ? 0 : 1;
            while (i < numbers.length - 1) {
                longNumList.add(numbers[i]);
                ++i;
            }
        }
        return longNumList;
    }

    private static void removeAllSearchTreeNodeCache(IPageCache pageCache) {
        pageCache.remove("_searchNodes");
        pageCache.remove("_oldSearchText");
        pageCache.remove("_oldSearchViewSchema");
        pageCache.remove("_resultTotalCacheKey");
    }

    private static void removeLoopSearchTreeNodeCache(IPageCache pageCache) {
        pageCache.remove("_searchNodes");
    }
}

