/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.gmc.common.util;

import java.util.Iterator;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public final class ORMUtil {
    private static final String orderBys = null;

    private ORMUtil() {
    }

    public static boolean isExist(String entityName, String pro, Object proValue) {
        QFilter[] filters = new QFilter[]{new QFilter(pro, "=", proValue)};
        return ORM.create().exists(entityName, filters);
    }

    public static boolean isExist4MultiQFilter(String entityName, Map<String, Map<String, Object>> map) {
        if (map == null) {
            return false;
        }
        QFilter[] filters = ORMUtil.map2QFilter(map);
        return ORM.create().exists(entityName, filters);
    }

    public static DynamicObject queryOneByPro(String entityName, String selectFields, Map<String, Object> map) {
        QFilter[] filters = ORMUtil.map2QFilters(map);
        if (null == filters) {
            return null;
        }
        DynamicObject[] dynObjs = BusinessDataServiceHelper.load((String)entityName, (String)selectFields, (QFilter[])filters);
        return dynObjs.length == 0 ? null : dynObjs[0];
    }

    public static DynamicObject[] queryByPro(String entityName, String selectFields, Map<String, Object> map) {
        QFilter[] filters = ORMUtil.map2QFilters(map);
        if (null == filters) {
            return null;
        }
        return BusinessDataServiceHelper.load((String)entityName, (String)selectFields, (QFilter[])filters);
    }

    public static void setPrimaryKey(DynamicObject obj) {
        ORM.create().setPrimaryKey(obj);
    }

    private static QFilter[] map2QFilters(Map<String, Object> map) {
        if (map == null) {
            return null;
        }
        QFilter[] filters = new QFilter[map.size()];
        int i = 0;
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            QFilter filter;
            filters[i] = filter = new QFilter(entry.getKey(), "=", entry.getValue());
            ++i;
        }
        return filters;
    }

    public static QFilter[] map2QFilter(Map<String, Map<String, Object>> map) {
        if (CollectionUtils.isEmpty(map)) {
            return null;
        }
        QFilter[] filters = new QFilter[1];
        QFilter filter = new QFilter("id", "!=", (Object)0);
        for (Map.Entry<String, Map<String, Object>> entry : map.entrySet()) {
            Map<String, Object> cpVal = entry.getValue();
            for (Map.Entry<String, Object> vpValEntry : cpVal.entrySet()) {
                if (vpValEntry.getKey().equals("is null")) {
                    filter = filter.and(QFilter.isNull((String)entry.getKey()));
                    continue;
                }
                if (vpValEntry.getKey().equals("is not null")) {
                    filter = filter.and(QFilter.isNotNull((String)entry.getKey()));
                    continue;
                }
                if ("of".equals(vpValEntry.getKey())) {
                    filter = filter.and(QFilter.of((String)vpValEntry.getValue().toString(), (Object[])new Object[0]));
                    continue;
                }
                filter = filter.and(entry.getKey(), vpValEntry.getKey(), vpValEntry.getValue());
            }
        }
        filters[0] = filter;
        return filters;
    }

    public static DynamicObject newDynamicObject(String entityKey) {
        return ORM.create().newDynamicObject(entityKey);
    }

    public static DynamicObject newDynamicObject(DynamicObjectType dynamicObjectType) {
        return ORM.create().newDynamicObject(dynamicObjectType);
    }

    public static DynamicObject[] getDynamicObjectByPk(Object[] pkArray, DynamicObjectType type) {
        return BusinessDataServiceHelper.load((Object[])pkArray, (DynamicObjectType)type);
    }

    public static DataSet queryDataSet(String algoKey, String entityName, String selectFields, Map<String, Map<String, Object>> map, String orderBys) {
        return QueryServiceHelper.queryDataSet((String)algoKey, (String)entityName, (String)selectFields, (QFilter[])ORMUtil.map2QFilter(map), (String)orderBys);
    }

    public static DynamicObjectCollection queryDynamicObjectCollection(String algoKey, String entityName, String selectFields, Map<String, Map<String, Object>> map, String orderBys) {
        return QueryServiceHelper.query((String)algoKey, (String)entityName, (String)selectFields, (QFilter[])ORMUtil.map2QFilter(map), (String)orderBys);
    }

    public static DynamicObjectCollection queryDynamicObjectCollection(String entityName, String selectFields, Map<String, Map<String, Object>> map) {
        return QueryServiceHelper.query((String)entityName, (String)selectFields, (QFilter[])ORMUtil.map2QFilter(map));
    }

    public static DynamicObject[] queryCollectionByUniquePro(String entryKey, String selectFields, Map<String, Map<String, Object>> map) {
        return BusinessDataServiceHelper.load((String)entryKey, (String)selectFields, (QFilter[])ORMUtil.map2QFilter(map));
    }

    public static Long queryPkValueByNumber(String entryKey, Map<String, Map<String, Object>> numberMap) {
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)entryKey, (String)"id", (QFilter[])ORMUtil.map2QFilter(numberMap));
        if (dynamicObjects.length == 1) {
            return (Long)dynamicObjects[0].get("id");
        }
        return 0L;
    }

    public static DynamicObject[] queryByPro(String entityName, String selectFields) {
        DynamicObjectCollection coll = ORM.create().query(entityName, selectFields, null);
        if (coll == null) {
            return null;
        }
        DynamicObject[] objs = new DynamicObject[coll.size()];
        int i = 0;
        Iterator iterator = coll.iterator();
        while (iterator.hasNext()) {
            DynamicObject obj;
            objs[i] = obj = (DynamicObject)iterator.next();
            ++i;
        }
        return objs;
    }

    public static DynamicObject[] query(String entityKey, String selectfields, Map<String, Map<String, Object>> map) {
        QFilter[] filters = ORMUtil.map2QFilter(map);
        return BusinessDataServiceHelper.load((String)entityKey, (String)selectfields, (QFilter[])filters);
    }

    public static DynamicObjectCollection query(String entityName, String selectFields, QFilter[] filters, String orderBys, int form, int length) {
        ORM orm = ORM.create();
        try (DataSet ds = orm.queryDataSet("mdr", entityName, selectFields, filters, orderBys, form, length);){
            DynamicObjectCollection rows;
            DynamicObjectCollection dynamicObjectCollection = rows = orm.toPlainDynamicObjectCollection(ds);
            return dynamicObjectCollection;
        }
    }
}

