/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.macc.common.helper;

import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;

public class AutoUpdateDataService {
    private static final Log logger = LogFactory.getLog(AutoUpdateDataService.class);

    public static Boolean updateDataResult(String updateType) {
        try {
            logger.info("AutoUpdateDataTask\u6570\u636e\u5347\u7ea7\u5f00\u59cb");
            if ("costbom".equals(updateType)) {
                AutoUpdateDataService.excetUpdaeData("cad_costbom", "pdm_mftbom");
            } else {
                AutoUpdateDataService.excetUpdaeData("cad_router", "pdm_route");
            }
            return true;
        }
        catch (Exception e) {
            logger.error("AutoUpdateDataTask\u6570\u636e\u5347\u7ea7\u5931\u8d25", (Throwable)e);
            return false;
        }
    }

    private static void excetUpdaeData(String updateEntityName, String sourceeEntityName) {
        QFilter qFilter = new QFilter("manuorg", "=", (Object)0L).or(new QFilter("manuorg", "is null", null));
        int pageNum = 0;
        int pageSize = 10000;
        int dataSize = 10000;
        while (dataSize >= pageSize) {
            DynamicObject[] costBoms = BusinessDataServiceHelper.load((String)updateEntityName, (String)"number,createorg,manuorg", (QFilter[])new QFilter[]{qFilter}, null, (int)pageNum, (int)pageSize);
            dataSize = costBoms.length;
            ++pageNum;
            if (costBoms == null || costBoms.length <= 0) continue;
            Set numberList = Arrays.stream(costBoms).map(o -> o.get("number")).collect(Collectors.toSet());
            QFilter numberQf = new QFilter("number", "in", numberList);
            DynamicObject[] pdmBoms = BusinessDataServiceHelper.load((String)sourceeEntityName, (String)"number,createorg,ctrlstrategy,useorg", (QFilter[])new QFilter[]{numberQf});
            logger.info("AutoUpdateDataTask\u6570\u636e\u5347\u7ea7" + sourceeEntityName + "\u6570\u91cf" + pdmBoms.length);
            for (DynamicObject costBom : costBoms) {
                String costNumber = costBom.getString("number");
                for (DynamicObject pdmBom : pdmBoms) {
                    String pdmNumber = pdmBom.getString("number");
                    if (StringUtils.isEmpty((String)pdmNumber) || !pdmNumber.equals(costNumber)) continue;
                    costBom.set("manuorg", pdmBom.get("createorg"));
                }
            }
            SaveServiceHelper.save((DynamicObject[])costBoms);
        }
    }
}

