/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.macc.common.utils;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class EntityUtil {
    public static DynamicObject copyEntity(String fromEntityName, DynamicObject fromDynamicObject, String toEntityName) {
        MainEntityType fromEntityType = EntityMetadataCache.getDataEntityType((String)fromEntityName);
        MainEntityType toEntityType = EntityMetadataCache.getDataEntityType((String)toEntityName);
        DynamicObject toDynamicObject = BusinessDataServiceHelper.newDynamicObject((String)toEntityName);
        Map fromFieldsMap = fromEntityType.getAllFields();
        Map toFieldsMap = toEntityType.getAllFields();
        for (String key : fromFieldsMap.keySet()) {
            if (!toFieldsMap.containsKey(key)) continue;
            toDynamicObject.set(key, fromDynamicObject.get(key));
        }
        return toDynamicObject;
    }

    public static String getEntityFields(String entityName) {
        StringBuilder fields = new StringBuilder();
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityName);
        Map fieldsMap = entityType.getFields();
        for (Map.Entry fieldsMapEntry : fieldsMap.entrySet()) {
            if (((IDataEntityProperty)fieldsMapEntry.getValue()).toString().endsWith(":")) continue;
            fields.append(",").append(((IDataEntityProperty)fieldsMapEntry.getValue()).toString().split(":")[0]);
        }
        if (fields.length() > 0) {
            return fields.substring(1);
        }
        return fields.toString();
    }

    public static Object getDynamicObjectID(DynamicObject data, String name) {
        DynamicObject ob = data.getDynamicObject(name);
        if (ob == null) {
            return null;
        }
        Object id = ob.get("id");
        return id;
    }

    public static boolean isNewCreate(DynamicObject data) {
        return !data.getDataEntityState().getFromDatabase();
    }

    public static void copyPropertiesWithOutId(DynamicObject toObj, DynamicObject fromObj) {
        EntityUtil.copyProperties(toObj, fromObj, null, null, false);
    }

    public static void copyPropertiesWithOutId(DynamicObject toObj, DynamicObject fromObj, Set<String> ignoreKeys) {
        EntityUtil.copyProperties(toObj, fromObj, ignoreKeys, null, false);
    }

    public static void copyProperties(DynamicObject toObj, DynamicObject fromObj, String ... keys) {
        if (keys == null || keys.length == 0) {
            return;
        }
        int len = keys.length;
        for (int i = 0; i < len; ++i) {
            toObj.set(keys[i], fromObj.get(keys[i]));
        }
    }

    public static void copyProperties(DynamicObject fromObj, DynamicObject toObj, Map propMap) {
        Iterator iteator = propMap.keySet().iterator();
        while (iteator.hasNext()) {
            String fromProp = iteator.next().toString();
            String toProp = propMap.get(fromProp).toString();
            toObj.set(toProp, fromObj.get(fromProp));
        }
    }

    public static void copyProperties(DynamicObject toObj, DynamicObject fromObj, Set<String> ignoreKeys, Map<String, String> convertKeysMap, boolean needCopyId) {
        DataEntityPropertyCollection toPs = toObj.getDataEntityType().getProperties();
        DataEntityPropertyCollection fromPs = fromObj.getDataEntityType().getProperties();
        HashSet<String> fromPsSet = new HashSet<String>(fromPs.size());
        for (IDataEntityProperty dp : fromPs) {
            fromPsSet.add(dp.getName());
        }
        if (ignoreKeys == null) {
            ignoreKeys = new HashSet<String>();
        }
        if (!needCopyId) {
            ignoreKeys.add("id");
        }
        String toKey = null;
        String fromKey = null;
        int len = toPs.size();
        for (int i = 0; i < len; ++i) {
            toKey = ((IDataEntityProperty)toPs.get(i)).getName();
            if (ignoreKeys.contains(toKey) || !fromPsSet.contains(fromKey = convertKeysMap != null && convertKeysMap.containsKey(toKey) ? convertKeysMap.get(toKey) : toKey)) continue;
            Object value = fromObj.get(fromKey);
            if (value instanceof DynamicObjectCollection) {
                DynamicObjectCollection formEntity = (DynamicObjectCollection)value;
                DynamicObjectCollection toEntity = toObj.getDynamicObjectCollection(toKey);
                if (toEntity != null) {
                    toEntity.clear();
                    DynamicObjectType entityType = toEntity.getDynamicObjectType();
                    for (DynamicObject baseEntry : formEntity) {
                        DynamicObject newEntry = new DynamicObject(entityType);
                        EntityUtil.copy(baseEntry, newEntry, ignoreKeys);
                        toEntity.add((Object)newEntry);
                    }
                }
                toObj.set(toKey, (Object)toEntity);
                continue;
            }
            toObj.set(toKey, value);
        }
    }

    public static void copy(DynamicObject fromObj, DynamicObject toObj) {
        EntityUtil.copy(fromObj, toObj, null, null);
    }

    public static void copy(DynamicObject fromObj, DynamicObject toObj, Set<String> ignoreKeys) {
        EntityUtil.copy(fromObj, toObj, ignoreKeys, null);
    }

    public static void copy(DynamicObject fromObj, DynamicObject toObj, Map<String, String> transKeyMap) {
        EntityUtil.copy(fromObj, toObj, null, transKeyMap);
    }

    public static void copy(DynamicObject fromObj, DynamicObject toObj, Set<String> ignoreKeys, Map<String, String> transKeyMap) {
        if (fromObj == null || toObj == null) {
            return;
        }
        DataEntityPropertyCollection fromPros = fromObj.getDataEntityType().getProperties();
        if (fromPros == null || fromPros.size() == 0) {
            return;
        }
        DataEntityPropertyCollection toPros = toObj.getDataEntityType().getProperties();
        if (toPros == null || toPros.size() == 0) {
            return;
        }
        HashSet<String> fromPsSet = new HashSet<String>(fromPros.size());
        for (Object pro : fromPros) {
            fromPsSet.add(String.valueOf(pro.getName()).toLowerCase());
        }
        HashSet<String> toPsSet = new HashSet<String>(fromPros.size());
        for (IDataEntityProperty pro : toPros) {
            toPsSet.add(String.valueOf(pro.getName()).toLowerCase());
        }
        ISimpleProperty primaryKeyObj = toObj.getDataEntityType().getPrimaryKey();
        String primaryKey = "";
        if (primaryKeyObj != null) {
            primaryKey = primaryKeyObj.getName();
        }
        for (IDataEntityProperty pro : toPros) {
            String toProName;
            String fromProName = toProName = pro.getName();
            if (transKeyMap != null && transKeyMap.containsKey(fromProName)) {
                toProName = transKeyMap.get(fromProName);
            } else if (ignoreKeys != null && ignoreKeys.contains(toProName)) continue;
            if (!fromPsSet.contains(fromProName) || !toPsSet.contains(toProName)) continue;
            if (toProName.equals(primaryKey)) {
                toObj.set(toProName, null);
                continue;
            }
            Object value = fromObj.get(fromProName);
            if (value instanceof DynamicObjectCollection) {
                DynamicObjectCollection formEntity = (DynamicObjectCollection)value;
                DynamicObjectCollection toEntity = toObj.getDynamicObjectCollection(toProName);
                if (toEntity != null) {
                    toEntity.clear();
                    DynamicObjectType entityType = toEntity.getDynamicObjectType();
                    for (DynamicObject baseEntry : formEntity) {
                        DynamicObject newEntry = new DynamicObject(entityType);
                        EntityUtil.copy(baseEntry, newEntry, ignoreKeys, transKeyMap);
                        toEntity.add((Object)newEntry);
                    }
                }
                toObj.set(toProName, (Object)toEntity);
                continue;
            }
            toObj.set(toProName, value);
        }
    }
}

