/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.master;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;

public class AddressDataImportOp
extends BatchImportPlugin {
    private final Log log = LogFactory.getLog(AddressDataImportOp.class);

    protected int getBatchImportSize() {
        return 1000;
    }

    protected ApiResult save(List<ImportBillData> rowdatas, ImportLogger logger) {
        try (TraceSpan span = Tracer.create((String)"AddressDataImportOp", (String)"beforeImportBill");){
            if (rowdatas.isEmpty()) {
                ApiResult apiResult = null;
                return apiResult;
            }
            this.log.info("AddressDataImportOp beforeImportBill begin.");
            this.beforeImportBill(rowdatas, logger);
            this.log.info("AddressDataImportOp beforeImportBill end.");
        }
        return super.save(rowdatas, logger);
    }

    protected void beforeImportBill(List<ImportBillData> rowdatas, ImportLogger logger) {
        Iterator<ImportBillData> iterator = rowdatas.iterator();
        try (TraceSpan span = Tracer.create((String)"AddressDataImportOp", (String)"validateDataRequiredField");){
            while (iterator.hasNext()) {
                this.validateDataRequiredField(logger, iterator);
            }
        }
    }

    private void validateDataRequiredField(ImportLogger logger, Iterator<ImportBillData> iterator) {
        ImportBillData importRowData = iterator.next();
        JSONObject importRowJsonData = importRowData.getData();
        String importDataCustomer = importRowJsonData.getString("customer");
        String importDataSupplier = importRowJsonData.getString("supplier");
        String importDatacreateorg = importRowJsonData.getString("createorg");
        String admindivision = importRowJsonData.getString("admindivision");
        if (!org.apache.commons.lang.StringUtils.isEmpty((String)admindivision)) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("id", admindivision);
            JSONObject admindivisionObj = new JSONObject(map);
            importRowJsonData.put("admindivisiondata", (Object)admindivisionObj);
        }
        if ((StringUtils.isEmpty((CharSequence)importDataCustomer) || "null".equals(importDataCustomer)) && (StringUtils.isEmpty((CharSequence)importDataSupplier) || "null".equals(importDataSupplier))) {
            int errMsgRowIndex = importRowData.getStartIndex();
            logger.log(Integer.valueOf(errMsgRowIndex), ResManager.loadKDString((String)"\u5bfc\u5165\u5730\u5740\u4fe1\u606f\u6570\u636e\u9700\u8981\u6307\u5b9a\u5f52\u5c5e\u4e8e\u54ea\u4e2a\u4f9b\u5e94\u5546\u6216\u8005\u5ba2\u6237\uff0c\u5f53\u524d\u6570\u636e\u4e0d\u7b26\u5408\u8981\u6c42\uff0c\u5bfc\u5165\u5931\u8d25\u3002", (String)"AddressDataImportOp_1", (String)"bd-master-opplugin", (Object[])new Object[0])).fail();
            iterator.remove();
            return;
        }
        if (StringUtils.isEmpty((CharSequence)importDatacreateorg) || "null".equals(importDatacreateorg)) {
            int errMsgRowIndex = importRowData.getStartIndex();
            logger.log(Integer.valueOf(errMsgRowIndex), ResManager.loadKDString((String)"\u5bfc\u5165\u5730\u5740\u4fe1\u606f\u6570\u636e\u9700\u8981\u6307\u5b9a\u4f9b\u5e94\u5546\u6216\u8005\u5ba2\u6237\u7684\u521b\u5efa\u7ec4\u7ec7\uff0c\u521b\u5efa\u7ec4\u7ec7\u9700\u8981\u5fc5\u5f55\uff0c\u5f53\u524d\u6570\u636e\u4e0d\u7b26\u5408\u8981\u6c42\uff0c\u5bfc\u5165\u5931\u8d25\u3002", (String)"AddressDataImportOp_2", (String)"bd-master-opplugin", (Object[])new Object[0])).fail();
            iterator.remove();
            return;
        }
        if (!StringUtils.isEmpty((CharSequence)importDataCustomer) && !"null".equals(importDataCustomer)) {
            importRowJsonData.put("isCustomer", (Object)"1");
            importRowJsonData.put("isSupplier", (Object)"0");
            JSONObject customer = JSON.parseObject((String)importDataCustomer);
            if (customer != null) {
                customer.put("createorg", (Object)JSON.parseObject((String)importDatacreateorg));
                importRowJsonData.put("customer", (Object)customer);
            }
        }
        if (!StringUtils.isEmpty((CharSequence)importDataSupplier) && !"null".equals(importDataSupplier)) {
            importRowJsonData.put("isSupplier", (Object)"1");
            importRowJsonData.put("isCustomer", (Object)"0");
            JSONObject supplier = JSON.parseObject((String)importDataSupplier);
            if (supplier != null) {
                supplier.put("createorg", (Object)JSON.parseObject((String)importDatacreateorg));
                importRowJsonData.put("supplier", (Object)supplier);
            }
        }
    }
}

