/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.macc.formplugin.costtype;

import java.util.EventObject;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class CostTypeEditPlugin
extends AbstractBasePlugIn {
    private static final String COLUMN_TYPE = "type";
    private static final String COLUMN_ELEMENTTYPE = "elementtype";
    private static final String TABLE_CAD_ELEMENTTYPE = "cad_elementtype";
    private static final String TABLE_CAD_ELEMENT = "cad_element";
    private static final String BAR_SAVE = "bar_save";
    private static final String BAR_SAVEANDNEW = "bar_saveandnew";
    private static final String COLUMN_NUMBER = "number";
    private static final String COLUMN_ISUPDATE = "isupdate";
    private static final String BAR_SUBMIT = "bar_submit";
    private static final String BAR_UNAUDIT = "bar_unaudit";
    private static final String BAR_UNSUBMIT = "bar_unsubmit";

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.initData();
        this.defualtCurreny();
        this.setEnableByUsed();
        this.setEnableBySysData();
        this.setEnableByAppNum();
        this.setVisibleByAppNum();
        this.getModel().setDataChanged(false);
    }

    private void setEnableByAppNum() {
        if ("aca".equals(this.getView().getFormShowParameter().getAppId())) {
            this.getView().setEnable(Boolean.FALSE, new String[]{COLUMN_TYPE});
        }
    }

    private void setVisibleByAppNum() {
        if ("aca".equals(this.getView().getFormShowParameter().getAppId())) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"relation"});
        }
    }

    private void setEnableByUsed() {
        String status = (String)this.getModel().getValue("status");
        if ("A".equals(status) && this.isUsed()) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"currency"});
            this.getView().setEnable(Boolean.FALSE, new String[]{COLUMN_TYPE});
            this.getView().setEnable(Boolean.FALSE, new String[]{COLUMN_ISUPDATE});
            this.getView().setEnable(Boolean.FALSE, new String[]{"isuseversion"});
        }
    }

    private boolean isUsed() {
        long costTypeId = (Long)this.getModel().getValue("id");
        if (costTypeId == 0L) {
            return false;
        }
        QFilter qfCostType = new QFilter("costtype", "=", (Object)costTypeId);
        if (QueryServiceHelper.exists((String)"cad_matcostinfo", (QFilter[])new QFilter[]{qfCostType})) {
            return true;
        }
        if (QueryServiceHelper.exists((String)"cad_subelement_material", (QFilter[])new QFilter[]{qfCostType})) {
            return true;
        }
        if (QueryServiceHelper.exists((String)"cad_outsourceprice", (QFilter[])new QFilter[]{qfCostType})) {
            return true;
        }
        if (QueryServiceHelper.exists((String)"cad_purprices", (QFilter[])new QFilter[]{qfCostType})) {
            return true;
        }
        if (QueryServiceHelper.exists((String)"cad_resourcerate", (QFilter[])new QFilter[]{qfCostType})) {
            return true;
        }
        if (QueryServiceHelper.exists((String)"cad_bomsetting", (QFilter[])new QFilter[]{qfCostType})) {
            return true;
        }
        return QueryServiceHelper.exists((String)"cad_routersetting", (QFilter[])new QFilter[]{qfCostType});
    }

    private void setEnableBySysData() {
        Boolean issystem = (Boolean)this.getModel().getValue("issystem");
        if (issystem.booleanValue()) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"currency"});
            this.getView().setEnable(Boolean.FALSE, new String[]{COLUMN_TYPE});
            this.getView().setEnable(Boolean.FALSE, new String[]{COLUMN_ISUPDATE});
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addListener();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        switch (name) {
            case "createorg": {
                OperationStatus os = this.getView().getFormShowParameter().getStatus();
                if (!OperationStatus.ADDNEW.equals((Object)os)) break;
                Object currencyId = null;
                if (newValue != null) {
                    DynamicObject object = (DynamicObject)newValue;
                    QFilter filter = new QFilter("baseacctorg", "=", object.getPkValue());
                    DynamicObject acctBaseOrg = QueryServiceHelper.queryOne((String)"bd_accountingsys_base", (String)"basecurrrency", (QFilter[])new QFilter[]{filter});
                    if (acctBaseOrg != null) {
                        currencyId = acctBaseOrg.get("basecurrrency");
                    }
                }
                this.getModel().setValue("currency", currencyId);
                break;
            }
            case "type": {
                Object typeValue = this.getModel().getValue(COLUMN_TYPE);
                if (typeValue.equals("0")) {
                    this.getModel().setValue(COLUMN_ISUPDATE, (Object)Boolean.TRUE);
                    break;
                }
                this.getModel().setValue(COLUMN_ISUPDATE, (Object)Boolean.FALSE);
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String key;
        switch (key = evt.getItemKey()) {
            case "bar_save": 
            case "bar_saveandnew": {
                this.initData();
                OperationStatus os = this.getView().getFormShowParameter().getStatus();
                if (!OperationStatus.ADDNEW.equals((Object)os)) break;
                this.getPageCache().put("isFirstSave", "1");
                break;
            }
            case "bar_submit": {
                this.setEnableByUsed();
                this.initData();
                break;
            }
            case "bar_unsubmit": {
                this.setEnableByUsed();
                break;
            }
            case "bar_unaudit": {
                this.setEnableByUsed();
            }
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String key;
        switch (key = evt.getItemKey()) {
            case "bar_submit": 
            case "bar_save": 
            case "bar_saveandnew": {
                Boolean isupdate;
                Object typeId = this.getModel().getValue(COLUMN_TYPE);
                if (!"0".equals(typeId) || (isupdate = (Boolean)this.getModel().getValue(COLUMN_ISUPDATE)).booleanValue()) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6838\u7b97\u6210\u672c\u5c5e\u6027\u4e0b\u5fc5\u987b\u52fe\u9009\u201c\u5141\u8bb8\u66f4\u65b0\u201d\u3002", (String)"CostTypeEditPlugin_0", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        if (afterDoOperationEventArgs.getOperateKey().equals("audit") && afterDoOperationEventArgs.getOperationResult().isSuccess()) {
            this.getView().invokeOperation("refresh");
        }
    }

    protected void addListener() {
        this.addItemClickListeners(new String[]{"tbmain"});
    }

    private void initData() {
        QFilter elementTypeFilter = new QFilter(COLUMN_NUMBER, "=", (Object)"ET001");
        DynamicObject material = QueryServiceHelper.queryOne((String)TABLE_CAD_ELEMENTTYPE, (String)"id", (QFilter[])new QFilter[]{elementTypeFilter});
        long elementTypeId = material.getLong("id");
        this.getModel().setValue(COLUMN_ELEMENTTYPE, (Object)elementTypeId);
        QFilter elementFilter = new QFilter(COLUMN_ELEMENTTYPE, "=", (Object)elementTypeId);
        DynamicObjectCollection element = QueryServiceHelper.query((String)TABLE_CAD_ELEMENT, (String)"id", (QFilter[])new QFilter[]{elementFilter}, (String)COLUMN_NUMBER);
        Boolean isfrist = Boolean.TRUE;
        for (DynamicObject ele : element) {
            int index = this.getModel().createNewEntryRow("elemententry");
            if (index != 0 && isfrist.booleanValue()) {
                this.getModel().deleteEntryRow("elemententry", index);
                break;
            }
            isfrist = Boolean.FALSE;
            this.getModel().setValue("element", (Object)ele.getLong("id"), index);
        }
        this.getModel().setDataChanged(false);
    }

    private void defualtCurreny() {
        OperationStatus os = this.getView().getFormShowParameter().getStatus();
        if (OperationStatus.ADDNEW.equals((Object)os)) {
            Object corg = this.getModel().getValue("createorg");
            Object currencyId = null;
            if (corg != null) {
                DynamicObject object = (DynamicObject)corg;
                QFilter filter = new QFilter("baseacctorg", "=", object.getPkValue());
                DynamicObject acctBaseOrg = QueryServiceHelper.queryOne((String)"bd_accountingsys_base", (String)"basecurrrency", (QFilter[])new QFilter[]{filter});
                if (acctBaseOrg != null) {
                    currencyId = acctBaseOrg.get("basecurrrency");
                }
            }
            this.getModel().setValue("currency", currencyId);
        }
    }
}

