/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.macc.formplugin.element;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bd.macc.common.constant.CommonConstant;
import kd.bd.macc.common.helper.CostTypeHelper;
import kd.bd.macc.common.helper.OrgHelper;
import kd.bd.macc.common.utils.CadEmptyUtils;
import kd.bd.macc.formplugin.element.SubElementAccountTreeListView;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.tree.TreeNode;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.filter.FilterContainer;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.AfterSearchClickListener;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.SearchClickEvent;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.list.AbstractTreeListView;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.CreateTreeListViewEvent;
import kd.bos.list.plugin.StandardTreeListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;

public class SubElementAccountTreeList
extends StandardTreeListPlugin
implements AfterSearchClickListener {
    private static final String TREE_ROOT_ID = "8609760E-EF83-4775-A9FF-CCDEC7C0B689";
    private SubElementAccountTreeListView treeListView = new SubElementAccountTreeListView();

    public void initialize() {
        super.initialize();
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        String fieldName = args.getFieldName();
        if (fieldName.startsWith("costtype")) {
            DynamicObject[] costTypes = CostTypeHelper.getCostTypeByOrgsRanges((String)"0");
            HashSet<Long> costTypeIds = new HashSet<Long>(10);
            for (DynamicObject costType : costTypes) {
                costTypeIds.add(costType.getLong("id"));
            }
            QFilter filter = new QFilter("id", "in", costTypeIds);
            args.getQfilters().add(filter);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        FilterContainer fc = (FilterContainer)this.getControl("filtercontainerap");
        fc.addAfterSearchClickListener((AfterSearchClickListener)this);
    }

    public void createTreeListView(CreateTreeListViewEvent e) {
        super.createTreeListView(e);
        e.setView((AbstractTreeListView)this.treeListView);
    }

    public void initTreeToolbar(EventObject e) {
        super.initTreeToolbar(e);
        this.getView().setVisible(Boolean.FALSE, new String[]{"btnnew", "btnedit", "btndel", "searchap"});
        this.getView().setVisible(Boolean.FALSE, new String[]{"flexpanel_treebtn"});
    }

    private void rebuildTreeNode() {
        TreeView tree = (TreeView)this.getView().getControl("treeview");
        if (tree == null) {
            return;
        }
        tree.deleteAllNodes();
        TreeNode rootNode = new TreeNode("", TREE_ROOT_ID, ResManager.loadKDString((String)"\u5168\u90e8", (String)"SubElementAccountTreeList_0", (String)"macc-cad-formplugin", (Object[])new Object[0]), true);
        tree.addNode(rootNode);
        List<TreeNode> loadChildrenNode = this.loadChildrenNode();
        if (loadChildrenNode == null || loadChildrenNode.isEmpty()) {
            return;
        }
        tree.addNodes(loadChildrenNode);
        tree.focusNode(rootNode);
        tree.expand(TREE_ROOT_ID);
    }

    private List<TreeNode> loadChildrenNode() {
        String costType = this.getCacheCostType();
        List<DynamicObject> list = this.getAllSubElementBy(costType);
        if (list == null || list.isEmpty()) {
            return null;
        }
        ArrayList<TreeNode> nodes = new ArrayList<TreeNode>(10);
        for (DynamicObject subEle : list) {
            if (subEle == null) continue;
            nodes.add(new TreeNode(TREE_ROOT_ID, String.valueOf(subEle.getPkValue()), subEle.getString("name"), false));
        }
        return nodes;
    }

    private List<DynamicObject> getAllSubElementBy(String costTypeId) {
        if (StringUtils.isEmpty((String)costTypeId)) {
            return null;
        }
        DynamicObject costType = BusinessDataServiceHelper.loadSingle((Object)costTypeId, (String)"cad_costtype");
        DynamicObject[] elements = null;
        if (costType != null && costType.getDynamicObject("elementtype") != null) {
            QFilter eleTypeFilter = new QFilter("elementtype", "=", costType.getDynamicObject("elementtype").getPkValue());
            QFilter subelementType = new QFilter("subelement.enable", "=", (Object)true);
            elements = BusinessDataServiceHelper.load((String)"cad_elementdetail", (String)"id,subelement", (QFilter[])new QFilter[]{eleTypeFilter, subelementType});
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u6210\u672c\u7c7b\u578b\u4e0b\u7684\u201c\u6210\u672c\u8981\u7d20\u5206\u7c7b\u201d\u4e3a\u7a7a\u3002", (String)"SubElementAccountTreeList_1", (String)"macc-cad-formplugin", (Object[])new Object[0]));
        }
        if (elements == null || elements.length == 0) {
            return null;
        }
        ArrayList<DynamicObject> list = new ArrayList<DynamicObject>(elements.length);
        for (void var8_8 : elements) {
            list.add(var8_8.getDynamicObject("subelement"));
        }
        return list;
    }

    protected QFilter nodeClickFilter() {
        QFilter resultFilter = super.nodeClickFilter();
        TreeView treeView = (TreeView)this.getControl("treeview");
        String focusNodeId = treeView.getTreeState().getFocusNodeId();
        String costTypeId = this.getCacheCostType();
        QFilter filter = new QFilter("subelement", "=", (Object)-1);
        if (StringUtils.isEmpty((String)focusNodeId) || TREE_ROOT_ID.equals(focusNodeId)) {
            List<DynamicObject> list = this.getAllSubElementBy(costTypeId);
            if (list != null && !list.isEmpty()) {
                ArrayList ids = new ArrayList();
                list.forEach(s -> {
                    if (s != null) {
                        ids.add(s.getPkValue());
                    }
                });
                filter = new QFilter("subelement", "in", ids);
            }
        } else {
            filter = new QFilter("subelement", "=", (Object)Long.valueOf(focusNodeId));
        }
        resultFilter = resultFilter == null ? filter : resultFilter.and(filter);
        return resultFilter;
    }

    public void treeNodeClick(TreeNodeEvent e) {
        TreeView treeView = (TreeView)e.getSource();
        Map node = treeView.getTreeState().getFocusNode();
        String nodeId = String.valueOf(node.get("id"));
        if (StringUtils.isEmpty((String)nodeId) || TREE_ROOT_ID.equals(nodeId)) {
            super.treeNodeClick(e);
            return;
        }
        if (!QueryServiceHelper.exists((String)"cad_subelement", (Object)nodeId)) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%s\u6570\u636e\u5df2\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u540e\u518d\u64cd\u4f5c\u3002", (String)"SubElementAccountTreeList_7", (String)"bd-macc-formplugin", (Object[])new Object[0]), node.get("text")));
            this.rebuildTreeNode();
            e.setCancel(true);
            return;
        }
        super.treeNodeClick(e);
    }

    public void beforeItemClick(BeforeItemClickEvent e) {
        switch (e.getItemKey()) {
            case "bar_export": {
                BillList billList = (BillList)this.getControl("billlistap");
                ListSelectedRowCollection rows = billList.getSelectedRows();
                if (rows.size() >= 1) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9700\u8981\u5bfc\u51fa\u7684\u6570\u636e\u3002", (String)"SubElementAccountTreeList_3", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
            }
        }
        super.beforeItemClick(e);
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        switch (evt.getItemKey()) {
            case "bar_addrel": {
                if (!this.isCostAccountRef(Long.parseLong(this.getCacheCostType())).booleanValue()) {
                    DynamicObject costType = QueryServiceHelper.queryOne((String)"cad_costtype", (String)"name", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.parseLong(this.getCacheCostType()))});
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u4e0d\u5141\u8bb8\u8bbe\u7f6e\uff0c%s \u6210\u672c\u7c7b\u578b\u672a\u88ab\u6210\u672c\u8d26\u7c3f\u5f15\u7528", (String)"SubElementAccountTreeList_4", (String)"macc-cad-formplugin", (Object[])new Object[0]), costType.getString("name")));
                    return;
                }
                this.openEditView();
                break;
            }
            case "bar_refresh": {
                this.refreshBillList();
            }
        }
    }

    private Boolean isCostAccountRef(Long costType) {
        DynamicObject[] bdCostAccounts;
        HashSet<Long> costAccountIds = new HashSet<Long>(10);
        QFilter filter = new QFilter("costtype", "=", (Object)costType);
        filter.and(new QFilter("calorg", "in", (Object)OrgHelper.getCurrAccountOrg()));
        for (DynamicObject bdCostAccount : bdCostAccounts = BusinessDataServiceHelper.load((String)"cal_bd_costaccount", (String)"id", (QFilter[])new QFilter[]{filter})) {
            costAccountIds.add(bdCostAccount.getLong("id"));
        }
        if (CadEmptyUtils.isEmpty(costAccountIds)) {
            return false;
        }
        return true;
    }

    private void refreshBillList() {
        this.getView().updateView("billlistap");
        BillList billListTemp = (BillList)this.getControl("billlistap");
        billListTemp.clearSelection();
    }

    private void openEditView() {
        TreeView treeView = (TreeView)this.getControl("treeview");
        TreeView.TreeState treeState = treeView.getTreeState();
        Map focusNode = treeState.getFocusNode();
        Long seId = null;
        if (focusNode != null && !TREE_ROOT_ID.equals(focusNode.get("id"))) {
            seId = Optional.ofNullable(focusNode.get("id")).map(s -> Long.parseLong(s.toString())).orElse(0L);
        }
        if (CadEmptyUtils.isEmpty(seId)) {
            BillList billList = (BillList)this.getControl("billlistap");
            ListSelectedRowCollection rows = billList.getSelectedRows();
            ListSelectedRow row = null;
            if (!CadEmptyUtils.isEmpty((ListSelectedRowCollection)rows) && rows.size() > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u9009\u62e9\u4e00\u6761\u201c\u79d1\u76ee\u201d\u8fdb\u884c\u5173\u7cfb\u7ef4\u62a4\u3002", (String)"SubElementAccountTreeList_5", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                return;
            }
            if (!CadEmptyUtils.isEmpty((ListSelectedRowCollection)rows)) {
                row = rows.get(0);
            }
            if (row != null && row.getPrimaryKeyValue() != null) {
                boolean isExist = QueryServiceHelper.exists((String)"cad_subelement_account", (Object)row.getPrimaryKeyValue());
                if (isExist) {
                    DynamicObject relation = BusinessDataServiceHelper.loadSingle((Object)row.getPrimaryKeyValue(), (String)"cad_subelement_account");
                    seId = relation.getDynamicObject("subelement").getLong("id");
                } else {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u540e\u518d\u64cd\u4f5c\u3002", (String)"SubElementAccountTreeList_2", (String)"macc-cad-formplugin", (Object[])new Object[0]));
                    return;
                }
            }
        }
        FormShowParameter fsp = new FormShowParameter();
        fsp.setFormId("cad_subele_account_edit");
        fsp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        fsp.setCustomParam("costtype", (Object)this.getCacheCostType());
        fsp.setCustomParam("subelement", (Object)seId);
        fsp.setCloseCallBack(new CloseCallBack(((Object)((Object)this)).getClass().getName(), "form"));
        this.getView().showForm(fsp);
    }

    public void closedCallBack(ClosedCallBackEvent e) {
        super.closedCallBack(e);
        this.refreshBillList();
    }

    public void billListHyperLinkClick(HyperLinkClickArgs e) {
        BillList billList = (BillList)this.getControl("billlistap");
        ListSelectedRowCollection rows = billList.getSelectedRows();
        if (!CadEmptyUtils.isEmpty((ListSelectedRowCollection)rows)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u80fd\u9009\u62e9\u4e00\u6761\u201c\u79d1\u76ee\u201d\u8fdb\u884c\u5173\u7cfb\u7ef4\u62a4\u3002", (String)"SubElementAccountTreeList_5", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        if (listShowParameter.isLookUp()) {
            return;
        }
        for (FilterColumn filterColumn : args.getFilterContainerInitEvent().getCommonFilterColumns()) {
            CommonFilterColumn commonFilterColumn = (CommonFilterColumn)filterColumn;
            String fieldName = commonFilterColumn.getFieldName();
            if (!fieldName.startsWith("costtype.")) continue;
            List listcomitem = commonFilterColumn.getComboItems();
            listcomitem.clear();
            String appId = this.getView().getFormShowParameter().getAppId();
            List<ComboItem> costTypes = this.getCostTypeComboItemList(appId);
            if (costTypes != null && !costTypes.isEmpty()) {
                commonFilterColumn.setComboItems(costTypes);
                ComboItem item = costTypes.get(0);
                commonFilterColumn.setDefaultValue(item.getValue());
                this.getPageCache().put("costtype", item.getValue());
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u6ca1\u6709\u53ef\u4f7f\u7528\u7684\u6210\u672c\u7c7b\u578b\u3002", (String)"SubElementAccountTreeList_6", (String)"macc-cad-formplugin", (Object[])new Object[0]));
            }
            if ("aca".equals(appId)) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{"filtergridview"});
            }
            this.rebuildTreeNode();
            break;
        }
    }

    protected List<ComboItem> getCostTypeComboItemList(String appId) {
        ArrayList<ComboItem> acctItems = new ArrayList<ComboItem>();
        if ("aca".equals(appId)) {
            DynamicObject costType = CostTypeHelper.getCostTypesById((Long)CommonConstant.ACA_COST_TYPE_ID);
            ComboItem item = this.makeComboItems(costType);
            acctItems.add(item);
        } else {
            DynamicObject[] costTypes = CostTypeHelper.getCostTypeByOrgsRanges((String)"0");
            if (costTypes == null || costTypes.length == 0) {
                return acctItems;
            }
            for (DynamicObject costType : costTypes) {
                ComboItem item = this.makeComboItems(costType);
                if (acctItems.contains(item) || costType.getLong("id") == CommonConstant.ACA_COST_TYPE_ID.longValue()) continue;
                acctItems.add(item);
            }
        }
        return acctItems;
    }

    private ComboItem makeComboItems(DynamicObject costType) {
        ComboItem item = new ComboItem();
        item.setCaption(new LocaleString(costType.getString("name")));
        item.setValue(costType.getString("id"));
        return item;
    }

    private String getCacheCostType() {
        String id = this.getPageCache().get("costtype");
        if (StringUtils.isEmpty((String)id) && StringUtils.isNotEmpty((String)(id = this.getDefualtSelectCostType()))) {
            this.getPageCache().put("costtype", id);
        }
        return id;
    }

    private String getDefualtSelectCostType() {
        DynamicObject[] costTypes = CostTypeHelper.getCostTypes();
        if (costTypes == null || costTypes.length < 1) {
            return null;
        }
        return String.valueOf(costTypes[0].getLong("id"));
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerSearchClick(args);
        Map filterValues = args.getSearchClickEvent().getFilterValues();
        if (filterValues.get("customfilter") != null) {
            List customfilter = (List)filterValues.get("customfilter");
            if (customfilter.isEmpty()) {
                return;
            }
            Map map = (Map)customfilter.get(0);
            List vals = (List)map.get("Value");
            if (vals == null || vals.isEmpty()) {
                return;
            }
            this.getPageCache().put("costtype", String.valueOf(vals.get(0)));
            this.rebuildTreeNode();
        }
    }

    public void setFilter(SetFilterEvent e) {
        List filters = e.getQFilters();
        if (!CadEmptyUtils.isEmpty((List)filters)) {
            Iterator it = filters.iterator();
            while (it.hasNext()) {
                QFilter filter = (QFilter)it.next();
                if (!"group".equals(filter.getProperty())) continue;
                it.remove();
            }
        }
        e.setOrderBy("number asc,name asc");
    }

    public void click(SearchClickEvent searchClickEvent) {
        super.click((EventObject)searchClickEvent);
    }
}

