/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.assistant.plugin.basedata;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.param.AppParam;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.devportal.BizCloudServiceHelp;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;

public class ProjectOp
extends AbstractOperationServicePlugIn {
    private static final String ISLEAF = "isleaf";

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("parent");
        e.getFieldKeys().add("longnumber");
        e.getFieldKeys().add("fullname");
        e.getFieldKeys().add(ISLEAF);
        e.getFieldKeys().add("number");
        e.getFieldKeys().add("name");
        e.getFieldKeys().add("pmascreateorg");
        e.getFieldKeys().add("department");
        e.getFieldKeys().add("createorg");
        e.getFieldKeys().add("systemtypebase");
        e.getFieldKeys().add("issys");
    }

    public void onAddValidators(final AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator(new AbstractValidator(){

            public void validate() {
                String operateKey;
                switch (operateKey = this.getOperateKey()) {
                    case "submit": {
                        this.validateSubmit(e);
                        break;
                    }
                    case "delete": {
                        this.validateDelete(e);
                        break;
                    }
                    case "unaudit": {
                        this.validateUnAudit(e);
                        break;
                    }
                }
            }

            private void validateSubmit(AddValidatorsEventArgs e2) {
                boolean canUpdateNotSys;
                ExtendedDataEntity[] dataEntities = this.getDataEntities();
                Long orgId = RequestContext.get().getOrgId();
                AppParam appParam = new AppParam();
                appParam.setAppId("basedata");
                appParam.setOrgId(orgId);
                appParam.setViewType("15");
                appParam.setActBookId(Long.valueOf(9999L));
                Object enableUpdateNotSys = ProjectOp.getAppParameter("enableupdatenotsys", "basedata");
                boolean bl = canUpdateNotSys = enableUpdateNotSys != null && (Boolean)enableUpdateNotSys != false;
                if (!canUpdateNotSys) {
                    for (ExtendedDataEntity dataEntity : dataEntities) {
                        String number;
                        DynamicObject systemTypeBase = (DynamicObject)dataEntity.getValue("systemtypebase");
                        boolean isSys = (Boolean)dataEntity.getValue("issys");
                        if (isSys || systemTypeBase == null || !StringUtils.isNotEmpty((CharSequence)(number = systemTypeBase.getString("number"))) || StringUtils.equalsIgnoreCase((CharSequence)"SYS", (CharSequence)number) || StringUtils.equalsIgnoreCase((CharSequence)"BAMP", (CharSequence)number)) continue;
                        String formatText = String.format(ResManager.loadKDString((String)"\u53c2\u6570\u8bbe\u7f6e\u4e0d\u5141\u8bb8\u4fee\u6539\u975e\u57fa\u7840\u670d\u52a1\u4e91\u3001\u7cfb\u7edf\u670d\u52a1\u4e91\u521b\u5efa\u7684%s\u3002", (String)"ProjectOp_4", (String)"bd-assistant-opplugin", (Object[])new Object[0]), dataEntity.getValue("name"));
                        this.addErrorMessage(dataEntity, formatText);
                    }
                }
            }

            private void validateDelete(AddValidatorsEventArgs e2) {
                ExtendedDataEntity[] dataEntities;
                for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
                    DynamicObject obj = dataEntity.getDataEntity();
                    DynamicObject pro = BusinessDataServiceHelper.loadSingle((Object)obj.getPkValue(), (String)"bd_project");
                    DynamicObject proStatus = pro.getDynamicObject("prostatus");
                    if (proStatus != null) {
                        String formatText = String.format(ResManager.loadKDString((String)"\u9879\u76ee\uff1a%s\uff0c\u5df2\u88ab\u7acb\u9879\u4e0d\u80fd\u5220\u9664\u3002", (String)"ProjectOp_0", (String)"bd-assistant-opplugin", (Object[])new Object[0]), obj.getString("name"));
                        this.addErrorMessage(dataEntity, formatText);
                    }
                    QFilter qFilter = new QFilter("parent", "=", obj.getPkValue());
                    DynamicObject[] load = BusinessDataServiceHelper.load((String)"bd_project", (String)"id", (QFilter[])new QFilter[]{qFilter});
                    if (load.length <= 0) continue;
                    String formatText = String.format(ResManager.loadKDString((String)"\u9879\u76ee\uff1a%s\uff0c\u5df2\u5b58\u5728\u5b50\u9879\u76ee\u4e0d\u80fd\u5220\u9664\u3002", (String)"ProjectOp_1", (String)"bd-assistant-opplugin", (Object[])new Object[0]), obj.getString("name"));
                    this.addErrorMessage(dataEntity, formatText);
                }
            }

            private void validateUnAudit(AddValidatorsEventArgs e2) {
                ExtendedDataEntity[] dataEntities;
                for (ExtendedDataEntity dataEntity : dataEntities = this.getDataEntities()) {
                    DynamicObject prostatus;
                    DynamicObject obj = dataEntity.getDataEntity();
                    DynamicObject pro = BusinessDataServiceHelper.loadSingle((Object)obj.getPkValue(), (String)"bd_project");
                    int refCheck = pro.getInt("refcheck");
                    if (refCheck == 1) {
                        DynamicObjectCollection clouds = BizCloudServiceHelp.getAllBizClouds();
                        String cloudName = null;
                        for (DynamicObject cloud : clouds) {
                            if (!cloud.getString("number").equalsIgnoreCase(pro.getString("systemtype"))) continue;
                            cloudName = cloud.getString("name");
                            break;
                        }
                        String formatText = String.format(ResManager.loadKDString((String)"\u8be5\u9879\u76ee\u5df2\u88ab\u201c%s\u201d\u5f15\u7528\uff0c\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"ProjectOp_5", (String)"bd-assistant-opplugin", (Object[])new Object[0]), cloudName);
                        this.addErrorMessage(dataEntity, formatText);
                    }
                    if ((prostatus = pro.getDynamicObject("prostatus")) != null) {
                        String formatText = String.format(ResManager.loadKDString((String)"\u9879\u76ee\uff1a%s\uff0c\u5df2\u88ab\u7acb\u9879\u4e0d\u80fd\u53cd\u5ba1\u6838\u3002", (String)"ProjectOp_2", (String)"bd-assistant-opplugin", (Object[])new Object[0]), obj.getString("name"));
                        this.addErrorMessage(dataEntity, formatText);
                    }
                    QFilter qFilter = new QFilter("parent", "=", obj.getPkValue());
                    DynamicObject[] load = BusinessDataServiceHelper.load((String)"bd_project", (String)"id", (QFilter[])new QFilter[]{qFilter});
                    if (load.length <= 0) continue;
                    String formatText = String.format(ResManager.loadKDString((String)"\u9879\u76ee\uff1a%s\uff0c\u5df2\u5b58\u5728\u5b50\u9879\u76ee\u4e0d\u80fd\u53cd\u5ba1\u6838\u3002", (String)"ProjectOp_3", (String)"bd-assistant-opplugin", (Object[])new Object[0]), obj.getString("name"));
                    this.addErrorMessage(dataEntity, formatText);
                }
            }
        });
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        String operationKey = e.getOperationKey();
        DynamicObject[] dataEntities = e.getDataEntities();
        switch (operationKey) {
            case "submit": {
                for (DynamicObject obj : dataEntities) {
                    if (obj.getDynamicObject("pmascreateorg") == null) {
                        obj.set("pmascreateorg", (Object)obj.getDynamicObject("createorg"));
                    }
                    if (obj.getDynamicObject("department") != null) continue;
                    obj.set("department", (Object)obj.getDynamicObject("createorg"));
                }
                break;
            }
            case "audit": {
                for (DynamicObject obj : dataEntities) {
                    this.updateParentPro(obj);
                }
                break;
            }
            case "delete": {
                this.batchDeleteOperate(dataEntities);
                break;
            }
        }
    }

    protected void batchDeleteOperate(DynamicObject[] dataEntities) {
        DynamicObject[] parents;
        HashMap fatherMap = new HashMap(16);
        for (DynamicObject dynamicObject : dataEntities) {
            DynamicObject parent = dynamicObject.getDynamicObject("parent");
            if (parent == null) continue;
            if (fatherMap.containsKey(parent.getPkValue())) {
                ((Set)fatherMap.get(parent.getPkValue())).add(dynamicObject.getPkValue());
                continue;
            }
            HashSet<Object> children = new HashSet<Object>(16);
            children.add(dynamicObject.getPkValue());
            fatherMap.put(parent.getPkValue(), children);
        }
        HashMap fatherMapDb = new HashMap(16);
        for (Object parentId : fatherMap.keySet()) {
            QFilter qFilter = new QFilter("parent", "=", (Object)Long.valueOf(parentId.toString()));
            DynamicObject[] children = BusinessDataServiceHelper.load((String)"bd_project", (String)"id,parent", (QFilter[])new QFilter[]{qFilter});
            fatherMapDb.put(parentId, Arrays.stream(children).map(DataEntityBase::getPkValue).collect(Collectors.toSet()));
        }
        HashSet<Long> parentSet = new HashSet<Long>(16);
        for (Map.Entry entry : fatherMap.entrySet()) {
            Object parentId = entry.getKey();
            if (((Set)entry.getValue()).size() != ((Set)fatherMapDb.get(parentId)).size()) continue;
            parentSet.add(Long.valueOf(parentId.toString()));
        }
        if (parentSet.isEmpty()) {
            return;
        }
        for (DynamicObject parent : parents = BusinessDataServiceHelper.load((Object[])parentSet.toArray(new Long[0]), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"bd_project"))) {
            parent.set(ISLEAF, (Object)Character.valueOf('1'));
        }
        SaveServiceHelper.save((DynamicObject[])parents);
    }

    private void updateParentPro(DynamicObject obj) {
        boolean aBoolean;
        DynamicObject parentPro;
        DynamicObject parent = (DynamicObject)obj.get("parent");
        if (parent != null && (parentPro = BusinessDataServiceHelper.loadSingle((Object)parent.getPkValue(), (String)"bd_project")) != null && (aBoolean = parentPro.getBoolean(ISLEAF))) {
            parentPro.set(ISLEAF, (Object)Character.valueOf('0'));
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{parentPro});
        }
    }

    public static Object getAppParameter(String paramKey, String appNumber) {
        String appId = BizAppServiceHelp.getAppIdByAppNumber((String)appNumber);
        Long orgId = RequestContext.get().getOrgId();
        Long actBookId = 0L;
        AppParam appParam = new AppParam(appId, "15", orgId, actBookId);
        return SystemParamServiceHelper.loadAppParameterFromCache((AppParam)appParam, (String)paramKey);
    }
}

