/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.assistant.plugin.basedata;

import java.util.Date;
import java.util.HashMap;
import kd.bd.assistant.plugin.basedata.StaffBankCardValidator;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class StaffBankCardServicePlugIn
extends AbstractOperationServicePlugIn {
    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new StaffBankCardValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        RequestContext requestContext = RequestContext.get();
        Long currentUserId = Long.valueOf(requestContext.getUserId());
        DynamicObject sbc = e.getDataEntities()[0];
        Long id = sbc.getLong("id");
        DynamicObjectCollection accounts = sbc.getDynamicObjectCollection("bankaccounts");
        if (id == 0L) {
            sbc.set("fmodifierid", (Object)currentUserId);
            sbc.set("fmodifytime", (Object)new Date());
            for (DynamicObject account : accounts) {
                account.set("accountfmodifierid", (Object)currentUserId);
                account.set("accountfmodifytime", (Object)new Date());
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{sbc});
            return;
        }
        if (accounts.isEmpty()) {
            DeleteServiceHelper.delete((IDataEntityType)sbc.getDataEntityType(), (Object[])new Object[]{id});
            return;
        }
        DynamicObject dbSbc = BusinessDataServiceHelper.loadSingle((Object)sbc.getLong("id"), (String)"staffbankcard");
        DynamicObjectCollection dbAccounts = dbSbc.getDynamicObjectCollection("bankaccounts");
        this.setAcctWho(e.getOperationKey(), accounts, dbAccounts, currentUserId);
        dbSbc.set("fmodifierid", (Object)currentUserId);
        dbSbc.set("fmodifytime", (Object)new Date());
        dbSbc.set("bankaccounts", (Object)sbc.getDynamicObjectCollection("bankaccounts"));
        if ("saveedit".equals(e.getOperationKey())) {
            return;
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dbSbc});
    }

    private void setAcctWho(String operationKey, DynamicObjectCollection accounts, DynamicObjectCollection dbAccounts, Long currentUserId) {
        if (!"saveedit".equals(operationKey)) {
            for (DynamicObject acc : accounts) {
                acc.set("accountfmodifierid", (Object)currentUserId);
                acc.set("accountfmodifytime", (Object)new Date());
            }
        }
        HashMap accountMap = new HashMap();
        for (DynamicObject acc : dbAccounts) {
            accountMap.put(this.getkeys(acc), null);
        }
        for (DynamicObject acc : accounts) {
            if (accountMap.containsKey(this.getkeys(acc))) continue;
            acc.set("accountfmodifierid", (Object)currentUserId);
            acc.set("accountfmodifytime", (Object)new Date());
        }
    }

    private String getkeys(DynamicObject acc) {
        StringBuilder accStr = new StringBuilder();
        accStr.append(acc.get("faccno")).append("##");
        accStr.append(acc.get("faccusername")).append("##");
        accStr.append(acc.get("ffinorginfoid")).append("##");
        accStr.append(acc.get("fcurrencyid")).append("##");
        accStr.append(acc.get("fisdefault")).append("##");
        accStr.append(acc.get("fremark")).append("##");
        return accStr.toString();
    }
}

