/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.assistant.plugin.basedata.bebank;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bd.assistant.plugin.basedata.bebank.BebankSaveValidator;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class BebankSaveOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("country");
        fieldKeys.add("province");
        fieldKeys.add("city");
        fieldKeys.add("provincetxt");
        fieldKeys.add("citytxt");
        fieldKeys.add("union_number");
        fieldKeys.add("name");
        fieldKeys.add("number");
        fieldKeys.add("isfromcloud");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new BebankSaveValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        DynamicObject[] beBanks = e.getDataEntities();
        List beBankIds = Arrays.stream(beBanks).map(DataEntityBase::getPkValue).collect(Collectors.toList());
        QFilter[] qFilters = new QFilter[]{new QFilter("id", "in", beBankIds)};
        DynamicObjectCollection beBankFromDBs = QueryServiceHelper.query((String)"bd_bebank", (String)"id,country,provincetxt,citytxt,union_number,name,number", (QFilter[])qFilters);
        if (beBankFromDBs != null && beBankFromDBs.size() > 0) {
            for (DynamicObject beBank : beBanks) {
                Optional<DynamicObject> first;
                boolean isFromCloud = beBank.getBoolean("isfromcloud");
                if (!isFromCloud || !(first = beBankFromDBs.stream().filter(o -> o.getLong("id") == ((Long)beBank.getPkValue()).longValue()).findFirst()).isPresent()) continue;
                DynamicObject beBankDB = first.get();
                long counttryId = beBank.getLong("country.id");
                if (beBankDB.getLong("country") == counttryId && beBankDB.getString("provincetxt").equalsIgnoreCase(beBank.getString("provincetxt")) && beBankDB.getString("citytxt").equalsIgnoreCase(beBank.getString("citytxt")) && beBankDB.getString("union_number").equalsIgnoreCase(beBank.getString("union_number")) && beBankDB.getString("name").equalsIgnoreCase(beBank.getString("name")) && beBankDB.getString("number").equalsIgnoreCase(beBank.getString("number"))) continue;
                beBank.set("isfromcloud", (Object)"0");
            }
        }
    }
}

