/*
 * Decompiled with CFR 0.152.
 */
package kd.bd.assistant.plugin.bom;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class BOMVersionSaveValidatorNew
extends AbstractValidator {
    private static final String OPERATE_SAVE = "save";
    private static final String KEY_BOMVERSION = "bd_bomversion_new";

    public void validate() {
        String operate = this.getOperateKey();
        if (OPERATE_SAVE.equals(operate)) {
            ExtendedDataEntity[] objs = this.getDataEntities();
            Map<Long, Boolean> ruleIsCheckDateMap = this.getRuleIsCheckDate(objs);
            HashMap<String, Set<Long>> typeMaterialIdMap = new HashMap<String, Set<Long>>(16);
            HashMap<String, Set<Long>> typeMaterialGroupIdMap = new HashMap<String, Set<Long>>(16);
            HashMap<String, Set<Long>> typeBomVersionRuleIdMap = new HashMap<String, Set<Long>>(16);
            for (ExtendedDataEntity obj : objs) {
                Date effectdate;
                String number;
                DynamicObject bomversion = obj.getDataEntity();
                DynamicObject material = bomversion.getDynamicObject("material");
                DynamicObject materialGroup = bomversion.getDynamicObject("materialgroup");
                String type = bomversion.getString("type");
                boolean isRt = "B".equals(type);
                if (!isRt && material == null) {
                    this.addErrorMessage(obj, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u7269\u6599\u3002", (String)"BOMVersionSaveValidator_0", (String)"bd-assistant-opplugin", (Object[])new Object[0]));
                    continue;
                }
                if (isRt && material != null && materialGroup != null) {
                    this.addErrorMessage(obj, ResManager.loadKDString((String)"\u5de5\u827a\u8def\u7ebf\u7248\u672c\u4e0d\u5141\u8bb8\u540c\u65f6\u5f55\u5165\u7269\u6599\u548c\u7269\u6599\u63a7\u5236\u7ec4\u3002", (String)"BOMVersionSaveValidator_11", (String)"bd-assistant-opplugin", (Object[])new Object[0]));
                    continue;
                }
                DynamicObject bomversionrule = bomversion.getDynamicObject("bomversionrule");
                if (bomversionrule == null) {
                    this.addErrorMessage(obj, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u7248\u672c\u89c4\u5219\u3002", (String)"BOMVersionSaveValidator_2", (String)"bd-assistant-opplugin", (Object[])new Object[0]));
                    continue;
                }
                String name = bomversion.getString("name");
                if (StringUtils.isBlank((CharSequence)name)) {
                    this.addErrorMessage(obj, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u7248\u672c\u3002", (String)"BOMVersionSaveValidator_3", (String)"bd-assistant-opplugin", (Object[])new Object[0]));
                    continue;
                }
                boolean existVersion = this.checkRuleExistVersion(bomversionrule, name);
                if (!existVersion) {
                    number = bomversionrule.getString("number") == null ? "" : bomversionrule.getString("number");
                    this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"\u7248\u672c\u89c4\u5219[%1$s]\u4e2d\u4e0d\u5b58\u5728\u7248\u672c[%2$s]\uff0c\u8bf7\u4fee\u6539\u3002", (String)"BOMVersionSaveValidator_8", (String)"bd-assistant-opplugin", (Object[])new Object[0]), number, name));
                    continue;
                }
                number = bomversion.getString("number");
                if (null == number || "".equals(number)) {
                    String materNum = material == null ? "" : material.getString("number");
                    String materGroupNum = materialGroup == null ? "" : materialGroup.getString("number");
                    String ruleNum = bomversionrule.getString("number");
                    String nums = materNum + "-";
                    if (isRt) {
                        if (kd.bos.util.StringUtils.isEmpty((String)materNum) && !kd.bos.util.StringUtils.isEmpty((String)materGroupNum)) {
                            nums = materGroupNum + "-";
                        }
                        if (kd.bos.util.StringUtils.isEmpty((String)materNum) && kd.bos.util.StringUtils.isEmpty((String)materGroupNum)) {
                            nums = "";
                        }
                    }
                    bomversion.set("number", (Object)(nums + ruleNum + "-" + ("B".equals(type) ? "route" : ("C".equals(type) ? "formula" : "bom")) + "-" + name));
                }
                if ((effectdate = bomversion.getDate("effectdate")) == null) {
                    this.addErrorMessage(obj, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u751f\u6548\u65f6\u95f4\u3002", (String)"BOMVersionSaveValidator_4", (String)"bd-assistant-opplugin", (Object[])new Object[0]));
                    continue;
                }
                Date invaliddate = bomversion.getDate("invaliddate");
                if (invaliddate == null) {
                    this.addErrorMessage(obj, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5931\u6548\u65f6\u95f4\u3002", (String)"BOMVersionSaveValidator_5", (String)"bd-assistant-opplugin", (Object[])new Object[0]));
                    continue;
                }
                if (effectdate.after(invaliddate)) {
                    this.addErrorMessage(obj, ResManager.loadKDString((String)"\u751f\u6548\u65f6\u95f4\u5fc5\u987b\u5c0f\u4e8e\u5931\u6548\u65f6\u95f4\u3002", (String)"BOMVersionSaveValidator_6", (String)"bd-assistant-opplugin", (Object[])new Object[0]));
                    continue;
                }
                boolean isCheckDate = true;
                DataEntityPropertyCollection properties = bomversionrule.getDynamicObjectType().getProperties();
                if (properties.containsKey((Object)"ischeckdate")) {
                    isCheckDate = bomversionrule.getBoolean("ischeckdate");
                } else if (ruleIsCheckDateMap.containsKey(bomversionrule.getLong("id"))) {
                    isCheckDate = ruleIsCheckDateMap.get(bomversionrule.getLong("id"));
                }
                if (!isCheckDate) continue;
                this.addToMap(typeBomVersionRuleIdMap, type, bomversionrule);
                if (material != null) {
                    this.addToMap(typeMaterialIdMap, type, material);
                }
                if (materialGroup == null) continue;
                this.addToMap(typeMaterialGroupIdMap, type, materialGroup);
            }
            if (typeBomVersionRuleIdMap.isEmpty()) {
                return;
            }
            this.checkBomVersionDate(objs, typeMaterialIdMap, typeMaterialGroupIdMap, typeBomVersionRuleIdMap);
        }
    }

    private void addToMap(Map<String, Set<Long>> maps, String keys, DynamicObject obj) {
        Object pkId;
        Set<Long> sets = maps.get(keys);
        if (sets == null) {
            sets = new HashSet<Long>(16);
        }
        if ((pkId = obj.getPkValue()) instanceof Long) {
            sets.add((Long)pkId);
            maps.put(keys, sets);
        }
    }

    private Map<Long, Boolean> getRuleIsCheckDate(ExtendedDataEntity[] objs) {
        DynamicObjectCollection bomVersionRuleDOC;
        HashSet<Long> bomVersionRulePks = new HashSet<Long>(16);
        HashMap<Long, Boolean> isCheckDateMap = new HashMap<Long, Boolean>(16);
        for (ExtendedDataEntity obj : objs) {
            DynamicObject bomversion = obj.getDataEntity();
            DynamicObject bomversionrule = bomversion.getDynamicObject("bomversionrule");
            if (bomversionrule == null) continue;
            bomVersionRulePks.add(bomversionrule.getLong("id"));
        }
        if (!bomVersionRulePks.isEmpty() && (bomVersionRuleDOC = QueryServiceHelper.query((String)"bd_bomversionrule_new", (String)"id,ischeckdate", (QFilter[])new QFilter[]{new QFilter("id", "in", bomVersionRulePks)})) != null) {
            for (DynamicObject bomVersionRule : bomVersionRuleDOC) {
                long rulePkValue = bomVersionRule.getLong("id");
                boolean isCheckDate = bomVersionRule.getBoolean("ischeckdate");
                isCheckDateMap.put(rulePkValue, isCheckDate);
            }
        }
        return isCheckDateMap;
    }

    public void checkBomVersionDate(ExtendedDataEntity[] objs, Map<String, Set<Long>> typeMaterialIdMap, Map<String, Set<Long>> typeMaterialGroupIdMap, Map<String, Set<Long>> typeBomVersionRuleIdMap) {
        if (objs == null) {
            return;
        }
        Map<Object, Object> bomVersionMap = new HashMap(16);
        bomVersionMap = this.queryBomVersionInfo(typeMaterialIdMap, typeMaterialGroupIdMap, typeBomVersionRuleIdMap);
        block0: for (int i = 0; i < objs.length; ++i) {
            Date invaliddate;
            Date effectdate;
            ExtendedDataEntity obj = objs[i];
            DynamicObject bomversion = obj.getDataEntity();
            if (bomversion == null) continue;
            StringBuilder materialBomVersionRuleKey = new StringBuilder();
            String type = bomversion.getString("type");
            DynamicObject material = bomversion.getDynamicObject("material");
            DynamicObject materialGroup = bomversion.getDynamicObject("materialgroup");
            if (material != null && material.getPkValue() != null) {
                materialBomVersionRuleKey.append(String.valueOf(material.getPkValue()));
            } else {
                materialBomVersionRuleKey.append("0");
            }
            materialBomVersionRuleKey.append(":");
            if (materialGroup != null && materialGroup.getPkValue() != null) {
                materialBomVersionRuleKey.append(String.valueOf(materialGroup.getPkValue()));
            } else {
                materialBomVersionRuleKey.append("0");
            }
            materialBomVersionRuleKey.append(":");
            DynamicObject bomversionrule = bomversion.getDynamicObject("bomversionrule");
            if (bomversionrule != null && bomversionrule.getPkValue() != null) {
                materialBomVersionRuleKey.append(String.valueOf(bomversionrule.getPkValue()));
            } else {
                materialBomVersionRuleKey.append("0");
            }
            materialBomVersionRuleKey.append(":");
            materialBomVersionRuleKey.append(type);
            List bomVerseionList = (List)bomVersionMap.get(materialBomVersionRuleKey.toString());
            String name = bomversion.getString("name");
            if (StringUtils.isBlank((CharSequence)name) || (effectdate = bomversion.getDate("effectdate")) == null || (invaliddate = bomversion.getDate("invaliddate")) == null || effectdate.after(invaliddate)) continue;
            DynamicObject versionName = bomversion.getDynamicObject("versionname");
            if (bomVerseionList == null || versionName == null) continue;
            int currentSeq = versionName.getInt("entrySeq");
            String materialMsg = this.getMaterialMsg(material, materialGroup);
            for (DynamicObject version : bomVerseionList) {
                Date oldeffectdate = version.getDate("effectdate");
                Date oldinvaliddate = version.getDate("invaliddate");
                int oldSeq = version.getInt("seq");
                if (oldeffectdate == null || oldinvaliddate == null || version.getString("id").equals(bomversion.getPkValue().toString())) continue;
                if (oldeffectdate.compareTo(effectdate) >= 0 && currentSeq > oldSeq) {
                    this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"%1$s\u5f53\u524d\u7248\u672c\u201c%2$s\u201d\u7684\u751f\u6548\u65f6\u95f4\u2264\u4f4e\u7248\u672c\u201c%3$s\u201d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"BOMVersionSaveValidator_9", (String)"bd-assistant-opplugin", (Object[])new Object[0]), materialMsg, name, version.getString("name")));
                    continue block0;
                }
                if (currentSeq >= oldSeq || oldeffectdate.compareTo(effectdate) > 0) continue;
                this.addErrorMessage(obj, String.format(ResManager.loadKDString((String)"%1$s\u5f53\u524d\u7248\u672c\u201c%2$s\u201d\u7684\u751f\u6548\u65f6\u95f4\u2265\u9ad8\u7248\u672c\u201c%3$s\u201d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"BOMVersionSaveValidator_10", (String)"bd-assistant-opplugin", (Object[])new Object[0]), materialMsg, name, version.getString("name")));
                continue block0;
            }
        }
    }

    private String getMaterialMsg(DynamicObject material, DynamicObject materialGroup) {
        if (material != null) {
            return String.format(ResManager.loadKDString((String)"\u7269\u6599\u201c%1$s\u201d", (String)"BOMVersionSaveValidator_12", (String)"bd-assistant-opplugin", (Object[])new Object[0]), material.getString("number"));
        }
        if (materialGroup != null) {
            return String.format(ResManager.loadKDString((String)"\u7269\u6599\u63a7\u5236\u7ec4\u201c%1$s\u201d", (String)"BOMVersionSaveValidator_13", (String)"bd-assistant-opplugin", (Object[])new Object[0]), materialGroup.getString("number"));
        }
        return "";
    }

    public Map<String, List<DynamicObject>> queryBomVersionInfo(Map<String, Set<Long>> typeMaterialIdMap, Map<String, Set<Long>> typeMaterialGroupIdMap, Map<String, Set<Long>> typeBomVersionRuleIdMap) {
        HashMap<String, List<DynamicObject>> bomVersionMap = new HashMap<String, List<DynamicObject>>(16);
        for (Map.Entry<String, Set<Long>> entrys : typeBomVersionRuleIdMap.entrySet()) {
            boolean bomVersionRuleEmpty;
            String type = entrys.getKey();
            Set<Long> bomVersionRuleSet = entrys.getValue();
            boolean bl = bomVersionRuleEmpty = bomVersionRuleSet == null || bomVersionRuleSet.isEmpty();
            if (bomVersionRuleEmpty) continue;
            Set<Long> materialGroupSet = typeMaterialGroupIdMap.get(type);
            Set<Long> materialSet = typeMaterialIdMap.get(type);
            if (materialGroupSet == null) {
                materialGroupSet = new HashSet<Long>(16);
            }
            if (materialSet == null) {
                materialSet = new HashSet<Long>(16);
            }
            materialGroupSet.add(0L);
            materialSet.add(0L);
            QFilter matQ = new QFilter("material", "in", materialSet);
            QFilter matGroupQ = new QFilter("materialgroup", "in", materialGroupSet);
            QFilter ruleQ = new QFilter("bomversionrule", "in", bomVersionRuleSet);
            QFilter typeQ = new QFilter("type", "=", (Object)type);
            String selectFields = "type,material,materialgroup,bomversionrule,name,effectdate,invaliddate,id,versionname.entrySeq seq";
            DynamicObjectCollection versions = QueryServiceHelper.query((String)KEY_BOMVERSION, (String)selectFields, (QFilter[])new QFilter[]{matQ, matGroupQ, ruleQ, typeQ});
            if (versions == null || versions.isEmpty()) continue;
            for (DynamicObject vsrsionDO : versions) {
                List<DynamicObject> list;
                StringBuilder keyInfo = new StringBuilder();
                Long material = vsrsionDO.get("material") == null ? 0L : vsrsionDO.getLong("material");
                Long materialGroup = vsrsionDO.get("materialgroup") == null ? 0L : vsrsionDO.getLong("materialgroup");
                keyInfo.append(material);
                keyInfo.append(":");
                keyInfo.append(materialGroup);
                keyInfo.append(":");
                Long bomversionrule = vsrsionDO.getLong("bomversionrule");
                keyInfo.append(bomversionrule);
                keyInfo.append(":");
                keyInfo.append(type);
                if (bomVersionMap.containsKey(keyInfo.toString())) {
                    list = (List)bomVersionMap.get(keyInfo.toString());
                    list.add(vsrsionDO);
                    bomVersionMap.put(keyInfo.toString(), list);
                    continue;
                }
                list = new ArrayList(16);
                list.add(vsrsionDO);
                bomVersionMap.put(keyInfo.toString(), list);
            }
        }
        return bomVersionMap;
    }

    private boolean checkRuleExistVersion(DynamicObject bomversionrule, String name) {
        boolean exsitFlag = false;
        if (bomversionrule == null) {
            return exsitFlag;
        }
        DynamicObjectCollection versionDOC = bomversionrule.getDynamicObjectCollection("entryentity");
        if (versionDOC == null) {
            return exsitFlag;
        }
        for (int i = 0; i < versionDOC.size(); ++i) {
            String vsersionStr;
            DynamicObject vsersionDo = (DynamicObject)versionDOC.get(i);
            if (vsersionDo == null || !StringUtils.equals((CharSequence)name, (CharSequence)(vsersionStr = vsersionDo.getString("version")))) continue;
            exsitFlag = true;
        }
        return exsitFlag;
    }
}

