/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.permission.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.FilterValue;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class PermFilterConditionUtil {
    private static final Log logger = LogFactory.getLog(PermFilterConditionUtil.class);

    public static boolean compareFilterCondition(String ruleText1, String ruleTex2) {
        try {
            FilterCondition o1 = (FilterCondition)SerializationUtils.fromJsonString((String)ruleText1, FilterCondition.class);
            FilterCondition o2 = (FilterCondition)SerializationUtils.fromJsonString((String)ruleTex2, FilterCondition.class);
            HashMap<String, List> map1 = new HashMap<String, List>(8);
            List filterRow1 = o1.getFilterRow();
            for (SimpleFilterRow filterRow : filterRow1) {
                map1.computeIfAbsent(filterRow.getCompareType() + filterRow.getFieldName() + filterRow.getEntityNumber(), k -> new ArrayList(10)).addAll(filterRow.getValue());
            }
            HashMap<String, List> map2 = new HashMap<String, List>(8);
            List filterRow2 = o2.getFilterRow();
            for (SimpleFilterRow simpleFilterRow : filterRow2) {
                map2.computeIfAbsent(simpleFilterRow.getCompareType() + simpleFilterRow.getFieldName() + simpleFilterRow.getEntityNumber(), k -> new ArrayList(10)).addAll(simpleFilterRow.getValue());
            }
            if ((null == map1 || map1.isEmpty()) && (null == map2 || map2.isEmpty())) {
                return true;
            }
            if (null != map1 && !map1.isEmpty() && (null == map2 || map2.isEmpty())) {
                return false;
            }
            if ((null == map1 || map1.isEmpty()) && null != map2 && !map2.isEmpty()) {
                return false;
            }
            if (map1.size() != map2.size()) {
                return false;
            }
            if (!map1.keySet().containsAll(map2.keySet())) {
                return false;
            }
            for (Map.Entry entry : map1.entrySet()) {
                Set vSet2;
                String key = (String)entry.getKey();
                List valueList = (List)entry.getValue();
                List value2List = (List)map2.get(key);
                if ((null == valueList || valueList.isEmpty()) && null != value2List && !value2List.isEmpty()) {
                    return false;
                }
                if (null != valueList && !valueList.isEmpty() && (null == value2List || value2List.isEmpty())) {
                    return false;
                }
                if (null == valueList || valueList.isEmpty() || null == value2List || value2List.isEmpty()) continue;
                Set vSet1 = valueList.stream().map(FilterValue::getValue).collect(Collectors.toSet());
                if (!vSet1.containsAll(vSet2 = value2List.stream().map(FilterValue::getValue).collect(Collectors.toSet()))) {
                    return false;
                }
                if (vSet2.containsAll(vSet1)) continue;
                return false;
            }
            return true;
        }
        catch (Exception e) {
            logger.error("PermFilterConditionUtil.compareFilterCondition error", (Throwable)e);
            return false;
        }
    }
}

