/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.workflow.engine.msg;

import java.util.Arrays;
import java.util.List;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.workflow.MultiLangEnumBridge;

public enum MessageTypeEnum {
    TODO("todo", new MultiLangEnumBridge("\u5f85\u529e\u6d88\u606f", "MessageTypeEnum_0", "bos-mservice-workflow-api")),
    URGENCY("urgency", new MultiLangEnumBridge("\u7d27\u6025\u6d88\u606f", "MessageTypeEnum_1", "bos-mservice-workflow-api")),
    REJECT("reject", new MultiLangEnumBridge("\u9a73\u56de\u6d88\u606f", "MessageTypeEnum_2", "bos-mservice-workflow-api")),
    ADDSIGN("addsign", new MultiLangEnumBridge("\u52a0\u7b7e\u6d88\u606f", "MessageTypeEnum_3", "bos-mservice-workflow-api")),
    TRANSFER("transfer", new MultiLangEnumBridge("\u8f6c\u4ea4\u6d88\u606f", "MessageTypeEnum_4", "bos-mservice-workflow-api")),
    CIRCULATION("circulation", new MultiLangEnumBridge("\u4f20\u9605\u6d88\u606f", "MessageTypeEnum_5", "bos-mservice-workflow-api")),
    REMINDERS("reminder", new MultiLangEnumBridge("\u50ac\u529e\u6d88\u606f", "MessageTypeEnum_6", "bos-mservice-workflow-api")),
    WARNING("warning", new MultiLangEnumBridge("\u9884\u8b66\u6d88\u606f", "MessageTypeEnum_7", "bos-mservice-workflow-api")),
    COORDINATE("coordinate", new MultiLangEnumBridge("\u534f\u529e\u6d88\u606f", "MessageTypeEnum_8", "bos-mservice-workflow-api")),
    COORDINATEREPLY("coordinateReply", new MultiLangEnumBridge("\u56de\u590d\u534f\u529e\u6d88\u606f", "MessageTypeEnum_9", "bos-mservice-workflow-api")),
    ADMINALARM("alarmNotation", new MultiLangEnumBridge("\u6d41\u7a0b\u8b66\u544a", "MessageTypeEnum_10", "bos-mservice-workflow-api")),
    WITHDRAW("withdraw", new MultiLangEnumBridge("\u64a4\u56de\u6d88\u606f", "MessageTypeEnum_11", "bos-mservice-workflow-api")),
    PROCEND("procend", new MultiLangEnumBridge("\u7ed3\u675f\u6d88\u606f", "MessageTypeEnum_12", "bos-mservice-workflow-api")),
    COMPLETEDELEGATE("completeDelegate", new MultiLangEnumBridge("\u5b8c\u6210\u59d4\u6258", "MessageTypeEnum_13", "bos-mservice-workflow-api")),
    SUBSCRIBETRANFER("transferCompleteNotation", new MultiLangEnumBridge("\u8ba2\u9605\u8f6c\u4ea4\u7ed3\u679c", "MessageTypeEnum_14", "bos-mservice-workflow-api")),
    SUBSCRIBEYZJRESULT("jointApprovalNotation", new MultiLangEnumBridge("\u8ba2\u9605\u4f1a\u5ba1\u7ed3\u679c", "MessageTypeEnum_15", "bos-mservice-workflow-api"));

    private String number;
    private String name;
    private MultiLangEnumBridge nameBridge;
    private static List<String> tasks;

    private MessageTypeEnum(String number, String name) {
        this.number = number;
        this.name = name;
    }

    private MessageTypeEnum(String number, MultiLangEnumBridge name) {
        this.number = number;
        this.nameBridge = name;
    }

    public String getNumber() {
        return this.number;
    }

    public String getName() {
        return this.nameBridge.loadKDString();
    }

    public static List<String> getTasks() {
        if (tasks == null || tasks.isEmpty()) {
            String[] arr = new String[]{CIRCULATION.getNumber(), COORDINATE.getNumber(), COORDINATEREPLY.getNumber(), REMINDERS.getNumber(), WITHDRAW.getNumber(), ADDSIGN.getNumber()};
            tasks = Arrays.asList(arr);
        }
        return tasks;
    }

    public static boolean isTaskMessageType(String scene) {
        return scene != null && MessageTypeEnum.getTasks() != null && MessageTypeEnum.getTasks().contains(scene);
    }

    public static boolean isExecutionMessageType(String scene) {
        return scene != null && scene.equalsIgnoreCase(PROCEND.getNumber());
    }

    public static boolean isHisTaskMessageType(String scene) {
        return scene != null && (scene.equalsIgnoreCase(COMPLETEDELEGATE.getNumber()) || scene.equalsIgnoreCase(SUBSCRIBETRANFER.getNumber()) || scene.equalsIgnoreCase(SUBSCRIBEYZJRESULT.getNumber()));
    }

    public static boolean isExit(String scene) {
        if (StringUtils.isNotBlank((CharSequence)scene)) {
            for (MessageTypeEnum messageScene : MessageTypeEnum.values()) {
                if (!messageScene.getNumber().equals(scene)) continue;
                return true;
            }
        }
        return false;
    }

    static {
        tasks = null;
    }
}

