/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.api.result;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import kd.bos.openapi.api.util.Pair;

public class ApiSaveError
implements Serializable {
    private static final long serialVersionUID = -7842162313783741697L;
    private boolean success = true;
    private int index;
    private String entryKey;
    private final Set<Pair<String, String>> candidateKeySet = new TreeSet<Pair>(Comparator.comparing(Pair::getKey));
    private final Set<String> errorSet = new HashSet<String>();
    private final List<ApiSaveError> childErrorList = new ArrayList<ApiSaveError>();

    public ApiSaveError() {
    }

    public ApiSaveError(int index) {
        this.index = index;
    }

    public int getIndex() {
        return this.index;
    }

    public String getEntryKey() {
        return this.entryKey;
    }

    public void setEntryKey(String entryKey) {
        this.entryKey = entryKey;
    }

    public Set<Pair<String, String>> getCandidateKeySet() {
        return this.candidateKeySet;
    }

    public Map<String, String> getKeys() {
        HashMap<String, String> map = new HashMap<String, String>(this.candidateKeySet.size());
        for (Pair<String, String> pair : this.candidateKeySet) {
            map.put(pair.getKey(), pair.getValue());
        }
        return map;
    }

    public void addCandidateKey(String key, Object value) {
        this.candidateKeySet.add(new Pair<String, String>(key, ApiSaveError.s(value)));
    }

    public boolean isSuccess() {
        return this.success;
    }

    public Set<String> getErrorSet() {
        return this.errorSet;
    }

    public void addError(String errorMsg, Object ... params) {
        this.errorSet.add(String.format(errorMsg, params));
        this.success = false;
    }

    public List<ApiSaveError> getChildErrorList() {
        return this.childErrorList;
    }

    public void addChildError(ApiSaveError child) {
        if (!child.isSuccess()) {
            this.success = false;
        }
        this.childErrorList.add(child);
    }

    public static String s(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof BigDecimal) {
            return ((BigDecimal)o).toPlainString();
        }
        String s = o.toString();
        if (s == null) {
            return null;
        }
        return (s = s.trim()).length() == 0 ? null : s;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ApiSaveError apiSaveError = (ApiSaveError)o;
        return this.success == apiSaveError.success && this.index == apiSaveError.index && this.candidateKeySet.equals(apiSaveError.candidateKeySet) && this.errorSet.equals(apiSaveError.errorSet) && this.childErrorList.equals(apiSaveError.childErrorList);
    }

    public int hashCode() {
        return Objects.hash(this.success, this.index, this.candidateKeySet, this.errorSet, this.childErrorList);
    }
}

