/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.api.result;

import java.io.Serializable;
import kd.bos.openapi.api.model.OpenApiResponse;

public class ApiServiceData<T>
implements Serializable {
    private static final long serialVersionUID = -534626517195851237L;
    private boolean status;
    private OpenApiResponse<T> response;
    private String pluginInstanceId;
    private int modelTimeCost;
    private String errorCode = "";
    private String message;
    private Throwable stack;

    public ApiServiceData() {
    }

    public static <T> ApiServiceData<T> ofTrue(OpenApiResponse<T> response, long modelTimeCost) {
        return ApiServiceData.of(true, response, modelTimeCost);
    }

    public static <T> ApiServiceData<T> ofTrue(OpenApiResponse<T> response, long startTime, long endTime) {
        return ApiServiceData.ofTrue(response, endTime - startTime);
    }

    public static <T> ApiServiceData<T> ofFalse(OpenApiResponse<T> response, long modelTimeCost) {
        return ApiServiceData.ofFalse(response, modelTimeCost, null);
    }

    public static <T> ApiServiceData<T> ofFalse(String errorCode, String message, OpenApiResponse<T> response, long modelTimeCost, Throwable stack) {
        return ApiServiceData.of(false, response, modelTimeCost, errorCode, message, stack);
    }

    public static <T> ApiServiceData<T> ofFalse(String errorCode, String message, OpenApiResponse<T> response, long modelTimeCost) {
        return ApiServiceData.of(false, response, modelTimeCost, errorCode, message, null);
    }

    public static <T> ApiServiceData<T> ofFalse(OpenApiResponse<T> response, long modelTimeCost, Throwable stack) {
        return ApiServiceData.of(false, response, modelTimeCost, null, null, stack);
    }

    public static <T> ApiServiceData<T> of(boolean status, OpenApiResponse<T> response, long modelTimeCost) {
        return ApiServiceData.of(status, response, modelTimeCost, null, null, null);
    }

    public static <T> ApiServiceData<T> of(boolean status, OpenApiResponse<T> response, long modelTimeCost, Throwable stack) {
        return ApiServiceData.of(status, response, modelTimeCost, null, null, stack);
    }

    public static <T> ApiServiceData<T> of(boolean status, OpenApiResponse<T> response, long modelTimeCost, String errorCode, String message, Throwable stack) {
        return new ApiServiceData<T>(status, response, modelTimeCost, errorCode, message, stack);
    }

    public ApiServiceData(boolean status, OpenApiResponse<T> response, long modelTimeCost, String errorCode, String message, Throwable stack) {
        this.status = status;
        this.response = response;
        this.modelTimeCost = Math.toIntExact(modelTimeCost);
        this.errorCode = errorCode;
        this.message = message;
        this.stack = stack;
    }

    public boolean isStatus() {
        return this.status;
    }

    public void setStatus(boolean status) {
        this.status = status;
    }

    public int getModelTimeCost() {
        return this.modelTimeCost;
    }

    public void setModelTimeCost(int modelTimeCost) {
        this.modelTimeCost = modelTimeCost;
    }

    public Throwable getStack() {
        return this.stack;
    }

    public void setStack(Throwable stack) {
        this.stack = stack;
    }

    public OpenApiResponse<T> getResponse() {
        return this.response;
    }

    public void setResponse(OpenApiResponse<T> response) {
        this.response = response;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getPluginInstanceId() {
        return this.pluginInstanceId;
    }

    public void setPluginInstanceId(String pluginInstanceId) {
        this.pluginInstanceId = pluginInstanceId;
    }
}

