/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.openapi.api.util;

import java.util.ArrayList;
import java.util.Map;
import kd.bos.openapi.api.model.OpenApiRequest;
import kd.bos.openapi.api.params.ApiAppendEntryRowsParam;
import kd.bos.openapi.api.params.ApiAuditParam;
import kd.bos.openapi.api.params.ApiDeleteEntryRowsParam;
import kd.bos.openapi.api.params.ApiDeleteParam;
import kd.bos.openapi.api.params.ApiParam;
import kd.bos.openapi.api.params.ApiQueyParam;
import kd.bos.openapi.api.params.ApiSaveParam;
import kd.bos.openapi.api.params.ApiSubmitParam;
import kd.bos.openapi.api.params.ApiUnAuditParam;
import kd.bos.openapi.api.params.ApiUnSubmitParam;
import kd.bos.openapi.api.params.BaseFilterParam;
import kd.bos.openapi.api.plugin.ApiAppendEntryRowsPlugin;
import kd.bos.openapi.api.plugin.ApiAuditPlugin;
import kd.bos.openapi.api.plugin.ApiCommonPlugin;
import kd.bos.openapi.api.plugin.ApiDeleteEntryRowsPlugin;
import kd.bos.openapi.api.plugin.ApiDeletePlugin;
import kd.bos.openapi.api.plugin.ApiDisablePlugin;
import kd.bos.openapi.api.plugin.ApiEnablePlugin;
import kd.bos.openapi.api.plugin.ApiQueryPlugin;
import kd.bos.openapi.api.plugin.ApiSavePlugin;
import kd.bos.openapi.api.plugin.ApiSubmitPlugin;
import kd.bos.openapi.api.plugin.ApiUnAuditPlugin;
import kd.bos.openapi.api.plugin.ApiUnSubmitPlugin;
import kd.bos.openapi.api.plugin.upper.ApiPlugin;
import kd.bos.openapi.api.result.ApiAuditResult;
import kd.bos.openapi.api.result.ApiDeleteResult;
import kd.bos.openapi.api.result.ApiQueryResult;
import kd.bos.openapi.api.result.ApiSaveItemData;
import kd.bos.openapi.api.result.ApiSaveResult;
import kd.bos.openapi.api.result.ApiServiceResult;
import kd.bos.openapi.api.result.ApiSubmitResult;
import kd.bos.openapi.api.result.ApiUnAuditResult;
import kd.bos.openapi.api.result.ApiUnSubmitResult;
import kd.bos.openapi.api.result.BaseFilterResult;

public enum ApiService {
    QUERY{

        @Override
        public ApiServiceResult getResultType() {
            return new ApiQueryResult();
        }

        public ApiParam<?, ApiQueryPlugin> getParamType() {
            return new ApiQueyParam(new OpenApiRequest<Map<String, Object>>());
        }
    }
    ,
    SAVE{

        @Override
        public ApiServiceResult getResultType() {
            ArrayList<ApiSaveItemData> insertIds = new ArrayList<ApiSaveItemData>();
            ArrayList<ApiSaveItemData> updateIds = new ArrayList<ApiSaveItemData>();
            return ApiSaveResult.of(insertIds, updateIds);
        }

        public ApiParam<?, ApiSavePlugin> getParamType() {
            return new ApiSaveParam<ApiSavePlugin>(new OpenApiRequest<Map<String, Object>>());
        }
    }
    ,
    DELETE{

        @Override
        public ApiServiceResult getResultType() {
            return new ApiDeleteResult();
        }

        public ApiParam<?, ApiDeletePlugin> getParamType() {
            return new ApiDeleteParam(new OpenApiRequest<Map<String, Object>>());
        }
    }
    ,
    APPENDENTRYROWS{

        @Override
        public ApiServiceResult getResultType() {
            return new ApiSaveResult();
        }

        public ApiParam<?, ApiAppendEntryRowsPlugin> getParamType() {
            return new ApiAppendEntryRowsParam<ApiAppendEntryRowsPlugin>(new OpenApiRequest<Map<String, Object>>());
        }
    }
    ,
    DELETEENTRYROWS{

        @Override
        public ApiServiceResult getResultType() {
            return new ApiSaveResult();
        }

        public ApiParam<?, ApiDeleteEntryRowsPlugin> getParamType() {
            return new ApiDeleteEntryRowsParam<ApiDeleteEntryRowsPlugin>(new OpenApiRequest<Map<String, Object>>());
        }
    }
    ,
    SUBMIT{

        @Override
        public ApiServiceResult getResultType() {
            return new ApiSubmitResult();
        }

        public ApiParam<?, ApiSubmitPlugin> getParamType() {
            return new ApiSubmitParam(new OpenApiRequest<Map<String, Object>>());
        }
    }
    ,
    UNSUBMIT{

        @Override
        public ApiServiceResult getResultType() {
            return new ApiUnSubmitResult();
        }

        public ApiParam<?, ApiUnSubmitPlugin> getParamType() {
            return new ApiUnSubmitParam(new OpenApiRequest<Map<String, Object>>());
        }
    }
    ,
    AUDIT{

        @Override
        public ApiServiceResult getResultType() {
            return new ApiAuditResult();
        }

        public ApiParam<?, ApiAuditPlugin> getParamType() {
            return new ApiAuditParam(new OpenApiRequest<Map<String, Object>>());
        }
    }
    ,
    UNAUDIT{

        @Override
        public ApiServiceResult getResultType() {
            return new ApiUnAuditResult();
        }

        public ApiParam<?, ApiUnAuditPlugin> getParamType() {
            return new ApiUnAuditParam(new OpenApiRequest<Map<String, Object>>());
        }
    }
    ,
    ENABLE{

        @Override
        public ApiServiceResult getResultType() {
            return new BaseFilterResult();
        }

        public ApiParam<?, ApiEnablePlugin> getParamType() {
            return new BaseFilterParam<ApiEnablePlugin>(new OpenApiRequest<Map<String, Object>>());
        }
    }
    ,
    DISABLE{

        @Override
        public ApiServiceResult getResultType() {
            return new BaseFilterResult();
        }

        public ApiParam<?, ApiDisablePlugin> getParamType() {
            return new BaseFilterParam<ApiDisablePlugin>(new OpenApiRequest<Map<String, Object>>());
        }
    }
    ,
    $_COMMON_OP{

        @Override
        public ApiServiceResult getResultType() {
            return new BaseFilterResult();
        }

        public ApiParam<?, ApiCommonPlugin> getParamType() {
            return new BaseFilterParam<ApiCommonPlugin>(new OpenApiRequest<Map<String, Object>>());
        }
    };


    public abstract ApiServiceResult getResultType();

    public abstract ApiParam<?, ? extends ApiPlugin> getParamType();

    public static ApiService getTypeByOp(String op) {
        if (op == null || op.trim().length() == 0) {
            throw new NullPointerException("operator not null");
        }
        for (ApiService type : ApiService.values()) {
            if (!type.name().equalsIgnoreCase(op)) continue;
            return type;
        }
        return $_COMMON_OP;
    }
}

