/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.log.api;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.log.api.FieldModifyInfo;

public class EntityModifyInfo
extends LinkedHashMap<String, Object>
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String key_keyID = "k";
    public static final String key_caption = "c";
    public static final String key_flag = "f";
    @JsonIgnore
    private EntityModifyInfo parent;
    @JsonIgnore
    private String fieldName;

    public EntityModifyInfo() {
    }

    public EntityModifyInfo(String keyID, String caption) {
        this.put(key_keyID, keyID);
        this.put(key_caption, caption);
    }

    public String getKeyID() {
        return (String)this.get(key_keyID);
    }

    public void setKeyID(String keyID) {
        this.put(key_keyID, keyID);
    }

    public String getCaption() {
        return (String)this.get(key_caption);
    }

    public void setCaption(String caption) {
        this.put(key_caption, caption);
    }

    public String getFlag() {
        return (String)this.get(key_flag);
    }

    public void setFlag(String flag) {
        this.put(key_flag, flag);
    }

    @JsonIgnore
    public List<FieldModifyInfo> getFields() {
        List<FieldModifyInfo> collect = this.entrySet().stream().filter(e -> e.getValue() instanceof FieldModifyInfo).map(m -> (FieldModifyInfo)m.getValue()).collect(Collectors.toList());
        return collect;
    }

    public void addField(String fieldName, FieldModifyInfo info) {
        info.setEntity(this);
        info.setFieldName(fieldName);
        this.put(fieldName, info);
    }

    public void addChild(String fieldName, EntityModifyInfo child) {
        LinkedList<EntityModifyInfo> entityModifyInfos = (LinkedList<EntityModifyInfo>)this.get(fieldName);
        if (entityModifyInfos == null) {
            entityModifyInfos = new LinkedList<EntityModifyInfo>();
            this.put(fieldName, entityModifyInfos);
        }
        entityModifyInfos.add(child);
        child.setFieldName(fieldName);
        child.setParent(this);
    }

    @JsonIgnore
    public EntityModifyInfo getParent() {
        return this.parent;
    }

    @JsonIgnore
    public void setParent(EntityModifyInfo parent) {
        this.parent = parent;
    }

    @JsonIgnore
    public String getFieldName() {
        return this.fieldName;
    }

    @JsonIgnore
    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public EntityModifyInfo findEntityModifyInfo(String fieldName, String keyID) {
        LinkedList entityModifyInfos = (LinkedList)this.get(fieldName);
        if (entityModifyInfos == null) {
            return null;
        }
        for (EntityModifyInfo entityModifyInfo : entityModifyInfos) {
            if (!keyID.equals(entityModifyInfo.getKeyID())) continue;
            return entityModifyInfo;
        }
        return null;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        int level = this.getLevel();
        String tuckunder = this.getTuckunder();
        if (level != 0) {
            sb.append(tuckunder).append(this.getCaption()).append("[").append(this.getDirtyFlagDispName()).append("]").append("\n");
        } else if ("-".equals(this.getFlag())) {
            sb.append(ResManager.loadKDString((String)"\u5220\u9664", (String)"EntityModifyInfo_0", (String)"bos-mservice-log-api", (Object[])new Object[0]));
        }
        if ("-".equals(this.getFlag())) {
            return sb.toString();
        }
        List fields = this.entrySet().stream().filter(e -> e.getValue() instanceof FieldModifyInfo).map(m -> (FieldModifyInfo)m.getValue()).collect(Collectors.toList());
        boolean bExistFields = false;
        if (fields != null && fields.size() > 0) {
            sb.append(tuckunder);
            if (level > 0) {
                sb.append("\t");
            }
            for (FieldModifyInfo field : fields) {
                String s = field.toString();
                if (!s.endsWith("\n")) {
                    s = s + "\n";
                }
                sb.append(s);
                bExistFields = true;
            }
            if (bExistFields) {
                sb.append("\n");
            }
        }
        boolean bExistEntry = false;
        List entries = this.entrySet().stream().filter(e -> e.getValue() instanceof LinkedList).map(m -> (LinkedList)m.getValue()).collect(Collectors.toList());
        if (entries != null) {
            for (LinkedList entry : entries) {
                for (EntityModifyInfo info : entry) {
                    String s = info.toString();
                    if (s == null) continue;
                    if (!s.endsWith("\n")) {
                        s = s + "\n";
                    }
                    sb.append(s);
                    bExistEntry = true;
                }
            }
        }
        if (bExistEntry || bExistFields) {
            return sb.toString();
        }
        return "";
    }

    private int getLevel() {
        int level = 0;
        for (EntityModifyInfo parent = this.getParent(); parent != null; parent = parent.getParent()) {
            ++level;
        }
        return level;
    }

    private String getTuckunder() {
        int level = this.getLevel();
        if (level == 0) {
            return "";
        }
        return StringUtils.repeat((char)'\t', (int)level);
    }

    private String getDirtyFlagDispName() {
        String flag = this.getFlag();
        if ("+".equals(flag)) {
            return ResManager.loadKDString((String)"\u65b0\u5efa", (String)"EntityModifyInfo_1", (String)"bos-mservice-log-api", (Object[])new Object[0]);
        }
        if ("-".equals(flag)) {
            return ResManager.loadKDString((String)"\u5220\u9664", (String)"EntityModifyInfo_0", (String)"bos-mservice-log-api", (Object[])new Object[0]);
        }
        return ResManager.loadKDString((String)"\u4fee\u6539", (String)"EntityModifyInfo_2", (String)"bos-mservice-log-api", (Object[])new Object[0]);
    }

    public String getPropertyPath() {
        EntityModifyInfo parent = this.getParent();
        if (parent == null) {
            return "";
        }
        String parentPath = parent.getPropertyPath();
        if (!StringUtils.isBlank((CharSequence)parentPath)) {
            return parentPath + "." + this.getFieldName();
        }
        return this.getFieldName();
    }

    public List<String> getModifyFields() {
        List entries;
        LinkedList<String> result = new LinkedList<String>();
        String entityPath = this.getPropertyPath();
        List fields = this.entrySet().stream().filter(e -> e.getValue() instanceof FieldModifyInfo).map(m -> (FieldModifyInfo)m.getValue()).collect(Collectors.toList());
        if (fields != null) {
            for (FieldModifyInfo field : fields) {
                String item = "";
                item = StringUtils.isBlank((CharSequence)entityPath) ? field.getFieldName() : entityPath + "." + field.getFieldName();
                if (result.contains(item)) continue;
                result.add(item);
            }
        }
        if ((entries = this.entrySet().stream().filter(e -> e.getValue() instanceof LinkedList).map(m -> (LinkedList)m.getValue()).collect(Collectors.toList())) != null) {
            for (LinkedList entry : entries) {
                for (EntityModifyInfo info : entry) {
                    List<String> modifyFields = info.getModifyFields();
                    if (modifyFields == null || modifyFields.size() <= 0) continue;
                    for (String modifyField : modifyFields) {
                        if (result.contains(modifyField)) continue;
                        result.add(modifyField);
                    }
                }
            }
        }
        return result;
    }

    @Override
    public boolean isEmpty() {
        boolean bExistFields = this.entrySet().stream().anyMatch(e -> e.getValue() instanceof FieldModifyInfo);
        if (bExistFields) {
            return false;
        }
        boolean bExistEntries = this.entrySet().stream().anyMatch(e -> e.getValue() instanceof LinkedList);
        return !bExistEntries;
    }
}

