/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.TypesContainer;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class ServiceSvcFactory {
    private static Map<String, String> serviceMap = new HashMap<String, String>();
    private static Map<String, Object> serviceInstanceMap = new HashMap<String, Object>();
    private static Log log = LogFactory.getLog(ServiceSvcFactory.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T getService(Class<T> clazz) {
        String key = clazz.getSimpleName();
        Object serviceObj = serviceInstanceMap.get(key);
        if (null != serviceObj) {
            return (T)serviceObj;
        }
        String clzFullPath = serviceMap.get(key);
        if (null == clzFullPath) {
            return null;
        }
        String string = key.intern();
        synchronized (string) {
            serviceObj = serviceInstanceMap.get(key);
            if (null != serviceObj) {
                return (T)serviceObj;
            }
            serviceObj = TypesContainer.createInstance((String)clzFullPath);
            serviceInstanceMap.put(key, serviceObj);
        }
        return (T)serviceObj;
    }

    static {
        serviceMap.put("IParameterWriterService", "kd.bos.param.impl.ParameterWriterServiceImpl");
        serviceMap.put("IParameterReaderService", "kd.bos.param.impl.ParameterReaderServiceImpl");
        serviceMap.put("IParameterHelperService", "kd.bos.data.impl.ParameterHelperServiceImpl");
    }
}

