/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.service.authorize.http;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.servlet.ReadListener;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class KDSignHttpServletRequestWrapper
extends HttpServletRequestWrapper {
    private static Log log = LogFactory.getLog(KDSignHttpServletRequestWrapper.class);
    private static final String UTF_8 = "UTF-8";
    private byte[] body;
    private AtomicBoolean isFirst = new AtomicBoolean(true);

    public KDSignHttpServletRequestWrapper(HttpServletRequest request) {
        super(request);
    }

    public ServletInputStream getInputStream() throws IOException {
        if (this.isFirst.get()) {
            if (this.isMultipart()) {
                return super.getInputStream();
            }
            this.isFirst.set(false);
            this.body = this.streamToByte((InputStream)super.getInputStream());
        }
        return new KDSignServletInputStream(this.body);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] streamToByte(InputStream inputStream) {
        try (BufferedReader br = new BufferedReader(new InputStreamReader(inputStream, UTF_8));){
            byte[] input;
            int n;
            byte[] buffer = new byte[1024];
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            while ((n = inputStream.read(buffer)) != -1) {
                bos.write(buffer, 0, n);
            }
            byte[] byArray = input = bos.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            log.error((Throwable)e);
            throw new RuntimeException("It's failed when get inputStream.", e);
        }
    }

    private boolean isMultipart() {
        HttpServletRequest request = (HttpServletRequest)this.getRequest();
        String contentType = request.getContentType();
        return "post".equalsIgnoreCase(request.getMethod()) && contentType != null && contentType.toLowerCase(Locale.ENGLISH).startsWith("multipart/");
    }

    public void setBody(byte[] body) {
        this.isFirst.set(false);
        this.body = body;
    }

    static class KDSignServletInputStream
    extends ServletInputStream {
        private InputStream sourceStream;
        private boolean finished = false;

        public KDSignServletInputStream(byte[] bytes) {
            this.sourceStream = new ByteArrayInputStream(bytes);
        }

        public boolean isFinished() {
            return this.finished;
        }

        public boolean isReady() {
            return true;
        }

        public void setReadListener(ReadListener readListener) {
            throw new UnsupportedOperationException();
        }

        public int read() throws IOException {
            int data = this.sourceStream.read();
            if (data == -1) {
                this.finished = true;
            }
            return data;
        }

        public int available() throws IOException {
            return this.sourceStream.available();
        }

        public void close() throws IOException {
            super.close();
            this.sourceStream.close();
        }
    }
}

