/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.kflow.api.enums;

import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;

public enum ErrorCode {
    Success("0"),
    NoSuchRef("400001"),
    NoSuchFlow("400002"),
    NoSuchAction("400003"),
    NoSuchVariable("400004"),
    NoSuchService("400005"),
    NoSuchBill("400006"),
    NoPermission("400007"),
    UnrecognizedNode("400008"),
    FlowDisabled("400009"),
    FlowIsEmpty("400010"),
    NoSuchParam("400011"),
    InvalidParam("400012"),
    MutualExclusive("500001"),
    FlowAnalysed("500002"),
    FlowExecute("500003"),
    ActionExecute("500004"),
    ServiceExecute("500005"),
    ExprError("500006"),
    CreateVariable("500007"),
    ChangeVariable("500008"),
    CallLimit("500009"),
    CommitDataEntity("500010"),
    CreateDataEntity("500011"),
    ChangeDataEntity("500012"),
    DeleteDataEntity("500013"),
    RetrieveDataEntity("500014"),
    CreateDataEntityList("500015"),
    Operation("500016"),
    CloseForm("500017"),
    OpenForm("500018"),
    ShowMessage("500019"),
    ChangePageData("500020"),
    AddPageEntry("500021"),
    RemovePageEntry("500022"),
    AddRecordEntry("500023"),
    RemoveRecordEntry("500024"),
    EndEvent("500025"),
    Internal("510000");

    private final String codeNum;
    private static final String BOS_KFLOW_API = "bos-mservice-kflow-api";

    private ErrorCode(String codeNum) {
        this.codeNum = codeNum;
    }

    public static ErrorCode getErrorCode(String codeNum) {
        for (ErrorCode errorCode : ErrorCode.values()) {
            if (!errorCode.getCodeNum().equals(codeNum)) continue;
            return errorCode;
        }
        return null;
    }

    public String getCodeNum() {
        return this.codeNum;
    }

    public ILocaleString getMessage() {
        switch (this) {
            case Success: {
                return null;
            }
            case NoSuchRef: {
                return ResManager.getLocaleString((String)"K\u6d41\u5f15\u7528\u4e0d\u5b58\u5728\u6216\u8005\u672a\u542f\u7528", (String)this.codeNum, (String)BOS_KFLOW_API);
            }
            case NoSuchFlow: {
                return ResManager.getLocaleString((String)"K\u6d41\u4e0d\u5b58\u5728\u6216\u8005\u672a\u542f\u7528", (String)this.codeNum, (String)BOS_KFLOW_API);
            }
            case FlowDisabled: {
                return ResManager.getLocaleString((String)"K\u6d41\u672a\u542f\u7528", (String)this.codeNum, (String)BOS_KFLOW_API);
            }
            case NoSuchAction: {
                return ResManager.getLocaleString((String)"\u6d3b\u52a8\u4e0d\u5b58\u5728\u6216\u8005\u672a\u542f\u7528", (String)this.codeNum, (String)BOS_KFLOW_API);
            }
            case NoSuchVariable: {
                return ResManager.getLocaleString((String)"\u53d8\u91cf\u4e0d\u5b58\u5728", (String)this.codeNum, (String)BOS_KFLOW_API);
            }
            case NoSuchService: {
                return ResManager.getLocaleString((String)"\u670d\u52a1\u6216\u65b9\u6cd5\u4e0d\u5b58\u5728", (String)this.codeNum, (String)BOS_KFLOW_API);
            }
            case NoSuchBill: {
                return ResManager.getLocaleString((String)"\u5355\u636e\u4e0d\u5b58\u5728", (String)this.codeNum, (String)BOS_KFLOW_API);
            }
            case NoPermission: {
                return ResManager.getLocaleString((String)"\u6ca1\u6709\u6267\u884c\u6743\u9650", (String)this.codeNum, (String)BOS_KFLOW_API);
            }
            case UnrecognizedNode: {
                return ResManager.getLocaleString((String)"\u65e0\u6cd5\u8bc6\u522b\u7684\u8282\u70b9\u5b9a\u4e49", (String)this.codeNum, (String)BOS_KFLOW_API);
            }
            case NoSuchParam: {
                return ResManager.getLocaleString((String)"\u53c2\u6570\u4e0d\u5b58\u5728", (String)this.codeNum, (String)BOS_KFLOW_API);
            }
            case InvalidParam: {
                return ResManager.getLocaleString((String)"\u65e0\u6548\u7684\u53c2\u6570", (String)this.codeNum, (String)BOS_KFLOW_API);
            }
            case FlowIsEmpty: {
                return ResManager.getLocaleString((String)"K\u6d41\u4e3a\u7a7a", (String)this.codeNum, (String)BOS_KFLOW_API);
            }
            case MutualExclusive: {
                return ResManager.getLocaleString((String)"\u4e0d\u5141\u8bb8\u5e76\u53d1\u6267\u884c", (String)this.codeNum, (String)BOS_KFLOW_API);
            }
            case FlowAnalysed: {
                return ResManager.getLocaleString((String)"K\u6d41\u89e3\u6790\u5f02\u5e38", (String)this.codeNum, (String)BOS_KFLOW_API);
            }
            case FlowExecute: {
                return ResManager.getLocaleString((String)"K\u6d41\u6267\u884c\u5f02\u5e38", (String)this.codeNum, (String)BOS_KFLOW_API);
            }
            case ActionExecute: {
                return ResManager.getLocaleString((String)"\u6d3b\u52a8\u6267\u884c\u5f02\u5e38", (String)this.codeNum, (String)BOS_KFLOW_API);
            }
            case ServiceExecute: {
                return ResManager.getLocaleString((String)"\u670d\u52a1\u8c03\u7528\u5f02\u5e38", (String)this.codeNum, (String)BOS_KFLOW_API);
            }
            case ExprError: {
                return ResManager.getLocaleString((String)"\u8868\u8fbe\u5f0f\u5f02\u5e38", (String)this.codeNum, (String)BOS_KFLOW_API);
            }
            case CreateVariable: {
                return ResManager.getLocaleString((String)"\u521b\u5efa\u53d8\u91cf\u5f02\u5e38", (String)this.codeNum, (String)BOS_KFLOW_API);
            }
            case ChangeVariable: {
                return ResManager.getLocaleString((String)"\u6539\u53d8\u53d8\u91cf\u5f02\u5e38", (String)this.codeNum, (String)BOS_KFLOW_API);
            }
            case CallLimit: {
                return ResManager.getLocaleString((String)"\u8c03\u7528\u6b21\u6570\u5f02\u5e38", (String)this.codeNum, (String)BOS_KFLOW_API);
            }
            case CommitDataEntity: {
                return ResManager.getLocaleString((String)"\u63d0\u4ea4\u8bb0\u5f55\u5f02\u5e38", (String)this.codeNum, (String)BOS_KFLOW_API);
            }
            case ChangeDataEntity: {
                return ResManager.getLocaleString((String)"\u66f4\u65b0\u8bb0\u5f55\u5f02\u5e38", (String)this.codeNum, (String)BOS_KFLOW_API);
            }
            case CreateDataEntity: {
                return ResManager.getLocaleString((String)"\u521b\u5efa\u8bb0\u5f55\u5f02\u5e38", (String)this.codeNum, (String)BOS_KFLOW_API);
            }
            case DeleteDataEntity: {
                return ResManager.getLocaleString((String)"\u5220\u9664\u8bb0\u5f55\u5f02\u5e38", (String)this.codeNum, (String)BOS_KFLOW_API);
            }
            case RetrieveDataEntity: {
                return ResManager.getLocaleString((String)"\u83b7\u53d6\u8bb0\u5f55\u5f02\u5e38", (String)this.codeNum, (String)BOS_KFLOW_API);
            }
            case CreateDataEntityList: {
                return ResManager.getLocaleString((String)"\u521b\u5efa\u8bb0\u5f55\u5217\u8868\u5f02\u5e38", (String)this.codeNum, (String)BOS_KFLOW_API);
            }
            case Operation: {
                return ResManager.getLocaleString((String)"\u6267\u884c\u64cd\u4f5c\u5f02\u5e38", (String)this.codeNum, (String)BOS_KFLOW_API);
            }
            case CloseForm: {
                return ResManager.getLocaleString((String)"\u5173\u95ed\u9875\u9762\u5f02\u5e38", (String)this.codeNum, (String)BOS_KFLOW_API);
            }
            case OpenForm: {
                return ResManager.getLocaleString((String)"\u6253\u5f00\u9875\u9762\u5f02\u5e38", (String)this.codeNum, (String)BOS_KFLOW_API);
            }
            case ShowMessage: {
                return ResManager.getLocaleString((String)"\u63d0\u793a\u6d88\u606f\u5f02\u5e38", (String)this.codeNum, (String)BOS_KFLOW_API);
            }
            case ChangePageData: {
                return ResManager.getLocaleString((String)"\u66f4\u65b0\u9875\u9762\u6570\u636e\u5f02\u5e38", (String)this.codeNum, (String)BOS_KFLOW_API);
            }
            case AddPageEntry: {
                return ResManager.getLocaleString((String)"\u6dfb\u52a0\u9875\u9762\u5206\u5f55\u5f02\u5e38", (String)this.codeNum, (String)BOS_KFLOW_API);
            }
            case RemovePageEntry: {
                return ResManager.getLocaleString((String)"\u5220\u9664\u9875\u9762\u5206\u5f55\u5f02\u5e38", (String)this.codeNum, (String)BOS_KFLOW_API);
            }
            case AddRecordEntry: {
                return ResManager.getLocaleString((String)"\u6dfb\u52a0\u8bb0\u5f55\u5206\u5f55\u5f02\u5e38", (String)this.codeNum, (String)BOS_KFLOW_API);
            }
            case RemoveRecordEntry: {
                return ResManager.getLocaleString((String)"\u5220\u9664\u8bb0\u5f55\u5206\u5f55\u5f02\u5e38", (String)this.codeNum, (String)BOS_KFLOW_API);
            }
            case EndEvent: {
                return ResManager.getLocaleString((String)"K\u6d41\u6267\u884c\u7ed3\u675f", (String)this.codeNum, (String)BOS_KFLOW_API);
            }
            case Internal: {
                return ResManager.getLocaleString((String)"\u5185\u90e8\u670d\u52a1\u5f02\u5e38", (String)this.codeNum, (String)BOS_KFLOW_API);
            }
        }
        return new LocaleString();
    }

    public String toString() {
        return String.format("%s[%s:%s]", this.name(), this.codeNum, this.getMessage());
    }
}

