/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.data.refshare;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.datamanager.refstrategy.BasedataRefShareStrategy;
import kd.bos.util.JSONUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpecifyBasedataRefShareStrategy
implements BasedataRefShareStrategy {
    private static final Logger log = LoggerFactory.getLogger(SpecifyBasedataRefShareStrategy.class);
    private static final Map<String, Object> dtAppShareMap = new HashMap<String, Object>();
    private static final Map<String, IDataEntityType> dtGlobalShareMap = new ConcurrentHashMap<String, IDataEntityType>();
    private static String shareStrategyDTConfigs;
    private static boolean isInit;

    public SpecifyBasedataRefShareStrategy() {
        this.initShareRefDT();
    }

    public IDataEntityType getShareRefDT(IDataEntityType type) {
        IDataEntityType dt;
        Map appShareDt = (Map)dtAppShareMap.get(type.getName());
        if (appShareDt != null && type instanceof BasedataEntityType && (dt = (IDataEntityType)appShareDt.get(((BasedataEntityType)type).getBizAppNumber())) != null) {
            return dt;
        }
        dt = dtGlobalShareMap.get(type.getName());
        if (dt != null) {
            return dt;
        }
        return type;
    }

    private void putAppShareRefDT(String appNumber, String formNumber, String propstring) {
        String[] propNames = propstring.split(",");
        this.putAppShareRefDT(appNumber, formNumber, Arrays.asList(propNames));
    }

    private void putGlobalShareRefDT(String formId, String propstring) {
        String[] propNames = propstring.split(",");
        this.putGlobalShareRefDT(formId, Arrays.asList(propNames));
        log.info("BasedataRefShareStrategy init global shareDT {}:{}", (Object)formId, (Object)propstring);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putAppShareRefDT(String appNumber, String formNumber, Collection<String> props) {
        MainEntityType met = EntityMetadataCache.getDataEntityType((String)formNumber);
        Map<String, Object> map = dtAppShareMap;
        synchronized (map) {
            HashMap<String, IDataEntityType> appDt = (HashMap<String, IDataEntityType>)dtAppShareMap.get(appNumber);
            if (appDt == null) {
                appDt = new HashMap<String, IDataEntityType>(16);
                dtAppShareMap.put(appNumber, appDt);
            }
            this.addRefDTProp(formNumber, appDt, props, met);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putGlobalShareRefDT(String baseEntityMetaNumber, Collection<String> propNames) {
        MainEntityType met = EntityMetadataCache.getDataEntityType((String)baseEntityMetaNumber);
        Map<String, IDataEntityType> map = dtGlobalShareMap;
        synchronized (map) {
            this.addRefDTProp(baseEntityMetaNumber, dtGlobalShareMap, propNames, met);
        }
    }

    private void addRefDTProp(String baseEntityMetaNumber, Map<String, IDataEntityType> dtSharePropMap, Collection<String> propNames, MainEntityType met) {
        IDataEntityType dt = dtSharePropMap.get(baseEntityMetaNumber);
        if (dt != null) {
            LinkedHashSet<String> propSet = new LinkedHashSet<String>();
            for (IDataEntityProperty prop : dt.getProperties()) {
                propSet.add(prop.getName());
            }
            propSet.addAll(propNames);
            dtSharePropMap.put(baseEntityMetaNumber, (IDataEntityType)met.getSubEntityType(propSet));
        } else {
            dtSharePropMap.put(baseEntityMetaNumber, (IDataEntityType)met.getSubEntityType(propNames));
        }
    }

    private void initShareRefDT() {
        if (!isInit) {
            this.putGlobalShareRefDT("bos_user", "email,enable,id,masterid,name,number,phone,username");
            this.putGlobalShareRefDT("bos_org", "enable,fispurchase,fyzjorgid,masterid,name,number,simplename,status");
            String shareDTGlobalConfig = System.getProperty("basedata.refshare.dt.global");
            this.initConfigShareRefDT(shareDTGlobalConfig, (key, entry) -> this.initGlobalShareRefDT((String)key, (Map.Entry<String, String>)entry));
            String shareDTAppConfig = System.getProperty("basedata.refshare.dt.app");
            this.initConfigShareRefDT(shareDTAppConfig, (key, entry) -> this.initAppShareRefDT((String)key, (Map.Entry<String, String>)entry));
            isInit = true;
        }
    }

    private void initConfigShareRefDT(String shareDTConfig, BiConsumer<String, Map.Entry<String, String>> biConsumer) {
        if (StringUtils.isNotBlank((CharSequence)shareDTConfig)) {
            Map shareDTMap = new HashMap(16);
            try {
                shareDTMap = (Map)JSONUtils.cast((String)shareDTConfig, HashMap.class);
            }
            catch (IOException e) {
                log.error("Load configuration('basedata.refshare.dt.global') cast error.", (Throwable)e);
            }
            if (shareDTMap != null && !shareDTMap.isEmpty()) {
                for (Map.Entry configEntry : shareDTMap.entrySet()) {
                    String region = (String)configEntry.getKey();
                    Object item = configEntry.getValue();
                    if (!(item instanceof Map)) continue;
                    Map dtPropMap = (Map)item;
                    for (Map.Entry o : dtPropMap.entrySet()) {
                        biConsumer.accept(region, o);
                    }
                }
            }
        }
    }

    private void initGlobalShareRefDT(String globalKey, Map.Entry<String, String> entry) {
        if ("global".equals(globalKey)) {
            this.putGlobalShareRefDT(entry.getKey(), entry.getValue());
        }
    }

    private void initAppShareRefDT(String appNumber, Map.Entry<String, String> entry) {
        this.putAppShareRefDT(appNumber, entry.getKey(), entry.getValue());
    }

    static {
        isInit = false;
    }
}

