/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.list.query;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import kd.bos.algo.Algo;
import kd.bos.algo.CachedDataSet;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.cache.CacheKeyUtil;
import kd.bos.entity.list.QueryResult;
import kd.bos.entity.property.BasedataProp;
import kd.bos.ksql.util.StringUtil;
import kd.bos.list.query.DBCostCache;
import kd.bos.list.query.DBCostCacheFactory;
import kd.bos.list.query.Mapper;
import kd.bos.list.query.QueryUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;

public class PageRowCacheUtils {
    private static Log log = LogFactory.getLog(PageRowCacheUtils.class);
    private static ThreadLocal<String> pageIdLocal = new ThreadLocal();
    private static ThreadLocal<String> controlKeyLocal = new ThreadLocal();
    private static ThreadLocal<AtomicInteger> touchValue = new ThreadLocal<AtomicInteger>(){

        @Override
        protected AtomicInteger initialValue() {
            return new AtomicInteger(0);
        }
    };
    static ThreadPool tpool = ThreadPools.newCachedThreadPool((String)"ListUIClearPageCacheDataSet");

    public static void initTouch() {
        touchValue.set(new AtomicInteger(0));
    }

    public static void touchFlag() {
        touchValue.get().incrementAndGet();
    }

    public static int getTouchValue() {
        return touchValue.get().intValue();
    }

    public static void setPageId(String cacheid) {
        pageIdLocal.set(cacheid);
    }

    public static String getPageId() {
        return pageIdLocal.get();
    }

    public static void setControlKey(String controlKey) {
        controlKeyLocal.set(controlKey);
    }

    public static String getControlKey() {
        return controlKeyLocal.get();
    }

    public static void clearPageId() {
        PageRowCacheUtils.setPageId(null);
    }

    public static boolean isNull() {
        return pageIdLocal.get() == null;
    }

    public static String getCacheKey() {
        return CacheKeyUtil.getAcctId() + ".pageListCache" + PageRowCacheUtils.getPageId();
    }

    public static void clearPageRowcache(String pageId) {
        DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("form-pagecache", new DistributeCacheHAPolicy(true, true));
        PageRowCacheUtils.setPageId(pageId);
        Map cacheMap = cache.getAll(PageRowCacheUtils.getCacheKey());
        for (Map.Entry entry : cacheMap.entrySet()) {
            String cacheId;
            if (!((String)entry.getKey()).endsWith("BILLLIST_cacheId") || !StringUtils.isNotEmpty((CharSequence)(cacheId = (String)cacheMap.get(entry.getKey()))) || cacheId.startsWith("onlyonepage_")) continue;
            tpool.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        CachedDataSet cds = Algo.getCacheDataSet((String)cacheId);
                        cds.close();
                    }
                    catch (Exception e) {
                        log.error("PageRowCacheUtils clearPageRowCache" + e.getMessage());
                    }
                }
            });
        }
        cache.remove(PageRowCacheUtils.getCacheKey());
    }

    public static void clearPageRowcache(String pageId, String controlKey) {
        DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("form-pagecache", new DistributeCacheHAPolicy(true, true));
        PageRowCacheUtils.setPageId(pageId);
        Map cacheMap = cache.getAll(PageRowCacheUtils.getCacheKey());
        ArrayList<String> keys = new ArrayList<String>();
        for (Map.Entry item : cacheMap.entrySet()) {
            String cacheId;
            String key = (String)item.getKey();
            if (!key.startsWith(controlKey + "BILLLIST")) continue;
            if (key.endsWith("BILLLIST_cacheId") && StringUtils.isNotEmpty((CharSequence)(cacheId = (String)cacheMap.get(key))) && !cacheId.startsWith("onlyonepage_")) {
                tpool.execute(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            CachedDataSet cds = Algo.getCacheDataSet((String)cacheId);
                            cds.close();
                        }
                        catch (Exception e) {
                            log.error("PageRowCacheUtils clearPageRowCache" + e.getMessage());
                        }
                    }
                });
            }
            keys.add(key);
        }
        if (!CollectionUtils.isEmpty(keys)) {
            cache.remove(PageRowCacheUtils.getCacheKey(), keys.toArray(new String[keys.size()]));
        }
    }

    @Deprecated
    public static QueryResult getCachedQueryResult(String pageId) {
        DBCostCache ics = DBCostCacheFactory.createCache();
        String cacheId = ics.getCacheMsg(pageId);
        String bdcMsg = ics.getCacheMsg(pageId + "BILLLIST_billDataCount");
        int billDataCount = 0;
        if (!StringUtil.isEmpty((String)bdcMsg)) {
            billDataCount = Integer.parseInt(bdcMsg);
        }
        QueryResult queryResult = null;
        if (StringUtils.isNotEmpty((CharSequence)cacheId)) {
            if (cacheId.startsWith("onlyonepage_")) {
                int datacount = 1;
                datacount = Integer.parseInt(cacheId.split("_")[1]);
                queryResult = new QueryResult();
                queryResult.setBillDataCount(billDataCount);
                queryResult.setSummaryResults(ics.getCacheSumResults(pageId + "BILLLIST_sumResults"));
                queryResult.setDataCount(datacount);
                return queryResult;
            }
            try {
                CachedDataSet cds = Algo.getCacheDataSet((String)cacheId);
                queryResult = new QueryResult();
                queryResult.setSummaryResults(ics.getCacheSumResults(pageId + "BILLLIST_sumResults"));
                queryResult.setBillDataCount(billDataCount);
                queryResult.setDataCount(cds.getRowCount());
                return queryResult;
            }
            catch (Exception e) {
                log.error("PageRowCacheUtils getCachedQueryResult" + e.getMessage());
            }
        }
        return queryResult;
    }

    public static QueryResult getCachedQueryResult(String pageId, String controlKey) {
        DBCostCache ics = DBCostCacheFactory.createCache();
        PageRowCacheUtils.setPageId(pageId);
        Map<String, String> cacheMap = ics.getCacheMap(PageRowCacheUtils.getCacheKey());
        String mapKeyPrfix = "";
        if (!StringUtil.isEmpty((String)controlKey)) {
            mapKeyPrfix = controlKey;
        }
        String cacheId = cacheMap.get(mapKeyPrfix + "BILLLIST_cacheId");
        String bdcMsg = cacheMap.get(mapKeyPrfix + "BILLLIST_billDataCount");
        int billDataCount = 0;
        if (!StringUtil.isEmpty((String)bdcMsg)) {
            billDataCount = Integer.parseInt(bdcMsg);
        }
        QueryResult queryResult = null;
        if (StringUtils.isNotEmpty((CharSequence)cacheId)) {
            if (cacheId.startsWith("onlyonepage_")) {
                int datacount = 1;
                datacount = Integer.parseInt(cacheId.split("_")[1]);
                queryResult = new QueryResult();
                queryResult.setBillDataCount(billDataCount);
                String sRStr = cacheMap.get(mapKeyPrfix + "BILLLIST_sumResults");
                queryResult.setSummaryResults(QueryUtils.getSRList(sRStr));
                queryResult.setDataCount(datacount);
                return queryResult;
            }
            try {
                CachedDataSet cds = Algo.getCacheDataSet((String)cacheId);
                queryResult = new QueryResult();
                String sRStr = cacheMap.get(mapKeyPrfix + "BILLLIST_sumResults");
                queryResult.setSummaryResults(QueryUtils.getSRList(sRStr));
                queryResult.setBillDataCount(billDataCount);
                queryResult.setDataCount(cds.getRowCount());
                return queryResult;
            }
            catch (Exception e) {
                log.error("PageRowCacheUtils getCachedQueryResult" + e.getMessage());
            }
        }
        return queryResult;
    }

    public static DynamicObjectCollection getAllCachedPkList(String pageId, String controlKey, DynamicObjectType dt) {
        return PageRowCacheUtils.getCachedPkList(pageId, controlKey, dt, 0, -1);
    }

    public static DynamicObjectCollection getCachedPkList(String pageId, String controlKey, DynamicObjectType dt, int start, int limit) {
        String cacheId;
        DBCostCache ics = DBCostCacheFactory.createCache();
        PageRowCacheUtils.setPageId(pageId);
        Map<String, String> cacheMap = ics.getCacheMap(PageRowCacheUtils.getCacheKey());
        String mapKeyPrfix = "";
        if (!StringUtil.isEmpty((String)controlKey)) {
            mapKeyPrfix = controlKey;
        }
        if (StringUtils.isNotEmpty((CharSequence)(cacheId = cacheMap.get(mapKeyPrfix + "BILLLIST_cacheId"))) && !cacheId.startsWith("onlyonepage_")) {
            CachedDataSet cds = Algo.getCacheDataSet((String)cacheId);
            int rowCount = cds.getRowCount();
            List dsRows = limit < 0 ? cds.getList(start, rowCount) : cds.getList(start, limit);
            DynamicObjectCollection dynamicObjectCollection = new DynamicObjectCollection(dt, null);
            RowMeta rowMeta = cds.getRowMeta();
            int n = rowMeta.getFieldCount();
            ArrayList<Mapper> mappers = new ArrayList<Mapper>(n);
            for (int i = 0; i < n; ++i) {
                DynamicProperty property = dt.getProperty(rowMeta.getField(i).getName());
                if (property == null) continue;
                Mapper mapper = new Mapper();
                mapper.index = i;
                mapper.property = property instanceof BasedataProp ? ((BasedataProp)property).getRefIdProp() : property;
                mappers.add(mapper);
            }
            Iterator iterator = dsRows.iterator();
            while (iterator.hasNext()) {
                DynamicObject obj = new DynamicObject(dt);
                Row row = (Row)iterator.next();
                for (Mapper mp : mappers) {
                    mp.property.setValueFast((Object)obj, row.get(mp.index));
                }
                dynamicObjectCollection.add((Object)obj);
            }
            return dynamicObjectCollection;
        }
        return new DynamicObjectCollection(dt, null);
    }
}

