/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.list.query;

import kd.bos.entity.list.IQuery;
import kd.bos.list.query.impl.IdQuery;
import kd.bos.list.query.impl.SqlQuery;

public class QueryFactory {
    private static final String QUERYTYPEKEY = "bos.billlist.queryType";

    public static boolean isSqlQuery() {
        String queryType = System.getProperty(QUERYTYPEKEY, "IdQuery");
        return "SqlQuery".equalsIgnoreCase(queryType);
    }

    public static IQuery createQuery() {
        if (QueryFactory.isSqlQuery()) {
            return QueryFactory.createSqlQuery();
        }
        return QueryFactory.createIdQuery();
    }

    public static IQuery createSqlQuery() {
        return new SqlQuery();
    }

    public static IQuery createIdQuery() {
        return new IdQuery();
    }
}

