/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.list.query;

import java.io.ByteArrayInputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.EntryType;
import kd.bos.entity.NumberFormatProvider;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.datamodel.FmtField;
import kd.bos.entity.datamodel.ListField;
import kd.bos.entity.datamodel.NumberPrecision;
import kd.bos.entity.list.QueryBuilder;
import kd.bos.entity.list.QueryResult;
import kd.bos.entity.list.SummaryResult;
import kd.bos.entity.property.BasedataProp;
import kd.bos.ksql.util.StringUtil;
import kd.bos.list.query.Mapper;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.io.ByteArrayOutputStream;

public class QueryUtils {
    QueryBuilder queryBuilder;
    Set<String> idHistoryList = new HashSet<String>();
    private static Log logger = LogFactory.getLog(QueryUtils.class);
    int startBillIndex = 1;

    public int getStartBillIndex() {
        return this.startBillIndex;
    }

    public void setStartBillIndex(int startBillIndex) {
        this.startBillIndex = startBillIndex;
    }

    public QueryUtils(QueryBuilder queryBuilder) {
        this.queryBuilder = queryBuilder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueryResult getQueryResult(DataSet ds) {
        try {
            final Iterator iter = ds.iterator();
            for (int i = 0; i < this.queryBuilder.getStart() && iter.hasNext(); ++i) {
                iter.next();
            }
            Iterator<Row> pagedIter = new Iterator<Row>(){
                int i = 0;

                @Override
                public Row next() {
                    return (Row)iter.next();
                }

                @Override
                public boolean hasNext() {
                    if (++this.i > QueryUtils.this.queryBuilder.getLimit()) {
                        return false;
                    }
                    return iter.hasNext();
                }
            };
            QueryResult queryResult = this.getQueryResult(pagedIter, ds.getRowMeta(), true);
            return queryResult;
        }
        finally {
            ds.close();
        }
    }

    public static String objToStr(Object obj) {
        String serStr = null;
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
             ObjectOutputStream objectOutputStream = new ObjectOutputStream((OutputStream)byteArrayOutputStream);){
            objectOutputStream.writeObject(obj);
            serStr = byteArrayOutputStream.toString("ISO-8859-1");
            serStr = URLEncoder.encode(serStr, "UTF-8");
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return serStr;
    }

    public static Object strToObj(String serStr) {
        Object obj = null;
        try {
            String deserStr = URLDecoder.decode(serStr, "UTF-8");
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(deserStr.getBytes("ISO-8859-1"));
            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
            obj = objectInputStream.readObject();
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return obj;
    }

    public static List<SummaryResult> getSRList(String sRStr) {
        ArrayList<SummaryResult> result = new ArrayList<SummaryResult>();
        if (!StringUtil.isEmpty((String)sRStr)) {
            String[] arr;
            for (String str : arr = sRStr.split(",")) {
                result.add((SummaryResult)QueryUtils.strToObj(str));
            }
        }
        return result;
    }

    public static String sRListToStr(List<SummaryResult> list) {
        StringBuilder sbStr = new StringBuilder();
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            if (i < size - 1) {
                sbStr.append(QueryUtils.objToStr(list.get(i)));
                sbStr.append(',');
                continue;
            }
            sbStr.append(QueryUtils.objToStr(list.get(i)));
        }
        return sbStr.toString();
    }

    private boolean isNeedSum(ListField listField, String thisId, String thisEntryId, String thisSubEntryId) {
        IDataEntityType dataEntityType = listField.getSrcFieldProp().getParent();
        return dataEntityType instanceof SubEntryType || dataEntityType instanceof EntryType && !(dataEntityType instanceof SubEntryType) && !this.idHistoryList.contains(thisId + thisEntryId) || !(dataEntityType instanceof EntryType) && !(dataEntityType instanceof SubEntryType) && !this.idHistoryList.contains(thisId);
    }

    public void addRowSummaryResult(Row row, Map<String, Mapper> mappers, Map<String, SummaryResult> sumResultsMap) {
        Object entryPkObject;
        String thisSubEntryId = "";
        String thisEntryId = "";
        List list = this.queryBuilder.getPkFields();
        String thisId = row.get(mappers.get((Object)((ListField)list.get((int)0)).getFieldName()).index).toString();
        if (list.size() == 2) {
            entryPkObject = row.get(mappers.get((Object)((ListField)list.get((int)1)).getFieldName()).index);
            if (entryPkObject != null) {
                thisEntryId = row.get(mappers.get((Object)((ListField)list.get((int)1)).getFieldName()).index).toString();
            }
        } else if (list.size() == 3) {
            entryPkObject = row.get(mappers.get((Object)((ListField)list.get((int)1)).getFieldName()).index);
            Object subEntryPkObject = row.get(mappers.get((Object)((ListField)list.get((int)2)).getFieldName()).index);
            if (entryPkObject != null) {
                thisEntryId = entryPkObject.toString();
            }
            if (subEntryPkObject != null) {
                thisSubEntryId = subEntryPkObject.toString();
            }
        }
        for (ListField sumField : this.queryBuilder.getSumFields()) {
            Object value;
            Mapper mapper = mappers.get(sumField.getFieldName());
            if (mapper == null || !this.isNeedSum(sumField, thisId, thisEntryId, thisSubEntryId) || (value = row.get(mapper.index)) == null) continue;
            sumResultsMap.get(sumField.getListFieldKey().replace('.', '_')).addResult(new BigDecimal(value.toString()));
        }
        if (list.size() == 1) {
            this.idHistoryList.add(thisId);
        } else if (list.size() >= 2) {
            this.idHistoryList.add(thisId);
            this.idHistoryList.add(thisId + thisEntryId);
        }
    }

    private void setSummaryResult(NumberFormatProvider numberFormatProvider, List<SummaryResult> summaryResults) {
        for (SummaryResult summaryResult : summaryResults) {
            NumberPrecision numberPrecision = numberFormatProvider.getFormatPrecision(summaryResult.getFieldName(), null);
            numberPrecision.setResult(summaryResult.getNumberPrecision().getResult());
            summaryResult.setNumberPrecision(numberPrecision);
        }
    }

    private QueryResult getQueryResult(Iterator<Row> iter, Map<String, Mapper> mappers, boolean isFirst) {
        Mapper seqMapper = new Mapper();
        seqMapper.property = this.queryBuilder.getReturnEntityType().getProperty(this.queryBuilder.getSeqField());
        Iterator prePK = null;
        int seqIndex = 1;
        int rowIndex = 0;
        DynamicObjectCollection dynamicObjectCollection = new DynamicObjectCollection(this.queryBuilder.getReturnEntityType(), null);
        QueryResult queryResult = new QueryResult();
        Mapper pkMapper = mappers.get(this.queryBuilder.getReturnEntityType().getPrimaryKey().getName().toLowerCase());
        ArrayList<SummaryResult> summaryResults = new ArrayList<SummaryResult>(16);
        HashMap<String, SummaryResult> sumResultsMap = new HashMap<String, SummaryResult>(16);
        for (ListField sumField : this.queryBuilder.getSumFields()) {
            SummaryResult summaryResult = new SummaryResult(sumField.getListFieldKey().replace('.', '_'), new BigDecimal("0"), sumField.getSummary());
            sumResultsMap.put(summaryResult.getFieldName(), summaryResult);
            summaryResults.add(summaryResult);
        }
        while (iter.hasNext()) {
            Row row = iter.next();
            Iterator curPK = null;
            if (pkMapper != null) {
                curPK = row.get(pkMapper.index);
            }
            if (prePK != null && curPK != null && !curPK.equals(prePK)) {
                ++seqIndex;
            }
            prePK = curPK;
            if (rowIndex >= this.queryBuilder.getStart() && rowIndex < this.queryBuilder.getStart() + this.queryBuilder.getLimit()) {
                DynamicObject obj = new DynamicObject(this.queryBuilder.getReturnEntityType());
                for (Map.Entry<String, Mapper> entry : mappers.entrySet()) {
                    entry.getValue().property.setValueFast((Object)obj, row.get(entry.getValue().index));
                }
                if (seqMapper.property != null) {
                    seqMapper.property.setValueFast((Object)obj, (Object)seqIndex);
                }
                dynamicObjectCollection.add((Object)obj);
            }
            if (!this.queryBuilder.getSumFields().isEmpty()) {
                this.addRowSummaryResult(row, mappers, sumResultsMap);
            }
            ++rowIndex;
        }
        queryResult.setLastBillIndex(seqIndex);
        BusinessDataReader.loadRefence(dynamicObjectCollection.toArray((Object[])new DynamicObject[dynamicObjectCollection.size()]), (IDataEntityType)dynamicObjectCollection.getDynamicObjectType());
        ArrayList<FmtField> fmtFields = new ArrayList<FmtField>(16);
        for (ListField field : this.queryBuilder.getDecimalFields()) {
            FmtField fmtField = new FmtField(field.getSrcFieldProp(), field.getListFieldKey().replace('.', '_'), field.getControlField() != null ? field.getControlField().getFieldName() : "");
            fmtField.setControlFieldKey(field.getControlField() != null ? field.getControlField().getListFieldKey() : "");
            fmtFields.add(fmtField);
        }
        NumberFormatProvider numberFormatProvider = new NumberFormatProvider(fmtFields, dynamicObjectCollection);
        queryResult.setNumberFormatProvider(numberFormatProvider);
        if (isFirst) {
            this.setSummaryResult(numberFormatProvider, summaryResults);
            queryResult.setSummaryResults(summaryResults);
        }
        queryResult.setCollection(dynamicObjectCollection);
        queryResult.setDataCount(rowIndex);
        return queryResult;
    }

    public QueryResult getQueryResult(Iterator<Row> iter, RowMeta rowMeta, boolean isFirst) {
        int n = rowMeta.getFieldCount();
        HashMap<String, Mapper> mappers = new HashMap<String, Mapper>();
        for (int i = 0; i < n; ++i) {
            DynamicProperty property = this.queryBuilder.getReturnEntityType().getProperty(rowMeta.getField(i).getName());
            if (property == null) continue;
            Mapper mapper = new Mapper();
            mapper.index = i;
            mapper.property = property instanceof BasedataProp ? ((BasedataProp)property).getRefIdProp() : property;
            mappers.put(rowMeta.getField(i).getName().toLowerCase(), mapper);
        }
        return this.getQueryResult(iter, mappers, isFirst);
    }
}

