/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.list.query;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.SqlParameter;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.filter.FilterScheme;
import kd.bos.entity.filter.FilterSchemeL;
import kd.bos.entity.filter.LocaleFilterScheme;
import kd.bos.entity.filter.SchemeShareUser;
import kd.bos.entity.filter.ShareFilterScheme;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.lang.Lang;

public class SchemeQuery {
    private static final String SCHEMEQUERY_SQL1 = "SELECT T1.FSCHEMEID,T1.FFORMID,T1.FSCHEMENAME,";
    private static final String SCHEMEQUERY_SQL2 = "T1.FUSERID,T1.FISDEFAULT,T1.FSCHEME,T1.FISSHARE,";
    private static final String SCHEMEQUERY_SQL3 = "FROM T_BAS_FILTERSCHEME ";
    private static final String SCHEMEQUERY_SQL4 = "T1.FNEXTENTRYSCHEME,T1.FSEQ,T1.FENTRYENTITY,T1.FISFIXED,T2.FLOCALEID,T2.FNAME,T2.FDESCRIPTION,T2.FID,T2.FPKID,T2.FSCHEMEID,T1.FCREATETIME,T1.FMODIFYTIME,T1.FISF7  ";
    private static final String SCHEMEQUERY_SQL5 = "FROM T_BAS_FILTERSCHEME T1 LEFT JOIN T_BAS_FILTERSCHEME_L T2 ON T1.FSCHEMEID = T2.FID ";
    private static final String SCHEMEQUERY_SQL6 = "SELECT T1.FSCHEMEID,T1.FFORMID,T1.FSCHEMENAME,T1.FUSERID,T1.FISDEFAULT,";
    private static String eRROR = "Error:%s";
    private static String eRRORANDSQL = "error:%s;  sql:%s";
    private static final String FFORMID = ":FFORMID";
    private static final String FUSERID = ":FUSERID";
    private static final String T_BAS_SHAREFILTERSCHEME = "FROM T_BAS_SHAREFILTERSCHEME ";
    private static final String FID = "WHERE FID=?  ";

    @Deprecated
    public List<FilterScheme> getSchemeList() {
        String sql = "SELECT T1.FSCHEMEID,T1.FFORMID,T1.FSCHEMENAME,T1.FUSERID,T1.FISDEFAULT,T1.FSCHEME,T1.FISSHARE,T1.FNEXTENTRYSCHEME,T1.FSEQ,T1.FENTRYENTITY,T1.FISFIXED,T2.FLOCALEID,T2.FNAME,T2.FDESCRIPTION,T2.FID,T2.FPKID,T2.FSCHEMEIDFROM T_BAS_FILTERSCHEME T1 LEFT JOIN T_BAS_FILTERSCHEME_L T2 ON T1.FSCHEMEID = T2.FID ";
        Map schemeMap = new HashMap();
        try {
            schemeMap = (Map)DB.query((DBRoute)DBRoute.basedata, (String)sql, null, (ResultSetHandler)new ResultSetHandler<Map<String, FilterScheme>>(){

                public Map<String, FilterScheme> handle(ResultSet rs) throws Exception {
                    HashMap<String, FilterScheme> map = new HashMap<String, FilterScheme>();
                    try {
                        while (rs.next()) {
                            FilterSchemeL filterSchemeL;
                            FilterScheme filterScheme;
                            if (map.containsKey(rs.getString(1))) {
                                filterScheme = (FilterScheme)map.get(rs.getString(1));
                                if (rs.getString(12) == null) continue;
                                filterSchemeL = new FilterSchemeL();
                                filterSchemeL.setDescription(rs.getString(14));
                                filterSchemeL.setId(rs.getString(15));
                                filterSchemeL.setLocaleId(rs.getString(12));
                                filterSchemeL.setName(rs.getString(13));
                                filterSchemeL.setPkId(rs.getString(16));
                                filterSchemeL.setSchemeId(rs.getString(17));
                                filterScheme.getLocaleFilterScheme().setItem(rs.getString(12), (Object)filterSchemeL);
                                continue;
                            }
                            filterScheme = new FilterScheme();
                            filterScheme.setId(rs.getString(1));
                            filterScheme.setFormId(rs.getString(2));
                            filterScheme.setSchemeName(rs.getString(3));
                            filterScheme.setUserId(rs.getLong(4));
                            filterScheme.setDefault(rs.getBoolean(5));
                            filterScheme.setScheme(rs.getString(6));
                            filterScheme.setShare(rs.getBoolean(7));
                            filterScheme.setNextEntryScheme(rs.getBoolean(8));
                            filterScheme.setSeq(rs.getInt(9));
                            filterScheme.setEntryEntity(rs.getString(10));
                            filterScheme.setFixed(rs.getBoolean(11));
                            if (rs.getString(12) != null) {
                                filterSchemeL = new FilterSchemeL();
                                filterSchemeL.setDescription(rs.getString(14));
                                filterSchemeL.setId(rs.getString(15));
                                filterSchemeL.setLocaleId(rs.getString(12));
                                filterSchemeL.setName(rs.getString(13));
                                filterSchemeL.setPkId(rs.getString(16));
                                filterSchemeL.setSchemeId(rs.getString(17));
                                filterScheme.getLocaleFilterScheme().setItem(rs.getString(12), (Object)filterSchemeL);
                            }
                            map.put(rs.getString(1), filterScheme);
                        }
                    }
                    catch (SQLException e) {
                        throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{String.format(eRROR, e.getMessage())});
                    }
                    return map;
                }
            });
        }
        catch (Exception e) {
            String msg = String.format(eRRORANDSQL, e.getMessage(), sql);
            throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{msg});
        }
        return new ArrayList<FilterScheme>(schemeMap.values());
    }

    public List<FilterScheme> getSchemeList(String formId) {
        String sql = "SELECT T1.FSCHEMEID,T1.FFORMID,T1.FSCHEMENAME,T1.FUSERID,T1.FISDEFAULT,T1.FSCHEME,T1.FISSHARE,T1.FNEXTENTRYSCHEME,T1.FSEQ,T1.FENTRYENTITY,T1.FISFIXED,T2.FLOCALEID,T2.FNAME,T2.FDESCRIPTION,T2.FID,T2.FPKID,T2.FSCHEMEID FROM T_BAS_FILTERSCHEME T1 LEFT JOIN T_BAS_FILTERSCHEME_L T2 ON T1.FSCHEMEID = T2.FID WHERE T1.FFORMID = ? AND T1.FISF7 = '0'";
        SqlParameter sqlfilter = new SqlParameter(FFORMID, 12, (Object)formId);
        Map schemeMap = new HashMap();
        try {
            schemeMap = (Map)DB.query((DBRoute)DBRoute.basedata, (String)sql, (Object[])new SqlParameter[]{sqlfilter}, (ResultSetHandler)new ResultSetHandler<Map<String, FilterScheme>>(){

                public Map<String, FilterScheme> handle(ResultSet rs) throws Exception {
                    HashMap<String, FilterScheme> map = new HashMap<String, FilterScheme>();
                    try {
                        while (rs.next()) {
                            FilterSchemeL filterSchemeL;
                            FilterScheme filterScheme;
                            if (map.containsKey(rs.getString(1))) {
                                filterScheme = (FilterScheme)map.get(rs.getString(1));
                                if (rs.getString(12) == null) continue;
                                filterSchemeL = new FilterSchemeL();
                                filterSchemeL.setDescription(rs.getString(14));
                                filterSchemeL.setId(rs.getString(15));
                                filterSchemeL.setLocaleId(rs.getString(12));
                                filterSchemeL.setName(rs.getString(13));
                                filterSchemeL.setPkId(rs.getString(16));
                                filterSchemeL.setSchemeId(rs.getString(17));
                                filterScheme.getLocaleFilterScheme().setItem(rs.getString(12), (Object)filterSchemeL);
                                continue;
                            }
                            filterScheme = new FilterScheme();
                            filterScheme.setId(rs.getString(1));
                            filterScheme.setFormId(rs.getString(2));
                            filterScheme.setSchemeName(rs.getString(3));
                            filterScheme.setUserId(rs.getLong(4));
                            filterScheme.setDefault(rs.getBoolean(5));
                            filterScheme.setScheme(rs.getString(6));
                            filterScheme.setShare(rs.getBoolean(7));
                            filterScheme.setNextEntryScheme(rs.getBoolean(8));
                            filterScheme.setSeq(rs.getInt(9));
                            filterScheme.setEntryEntity(rs.getString(10));
                            filterScheme.setFixed(rs.getBoolean(11));
                            if (rs.getString(12) != null) {
                                filterSchemeL = new FilterSchemeL();
                                filterSchemeL.setDescription(rs.getString(14));
                                filterSchemeL.setId(rs.getString(15));
                                filterSchemeL.setLocaleId(rs.getString(12));
                                filterSchemeL.setName(rs.getString(13));
                                filterSchemeL.setPkId(rs.getString(16));
                                filterSchemeL.setSchemeId(rs.getString(17));
                                filterScheme.getLocaleFilterScheme().setItem(rs.getString(12), (Object)filterSchemeL);
                            }
                            map.put(rs.getString(1), filterScheme);
                        }
                    }
                    catch (SQLException e) {
                        throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{String.format(eRROR, e.getMessage())});
                    }
                    return map;
                }
            });
        }
        catch (Exception e) {
            String msg = String.format(eRRORANDSQL, e.getMessage(), sql);
            throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{msg});
        }
        return new ArrayList<FilterScheme>(schemeMap.values());
    }

    public List<FilterScheme> getScheme(String formId, String userId) {
        return this.getFilterSchemes(formId, userId, false);
    }

    public List<FilterScheme> getF7Scheme(String formId, String userId) {
        return this.getFilterSchemes(formId, userId, true);
    }

    private List<FilterScheme> getFilterSchemes(String formId, String userId, boolean isF7) {
        SqlParameter[] params = !isF7 ? new SqlParameter[]{new SqlParameter(FFORMID, 12, (Object)formId), new SqlParameter(FFORMID, 12, (Object)formId), new SqlParameter(FUSERID, -5, (Object)Long.parseLong(userId)), new SqlParameter("fisf7", 1, (Object)isF7)} : new SqlParameter[]{new SqlParameter(FFORMID, 12, (Object)formId), new SqlParameter(FUSERID, -5, (Object)Long.parseLong(userId)), new SqlParameter("fisf7", 1, (Object)isF7)};
        String sql = (isF7 ? "" : "SELECT T1.FSCHEMEID,T1.FFORMID,T1.FSCHEMENAME,T1.FUSERID,T1.FISDEFAULT,T1.FSCHEME,T1.FISSHARE,T1.FNEXTENTRYSCHEME,T1.FSEQ,T1.FENTRYENTITY,T1.FISFIXED,T2.FLOCALEID,T2.FNAME,T2.FDESCRIPTION,T2.FID,T2.FPKID,T2.FSCHEMEID,T1.FCREATETIME,T1.FMODIFYTIME,T1.FISF7  FROM T_BAS_FILTERSCHEME T1 LEFT JOIN T_BAS_FILTERSCHEME_L T2 ON T1.FSCHEMEID = T2.FID WHERE T1.FFORMID=? AND T1.FISFIXED='1' UNION ALL ") + SCHEMEQUERY_SQL1 + SCHEMEQUERY_SQL2 + SCHEMEQUERY_SQL4 + SCHEMEQUERY_SQL5 + "WHERE T1.FFORMID=? AND T1.FISFIXED='0' AND T1.FUSERID=? AND T1.FISF7=? ORDER BY FCREATETIME DESC";
        return this.getSchemeList(params, sql);
    }

    private List<FilterScheme> getSchemeList(SqlParameter[] params, String sql) {
        ArrayList<FilterScheme> schemeList = new ArrayList();
        try {
            schemeList = (List)DB.query((DBRoute)DBRoute.basedata, (String)sql, (Object[])params, (ResultSetHandler)new ResultSetHandler<List<FilterScheme>>(){

                public List<FilterScheme> handle(ResultSet rs) throws Exception {
                    ArrayList<FilterScheme> list = new ArrayList<FilterScheme>();
                    HashMap<String, FilterScheme> map = new HashMap<String, FilterScheme>();
                    try {
                        while (rs.next()) {
                            FilterSchemeL filterSchemeL;
                            FilterScheme filterScheme;
                            if (map.containsKey(rs.getString(1))) {
                                filterScheme = (FilterScheme)map.get(rs.getString(1));
                                if (rs.getString(12) == null) continue;
                                filterSchemeL = new FilterSchemeL();
                                filterSchemeL.setDescription(rs.getString(14));
                                filterSchemeL.setId(rs.getString(15));
                                filterSchemeL.setLocaleId(rs.getString(12));
                                filterSchemeL.setName(rs.getString(13));
                                filterSchemeL.setPkId(rs.getString(16));
                                filterSchemeL.setSchemeId(rs.getString(17));
                                if (filterSchemeL.getLocaleId().equals(Lang.get().getLocale().toString())) {
                                    filterScheme.setDescription(filterSchemeL.getDescription());
                                }
                                filterScheme.getLocaleFilterScheme().setItem(rs.getString(12), (Object)filterSchemeL);
                                continue;
                            }
                            filterScheme = new FilterScheme();
                            filterScheme.setId(rs.getString(1));
                            filterScheme.setFormId(rs.getString(2));
                            filterScheme.setSchemeName(rs.getString(3));
                            filterScheme.setUserId(rs.getLong(4));
                            filterScheme.setDefault(rs.getBoolean(5));
                            filterScheme.setScheme(rs.getString(6));
                            filterScheme.setShare(rs.getBoolean(7));
                            filterScheme.setNextEntryScheme(rs.getBoolean(8));
                            filterScheme.setSeq(rs.getInt(9));
                            filterScheme.setEntryEntity(rs.getString(10));
                            filterScheme.setFixed(rs.getBoolean(11));
                            filterScheme.setCreateTime((Date)rs.getDate(18));
                            filterScheme.setModifyTime((Date)rs.getDate(19));
                            filterScheme.setF7(rs.getBoolean(20));
                            if (rs.getString(12) != null) {
                                filterSchemeL = new FilterSchemeL();
                                filterSchemeL.setDescription(rs.getString(14));
                                filterSchemeL.setId(rs.getString(15));
                                filterSchemeL.setLocaleId(rs.getString(12));
                                filterSchemeL.setName(rs.getString(13));
                                filterSchemeL.setPkId(rs.getString(16));
                                filterSchemeL.setSchemeId(rs.getString(17));
                                if (filterSchemeL.getLocaleId().equals(Lang.get().getLocale().toString())) {
                                    filterScheme.setDescription(filterSchemeL.getDescription());
                                }
                                filterScheme.getLocaleFilterScheme().setItem(rs.getString(12), (Object)filterSchemeL);
                            }
                            map.put(rs.getString(1), filterScheme);
                            list.add(filterScheme);
                        }
                    }
                    catch (SQLException e) {
                        throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{String.format(eRROR, e.getMessage())});
                    }
                    return list;
                }
            });
        }
        catch (Exception e) {
            String msg = String.format(eRRORANDSQL, e.getMessage(), sql);
            throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{msg});
        }
        return schemeList;
    }

    public List<FilterScheme> getSharedScheme(String formId, String userId) {
        return this.getF7SharedScheme(formId, userId, false);
    }

    public List<FilterScheme> getF7SharedScheme(String formId, String userId) {
        return this.getF7SharedScheme(formId, userId, true);
    }

    private List<FilterScheme> getF7SharedScheme(String formId, String userId, boolean isF7) {
        SqlParameter[] params = new SqlParameter[]{new SqlParameter(FFORMID, 12, (Object)formId), new SqlParameter(FUSERID, -5, (Object)Long.parseLong(userId)), new SqlParameter("fisf7", 1, (Object)isF7)};
        String sql = "SELECT T1.FSCHEMEID,T1.FFORMID,T1.FSCHEMENAME,T1.FUSERID,T1.FISDEFAULT,T1.FSCHEME,T1.FISSHARE,T1.FNEXTENTRYSCHEME,T1.FSEQ,T1.FENTRYENTITY,T1.FISFIXED,T2.FLOCALEID,T2.FNAME,T2.FDESCRIPTION,T2.FID,T2.FPKID,T2.FSCHEMEID,T1.FCREATETIME,T1.FMODIFYTIME,T1.FISF7  FROM T_BAS_FILTERSCHEME T1 LEFT JOIN T_BAS_FILTERSCHEME_L T2 ON T1.FSCHEMEID = T2.FID INNER JOIN T_BAS_SHAREFILTERSCHEME T3 ON T1.FSCHEMEID=T3.FSCHEMEID INNER JOIN T_BAS_SCHEMESHAREUSERS T4 ON T3.FID=T4.FID WHERE T1.FFORMID=? AND T4.FBASEDATAID=? AND T1.FISSHARE='1' AND T1.FISFIXED<>'1' AND T1.FISF7=?ORDER BY T3.FSHARETIME DESC";
        return this.getSchemeList(params, sql);
    }

    public FilterScheme getDefaultScheme(String formId, String userId) {
        Object[] params = new SqlParameter[]{new SqlParameter(FFORMID, 12, (Object)formId), new SqlParameter(FUSERID, -5, (Object)Long.parseLong(userId))};
        String sql = "SELECT T1.FSCHEMEID,T1.FFORMID,T1.FSCHEMENAME,T1.FUSERID,T1.FISDEFAULT,T1.FSCHEME,T1.FISSHARE,T1.FNEXTENTRYSCHEME,T1.FSEQ,T1.FENTRYENTITY,T1.FISFIXED,T2.FLOCALEID,T2.FNAME,T2.FDESCRIPTION,T2.FID,T2.FPKID,T2.FSCHEMEID  FROM T_BAS_FILTERSCHEME T1 LEFT JOIN T_BAS_FILTERSCHEME_L T2 ON T1.FSCHEMEID = T2.FID WHERE T1.FFORMID=? AND T1.FUSERID=? AND T1.FISDEFAULT='1' ";
        Map defSchemeMap = new HashMap();
        try {
            defSchemeMap = (Map)DB.query((DBRoute)DBRoute.basedata, (String)sql, (Object[])params, (ResultSetHandler)new ResultSetHandler<Map<String, FilterScheme>>(){

                public Map<String, FilterScheme> handle(ResultSet rs) throws Exception {
                    HashMap<String, FilterScheme> map = new HashMap<String, FilterScheme>();
                    try {
                        while (rs.next()) {
                            FilterSchemeL filterSchemeL;
                            if (map.containsKey(rs.getString(1))) {
                                FilterScheme filterScheme = (FilterScheme)map.get(rs.getString(1));
                                if (rs.getString(12) == null) continue;
                                filterSchemeL = new FilterSchemeL();
                                filterSchemeL.setDescription(rs.getString(14));
                                filterSchemeL.setId(rs.getString(15));
                                filterSchemeL.setLocaleId(rs.getString(12));
                                filterSchemeL.setName(rs.getString(13));
                                filterSchemeL.setSchemeId(rs.getString(17));
                                filterSchemeL.setPkId(rs.getString(16));
                                filterScheme.getLocaleFilterScheme().setItem(rs.getString(12), (Object)filterSchemeL);
                                continue;
                            }
                            if (map.size() <= 1) {
                                FilterScheme defScheme = new FilterScheme();
                                defScheme.setId(rs.getString(1));
                                defScheme.setFormId(rs.getString(2));
                                defScheme.setSchemeName(rs.getString(3));
                                defScheme.setUserId(rs.getLong(4));
                                defScheme.setDefault(rs.getBoolean(5));
                                defScheme.setScheme(rs.getString(6));
                                defScheme.setShare(rs.getBoolean(7));
                                defScheme.setNextEntryScheme(rs.getBoolean(8));
                                defScheme.setSeq(rs.getInt(9));
                                defScheme.setEntryEntity(rs.getString(10));
                                defScheme.setFixed(rs.getBoolean(11));
                                if (rs.getString(12) != null) {
                                    filterSchemeL = new FilterSchemeL();
                                    filterSchemeL.setDescription(rs.getString(14));
                                    filterSchemeL.setId(rs.getString(15));
                                    filterSchemeL.setLocaleId(rs.getString(12));
                                    filterSchemeL.setName(rs.getString(13));
                                    filterSchemeL.setSchemeId(rs.getString(17));
                                    filterSchemeL.setPkId(rs.getString(16));
                                    defScheme.getLocaleFilterScheme().setItem(rs.getString(12), (Object)filterSchemeL);
                                }
                                map.put(rs.getString(1), defScheme);
                                continue;
                            }
                            break;
                        }
                    }
                    catch (SQLException e) {
                        throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{String.format(eRROR, e.getMessage())});
                    }
                    return map;
                }
            });
        }
        catch (Exception e) {
            String msg = String.format(eRRORANDSQL, e.getMessage(), sql);
            throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{msg});
        }
        return (FilterScheme)new ArrayList(defSchemeMap.values()).get(0);
    }

    public List<FilterScheme> getPreScheme(String formId) {
        Object[] params = new SqlParameter[]{new SqlParameter(FFORMID, 12, (Object)formId)};
        String sql = "SELECT T1.FSCHEMEID,T1.FFORMID,T1.FSCHEMENAME,T1.FUSERID,T1.FISDEFAULT,T1.FSCHEME,T1.FISSHARE,T1.FNEXTENTRYSCHEME,T1.FSEQ,T1.FENTRYENTITY,T1.FISFIXED,T2.FLOCALEID,T2.FNAME,T2.FDESCRIPTION,T2.FID,T2.FPKID,T2.FSCHEMEID  FROM T_BAS_FILTERSCHEME T1 LEFT JOIN T_BAS_FILTERSCHEME_L T2 ON T1.FSCHEMEID = T2.FID WHERE  T1.FFORMID=? AND T1.FISFIXED='1'";
        Map schemeMap = new HashMap();
        try {
            schemeMap = (Map)DB.query((DBRoute)DBRoute.basedata, (String)sql, (Object[])params, (ResultSetHandler)new ResultSetHandler<Map<String, FilterScheme>>(){

                public Map<String, FilterScheme> handle(ResultSet rs) throws Exception {
                    HashMap<String, FilterScheme> map = new HashMap<String, FilterScheme>();
                    try {
                        while (rs.next()) {
                            FilterSchemeL filterSchemeL;
                            FilterScheme filterScheme;
                            if (map.containsKey(rs.getString(1))) {
                                filterScheme = (FilterScheme)map.get(rs.getString(1));
                                if (rs.getString(12) == null) continue;
                                filterSchemeL = new FilterSchemeL();
                                filterSchemeL.setDescription(rs.getString(14));
                                filterSchemeL.setId(rs.getString(15));
                                filterSchemeL.setLocaleId(rs.getString(12));
                                filterSchemeL.setName(rs.getString(13));
                                filterSchemeL.setPkId(rs.getString(16));
                                filterSchemeL.setSchemeId(rs.getString(17));
                                filterScheme.getLocaleFilterScheme().setItem(rs.getString(12), (Object)filterSchemeL);
                                continue;
                            }
                            filterScheme = new FilterScheme();
                            filterScheme.setId(rs.getString(1));
                            filterScheme.setFormId(rs.getString(2));
                            filterScheme.setSchemeName(rs.getString(3));
                            filterScheme.setUserId(rs.getLong(4));
                            filterScheme.setDefault(rs.getBoolean(5));
                            filterScheme.setScheme(rs.getString(6));
                            filterScheme.setShare(rs.getBoolean(7));
                            filterScheme.setNextEntryScheme(rs.getBoolean(8));
                            filterScheme.setSeq(rs.getInt(9));
                            filterScheme.setEntryEntity(rs.getString(10));
                            filterScheme.setFixed(rs.getBoolean(11));
                            if (rs.getString(12) != null) {
                                filterSchemeL = new FilterSchemeL();
                                filterSchemeL.setDescription(rs.getString(14));
                                filterSchemeL.setId(rs.getString(15));
                                filterSchemeL.setLocaleId(rs.getString(12));
                                filterSchemeL.setName(rs.getString(13));
                                filterSchemeL.setSchemeId(rs.getString(17));
                                filterSchemeL.setPkId(rs.getString(16));
                                filterScheme.getLocaleFilterScheme().setItem(rs.getString(12), (Object)filterSchemeL);
                            }
                            map.put(rs.getString(1), filterScheme);
                        }
                    }
                    catch (SQLException e) {
                        throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{String.format(eRROR, e.getMessage())});
                    }
                    return map;
                }
            });
        }
        catch (Exception e) {
            String msg = String.format(eRRORANDSQL, e.getMessage(), sql);
            throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{msg});
        }
        return new ArrayList<FilterScheme>(schemeMap.values());
    }

    public FilterScheme getScheme(String fSchemeId) {
        Object[] params = new SqlParameter[]{new SqlParameter(":FSCHEMEID", 12, (Object)fSchemeId)};
        String sql = "SELECT T1.FSCHEMEID,T1.FFORMID,T1.FSCHEMENAME,T1.FUSERID,T1.FISDEFAULT,T1.FSCHEME,T1.FISSHARE,T1.FNEXTENTRYSCHEME,T1.FSEQ,T1.FENTRYENTITY,T1.FISFIXED,T2.FLOCALEID,T2.FNAME,T2.FDESCRIPTION,T2.FID,T2.FPKID,T2.FSCHEMEID,T1.FCREATETIME,T1.FMODIFYTIME,T1.FISF7 FROM T_BAS_FILTERSCHEME T1 LEFT JOIN T_BAS_FILTERSCHEME_L T2 ON T1.FSCHEMEID = T2.FID WHERE T1.FSCHEMEID=?";
        Map schemeMap = new HashMap();
        try {
            schemeMap = (Map)DB.query((DBRoute)DBRoute.basedata, (String)sql, (Object[])params, (ResultSetHandler)new ResultSetHandler<Map<String, FilterScheme>>(){

                public Map<String, FilterScheme> handle(ResultSet rs) throws Exception {
                    HashMap<String, FilterScheme> map = new HashMap<String, FilterScheme>();
                    try {
                        while (rs.next()) {
                            FilterSchemeL filterSchemeL;
                            FilterScheme filterScheme;
                            if (map.containsKey(rs.getString(1))) {
                                filterScheme = (FilterScheme)map.get(rs.getString(1));
                                if (rs.getString(12) == null) continue;
                                filterSchemeL = new FilterSchemeL();
                                filterSchemeL.setDescription(rs.getString(14));
                                filterSchemeL.setId(rs.getString(15));
                                filterSchemeL.setLocaleId(rs.getString(12));
                                filterSchemeL.setName(rs.getString(13));
                                filterSchemeL.setPkId(rs.getString(16));
                                filterSchemeL.setSchemeId(rs.getString(17));
                                if (filterSchemeL.getLocaleId().equals(Lang.get().getLocale().toString())) {
                                    filterScheme.setDescription(filterSchemeL.getDescription());
                                }
                                filterScheme.getLocaleFilterScheme().setItem(rs.getString(12), (Object)filterSchemeL);
                                continue;
                            }
                            filterScheme = new FilterScheme();
                            filterScheme.setId(rs.getString(1));
                            filterScheme.setFormId(rs.getString(2));
                            filterScheme.setSchemeName(rs.getString(3));
                            filterScheme.setUserId(rs.getLong(4));
                            filterScheme.setDefault(rs.getBoolean(5));
                            filterScheme.setScheme(rs.getString(6));
                            filterScheme.setShare(rs.getBoolean(7));
                            filterScheme.setNextEntryScheme(rs.getBoolean(8));
                            filterScheme.setSeq(rs.getInt(9));
                            filterScheme.setEntryEntity(rs.getString(10));
                            filterScheme.setFixed(rs.getBoolean(11));
                            filterScheme.setCreateTime((Date)rs.getDate(18));
                            filterScheme.setModifyTime((Date)rs.getDate(19));
                            filterScheme.setF7(rs.getBoolean(20));
                            if (rs.getString(12) != null) {
                                filterSchemeL = new FilterSchemeL();
                                filterSchemeL.setDescription(rs.getString(14));
                                filterSchemeL.setId(rs.getString(15));
                                filterSchemeL.setLocaleId(rs.getString(12));
                                filterSchemeL.setName(rs.getString(13));
                                filterSchemeL.setPkId(rs.getString(16));
                                filterSchemeL.setSchemeId(rs.getString(17));
                                if (filterSchemeL.getLocaleId().equals(Lang.get().getLocale().toString())) {
                                    filterScheme.setDescription(filterSchemeL.getDescription());
                                }
                                filterScheme.getLocaleFilterScheme().setItem(rs.getString(12), (Object)filterSchemeL);
                            }
                            map.put(rs.getString(1), filterScheme);
                        }
                    }
                    catch (SQLException e) {
                        throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{String.format(eRROR, e.getMessage())});
                    }
                    return map;
                }
            });
        }
        catch (Exception e) {
            String msg = String.format(eRRORANDSQL, e.getMessage(), sql);
            throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{msg});
        }
        if (schemeMap.values().isEmpty()) {
            return null;
        }
        return (FilterScheme)new ArrayList(schemeMap.values()).get(0);
    }

    public LocaleFilterScheme getSchemeL(String fSchemeId) {
        Object[] params = new SqlParameter[]{new SqlParameter(":FPKID", 12, (Object)fSchemeId)};
        String sql = "SELECT FLOCALEID,FNAME,FDESCRIPTION,FID,FPKID,FSCHEMEID  FROM   T_BAS_FILTERSCHEME_L  WHERE FID=?";
        LocaleFilterScheme schemeMap = new LocaleFilterScheme();
        try {
            schemeMap = (LocaleFilterScheme)DB.query((DBRoute)DBRoute.basedata, (String)sql, (Object[])params, (ResultSetHandler)new ResultSetHandler<LocaleFilterScheme>(){

                public LocaleFilterScheme handle(ResultSet rs) throws Exception {
                    LocaleFilterScheme map = new LocaleFilterScheme();
                    try {
                        while (rs.next()) {
                            FilterSchemeL filterSchemeL = new FilterSchemeL();
                            filterSchemeL.setLocaleId(rs.getString(1));
                            filterSchemeL.setName(rs.getString(2));
                            filterSchemeL.setDescription(rs.getString(3));
                            filterSchemeL.setId(rs.getString(4));
                            filterSchemeL.setPkId(rs.getString(5));
                            filterSchemeL.setSchemeId(rs.getString(6));
                            map.setItem(rs.getString(1), (Object)filterSchemeL);
                        }
                    }
                    catch (SQLException e) {
                        throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{String.format(eRROR, e.getMessage())});
                    }
                    return map;
                }
            });
        }
        catch (Exception e) {
            String msg = String.format(eRRORANDSQL, e.getMessage(), sql);
            throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{msg});
        }
        return schemeMap;
    }

    public List<Long> getShareUserFpkid(String formId) {
        ArrayList<Long> fPkidList = new ArrayList(10);
        String sql = "select u.fpkid from t_bas_filterscheme f, t_bas_sharefilterscheme s, t_bas_schemeshareusers u where f.fformid = '" + formId + "' and s.fschemeid = f.fschemeid and s.fid = u.fid and u.fbasedataid = " + RequestContext.get().getCurrUserId();
        try {
            fPkidList = (List)DB.query((DBRoute)DBRoute.basedata, (String)sql, (ResultSetHandler)new ResultSetHandler<List<Long>>(){

                public List<Long> handle(ResultSet rs) throws KDException {
                    ArrayList<Long> list = new ArrayList<Long>(10);
                    try {
                        while (rs.next()) {
                            list.add(rs.getLong(1));
                        }
                    }
                    catch (SQLException e) {
                        throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{String.format("Error:%s", e.getMessage())});
                    }
                    return list;
                }
            });
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[0]);
        }
        return fPkidList;
    }

    public Long getSchemeshareusersPkid(String schemeId, Long userId) {
        long fid = 0L;
        String sql = "select u.fpkid from t_bas_sharefilterscheme s, t_bas_schemeshareusers u where s.fschemeid = '" + schemeId + "' and s.fid = u.fid and u.fbasedataid = " + userId;
        try {
            fid = (Long)DB.query((DBRoute)DBRoute.basedata, (String)sql, (ResultSetHandler)new ResultSetHandler<Long>(){

                public Long handle(ResultSet rs) throws KDException {
                    Long sFdata = 0L;
                    try {
                        if (rs.next()) {
                            sFdata = rs.getLong(1);
                        }
                    }
                    catch (SQLException e) {
                        throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{String.format("Error:%s", e.getMessage())});
                    }
                    return sFdata;
                }
            });
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[0]);
        }
        return fid;
    }

    private String stringListToString(List<String> list) {
        StringBuilder sb = new StringBuilder();
        for (String s : list) {
            sb.append("'").append(s).append("'").append(",");
        }
        return sb.substring(0, sb.length() - 1);
    }

    public ShareFilterScheme getSharedScheme(String schemeId) {
        Object[] params = new SqlParameter[]{new SqlParameter(":FSCHEMEID", 12, (Object)schemeId)};
        String sql = "SELECT FID,FSCHEMEID FROM T_BAS_SHAREFILTERSCHEME WHERE FSCHEMEID=?  ";
        ShareFilterScheme shareFilterScheme = null;
        try {
            shareFilterScheme = (ShareFilterScheme)DB.query((DBRoute)DBRoute.basedata, (String)sql, (Object[])params, (ResultSetHandler)new ResultSetHandler<ShareFilterScheme>(){

                public ShareFilterScheme handle(ResultSet rs) throws Exception {
                    ShareFilterScheme shareFilterScheme = new ShareFilterScheme();
                    try {
                        if (rs.next()) {
                            shareFilterScheme.setId(rs.getLong(1));
                            shareFilterScheme.setSchemeId(rs.getString(2));
                        }
                    }
                    catch (SQLException e) {
                        throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{String.format(eRROR, e.getMessage())});
                    }
                    return shareFilterScheme;
                }
            });
        }
        catch (Exception e) {
            String msg = String.format(eRRORANDSQL, e.getMessage(), sql);
            throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{msg});
        }
        return shareFilterScheme;
    }

    public ShareFilterScheme getSharedScheme(long id) {
        Object[] params = new SqlParameter[]{new SqlParameter(":FID", -5, (Object)id)};
        String sql = "SELECT FID,FSCHEMEID FROM T_BAS_SHAREFILTERSCHEME WHERE FID=?  ";
        ShareFilterScheme shareFilterScheme = null;
        try {
            shareFilterScheme = (ShareFilterScheme)DB.query((DBRoute)DBRoute.basedata, (String)sql, (Object[])params, (ResultSetHandler)new ResultSetHandler<ShareFilterScheme>(){

                public ShareFilterScheme handle(ResultSet rs) throws Exception {
                    ShareFilterScheme shareFilterScheme = new ShareFilterScheme();
                    try {
                        if (rs.next()) {
                            shareFilterScheme.setId(rs.getLong(1));
                            shareFilterScheme.setSchemeId(rs.getString(2));
                        }
                    }
                    catch (SQLException e) {
                        throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{String.format(eRROR, e.getMessage())});
                    }
                    return shareFilterScheme;
                }
            });
        }
        catch (Exception e) {
            String msg = String.format(eRRORANDSQL, e.getMessage(), sql);
            throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{msg});
        }
        return shareFilterScheme;
    }

    public List<SchemeShareUser> getSchemeShareUsers(long id) {
        Object[] params = new SqlParameter[]{new SqlParameter(":FID", -5, (Object)id)};
        String sql = "SELECT FPKID,FID,FBASEDATAID FROM T_BAS_SCHEMESHAREUSERS WHERE FID=?  ";
        final ArrayList<SchemeShareUser> schemeShareUsers = new ArrayList<SchemeShareUser>();
        try {
            DB.query((DBRoute)DBRoute.basedata, (String)sql, (Object[])params, (ResultSetHandler)new ResultSetHandler<Void>(){

                public Void handle(ResultSet rs) throws Exception {
                    try {
                        while (rs.next()) {
                            SchemeShareUser schemeShareUser = new SchemeShareUser();
                            schemeShareUser.setPkId(rs.getLong(1));
                            schemeShareUser.setId(rs.getLong(2));
                            schemeShareUser.setUserId(rs.getLong(3));
                            schemeShareUsers.add(schemeShareUser);
                        }
                    }
                    catch (SQLException e) {
                        throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{String.format(eRROR, e.getMessage())});
                    }
                    return null;
                }
            });
        }
        catch (Exception e) {
            String msg = String.format(eRRORANDSQL, e.getMessage(), sql);
            throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{msg});
        }
        return schemeShareUsers;
    }

    public static boolean isSchemeShared(long shareSchemeId) {
        Object[] params = new SqlParameter[]{new SqlParameter(":FID", -5, (Object)shareSchemeId)};
        String sql = "SELECT COUNT(*) FROM T_BAS_SHAREFILTERSCHEME WHERE FID=?  ";
        return (Integer)DB.query((DBRoute)DBRoute.basedata, (String)sql, (Object[])params, (ResultSetHandler)new ResultSetHandler<Integer>(){

            public Integer handle(ResultSet rs) throws Exception {
                int isvcount = 0;
                if (rs.next()) {
                    isvcount = rs.getInt(1);
                }
                return isvcount;
            }
        }) > 0;
    }

    public Map<String, String> getShareSchemeByIdList(List<String> schemeIdList, Long userId) {
        HashMap<String, String> resMap = new HashMap(16);
        String ids = this.stringListToString(schemeIdList);
        String sql = "select s.fschemeid, u.fisdefault from t_bas_sharefilterscheme s, t_bas_schemeshareusers u where s.fschemeid in(" + ids + ") and s.fid = u.fid and u.fbasedataid = " + userId;
        try {
            resMap = (Map)DB.query((DBRoute)DBRoute.basedata, (String)sql, (ResultSetHandler)new ResultSetHandler<Map<String, String>>(){

                public Map<String, String> handle(ResultSet rs) throws KDException {
                    HashMap<String, String> sFdata = new HashMap<String, String>(16);
                    try {
                        while (rs.next()) {
                            sFdata.put(rs.getString(1), rs.getString(2));
                        }
                    }
                    catch (SQLException e) {
                        throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{String.format("Error:%s", e.getMessage())});
                    }
                    return sFdata;
                }
            });
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[0]);
        }
        return resMap;
    }

    public Map<String, Integer> getShareSchemeMap(long userId, List<String> schemeIdList) {
        HashMap<String, Integer> resMap = new HashMap();
        String ids = this.stringListToString(schemeIdList);
        String sql = "select s.fschemeid , u.fisdefault  from t_bas_sharefilterscheme s, t_bas_schemeshareusers u where s.fschemeid in (" + ids + ") and s.fid = u.fid and u.fbasedataid = " + userId;
        try {
            resMap = (Map)DB.query((DBRoute)DBRoute.basedata, (String)sql, (ResultSetHandler)new ResultSetHandler<Map>(){

                public Map handle(ResultSet rs) throws KDException {
                    HashMap<String, Integer> map = new HashMap<String, Integer>();
                    try {
                        while (rs.next()) {
                            map.put(rs.getString(1), rs.getInt(2));
                        }
                    }
                    catch (SQLException e) {
                        throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{String.format("Error:%s", e.getMessage())});
                    }
                    return map;
                }
            });
        }
        catch (Exception e) {
            throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[0]);
        }
        return resMap;
    }
}

