/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.list.query.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListField;
import kd.bos.entity.filter.FilterField;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.RefBillProp;
import kd.bos.list.query.impl.MulBaseDataMapper;

class DataSetMapper {
    private RowMeta rowMeta;
    private DynamicObjectType dt;
    private List<Row> rowList = new ArrayList<Row>();
    private List<ListField> pkFields = new ArrayList<ListField>();
    private MainEntityType mainEntityType;

    DataSetMapper(MainEntityType mainEntityType, DynamicObjectType dt, RowMeta rowMeta, List<Row> rowList, List<ListField> pkFields) {
        this.mainEntityType = mainEntityType;
        this.dt = dt;
        this.rowMeta = rowMeta;
        this.rowList = rowList;
        this.pkFields = pkFields;
    }

    DynamicObjectCollection getDynamicObjectCollection() {
        int i;
        int n = this.rowMeta.getFieldCount();
        ArrayList<MulBaseDataMapper> mulBaseDataMappers = new ArrayList<MulBaseDataMapper>(10);
        HashMap<String, MulBaseDataMapper> mulBaseMaps = new HashMap<String, MulBaseDataMapper>(16);
        HashMap<String, Integer> fieldMapIndex = new HashMap<String, Integer>(n);
        for (i = 0; i < n; ++i) {
            fieldMapIndex.put(this.rowMeta.getField(i).getName(), i);
        }
        for (i = 0; i < n; ++i) {
            DynamicProperty property = this.dt.getProperty(this.rowMeta.getField(i).getName());
            if (!(property instanceof MulBasedataProp)) continue;
            FilterField filterField = FilterField.create((MainEntityType)this.mainEntityType, (String)this.rowMeta.getField(i).getName());
            MulBaseDataMapper mulBaseDataMapper = (MulBaseDataMapper)mulBaseMaps.get(filterField.getSubEntityName());
            List<Object> mulBasedataProps = new ArrayList(10);
            if (mulBaseDataMapper != null) {
                mulBasedataProps = mulBaseDataMapper.getMulBasedataProps();
            } else {
                for (ListField pkField : this.pkFields) {
                    FilterField filterFieldPK = FilterField.create((MainEntityType)this.mainEntityType, (String)pkField.getFieldName());
                    if (!filterField.getSubEntityName().equals(filterFieldPK.getSubEntityName())) continue;
                    MulBaseDataMapper mulBaseDataMapper1 = this.createMulBaseDataMapper((Integer)fieldMapIndex.get(pkField.getFieldName()), mulBasedataProps);
                    mulBaseDataMappers.add(mulBaseDataMapper1);
                    mulBaseMaps.put(filterField.getSubEntityName(), mulBaseDataMapper1);
                    break;
                }
            }
            mulBasedataProps.add((MulBasedataProp)property);
        }
        return this.createDynamicObjectCollection(mulBaseDataMappers);
    }

    private MulBaseDataMapper createMulBaseDataMapper(int pkIndex, List<MulBasedataProp> mulBasedataProps) {
        ArrayList<Object> pkList = new ArrayList<Object>();
        for (Row row : this.rowList) {
            if (pkIndex <= -1) continue;
            pkList.add(row.get(pkIndex));
        }
        return new MulBaseDataMapper(this.mainEntityType, pkList, mulBasedataProps, pkIndex);
    }

    private DynamicObjectCollection createDynamicObjectCollection(List<MulBaseDataMapper> mulBaseDataMappers) {
        if (this.rowList.isEmpty()) {
            return new DynamicObjectCollection(this.dt, null);
        }
        for (MulBaseDataMapper mulBaseDataMapper : mulBaseDataMappers) {
            mulBaseDataMapper.buildMulBasedataData();
        }
        int n = this.rowMeta.getFieldCount();
        Iterator<Row> iterator = this.rowList.iterator();
        DynamicObjectCollection ret = new DynamicObjectCollection(this.dt, null);
        ret.beginInit();
        while (iterator.hasNext()) {
            Row row = iterator.next();
            DynamicObject obj = new DynamicObject(this.dt);
            for (int i = 0; i < n; ++i) {
                this.setPropertyValue(row, obj, i, mulBaseDataMappers);
            }
            ret.add((Object)obj);
        }
        for (MulBaseDataMapper mulBaseDataMapper : mulBaseDataMappers) {
            mulBaseDataMapper.loadAndFillMulBaseDataRows();
        }
        ret.endInit();
        BusinessDataReader.loadRefence(ret.toArray((Object[])new DynamicObject[ret.size()]), (IDataEntityType)this.dt);
        return ret;
    }

    private void setPropertyValue(Row row, DynamicObject obj, int i, List<MulBaseDataMapper> mulBaseDataMappers) {
        DynamicProperty property = this.dt.getProperty(this.rowMeta.getField(i).getName());
        if (property != null) {
            if (property instanceof MulBasedataProp) {
                MulBasedataProp mulBasedataProp = (MulBasedataProp)property;
                for (MulBaseDataMapper mulBaseDataMapper : mulBaseDataMappers) {
                    mulBaseDataMapper.addMulBaseDataRow(mulBasedataProp, row.get(mulBaseDataMapper.getPkIndex()), obj);
                }
            } else {
                if (property instanceof BasedataProp) {
                    property = ((BasedataProp)property).getRefIdProp();
                } else if (property instanceof RefBillProp) {
                    property = ((RefBillProp)property).getRefIdProp();
                }
                property.setValueFast((Object)obj, row.get(i));
            }
        }
    }
}

