/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.pushservice;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.cache.ThreadCache;
import kd.bos.cache.redis.RedisSessionableCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.ksql.exception.NotSupportedException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class WebSocketIdReader {
    private static final String WEBSOCKET_TARGET = "websocetRecord";
    private static final Log log = LogFactory.getLog(WebSocketIdReader.class);
    private static final String SESSION_ACCOUNT_SPLITSTR = "@@@";
    private static DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache(null, new DistributeCacheHAPolicy(true, false));

    public static List<String> getSocketIdsByTenantId(String tenantId) {
        throw new NotSupportedException(ResManager.loadKDString((String)"\u76ee\u524d\u8fd8\u672a\u5b9e\u73b0", (String)"WebSocketIdReader_0", (String)"bos-business-dao", (Object[])new Object[0]));
    }

    public static List<String> getWebSocketIds(String accountId, String globalSessionId) {
        String[] wsids = cache.getSetValues(WebSocketIdReader.buildKey(globalSessionId));
        List<String> socketIds = Arrays.asList(wsids);
        if ((socketIds == null || socketIds.isEmpty()) && WebSocketIdReader.isClearLostConnect()) {
            WebSocketIdReader.clearLostConnect(accountId, globalSessionId);
        }
        return socketIds;
    }

    public static List<String> getWebSocketIdsTen() {
        String[] wsids = cache.getSetValues(WebSocketIdReader.buildWsKey());
        if (wsids.length > 10) {
            wsids = Arrays.copyOfRange(wsids, wsids.length - 10, wsids.length);
        }
        return Arrays.asList(wsids);
    }

    private static String buildWsKey() {
        return "websocetRecord:" + RequestContext.get().getAccountId() + ":websocketids";
    }

    private static boolean isClearLostConnect() {
        return Boolean.parseBoolean(System.getProperty("mvc.websocket.autoclear", "true"));
    }

    private static void clearLostConnect(String accountId, String globalSessionId) {
        if (StringUtils.isBlank((CharSequence)accountId) || StringUtils.isBlank((CharSequence)globalSessionId)) {
            return;
        }
        log.info("\u6e05\u7406\u5931\u8054\u7684websocket\u4fe1\u606f\u3002");
        try {
            String userId = (String)cache.get(WebSocketIdReader.buildSessionUserIdKey(accountId), globalSessionId);
            if (StringUtils.isBlank((CharSequence)userId) && StringUtils.isBlank((CharSequence)(userId = (String)ThreadCache.get((Object)"pushservice_websocket_push_userId")))) {
                return;
            }
            cache.removeSetValues(WebSocketIdReader.buildUserIdKey(accountId, userId), new String[]{globalSessionId});
            cache.remove(WebSocketIdReader.buildSessionUserIdKey(accountId), globalSessionId);
            String[] socketIds = cache.getSetValues(WebSocketIdReader.buildKey(globalSessionId));
            cache.remove(WebSocketIdReader.buildKey(globalSessionId));
            if (socketIds != null && socketIds.length > 0) {
                cache.remove(WebSocketIdReader.buildSocketSessionKey(accountId), socketIds);
            }
        }
        catch (Exception e) {
            log.error("removeWebSockets error:" + e.getMessage());
        }
    }

    public static List<String> getWebSocketIdsInAccount(String accountId) {
        RedisSessionableCache redisCache = new RedisSessionableCache();
        Map partSessionIdsWithAccountIds = redisCache.getPartSessionIdsWithAccountId();
        Predicate<Map.Entry> predicate = partSessionIdsWithAccountId -> {
            String[] reqctxInfo = ((String)partSessionIdsWithAccountId.getKey()).split(SESSION_ACCOUNT_SPLITSTR);
            if (reqctxInfo.length == 2) {
                return Objects.equals(accountId, reqctxInfo[1]);
            }
            return Objects.equals(accountId, reqctxInfo[0]);
        };
        return partSessionIdsWithAccountIds.entrySet().stream().filter(predicate).map(Map.Entry::getKey).collect(Collectors.toList());
    }

    public static String[] getWSSessionIdByUser(String accountId, String userId) {
        return cache.getSetValues(WebSocketIdReader.buildUserIdKey(accountId, userId));
    }

    public static List<String> getWebSocketIdByUserIds(String accountId, List<String> userIds) {
        Map sessionUserIdMapping = cache.getAll(WebSocketIdReader.buildSessionUserIdKey(accountId));
        ArrayList<String> result = new ArrayList<String>();
        if (sessionUserIdMapping == null) {
            return result;
        }
        ArrayList sessionIds = new ArrayList();
        for (Map.Entry row : sessionUserIdMapping.entrySet()) {
            if (!userIds.contains(row.getValue())) continue;
            sessionIds.add(row.getKey());
        }
        Map socketSessionMapping = cache.getAll(WebSocketIdReader.buildSocketSessionKey(accountId));
        for (Map.Entry row : socketSessionMapping.entrySet()) {
            if (!sessionIds.contains(row.getValue())) continue;
            result.add((String)row.getKey());
        }
        return result;
    }

    private static String buildKey(String globalSessionId) {
        return "websocetRecord:" + globalSessionId;
    }

    private static String buildUserIdKey(String accountId, String userId) {
        return "websocetRecord_user_" + accountId + "." + userId;
    }

    private static String buildSessionUserIdKey(String account) {
        return "websocetRecord:" + account + "_session_user";
    }

    private static String buildSocketSessionKey(String account) {
        return "websocetRecord:" + account + "_socket_session";
    }
}

