/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.userconfig;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.userconfig.UserConfig;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.userconfig.UserConfigDistributeCache;
import kd.bos.userconfig.UserConfigQueryBuilder;

public class UserConfigQuery {
    public UserConfig getUserConfig(final String key, final long userId) {
        UserConfig userConfig;
        String regionKey = String.valueOf(userId);
        String[] valueList = (String[])UserConfigDistributeCache.getDistributeCache(regionKey, key, new String[2].getClass());
        if (valueList != null) {
            UserConfig userConfig2 = new UserConfig();
            userConfig2.setKey(key);
            userConfig2.setUserId(userId);
            userConfig2.setId(valueList[0]);
            userConfig2.setSetting(valueList[1]);
            return userConfig2;
        }
        Object[] params = new SqlParameter[]{new SqlParameter(":FKEY", 12, (Object)key), new SqlParameter(":FUSERID", -5, (Object)userId)};
        String sql = "SELECT FUSERCONFIGID,FSETTING FROM T_BAS_USERCONFIG WHERE FKEY=? AND FUSERID=?";
        try {
            userConfig = (UserConfig)DB.query((DBRoute)DBRoute.basedata, (String)sql, (Object[])params, (ResultSetHandler)new ResultSetHandler<UserConfig>(){

                public UserConfig handle(ResultSet rs) throws KDException {
                    UserConfig userConfig = new UserConfig();
                    userConfig.setKey(key);
                    userConfig.setUserId(userId);
                    try {
                        if (rs.next()) {
                            userConfig.setId(rs.getString(1));
                            userConfig.setSetting(rs.getString(2));
                        }
                    }
                    catch (SQLException e) {
                        throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{String.format("Error:%s", e.getMessage())});
                    }
                    return userConfig;
                }
            });
        }
        catch (Exception e) {
            Log log = LogFactory.getLog(UserConfigQuery.class);
            log.error((Throwable)e);
            String msg = String.format("error:%s;  sql:%s", e.getMessage(), sql);
            throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{msg});
        }
        valueList = new String[]{userConfig.getId(), userConfig.getSetting()};
        UserConfigDistributeCache.putDistributeCache(regionKey, key, valueList);
        UserConfigQueryBuilder userConfigQueryBuilder = UserConfigQueryBuilder.create();
        if (userConfigQueryBuilder != null) {
            return userConfigQueryBuilder.getUserConfig(key, userId, userConfig);
        }
        return userConfig;
    }

    public Map<String, UserConfig> getUserConfig(String[] keys, final long userId) {
        UserConfigQueryBuilder userConfigQueryBuilder;
        HashMap<String, UserConfig> userConfigs = new HashMap<String, UserConfig>();
        ArrayList<String> notExists = new ArrayList<String>();
        String regionKey = String.valueOf(userId);
        List cacheVals = UserConfigDistributeCache.getDistributeCache(regionKey, keys, new String[2].getClass());
        for (int i = 0; i < keys.length; ++i) {
            String[] valueList;
            String key = keys[i];
            String[] stringArray = valueList = i >= cacheVals.size() ? null : (String[])cacheVals.get(i);
            if (valueList == null) {
                notExists.add(key);
                continue;
            }
            UserConfig userConfig = new UserConfig();
            userConfig.setKey(key);
            userConfig.setUserId(userId);
            userConfig.setId(valueList[0]);
            userConfig.setSetting(valueList[1]);
            userConfigs.put(key, userConfig);
        }
        if (!notExists.isEmpty()) {
            ArrayList<SqlParameter> params = new ArrayList<SqlParameter>(16);
            params.add(new SqlParameter(":FUSERID", -5, (Object)userId));
            ArrayList<String> keyList = new ArrayList<String>(16);
            for (int i = 0; i < notExists.size(); ++i) {
                String key = (String)notExists.get(i);
                params.add(new SqlParameter(":FKEY" + String.valueOf(i), 12, (Object)key));
                keyList.add("?");
            }
            String sql = "SELECT FUSERCONFIGID, FKEY, FSETTING FROM T_BAS_USERCONFIG WHERE FUSERID=? AND FKEY IN (" + StringUtils.join((Object[])keyList.toArray(), (String)",") + ")";
            Map fromDB = new HashMap();
            try {
                fromDB = (Map)DB.query((DBRoute)DBRoute.basedata, (String)sql, (Object[])params.toArray(new SqlParameter[0]), (ResultSetHandler)new ResultSetHandler<Map<String, UserConfig>>(){

                    public Map<String, UserConfig> handle(ResultSet rs) throws KDException {
                        HashMap<String, UserConfig> map = new HashMap<String, UserConfig>();
                        try {
                            while (rs.next()) {
                                UserConfig userConfig = new UserConfig();
                                userConfig.setUserId(userId);
                                userConfig.setId(rs.getString(1));
                                userConfig.setKey(rs.getString(2));
                                userConfig.setSetting(rs.getString(3));
                                map.put(userConfig.getKey(), userConfig);
                            }
                        }
                        catch (SQLException e) {
                            throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{String.format("Error:%s", e.getMessage())});
                        }
                        return map;
                    }
                });
            }
            catch (Exception e) {
                Log log = LogFactory.getLog(UserConfigQuery.class);
                log.error((Throwable)e);
                String msg = String.format("error:%s;  sql:%s", e.getMessage(), sql);
                throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{msg});
            }
            HashMap<String, Object> putCacheVals = new HashMap<String, Object>(notExists.size());
            for (String key : notExists) {
                UserConfig userConfig = null;
                UserConfig config = (UserConfig)fromDB.get(key);
                if (!ObjectUtils.isEmpty((Object)config)) {
                    userConfig = config;
                } else {
                    userConfig = new UserConfig();
                    userConfig.setKey(key);
                    userConfig.setSetting(null);
                    userConfig.setUserId(userId);
                }
                userConfigs.put(key, userConfig);
                String[] valueList = new String[]{userConfig.getId(), userConfig.getSetting()};
                putCacheVals.put(key, valueList);
            }
            if (!putCacheVals.isEmpty()) {
                UserConfigDistributeCache.putDistributeCache(regionKey, putCacheVals);
            }
        }
        if ((userConfigQueryBuilder = UserConfigQueryBuilder.create()) != null) {
            return userConfigQueryBuilder.getUserConfig(keys, userId, userConfigs);
        }
        return userConfigs;
    }
}

