/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata.billtype;

import java.util.ArrayList;
import java.util.List;
import kd.bos.entity.DifferentialControlInfo;

class BillTypeControlCacheInfo {
    private static final long TIME_OUT_MS = 10800000L;
    private static final long RECHECK_TIMEINTERVAL = 600000L;
    private long billTypeId;
    private long billTypeModifyTime;
    private long cacheTime;
    private List<DifferentialControlInfo> deffControlInfos = new ArrayList<DifferentialControlInfo>(10);
    private long lastCheckVersionTimeMillis;

    public BillTypeControlCacheInfo(long billTypeId, long billTypeModifyTime) {
        long cur;
        this.billTypeId = billTypeId;
        this.billTypeModifyTime = billTypeModifyTime;
        this.cacheTime = cur = System.currentTimeMillis();
        this.lastCheckVersionTimeMillis = cur;
    }

    public long getBillTypeId() {
        return this.billTypeId;
    }

    public void setBillTypeId(long billTypeId) {
        this.billTypeId = billTypeId;
    }

    public long getBillTypeModifyTime() {
        return this.billTypeModifyTime;
    }

    public void setBillTypeModifyTime(long billTypeModifyTime) {
        this.billTypeModifyTime = billTypeModifyTime;
    }

    public boolean isTimeOut() {
        long currTime = System.currentTimeMillis();
        long offsetTime = currTime - this.cacheTime;
        return offsetTime > 10800000L;
    }

    public List<DifferentialControlInfo> getDeffControlInfos() {
        return new ArrayList<DifferentialControlInfo>(this.deffControlInfos);
    }

    public void setDeffControlInfos(List<DifferentialControlInfo> deffControlInfos) {
        this.deffControlInfos = deffControlInfos;
        for (DifferentialControlInfo controlInfo : this.deffControlInfos) {
            controlInfo.setLocalCache(true);
        }
    }

    public boolean needCheckVersion() {
        long currTime = System.currentTimeMillis();
        long offsetTime = currTime - this.lastCheckVersionTimeMillis;
        return offsetTime > 600000L;
    }

    public void resetLastCheckVersionTime() {
        this.lastCheckVersionTimeMillis = System.currentTimeMillis();
    }
}

