/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata.billtype;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.orm.ORM;
import kd.bos.orm.query.Distinctable;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.query.WithEntityEntryDistinctable;

class BillTypeReader {
    public static final String FORMID_BOS_BILLTYPE = "bos_billtype";
    public static final String FORMID_BOS_FORMMETA = "bos_formmeta";
    public static final String KEY_FIELD_CONTROL_ENTRY = "fieldcontrolentry";
    public static final String KEY_BILL_FORMID = "billformid";
    public static final String KEY_FIELDKEY = "fieldkey";
    public static final String KEY_MUST_INPUT = "mustinput";
    public static final String KEY_DEFAULT_VALUE = "defaultvalue";
    public static final String KEY_LAYOUT = "layoutsolution";
    public static final String KEY_MODIFYTIME = "modifytime";
    public static final String KEY_MOB_FIELD_CONTROL_ENTRY = "mob_fieldcontrolentry";
    public static final String KEY_MOB_FIELDKEY = "mob_fieldkey";
    public static final String KEY_MOB_MUST_INPUT = "mob_mustinput";
    public static final String KEY_MOB_DEFAULT_VALUE = "mob_defaultvalue";
    public static final String KEY_MOB_LAYOUT = "mob_layoutsolution";
    public static final Map<String, String> VISIBLE2STATUS = new HashMap<String, String>();
    public static final Map<String, String> LOCK2STATUS = new HashMap<String, String>();
    public static final Map<String, String> MOB_VISIBLE2STATUS = new HashMap<String, String>();
    public static final Map<String, String> MOB_LOCK2STATUS = new HashMap<String, String>();
    public static final Set<String> selectedFields = new HashSet<String>();
    public static final Set<String> modifyTimeFields = new HashSet<String>();
    private static final String BILLTYPEREADER_LOADBILLTYPEOBJECTS = "BillTypeReader.loadBillTypeObjects";
    private static final String NUMBER_STR = "number";
    private static final String BASEDATEFIELD = "basedatafield";

    BillTypeReader() {
    }

    public static Map<Object, DynamicObject> loadBillTypeObjects(String entityNumber) {
        MainEntityType dType;
        QFilter f = new QFilter(KEY_BILL_FORMID, "=", (Object)entityNumber);
        QFilter[] filters = new QFilter[]{f};
        ArrayList idList = new ArrayList();
        try (DataSet ds = ORM.create().queryDataSet(BILLTYPEREADER_LOADBILLTYPEOBJECTS, FORMID_BOS_BILLTYPE, "id", filters, null, -1, (Distinctable)WithEntityEntryDistinctable.get());){
            ds.forEach(row -> idList.add(row.get(0)));
        }
        if (idList.isEmpty()) {
            return new HashMap<Object, DynamicObject>();
        }
        Object[] pks = idList.toArray();
        DynamicObject[] billTypeObjs = BusinessDataReader.load((Object[])pks, (DynamicObjectType)(dType = EntityMetadataCache.getDataEntityType((String)FORMID_BOS_BILLTYPE)), (Boolean)true);
        if (billTypeObjs == null || billTypeObjs.length == 0) {
            return new HashMap<Object, DynamicObject>(0);
        }
        HashMap<Object, DynamicObject> map = new HashMap<Object, DynamicObject>(billTypeObjs.length);
        for (DynamicObject billTypeObj : billTypeObjs) {
            map.put(billTypeObj.getPkValue(), billTypeObj);
        }
        return map;
    }

    public static Map<Object, DynamicObject> loadSubBillTypeObjectsFromCache(String entityNumber) {
        QFilter f = new QFilter(KEY_BILL_FORMID, "=", (Object)entityNumber);
        QFilter[] filters = new QFilter[]{f};
        ArrayList idList = new ArrayList();
        try (DataSet ds = ORM.create().queryDataSet(BILLTYPEREADER_LOADBILLTYPEOBJECTS, FORMID_BOS_BILLTYPE, "id", filters, null, -1, (Distinctable)WithEntityEntryDistinctable.get());){
            ds.forEach(row -> idList.add(row.get(0)));
        }
        if (idList.isEmpty()) {
            return new HashMap<Object, DynamicObject>();
        }
        Object[] pks = idList.toArray();
        DynamicObjectType dType = EntityMetadataCache.getSubDataEntityType((String)FORMID_BOS_BILLTYPE, selectedFields);
        return BusinessDataReader.loadFromCache((Object[])pks, (DynamicObjectType)dType);
    }

    public static Map<Object, DynamicObject> loadSubBillTypeObjectsFromCache(List<Long> billTypeIds) {
        if (billTypeIds.isEmpty()) {
            return new HashMap<Object, DynamicObject>();
        }
        Object[] pks = billTypeIds.toArray();
        DynamicObjectType dType = EntityMetadataCache.getSubDataEntityType((String)FORMID_BOS_BILLTYPE, selectedFields);
        return BusinessDataReader.loadFromCache((Object[])pks, (DynamicObjectType)dType);
    }

    public static Map<Object, DynamicObject> loadModifytimesFromCache(String entityNumber) {
        QFilter f = new QFilter(KEY_BILL_FORMID, "=", (Object)entityNumber);
        QFilter[] filters = new QFilter[]{f};
        ArrayList idList = new ArrayList();
        try (DataSet ds = ORM.create().queryDataSet(BILLTYPEREADER_LOADBILLTYPEOBJECTS, FORMID_BOS_BILLTYPE, "id", filters, null, -1, (Distinctable)WithEntityEntryDistinctable.get());){
            ds.forEach(row -> idList.add(row.get(0)));
        }
        if (idList.isEmpty()) {
            return new HashMap<Object, DynamicObject>();
        }
        Object[] pks = idList.toArray();
        DynamicObjectType dType = EntityMetadataCache.getSubDataEntityType((String)FORMID_BOS_BILLTYPE, modifyTimeFields);
        return BusinessDataReader.loadFromCache((Object[])pks, (DynamicObjectType)dType);
    }

    public static Map<Object, Long> loadModifytimesFormDB(String entityNumber) {
        QFilter f = new QFilter(KEY_BILL_FORMID, "=", (Object)entityNumber);
        QFilter[] filters = new QFilter[]{f};
        HashMap<Object, Long> result = new HashMap<Object, Long>(3);
        String selectFields = String.join((CharSequence)",", "id", KEY_MODIFYTIME);
        try (DataSet ds = ORM.create().queryDataSet(BILLTYPEREADER_LOADBILLTYPEOBJECTS, FORMID_BOS_BILLTYPE, selectFields, filters, null, -1, (Distinctable)WithEntityEntryDistinctable.get());){
            ds.forEach(row -> {
                Object pk = row.get("id");
                Timestamp modifyTime = row.getTimestamp(KEY_MODIFYTIME);
                long time = modifyTime == null ? 0L : modifyTime.getTime();
                result.put(pk, time);
            });
        }
        return result;
    }

    public static DynamicObject loadBillTypeObject(String entityNumber, long billTypeId) {
        MainEntityType dType = EntityMetadataCache.getDataEntityType((String)FORMID_BOS_BILLTYPE);
        DynamicObject[] billTypeObjs = BusinessDataReader.load((Object[])new Long[]{billTypeId}, (DynamicObjectType)dType, (Boolean)true);
        if (billTypeObjs == null || billTypeObjs.length == 0) {
            return null;
        }
        return billTypeObjs[0];
    }

    public static DynamicObject loadBillTypeObjectFormCache(String entityNumber, long billTypeId) {
        MainEntityType dType = EntityMetadataCache.getDataEntityType((String)FORMID_BOS_BILLTYPE);
        Map billTypeObjs = BusinessDataReader.loadFromCache((Object[])new Long[]{billTypeId}, (DynamicObjectType)dType, (boolean)true);
        if (billTypeObjs == null || billTypeObjs.size() == 0) {
            return null;
        }
        return (DynamicObject)billTypeObjs.values().iterator().next();
    }

    public static DynamicObject loadSubBillTypeObjectFromCache(String entityNumber, long billTypeId) {
        DynamicObjectType dType = EntityMetadataCache.getSubDataEntityType((String)FORMID_BOS_BILLTYPE, selectedFields);
        Map billTypeObjs = BusinessDataReader.loadFromCache((Object[])new Long[]{billTypeId}, (DynamicObjectType)dType);
        if (billTypeObjs == null || billTypeObjs.isEmpty()) {
            return null;
        }
        return (DynamicObject)billTypeObjs.entrySet().iterator().next().getValue();
    }

    public static DynamicObject loadModifyTimeFromCache(String entityNumber, long billTypeId) {
        DynamicObjectType dType = EntityMetadataCache.getSubDataEntityType((String)FORMID_BOS_BILLTYPE, modifyTimeFields);
        Map billTypeObjs = BusinessDataReader.loadFromCache((Object[])new Long[]{billTypeId}, (DynamicObjectType)dType);
        if (billTypeObjs == null || billTypeObjs.isEmpty()) {
            return null;
        }
        return (DynamicObject)billTypeObjs.entrySet().iterator().next().getValue();
    }

    public static long loadModifyTimeFormDB(String entityNumber, long billTypeId) {
        long modifyTime = 0L;
        try (DataSet dataSet = ORM.create().queryDataSet("BillTypeReader.loadModifyTime", FORMID_BOS_BILLTYPE, KEY_MODIFYTIME, new QFilter[]{new QFilter("id", "=", (Object)billTypeId)}, null, 1);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                Timestamp date = row.getTimestamp(KEY_MODIFYTIME);
                if (date == null) continue;
                modifyTime = date.getTime();
            }
        }
        return modifyTime;
    }

    public static DynamicObjectCollection loadFieldEntryRows(String entityNumber, long billTypeId) {
        DynamicObject billTypeObj = BillTypeReader.loadBillTypeObject(entityNumber, billTypeId);
        if (billTypeObj == null) {
            return null;
        }
        return billTypeObj.getDynamicObjectCollection(KEY_FIELD_CONTROL_ENTRY);
    }

    public static Map<String, Map<String, Object>> loadBillLayoutByFormId(String entityNumber) {
        String layoutId;
        Row row;
        HashMap<String, String> layout;
        HashMap<String, Map<String, Object>> layouts = new HashMap<String, Map<String, Object>>(10);
        QFilter f = new QFilter(NUMBER_STR, "=", (Object)entityNumber);
        QFilter[] filters = new QFilter[]{f};
        String layoutEntityId = null;
        try (DataSet ds = ORM.create().queryDataSet("BillTypeReader.loadBillLayoutByFormId", FORMID_BOS_FORMMETA, "id, number,name, basedatafield", filters, null, -1, (Distinctable)WithEntityEntryDistinctable.get());){
            if (ds.hasNext()) {
                layout = new HashMap<String, String>();
                row = ds.next();
                layoutId = row.getString("id");
                layout.put("id", layoutId);
                layout.put(NUMBER_STR, row.getString(NUMBER_STR));
                layout.put("name", row.getString("name"));
                layouts.put(layoutId, layout);
                layoutEntityId = row.getString(BASEDATEFIELD);
            }
        }
        filters = new QFilter[]{QFilter.of((String)"id <> basedatafield", (Object[])new Object[0]).and(new QFilter(BASEDATEFIELD, "=", layoutEntityId)).and(new QFilter("modeltype", "=", (Object)"BillFormModel"))};
        ds = ORM.create().queryDataSet("BillTypeReader.loadBillLayoutByFormId", FORMID_BOS_FORMMETA, "id, number,name", filters, null, -1, (Distinctable)WithEntityEntryDistinctable.get());
        var6_6 = null;
        try {
            while (ds.hasNext()) {
                layout = new HashMap();
                row = ds.next();
                layoutId = row.getString("id");
                layout.put("id", layoutId);
                layout.put(NUMBER_STR, row.getString(NUMBER_STR));
                layout.put("name", row.getString("name"));
                layouts.put(layoutId, layout);
            }
        }
        catch (Throwable throwable) {
            var6_6 = throwable;
            throw throwable;
        }
        finally {
            if (ds != null) {
                if (var6_6 != null) {
                    try {
                        ds.close();
                    }
                    catch (Throwable throwable) {
                        var6_6.addSuppressed(throwable);
                    }
                } else {
                    ds.close();
                }
            }
        }
        return layouts;
    }

    public static String loadLayoutNumber(String entityNumber, String layoutId) {
        if (StringUtils.isBlank((CharSequence)layoutId)) {
            return null;
        }
        QFilter f = new QFilter("id", "=", (Object)layoutId);
        QFilter[] filters = new QFilter[]{f};
        String layoutEntityId = null;
        String layoutNumber = null;
        try (DataSet ds = ORM.create().queryDataSet("BillTypeReader.loadLayoutNumber", FORMID_BOS_FORMMETA, "id, number, basedatafield", filters, null, -1, (Distinctable)WithEntityEntryDistinctable.get());){
            if (ds.hasNext()) {
                Row row = ds.next();
                layoutNumber = row.getString(NUMBER_STR);
                layoutEntityId = row.getString(BASEDATEFIELD);
            }
        }
        if (StringUtils.isBlank(layoutEntityId)) {
            return null;
        }
        String defaultEntityId = MetadataDao.getIdByNumber(entityNumber, MetaCategory.Entity);
        if (!StringUtils.equals((CharSequence)layoutEntityId, (CharSequence)defaultEntityId)) {
            return null;
        }
        return layoutNumber;
    }

    static {
        VISIBLE2STATUS.put("vinit", "init");
        VISIBLE2STATUS.put("vnew", "new");
        VISIBLE2STATUS.put("vedit", "edit");
        VISIBLE2STATUS.put("vview", "view");
        VISIBLE2STATUS.put("vsubmit", "submit");
        VISIBLE2STATUS.put("vaudit", "audit");
        LOCK2STATUS.put("enabled", "new");
        LOCK2STATUS.put("editenabled", "edit");
        LOCK2STATUS.put("submitenabled", "submit");
        LOCK2STATUS.put("auditenabled", "audit");
        MOB_VISIBLE2STATUS.put("mob_vinit", "init");
        MOB_VISIBLE2STATUS.put("mob_vnew", "new");
        MOB_VISIBLE2STATUS.put("mob_vedit", "edit");
        MOB_VISIBLE2STATUS.put("mob_vview", "view");
        MOB_VISIBLE2STATUS.put("mob_vsubmit", "submit");
        MOB_VISIBLE2STATUS.put("mob_vaudit", "audit");
        MOB_LOCK2STATUS.put("mob_enabled", "new");
        MOB_LOCK2STATUS.put("mob_editenabled", "edit");
        MOB_LOCK2STATUS.put("mob_submitenabled", "submit");
        MOB_LOCK2STATUS.put("mob_auditenabled", "audit");
        selectedFields.add("id");
        selectedFields.add(KEY_BILL_FORMID);
        selectedFields.add(KEY_MODIFYTIME);
        selectedFields.add(KEY_LAYOUT);
        selectedFields.add(KEY_FIELDKEY);
        selectedFields.add(KEY_MUST_INPUT);
        selectedFields.add(KEY_DEFAULT_VALUE);
        selectedFields.add(KEY_MOB_LAYOUT);
        selectedFields.add(KEY_MOB_FIELDKEY);
        selectedFields.add(KEY_MOB_MUST_INPUT);
        selectedFields.add(KEY_MOB_DEFAULT_VALUE);
        selectedFields.addAll(VISIBLE2STATUS.keySet());
        selectedFields.addAll(MOB_VISIBLE2STATUS.keySet());
        selectedFields.addAll(LOCK2STATUS.keySet());
        selectedFields.addAll(MOB_LOCK2STATUS.keySet());
        modifyTimeFields.add("id");
        modifyTimeFields.add(KEY_MODIFYTIME);
    }
}

