/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata.botp;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityTypeAttribute;
import kd.bos.dataentity.entity.SimplePropertyAttribute;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.DesignMeta;
import kd.bos.metadata.dao.MetaLogType;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.ServiceFactory;
import kd.bos.service.botp.BOTPServiceFactory;
import kd.bos.service.botp.metadata.IWriteBackRuleReaderProxy;
import kd.bos.service.botp.metadata.IWriteBackRuleWriterProxy;
import kd.bos.service.metadata.MetadataLogService;

@DataEntityTypeAttribute(tableName="T_BOTP_WriteBackRule", dbRouteKey="sys.meta")
public class DesignWriteBackRuleMeta
extends DesignMeta {
    private static Log log = LogFactory.getLog(DesignWriteBackRuleMeta.class);
    private static final long serialVersionUID = -1720814134304411520L;
    private String sourceEntityNumber;
    private String targetEntityNumber;
    private Date createDate = new Date();
    private Long modifierId;
    private Date modifyDate;
    private String sysStatus;
    private String custStatus = "1";

    @Override
    @SimplePropertyAttribute(isDbIgnore=true)
    public String getNumber() {
        return super.getNumber();
    }

    @Override
    @SimplePropertyAttribute(isDbIgnore=true)
    public Integer getSubSysId() {
        return super.getSubSysId();
    }

    @SimplePropertyAttribute(alias="FSourceEntityNumber", dbType=12)
    public String getSourceEntityNumber() {
        return this.sourceEntityNumber;
    }

    public void setSourceEntityNumber(String sourceEntityNumber) {
        this.sourceEntityNumber = sourceEntityNumber;
    }

    @SimplePropertyAttribute(alias="FTargetEntityNumber", dbType=12)
    public String getTargetEntityNumber() {
        return this.targetEntityNumber;
    }

    public void setTargetEntityNumber(String targetEntityNumber) {
        this.targetEntityNumber = targetEntityNumber;
    }

    @SimplePropertyAttribute(alias="FCreateDate", dbType=91)
    public Date getCreateDate() {
        return this.createDate;
    }

    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    @SimplePropertyAttribute(alias="FModifierId", dbType=-5)
    public Long getModifierId() {
        return this.modifierId;
    }

    public void setModifierId(Long modifierId) {
        this.modifierId = modifierId;
    }

    @SimplePropertyAttribute(alias="FModifyDate", dbType=91)
    public Date getModifyDate() {
        return this.modifyDate;
    }

    public void setModifyDate(Date modifyDate) {
        this.modifyDate = modifyDate;
    }

    @SimplePropertyAttribute(alias="FSysStatus", dbType=1)
    public String getSysStatus() {
        return this.sysStatus;
    }

    public void setSysStatus(String sysStatus) {
        this.sysStatus = sysStatus;
    }

    @SimplePropertyAttribute(alias="FCustStatus", dbType=1)
    public String getCustStatus() {
        return this.custStatus;
    }

    public void setCustStatus(String custStatus) {
        this.custStatus = custStatus;
    }

    @Override
    public void deployMetadata() {
        super.deployMetadata();
        this.setModifierId(Long.valueOf(RequestContext.get().getUserId()));
        this.setModifyDate(new Date());
        IWriteBackRuleWriterProxy writeBackRuleWriter = (IWriteBackRuleWriterProxy)BOTPServiceFactory.getSingletonService(IWriteBackRuleWriterProxy.class);
        writeBackRuleWriter.updateInheritRuleVer(this.getId());
        try (TXHandle h = TX.notSupported();){
            this.writeMetadataLog(this.getId(), this.getSourceEntityNumber(), this.getTargetEntityNumber(), this.getDataXml(), this.getBizappId());
        }
        catch (Exception e) {
            log.error("\u5bfc\u5165\u53cd\u5199\u89c4\u5219\u8bb0\u5f55\u64cd\u4f5c\u65e5\u5fd7\u5f02\u5e38", (Throwable)e);
        }
        writeBackRuleWriter.clearCache(new String[]{this.getId()});
    }

    private void writeMetadataLog(String ruleId, String sourceEntityNumber, String targetEntityNumber, String xmlData, String bizappId) {
        IWriteBackRuleReaderProxy reader;
        String sourceXmlData;
        String metaId = ruleId;
        String metaNumber = sourceEntityNumber + "-" + targetEntityNumber;
        String remark = ResManager.loadKDString((String)"\u53cd\u5199\u89c4\u5219", (String)"DesignWriteBackRuleMeta_0", (String)"bos-metadata", (Object[])new Object[0]);
        MetadataLogService logService = (MetadataLogService)ServiceFactory.getService(MetadataLogService.class);
        ArrayList<String> ruleIdList = new ArrayList<String>(1);
        ruleIdList.add(ruleId);
        if (CollectionUtils.isEmpty((Collection)logService.queryMetaIds(ruleIdList)) && (sourceXmlData = (reader = (IWriteBackRuleReaderProxy)BOTPServiceFactory.getPrototypeService(IWriteBackRuleReaderProxy.class)).buildXml(ruleId, false, false)) != null) {
            long logId = DB.genGlobalLongId();
            logService.addBotpMetaLog(metaId, metaNumber, sourceXmlData, (int)MetaLogType.BotpInit.getValue(), logId, bizappId, remark);
        }
        long logId = DB.genGlobalLongId();
        logService.addBotpMetaLog(metaId, metaNumber, xmlData, (int)MetaLogType.BotpImport.getValue(), logId, bizappId, remark);
    }
}

