/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata.dao;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.cache.ThreadCache;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DcBinder;
import kd.bos.dataentity.serialization.DcxmlSerializer;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.gray.AppGroupUtils;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.inte.api.EnabledLang;
import kd.bos.inte.api.IInteService;
import kd.bos.metadata.AbstractMetadata;
import kd.bos.metadata.DesignMeta;
import kd.bos.metadata.dao.ExtMetadataNode;
import kd.bos.metadata.dao.IMetadataDaoPlugIn;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.dao.MetadataNode;
import kd.bos.metadata.dao.MetadataServicePlugInProxy;
import kd.bos.metadata.dao.MetadataTree;
import kd.bos.metadata.domainmodel.DomainModelBinder;
import kd.bos.metadata.domainmodel.DomainModelType;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.extensible.BizObjExtPreviewService;
import kd.bos.metadata.form.DesignFormMeta;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.service.ServiceFactory;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public abstract class AbstractMetadataReader {
    private String modelType;
    private DcBinder binder;
    private DcxmlSerializer xmlSerializer;
    private boolean colloctionIgnorePKValue;
    private String currId = "";
    private String currParentId = "";
    private boolean fillExtends = false;
    private String appGroup = "defaultGroup";
    private IMetadataDaoPlugIn plugIn;

    public String getModelType() {
        return this.modelType;
    }

    public void setModelType(String modelType) {
        this.modelType = modelType;
    }

    protected String getCurrId() {
        return this.currId;
    }

    protected String getCurrParentId() {
        return this.currParentId;
    }

    public boolean isFillExtends() {
        return this.fillExtends;
    }

    public void setFillExtends(boolean fillExtends) {
        this.fillExtends = fillExtends;
    }

    public boolean isColloctionIgnorePKValue() {
        return this.colloctionIgnorePKValue;
    }

    public void setColloctionIgnorePKValue(boolean colloctionIgnorePKValue) {
        this.colloctionIgnorePKValue = colloctionIgnorePKValue;
    }

    public String getAppGroup() {
        return this.appGroup;
    }

    public void setAppGroup(String appGroup) {
        this.appGroup = appGroup;
    }

    protected DcBinder getBinder() {
        if (StringUtils.isBlank((CharSequence)this.modelType)) {
            throw new KDException(BosErrorCode.variableNotValid, new Object[]{ResManager.loadKDString((String)"MetadataReader\u65b9\u6cd5\uff1acreateBinder\uff0c\u53c2\u6570ModelType\u4e3a\u7a7a\u65e0\u6cd5\u521d\u59cb\u5316\u7ed1\u5b9a\u5668\u3002", (String)"AbstractMetadataReader_0", (String)"bos-metadata", (Object[])new Object[0])});
        }
        if (this.binder == null) {
            DomainModelType domainModel = DomainModelType.getDomainModelType(this.modelType, false);
            this.binder = new DomainModelBinder(domainModel);
        }
        return this.binder;
    }

    public void setBinder(DcBinder dcBinder) {
        this.binder = dcBinder;
    }

    public AbstractMetadata readMeta(String id, IDataEntityType designerMetaType, boolean runtime, boolean isBaseMeta) {
        IDataEntityType det = this.getGrayDeataEntityType(designerMetaType);
        return this.readMetaForMetadataDao(id, det, runtime, isBaseMeta);
    }

    public AbstractMetadata readMetaForMetadataDao(String id, IDataEntityType designerMetaType, boolean runtime, boolean isBaseMeta) {
        DesignMeta designMeta = null;
        try {
            designMeta = (DesignMeta)BusinessDataReader.read((Object)id, (IDataEntityType)designerMetaType, (Boolean)false);
        }
        catch (KDException e) {
            if (e.getErrorCode().getCode().equals("bos.orm.read.dataNotExist")) {
                return null;
            }
            throw e;
        }
        if (designMeta == null) {
            return null;
        }
        BizObjExtPreviewService.changeToPreviewMetadata(designMeta);
        return this.design2Metadata(designMeta, designerMetaType, runtime, isBaseMeta);
    }

    public AbstractMetadata design2Metadata(DesignMeta designMeta, IDataEntityType designerMetaType, boolean runtime, boolean isBaseMeta) {
        this.modelType = designMeta.getModelType();
        this.plugIn = MetadataServicePlugInProxy.create(this.modelType);
        String id = designMeta.getId();
        String parentId = designMeta.getParentId();
        String xml = designMeta.getDataXml();
        String inheritPath = designMeta.getInheritPath();
        String masterId = designMeta.getMasterId();
        if (StringUtils.isBlank((CharSequence)masterId)) {
            masterId = id;
        }
        this.currId = id;
        this.currParentId = parentId;
        DcBinder dcBinder = this.getBinder();
        Boolean rebuildSpeed = Boolean.valueOf(String.valueOf(ThreadCache.get((Object)"rebuild.speed.model")));
        AbstractMetadata metadata = rebuildSpeed != false ? this.assembleWholeMetadataForRebuildAll(id, designerMetaType, masterId, parentId, inheritPath, xml, dcBinder, runtime, isBaseMeta) : this.assembleWholeMetadata(id, designerMetaType, masterId, parentId, inheritPath, xml, dcBinder, runtime, isBaseMeta);
        if (StringUtils.isBlank((CharSequence)metadata.getBizappId())) {
            metadata.setBizappId(MetadataDao.getAppIdByFormId(id));
        }
        metadata.convertFromDesignMeta(designMeta);
        metadata.setRuntime(runtime);
        if (designMeta instanceof DesignFormMeta) {
            DesignFormMeta designFormMeta = (DesignFormMeta)designMeta;
            metadata.setModifyDate(designFormMeta.getModifyDate());
            metadata.setModifierId(designFormMeta.getModifierId());
            if (metadata instanceof FormMetadata) {
                ((FormMetadata)metadata).setEnabled(designFormMeta.isEnabled());
            }
            if (metadata instanceof EntityMetadata) {
                ((EntityMetadata)metadata).setEnabled(designFormMeta.isEnabled());
            }
        }
        this.plugIn.afterReadMeta(metadata);
        return metadata;
    }

    public DcxmlSerializer getDcxmlSerializer(DcBinder pbinder) {
        if (this.xmlSerializer == null) {
            if (pbinder == null) {
                DcBinder dcBinder = this.getBinder();
                this.xmlSerializer = new DcxmlSerializer(dcBinder);
            } else {
                this.xmlSerializer = new DcxmlSerializer(pbinder);
            }
            this.xmlSerializer.setColloctionIgnorePKValue(this.isColloctionIgnorePKValue());
        }
        return this.xmlSerializer;
    }

    public AbstractMetadata buildMetadata(DcBinder binder, MetadataTree tree) {
        MetadataNode node = tree.getRootNode();
        if (node == null) {
            String treeinfo = SerializationUtils.toJsonString((Object)tree);
            String error = String.format(ResManager.loadKDString((String)"\u5143\u6570\u636e\u7684\u7ee7\u627f\u5173\u7cfb\u9519\u8bef\uff0c\u7236\u4e1a\u52a1\u5bf9\u8c61\u4e0d\u5b58\u5728.%1$sMetadataTree\uff1a%2$s", (String)"AbstractMetadataReader_2", (String)"bos-metadata", (Object[])new Object[0]), System.lineSeparator(), treeinfo);
            throw new KDException(BosErrorCode.metaNotFound, new Object[]{error});
        }
        DcxmlSerializer serializer = this.getDcxmlSerializer(binder);
        return (AbstractMetadata)this.deSerializer(serializer, tree, node, null);
    }

    private AbstractMetadata assembleWholeMetadataForRebuildAll(String id, IDataEntityType designerMetaType, String masterId, String parentId, String inheritPath, String xml, DcBinder binder, boolean runtime, boolean isBaseMeta) {
        ArrayList<MetadataNode> nodes = new ArrayList<MetadataNode>();
        MetadataNode curentNode = new MetadataNode(id, parentId, xml);
        ArrayList<MetadataNode> parentNodes = null;
        if (StringUtils.isNotBlank((CharSequence)inheritPath) && (parentNodes = (List)ThreadCache.get((Object)("rebuild.speed.model." + inheritPath + "." + designerMetaType.getName()))) == null) {
            parentNodes = new ArrayList<MetadataNode>(10);
            parentNodes.addAll(this.getParentNodes(inheritPath, designerMetaType));
            if (!parentNodes.isEmpty()) {
                ThreadCache.put((Object)("rebuild.speed.model." + inheritPath + "." + designerMetaType.getName()), parentNodes);
            }
        }
        if (parentNodes != null && !parentNodes.isEmpty()) {
            nodes.addAll(parentNodes);
        }
        nodes.add(curentNode);
        MetadataTree tree = new MetadataTree(nodes);
        this.fillLocale(tree, designerMetaType, false);
        this.fillExtends(tree, designerMetaType, runtime, isBaseMeta, masterId);
        this.fillLocale(tree, designerMetaType, true);
        AbstractMetadata buildMetadata = this.buildMetadata(binder, tree);
        buildMetadata.setInheritPath(inheritPath);
        this.fillTerm(buildMetadata, designerMetaType, tree, runtime);
        String mergeVer = this.buildMergeVer(tree);
        buildMetadata.setMergeVersion(mergeVer);
        return buildMetadata;
    }

    private AbstractMetadata assembleWholeMetadata(String id, IDataEntityType designerMetaType, String masterId, String parentId, String inheritPath, String xml, DcBinder binder, boolean runtime, boolean isBaseMeta) {
        ArrayList<MetadataNode> nodes = new ArrayList<MetadataNode>();
        nodes.add(new MetadataNode(id, parentId, xml));
        if (StringUtils.isNotBlank((CharSequence)inheritPath)) {
            nodes.addAll(this.getParentNodes(inheritPath, designerMetaType));
        }
        MetadataTree tree = new MetadataTree(nodes);
        this.fillLocale(tree, designerMetaType, false);
        BizObjExtPreviewService.fillLocale(tree.getRootNode());
        this.fillExtends(tree, designerMetaType, runtime, isBaseMeta, masterId);
        this.fillLocale(tree, designerMetaType, true);
        AbstractMetadata buildMetadata = this.buildMetadata(binder, tree);
        buildMetadata.setInheritPath(inheritPath);
        this.fillTerm(buildMetadata, designerMetaType, tree, runtime);
        String mergeVer = this.buildMergeVer(tree);
        buildMetadata.setMergeVersion(mergeVer);
        return buildMetadata;
    }

    private void fillTerm(AbstractMetadata buildMetadata, IDataEntityType type, MetadataTree tree, boolean runtime) {
        if (AppGroupUtils.isGrayGroup() || StringUtils.isNotBlank((CharSequence)this.appGroup) && !"defaultGroup".equals(this.appGroup)) {
            return;
        }
        ArrayList<String> ids = new ArrayList<String>();
        AbstractMetadataReader.getTermFIdsFromTreeNode(tree.getRootNode(), ids);
        this.plugIn.fillMetaTerm(buildMetadata, type, runtime, ids);
    }

    private Object deSerializer(DcxmlSerializer xmlSerializer, MetadataTree tree, MetadataNode node, Object baseMetadata) {
        MetadataNode parentNode;
        DomainModelBinder dbinder = (DomainModelBinder)xmlSerializer.getBinder();
        dbinder.setLCId("zh_CN");
        dbinder.setInherit(node.isInherit());
        if (node instanceof ExtMetadataNode) {
            dbinder.setExt(true);
        } else {
            dbinder.setExt(false);
        }
        if (node instanceof ExtMetadataNode && (parentNode = this.findOriginNode(tree, (ExtMetadataNode)node)) != null && parentNode.isInherit()) {
            dbinder.setInherit(true);
        }
        xmlSerializer.setOnlyLocaleVale(false);
        xmlSerializer.setResetLoacaleValueBy2052(true);
        Object metadata = xmlSerializer.deserializeFromString(node.getXml(), baseMetadata);
        xmlSerializer.setOnlyLocaleVale(true);
        for (Map.Entry entry : node.getLoacleXml().entrySet()) {
            String localeId = (String)entry.getKey();
            if ("en".equals(localeId)) continue;
            dbinder.setLCId(localeId);
            String localeXml = (String)node.getLoacleXml().getItem(localeId);
            if (!StringUtils.isNotBlank((CharSequence)localeXml)) continue;
            metadata = xmlSerializer.deserializeFromString(localeXml, metadata);
        }
        for (MetadataNode metadataNode : node.getExtendNodes()) {
            metadata = this.deSerializer(xmlSerializer, tree, metadataNode, metadata);
        }
        if (node.getChildNode() != null) {
            metadata = this.deSerializer(xmlSerializer, tree, node.getChildNode(), metadata);
        }
        return metadata;
    }

    private MetadataNode findOriginNode(MetadataTree context, ExtMetadataNode current) {
        if (StringUtils.isBlank((CharSequence)current.getParentId()) || StringUtils.equals((CharSequence)current.getId(), (CharSequence)current.getParentId())) {
            return null;
        }
        MetadataNode parent = context.getExtNodes().get(current.getParentId());
        if (parent == null) {
            parent = context.getNode(current.getParentId());
        }
        if (parent == null) {
            return null;
        }
        if (parent instanceof ExtMetadataNode) {
            parent = this.findOriginNode(context, (ExtMetadataNode)parent);
        }
        return parent;
    }

    private void fillExtends(MetadataTree tree, IDataEntityType designerMetaType, boolean runtime, boolean readBaseMeta, String masterId) {
        HashSet<String> withoutIds = new HashSet<String>();
        this.resolveExcludeForm(runtime, readBaseMeta, masterId, withoutIds);
        List<ExtMetadataNode> list = this.plugIn.loadExtendNode(designerMetaType, tree, withoutIds);
        HashSet<String> extIds = new HashSet<String>();
        for (ExtMetadataNode node : list) {
            extIds.add(node.getId());
        }
        HashSet<String> disableIds = this.plugIn.loadDisableExtend(extIds);
        ArrayList<ExtMetadataNode> list2 = new ArrayList<ExtMetadataNode>();
        for (ExtMetadataNode node : list) {
            if (disableIds.contains(node.getId())) continue;
            list2.add(node);
        }
        tree.fillExtends(list2);
    }

    protected void resolveExcludeForm(boolean runtime, boolean readBaseMeta, String masterId, Set<String> withoutIds) {
        if (runtime) {
            return;
        }
        if (this.isFillExtends()) {
            return;
        }
        withoutIds.add(this.currId);
        if (!readBaseMeta && !StringUtils.isBlank((CharSequence)masterId) && !StringUtils.equals((CharSequence)masterId, (CharSequence)this.currId) && StringUtils.isNotBlank((CharSequence)this.currParentId)) {
            withoutIds.add(this.currParentId);
        }
    }

    protected IDataEntityType getGrayDeataEntityType(IDataEntityType designerMetaType) {
        IDataEntityType det;
        if (StringUtils.isBlank((CharSequence)this.appGroup) || "defaultGroup".equals(this.appGroup)) {
            return designerMetaType;
        }
        try {
            det = (IDataEntityType)designerMetaType.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new KDException((Throwable)e, BosErrorCode.bOS, new Object[]{e.getMessage()});
        }
        det.setAlias(String.format("%s_%s", det.getAlias(), this.appGroup));
        return det;
    }

    protected String getGrayTableName(String tabName) {
        if (StringUtils.isBlank((CharSequence)this.appGroup) || "defaultGroup".equals(this.appGroup)) {
            return tabName;
        }
        return String.format("%s_%s", tabName, this.appGroup);
    }

    private void fillLocale(final MetadataTree tree, IDataEntityType designerMetaType, final boolean ext) {
        String tableName = designerMetaType.getAlias();
        tableName = StringUtils.isNotBlank((CharSequence)this.appGroup) && tableName.endsWith(this.appGroup) ? tableName.replace(this.appGroup, "L_" + this.appGroup) : tableName + "_L";
        HashSet<String> idSet = ext ? tree.getExtendNodeIds() : tree.getNodeIds();
        String ids = "'" + StringUtils.join((Object[])idSet.toArray(), (String)"','") + "'";
        boolean findall = Boolean.getBoolean("metadata.multilang.mergeall");
        if (!idSet.isEmpty()) {
            String sql = String.format("select FId,FDATA,FLOCALEID from %s where FId in(%s) ", tableName, ids);
            if (!findall) {
                IInteService service = (IInteService)ServiceFactory.getService(IInteService.class);
                List langs = service.getRebuildMetaLang();
                if (langs.isEmpty()) {
                    return;
                }
                ArrayList<String> supportLanguages = new ArrayList<String>(langs.size());
                for (EnabledLang lang : langs) {
                    if (!StringUtils.isNotBlank((CharSequence)lang.getNumber())) continue;
                    supportLanguages.add(lang.getNumber());
                }
                String langStr = "'" + StringUtils.join((Object[])supportLanguages.toArray(), (String)"','") + "'";
                sql = String.format("select FId,FDATA,FLOCALEID from %s where FId in(%s) and FLOCALEID in (%s) ", tableName, ids, langStr);
            }
            ResultSetHandler<Object> action = new ResultSetHandler<Object>(){

                public Object handle(ResultSet rs) throws Exception {
                    while (rs.next()) {
                        String id = rs.getString("FId");
                        String xml = rs.getString("FDATA");
                        String locale = rs.getString("FLOCALEID");
                        MetadataNode node = ext ? tree.getExtNode(id) : tree.getNode(id);
                        node.getLoacleXml().setItem(locale, (Object)xml);
                    }
                    return null;
                }
            };
            DB.query((DBRoute)this.getDbRoute(designerMetaType), (String)sql, null, (ResultSetHandler)action);
        }
    }

    private List<MetadataNode> getParentNodes(String path, IDataEntityType designerMetaType) {
        String tableName = designerMetaType.getAlias();
        String sql = String.format("select FId,FParentID, FDATA, FVERSION from %s where FID in('%s') ", tableName, path.replace(",", "','"));
        Object[] params = new SqlParameter[]{};
        ResultSetHandler<List<MetadataNode>> action = new ResultSetHandler<List<MetadataNode>>(){

            public List<MetadataNode> handle(ResultSet rs) throws Exception {
                ArrayList<MetadataNode> list = new ArrayList<MetadataNode>(10);
                while (rs.next()) {
                    String id = rs.getString("FId");
                    String parentId = rs.getString("FParentID");
                    String version = rs.getString("FVERSION");
                    MetadataNode node = new MetadataNode(id, parentId, rs.getString("FDATA"), true);
                    node.setVersion(version);
                    list.add(node);
                }
                return list;
            }
        };
        return (List)DB.query((DBRoute)this.getDbRoute(designerMetaType), (String)sql, (Object[])params, (ResultSetHandler)action);
    }

    private DBRoute getDbRoute(IDataEntityType metaType) {
        String dbRouteKey = metaType.getDBRouteKey();
        return StringUtils.isBlank((CharSequence)dbRouteKey) ? DBRoute.meta : DBRoute.of((String)dbRouteKey);
    }

    private String buildMergeVer(MetadataTree tree) {
        ArrayList<MetadataNode> nodes = new ArrayList<MetadataNode>(10);
        nodes.addAll(tree.getNodes().values());
        nodes.addAll(tree.getExtNodes().values());
        StringBuilder mergeVer = new StringBuilder();
        int index = 0;
        for (int i = 0; i < nodes.size(); ++i) {
            String ver;
            MetadataNode node = (MetadataNode)nodes.get(i);
            String string = ver = node == null ? "" : node.getVersion();
            if (StringUtils.isBlank((CharSequence)ver)) continue;
            if (index == 0) {
                mergeVer.append(ver);
            } else {
                mergeVer.append(",").append(ver);
            }
            ++index;
        }
        return mergeVer.toString();
    }

    private static void getTermFIdsFromTreeNode(MetadataNode node, List<String> ids) {
        if (node == null) {
            return;
        }
        ids.add(node.getId());
        for (MetadataNode metadataNode : node.getExtendNodes()) {
            AbstractMetadataReader.getTermFIdsFromTreeNode(metadataNode, ids);
        }
        if (node.getChildNode() != null) {
            AbstractMetadataReader.getTermFIdsFromTreeNode(node.getChildNode(), ids);
        }
    }
}

