/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata.dao;

import java.sql.ResultSet;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.AppInfo;

public class AppRebuilder {
    private static final String T_META_BIZAPP = "t_meta_bizapp";
    private static final String T_META_BIZUNITREFROM = "T_META_BIZUNITRELFORM";
    private static final String ERROR_STR_SQL = "Error:%s. sql:%s";
    private String appGroup;

    public AppRebuilder(String appGroup) {
        this.appGroup = appGroup;
    }

    public AppInfo getMasterAppInfo(String appId) {
        String tabName = this.getGrayTableName(T_META_BIZAPP);
        String sql = String.format("select a.FType,b.FNumber as FMasterNumber,a.FNumber,a.FBizCloudId, a.FISV from %s a left join %s b on a.FMasterId = b.FId where a.FId = ? ", tabName, tabName);
        Object[] params = new SqlParameter[]{new SqlParameter(":FId", 12, (Object)appId)};
        ResultSetHandler<AppInfo> action = new ResultSetHandler<AppInfo>(){

            public AppInfo handle(ResultSet rs) throws Exception {
                if (rs.next()) {
                    AppInfo appInfo = new AppInfo();
                    String type = rs.getString(1);
                    appInfo.setType(type);
                    if ("2".equals(type)) {
                        appInfo.setNumber(rs.getString(2));
                    } else {
                        appInfo.setNumber(rs.getString(3));
                    }
                    appInfo.setCloudId(rs.getString(4));
                    appInfo.setIsv(rs.getString(5));
                    return appInfo;
                }
                return null;
            }
        };
        return (AppInfo)DB.query((DBRoute)DBRoute.meta, (String)sql, (Object[])params, (ResultSetHandler)action);
    }

    private String getGrayTableName(String tabName) {
        if (StringUtils.isBlank((CharSequence)this.appGroup) || "defaultGroup".equals(this.appGroup)) {
            return tabName;
        }
        return String.format("%s_%s", tabName, this.appGroup);
    }
}

