/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata.dao;

import java.util.ArrayList;
import java.util.List;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logorm.impl.EntityMetadataContext;
import kd.bos.logorm.impl.EntityProperty;
import kd.bos.metadata.entity.Entity;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.LogBillEntity;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.IDBField;
import kd.bos.metadata.entity.commonfield.LargeTextField;

public class LogORMEntityMetaContextBuilder {
    private final EntityMetadata entityMetadata;

    public LogORMEntityMetaContextBuilder(EntityMetadata entityMetadata) {
        this.entityMetadata = entityMetadata;
    }

    public EntityMetadataContext build() {
        List<Entity<?, ?>> entities = this.entityMetadata.getEntitys();
        if (entities.size() > 1) {
            throw new KDException(BosErrorCode.bOS, new Object[]{"LogBillEntities update field error, require single entity."});
        }
        Entity<?, ?> entity = entities.get(0);
        if (entity == null) {
            throw new KDException(BosErrorCode.bOS, new Object[]{"LogBillEntities update field error, require LogBillEntity but current is null"});
        }
        if (!(entity instanceof LogBillEntity)) {
            throw new KDException(BosErrorCode.bOS, new Object[]{"LogBillEntities update field error, require LogBillEntity but current is " + entity.getClass().getName()});
        }
        LogBillEntity logBillEntity = (LogBillEntity)entity;
        List<EntityItem<?>> items = logBillEntity.getItems();
        String entityName = logBillEntity.getKey();
        String tableName = logBillEntity.getTableName();
        ArrayList<EntityProperty> entityProperties = new ArrayList<EntityProperty>(32);
        int pkType = logBillEntity.getPkType() == 0 ? -9 : -5;
        entityProperties.add(new EntityProperty("id", logBillEntity.getPkFieldName(), pkType, 0, null, null, null));
        int ordinal = 1;
        for (EntityItem<?> item : items) {
            if (!(item instanceof Field)) continue;
            Field field = (Field)item;
            List<IDBField> idbFields = field.getDBFields();
            for (IDBField idbField : idbFields) {
                String propertyName = field.getKey();
                String columnName = idbField.getFieldName();
                int dbType = idbField.getFieldDBType();
                if (idbField instanceof LargeTextField && columnName.endsWith("_tag")) {
                    propertyName = propertyName + "_tag";
                    dbType = 2011;
                }
                EntityProperty property = new EntityProperty(propertyName, columnName, dbType, ordinal++, null, null, null);
                entityProperties.add(property);
            }
        }
        return new EntityMetadataContext(entityName, tableName, entityProperties.toArray(new EntityProperty[0]));
    }
}

