/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.metadata.dao;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.entity.cache.CacheKeyUtil;
import kd.bos.entity.gray.AppGroupUtils;
import kd.bos.metadata.dao.RedisAppMetadataCache;
import kd.bos.metadata.dao.RedisEntityTypeCache;
import kd.bos.metadata.dao.RedisMetadataCache;
import kd.bos.util.ConfigurationChangeListener;
import kd.bos.util.ConfigurationUtil;
import kd.sdk.annotation.SdkPublic;

@SdkPublic
public class MetaCacheUtils {
    private static final String REGION = "meta";
    private static final String STR_METAVERSION_STR = "%s_metaversion_%s_%s";
    static String META_CACHETYPE_ENTITY = "meta.cachetype.usetype.entity.enable";
    static boolean cacheTypeEntityMetaUseType = true;

    private static DistributeSessionlessCache getCache() {
        return CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache(REGION, new DistributeCacheHAPolicy());
    }

    public static String getDistributeCache(String number, String key, int metaType) {
        if (Boolean.getBoolean("meta.rediscache.disabled")) {
            return null;
        }
        DistributeSessionlessCache cache = MetaCacheUtils.getCache();
        if (cacheTypeEntityMetaUseType && metaType == 11) {
            return RedisEntityTypeCache.get(cache, number, key);
        }
        return RedisMetadataCache.get(cache, metaType, number, key);
    }

    public static void putDistributeCache(String number, String key, int metaType, String val) {
        if (val == null) {
            return;
        }
        if (Boolean.getBoolean("meta.rediscache.disabled")) {
            return;
        }
        DistributeSessionlessCache cache = MetaCacheUtils.getCache();
        if (cacheTypeEntityMetaUseType && metaType == 11) {
            RedisEntityTypeCache.put(cache, number, key, val);
        } else {
            RedisMetadataCache.put(cache, metaType, number, key, val);
        }
    }

    public static List<String> getEntityDistributeCache(String[] numbers) {
        if (numbers == null || numbers.length == 0) {
            return new ArrayList<String>(0);
        }
        if (Boolean.getBoolean("meta.rediscache.disabled")) {
            return new ArrayList<String>(0);
        }
        ArrayList<String> list = new ArrayList<String>(numbers.length);
        DistributeSessionlessCache cache = MetaCacheUtils.getCache();
        if (cacheTypeEntityMetaUseType) {
            return RedisEntityTypeCache.get(cache, numbers);
        }
        for (String number : numbers) {
            list.add(RedisMetadataCache.get(cache, 11, number, number));
        }
        return list;
    }

    public static void putEntityDistributeCache(Map<String, String> entityMap) {
        if (Boolean.getBoolean("meta.rediscache.disabled")) {
            return;
        }
        DistributeSessionlessCache cache = MetaCacheUtils.getCache();
        if (cacheTypeEntityMetaUseType) {
            RedisEntityTypeCache.put(cache, entityMap);
        } else {
            for (Map.Entry<String, String> entry : entityMap.entrySet()) {
                String number = entry.getKey();
                String val = entry.getValue();
                RedisEntityTypeCache.put(cache, number, number, val);
            }
        }
    }

    @Deprecated
    public static String getAppmetaDistributeCache(String appNumber, String key, int metaType) {
        DistributeSessionlessCache cache = MetaCacheUtils.getCache();
        return RedisAppMetadataCache.get(cache, metaType, appNumber, key);
    }

    @Deprecated
    public static void putAppmetaDistributeCache(String appNumber, String key, int metaType, String val) {
        if (val == null) {
            return;
        }
        DistributeSessionlessCache cache = MetaCacheUtils.getCache();
        RedisAppMetadataCache.put(cache, metaType, appNumber, key, val);
    }

    @Deprecated
    public static void removeAppmetaDistributeCache(String appNumber, String key, int metaType) {
        DistributeSessionlessCache cache = MetaCacheUtils.getCache();
        RedisAppMetadataCache.remove(cache, metaType, appNumber, key);
    }

    @Deprecated
    public static void removeAppmetaDistributeCache(String appNumber) {
        DistributeSessionlessCache cache = MetaCacheUtils.getCache();
        RedisAppMetadataCache.remove(cache, appNumber);
    }

    @Deprecated
    public static void removeAppmetaDistributeCache(String appGroup, String appNumber) {
        DistributeSessionlessCache cache = MetaCacheUtils.getCache();
        RedisAppMetadataCache.remove(cache, appGroup, appNumber);
    }

    @Deprecated
    public static void removeAppMetaDistributeCache(String ... numbers) {
        DistributeSessionlessCache cache = MetaCacheUtils.getCache();
        RedisAppMetadataCache.removeBatch(cache, numbers);
    }

    public static void setFormMetaVersion(String number, String version) {
        DistributeSessionlessCache cache = MetaCacheUtils.getCache();
        RedisMetadataCache.put(cache, 10, number, number, version, 5000);
    }

    public static String getFormMetaVersion(String number) {
        DistributeSessionlessCache cache = MetaCacheUtils.getCache();
        return RedisMetadataCache.get(cache, 10, number, number);
    }

    public static void removeDistributeCache(String type, String key, int metaType) {
        DistributeSessionlessCache cache = MetaCacheUtils.getCache();
        if (cacheTypeEntityMetaUseType && metaType == 11) {
            RedisEntityTypeCache.remove(cache, type, key);
        } else {
            RedisMetadataCache.remove(cache, metaType, type, key);
        }
    }

    public static void removeDistributeCache(String ... numbers) {
        DistributeSessionlessCache cache = MetaCacheUtils.getCache();
        RedisEntityTypeCache.remove(cache, numbers);
        RedisMetadataCache.remove(cache, numbers);
    }

    public static void removeGroupDistributeCache(String appGroup, String type, String key, int metaType) {
        DistributeSessionlessCache cache = MetaCacheUtils.getCache();
        if (cacheTypeEntityMetaUseType && metaType == 11) {
            RedisEntityTypeCache.remove(cache, type, key);
        } else {
            RedisMetadataCache.remove(cache, appGroup, metaType, type, key);
        }
    }

    public static void removeGroupDistributeCache(String appGroup, List<String> numbers) {
        DistributeSessionlessCache cache = MetaCacheUtils.getCache();
        RedisEntityTypeCache.removeAppGroup(cache, appGroup, numbers);
        RedisMetadataCache.remove(cache, appGroup, numbers);
    }

    private static String getVerCacheType(String number) {
        String accountId = CacheKeyUtil.getAcctId();
        String appGroup = AppGroupUtils.getCurrentAppGroup();
        return String.format(STR_METAVERSION_STR, accountId, appGroup, number);
    }

    static {
        cacheTypeEntityMetaUseType = Boolean.parseBoolean(System.getProperty(META_CACHETYPE_ENTITY, "true"));
        ConfigurationUtil.observeChange((String)META_CACHETYPE_ENTITY, (ConfigurationChangeListener)new ConfigurationChangeListener(){

            public void onChange(Object key, Object newValue) {
                cacheTypeEntityMetaUseType = Boolean.parseBoolean(System.getProperty(META_CACHETYPE_ENTITY, "true"));
            }
        });
    }
}

